/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Platform;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@GoogleInternal
public final class StringUtil {
    @Deprecated
    public static final String WHITE_SPACES = "\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a";
    public static final String LINE_BREAKS = "\r\n";
    private static final Splitter NEWLINE_SPLITTER = Splitter.on('\n').omitEmptyStrings();
    private static final Splitter TO_WORDS = Splitter.on(CharMatcher.BREAKING_WHITESPACE).omitEmptyStrings();
    private static final CharMatcher FANCY_SINGLE_QUOTE = CharMatcher.anyOf("\u0091\u0092\u2018\u2019");
    private static final CharMatcher FANCY_DOUBLE_QUOTE = CharMatcher.anyOf("\u0093\u0094\u201c\u201d");
    private static final Map<String, Character> ESCAPE_STRINGS;
    private static final CharMatcher HEX_LETTER;
    private static final CharEscaper LT_GT_ESCAPE;
    private static final Pattern HTML_TAG_PATTERN;
    private static final Pattern CHARACTER_REFERENCE_PATTERN;
    private static final Set<Character.UnicodeBlock> CJK_BLOCKS;
    private static final char[] hexChars;
    private static final char[] octalChars;
    private static final CodePointSet JS_ESCAPE_CHARS;
    private static final CodePointSet JSON_ESCAPE_CHARS;
    private static final CodePointSet JSON_OR_JS_ESCAPE_CHARS;

    private StringUtil() {
    }

    public static boolean isEmptyOrWhitespace(@Nullable String string) {
        return string == null || CharMatcher.WHITESPACE.matchesAllOf(string);
    }

    @Nullable
    public static String toNullIfEmptyOrWhitespace(@Nullable String string) {
        return StringUtil.isEmptyOrWhitespace(string) ? null : string;
    }

    @Deprecated
    public static String[] split(String str, String delims) {
        return StringUtil.split(str, delims, false);
    }

    @Deprecated
    public static String[] split(String str, String delims, boolean trimTokens) {
        StringTokenizer tokenizer = new StringTokenizer(str, delims);
        int n = tokenizer.countTokens();
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = trimTokens ? CharMatcher.WHITESPACE.trimFrom(tokenizer.nextToken()) : tokenizer.nextToken();
        }
        return list;
    }

    public static String trimStart(String s) {
        return CharMatcher.WHITESPACE.trimLeadingFrom(s);
    }

    public static String trimStart(String s, @Nullable String extraChars) {
        return extraChars == null ? CharMatcher.WHITESPACE.trimLeadingFrom(s) : CharMatcher.WHITESPACE.or(CharMatcher.anyOf(extraChars)).trimLeadingFrom(s);
    }

    public static String trimEnd(String s) {
        return CharMatcher.WHITESPACE.trimTrailingFrom(s);
    }

    public static String trimEnd(String s, @Nullable String extraChars) {
        return extraChars == null ? CharMatcher.WHITESPACE.trimTrailingFrom(s) : CharMatcher.WHITESPACE.or(CharMatcher.anyOf(extraChars)).trimTrailingFrom(s);
    }

    @Deprecated
    public static String[] splitAndTrim(String str, String delims) {
        return StringUtil.split(str, delims, true);
    }

    public static int[] splitInts(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int n = tokenizer.countTokens();
        int[] list = new int[n];
        for (int i = 0; i < n; ++i) {
            String token = tokenizer.nextToken();
            list[i] = Integer.parseInt(token);
        }
        return list;
    }

    public static long[] splitLongs(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int n = tokenizer.countTokens();
        long[] list = new long[n];
        for (int i = 0; i < n; ++i) {
            String token = tokenizer.nextToken();
            list[i] = Long.parseLong(token);
        }
        return list;
    }

    public static String fixedWidth(String str, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : NEWLINE_SPLITTER.split(str)) {
            lines.add(line);
        }
        String[] lineArray = lines.toArray(new String[0]);
        return StringUtil.fixedWidth(lineArray, width);
    }

    @VisibleForTesting
    static String fixedWidth(String[] lines, int width) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        for (String line : lines) {
            formattedLines.add(StringUtil.formatLineToFixedWidth(line, width));
        }
        return Joiner.on('\n').join(formattedLines);
    }

    private static String formatLineToFixedWidth(String line, int width) {
        if (line.length() <= width) {
            return line;
        }
        StringBuilder builder = new StringBuilder();
        int col = 0;
        for (String word : TO_WORDS.split(line)) {
            if (col == 0) {
                col = word.length();
            } else {
                int newCol = col + word.length() + 1;
                if (newCol <= width) {
                    builder.append(' ');
                    col = newCol;
                } else {
                    builder.append('\n');
                    col = word.length();
                }
            }
            builder.append(word);
        }
        return builder.toString();
    }

    public static String indent(String iString, int iIndentDepth) {
        StringBuilder spacer = new StringBuilder();
        spacer.append("\n");
        for (int i = 0; i < iIndentDepth; ++i) {
            spacer.append("  ");
        }
        return iString.replace("\n", spacer.toString());
    }

    @Deprecated
    public static String megastrip(@Nullable String str, boolean left, boolean right, String what) {
        if (str == null) {
            return null;
        }
        CharMatcher matcher = CharMatcher.anyOf(what);
        if (left) {
            if (right) {
                return matcher.trimFrom(str);
            }
            return matcher.trimLeadingFrom(str);
        }
        if (right) {
            return matcher.trimTrailingFrom(str);
        }
        return str;
    }

    @Deprecated
    public static String strip(@Nullable String str) {
        return str == null ? null : CharMatcher.WHITESPACE.trimFrom(str);
    }

    @Deprecated
    public static String stripAndCollapse(@Nullable String str) {
        return str == null ? null : CharMatcher.WHITESPACE.trimAndCollapseFrom(str, ' ');
    }

    @Nullable
    public static String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : null;
    }

    @Nullable
    public static String stripPrefixIgnoreCase(String str, String prefix) {
        return StringUtil.startsWithIgnoreCase(str, prefix) ? str.substring(prefix.length()) : null;
    }

    @Nullable
    public static String stripSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : null;
    }

    @Nullable
    public static String stripSuffixIgnoreCase(String str, String suffix) {
        return StringUtil.endsWithIgnoreCase(str, suffix) ? str.substring(0, str.length() - suffix.length()) : null;
    }

    public static String replaceSmartQuotes(String str) {
        String tmp = FANCY_SINGLE_QUOTE.replaceFrom((CharSequence)str, '\'');
        return FANCY_DOUBLE_QUOTE.replaceFrom((CharSequence)tmp, '\"');
    }

    public static byte[] hexToBytes(CharSequence str) {
        byte[] bytes = new byte[(str.length() + 1) / 2];
        if (str.length() == 0) {
            return bytes;
        }
        bytes[0] = 0;
        int nibbleIdx = str.length() % 2;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!StringUtil.isHex(c)) {
                throw new IllegalArgumentException("string contains non-hex chars");
            }
            if (nibbleIdx % 2 == 0) {
                bytes[nibbleIdx >> 1] = (byte)(StringUtil.hexValue(c) << 4);
            } else {
                int n = nibbleIdx >> 1;
                bytes[n] = (byte)(bytes[n] + (byte)StringUtil.hexValue(c));
            }
            ++nibbleIdx;
        }
        return bytes;
    }

    public static String convertEOLToLF(String input) {
        StringBuilder res = new StringBuilder(input.length());
        char[] s = input.toCharArray();
        int from = 0;
        int end = s.length;
        for (int i = 0; i < end; ++i) {
            if (s[i] != '\r') continue;
            res.append(s, from, i - from);
            res.append('\n');
            if (i + 1 < end && s[i + 1] == '\n') {
                ++i;
            }
            from = i + 1;
        }
        if (from == 0) {
            return input;
        }
        res.append(s, from, end - from);
        return res.toString();
    }

    public static String maskLeft(String s, int len, char maskChar) {
        if (len <= 0) {
            return s;
        }
        len = Math.min(len, s.length());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(maskChar);
        }
        sb.append(s.substring(len));
        return sb.toString();
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static String unescapeCString(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len) {
                c = s.charAt(i++);
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case '?': {
                        c = '?';
                        break;
                    }
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    default: {
                        int v;
                        if (c == 'x' && i < len && StringUtil.isHex(s.charAt(i))) {
                            v = StringUtil.hexValue(s.charAt(i++));
                            if (i < len && StringUtil.isHex(s.charAt(i))) {
                                v = v * 16 + StringUtil.hexValue(s.charAt(i++));
                            }
                            c = (char)v;
                            break;
                        }
                        if (StringUtil.isOctal(c)) {
                            v = c - 48;
                            if (i < len && StringUtil.isOctal(s.charAt(i))) {
                                v = v * 8 + (s.charAt(i++) - 48);
                            }
                            if (i < len && StringUtil.isOctal(s.charAt(i))) {
                                v = v * 8 + (s.charAt(i++) - 48);
                            }
                            c = (char)v;
                            break;
                        }
                        sb.append('\\');
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapeMySQLString(String s) {
        char[] chars = s.toCharArray();
        if (chars.length < 2 || chars[0] != chars[chars.length - 1] || chars[0] != '\'' && chars[0] != '\"') {
            throw new IllegalArgumentException("not a valid MySQL string: " + s);
        }
        int j = 1;
        int f = 0;
        for (int i = 1; i < chars.length - 1; ++i) {
            if (f == 0) {
                if (chars[i] == '\\') {
                    f = 1;
                    continue;
                }
                if (chars[i] == chars[0]) {
                    f = 2;
                    continue;
                }
                chars[j++] = chars[i];
                continue;
            }
            if (f == 1) {
                switch (chars[i]) {
                    case '0': {
                        chars[j++] = '\u0000';
                        break;
                    }
                    case '\'': {
                        chars[j++] = 39;
                        break;
                    }
                    case '\"': {
                        chars[j++] = 34;
                        break;
                    }
                    case 'b': {
                        chars[j++] = 8;
                        break;
                    }
                    case 'n': {
                        chars[j++] = 10;
                        break;
                    }
                    case 'r': {
                        chars[j++] = 13;
                        break;
                    }
                    case 't': {
                        chars[j++] = 9;
                        break;
                    }
                    case 'z': {
                        chars[j++] = 26;
                        break;
                    }
                    case '\\': {
                        chars[j++] = 92;
                        break;
                    }
                    default: {
                        chars[j++] = chars[i];
                    }
                }
                f = 0;
                continue;
            }
            if (chars[i] != chars[0]) {
                throw new IllegalArgumentException("not a valid MySQL string: " + s);
            }
            chars[j++] = chars[0];
            f = 0;
        }
        if (f != 0) {
            throw new IllegalArgumentException("not a valid MySQL string: " + s);
        }
        return new String(chars, 1, j - 1);
    }

    public static String unescapeHTML(String s) {
        return StringUtil.unescapeHTML(s, false);
    }

    public static String unescapeHTML(String s, boolean emulateBrowsers) {
        int index = s.indexOf(38);
        if (index == -1) {
            return s;
        }
        char[] chars = s.toCharArray();
        char[] escaped = new char[chars.length];
        System.arraycopy(chars, 0, escaped, 0, index);
        int pos = index;
        int i = index;
        while (i < chars.length) {
            if (chars[i] != '&') {
                escaped[pos++] = chars[i++];
                continue;
            }
            int j = i + 1;
            boolean isNumericEntity = false;
            if (j < chars.length && chars[j] == '#') {
                ++j;
                isNumericEntity = true;
            }
            boolean isHexEntity = false;
            if (j < chars.length && (chars[j] == 'x' || chars[j] == 'X')) {
                ++j;
                isHexEntity = true;
            }
            while (j < chars.length) {
                char ch = chars[j];
                boolean isDigit = Character.isDigit(ch);
                if (isNumericEntity && (!isHexEntity && !isDigit || isHexEntity && !isDigit && !HEX_LETTER.matches(ch)) || !isDigit && !Character.isLetter(ch)) break;
                ++j;
            }
            boolean replaced = false;
            if (j <= chars.length && emulateBrowsers || j < chars.length && chars[j] == ';') {
                if (i + 2 < chars.length && s.charAt(i + 1) == '#') {
                    try {
                        long charcode = 0L;
                        char ch = s.charAt(i + 2);
                        if (isHexEntity) {
                            charcode = Long.parseLong(new String(chars, i + 3, j - i - 3), 16);
                        } else if (Character.isDigit(ch)) {
                            charcode = Long.parseLong(new String(chars, i + 2, j - i - 2));
                        }
                        if (charcode > 0L && charcode < 65536L) {
                            escaped[pos++] = (char)charcode;
                            replaced = true;
                        }
                    }
                    catch (NumberFormatException ex) {}
                } else {
                    String key = new String(chars, i, j - i);
                    Character repl = ESCAPE_STRINGS.get(key);
                    if (repl != null) {
                        escaped[pos++] = repl.charValue();
                        replaced = true;
                    }
                }
                if (j < chars.length && chars[j] == ';') {
                    ++j;
                }
            }
            if (!replaced) {
                System.arraycopy(chars, i, escaped, pos, j - i);
                pos += j - i;
            }
            i = j;
        }
        return new String(escaped, 0, pos);
    }

    public static String stripHtmlTags(@Nullable String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        String stripped = HTML_TAG_PATTERN.matcher(string).replaceAll("");
        return LT_GT_ESCAPE.escape(stripped);
    }

    public static String javaScriptEscape(CharSequence s) {
        return StringUtil.javaScriptEscapeHelper(s, false);
    }

    public static String javaScriptEscapeToAscii(CharSequence s) {
        return StringUtil.javaScriptEscapeHelper(s, true);
    }

    private static String javaScriptEscapeHelper(CharSequence s, boolean escapeToAscii) {
        StringBuilder sb = new StringBuilder(s.length() * 9 / 8);
        try {
            StringUtil.escapeStringBody(s, escapeToAscii, JsEscapingMode.EMBEDDABLE_JS, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }

    public static void escapeStringBody(CharSequence plainText, boolean escapeToAscii, JsEscapingMode jsEscapingMode, Appendable out) throws IOException {
        int charCount;
        int pos = 0;
        int len = plainText.length();
        block9: for (int i = 0; i < len; i += charCount) {
            int codePoint = Character.codePointAt(plainText, i);
            charCount = Character.charCount(codePoint);
            if (!StringUtil.shouldEscapeChar(codePoint, escapeToAscii, jsEscapingMode)) continue;
            out.append(plainText, pos, i);
            pos = i + charCount;
            switch (codePoint) {
                case 8: {
                    out.append("\\b");
                    continue block9;
                }
                case 9: {
                    out.append("\\t");
                    continue block9;
                }
                case 10: {
                    out.append("\\n");
                    continue block9;
                }
                case 12: {
                    out.append("\\f");
                    continue block9;
                }
                case 13: {
                    out.append("\\r");
                    continue block9;
                }
                case 92: {
                    out.append("\\\\");
                    continue block9;
                }
                case 34: 
                case 39: {
                    if (jsEscapingMode == JsEscapingMode.JSON && 39 == codePoint) {
                        out.append((char)codePoint);
                        continue block9;
                    }
                    if (jsEscapingMode != JsEscapingMode.EMBEDDABLE_JS) {
                        out.append('\\').append((char)codePoint);
                        continue block9;
                    }
                }
                default: {
                    if (codePoint >= 256 || jsEscapingMode == JsEscapingMode.JSON) {
                        StringUtil.appendHexJavaScriptRepresentation(codePoint, out);
                        continue block9;
                    }
                    boolean pad = i + charCount >= len || StringUtil.isOctal(plainText.charAt(i + charCount));
                    StringUtil.appendOctalJavaScriptRepresentation((char)codePoint, pad, out);
                }
            }
        }
        out.append(plainText, pos, len);
    }

    private static boolean shouldEscapeChar(int codePoint, boolean escapeToAscii, JsEscapingMode jsEscapingMode) {
        if (escapeToAscii && (codePoint < 32 || codePoint > 126)) {
            return true;
        }
        if (jsEscapingMode == JsEscapingMode.JSON) {
            return StringUtil.mustEscapeCharInJsonOrJsString(codePoint);
        }
        return StringUtil.mustEscapeCharInJsString(codePoint);
    }

    private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            StringUtil.appendHexJavaScriptRepresentation(surrogates[0], out);
            StringUtil.appendHexJavaScriptRepresentation(surrogates[1], out);
            return;
        }
        out.append("\\u").append(hexChars[codePoint >>> 12 & 0xF]).append(hexChars[codePoint >>> 8 & 0xF]).append(hexChars[codePoint >>> 4 & 0xF]).append(hexChars[codePoint & 0xF]);
    }

    private static void appendOctalJavaScriptRepresentation(char ch, boolean pad, Appendable out) throws IOException {
        if (ch >= '@' || pad) {
            out.append('\\').append(octalChars[ch >>> 6 & 7]).append(octalChars[ch >>> 3 & 7]).append(octalChars[ch & 7]);
        } else if (ch >= '\b') {
            out.append('\\').append(octalChars[ch >>> 3 & 7]).append(octalChars[ch & 7]);
        } else {
            out.append('\\').append(octalChars[ch & 7]);
        }
    }

    public static String javaScriptUnescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                i = StringUtil.javaScriptUnescapeHelper(s, i + 1, sb);
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static int javaScriptUnescapeHelper(String s, int i, StringBuilder sb) {
        if (i >= s.length()) {
            throw new IllegalArgumentException("End-of-string after escape character in [" + s + "]");
        }
        char c = s.charAt(i++);
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'b': {
                sb.append('\b');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '\\': {
                sb.append(c);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int nOctalDigits;
                int digitLimit;
                --i;
                int n = digitLimit = c < '4' ? 3 : 2;
                for (nOctalDigits = 1; nOctalDigits < digitLimit && i + nOctalDigits < s.length() && StringUtil.isOctal(s.charAt(i + nOctalDigits)); ++nOctalDigits) {
                }
                sb.append((char)Integer.parseInt(s.substring(i, i + nOctalDigits), 8));
                i += nOctalDigits;
                break;
            }
            case 'u': 
            case 'x': {
                int unicodeValue;
                String hexCode;
                int nHexDigits = c == 'u' ? 4 : 2;
                try {
                    hexCode = s.substring(i, i + nHexDigits);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + s.substring(i) + "] at index " + i + " in [" + s + "]");
                }
                try {
                    unicodeValue = Integer.parseInt(hexCode, 16);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + hexCode + "] at index " + i + " in [" + s + "]");
                }
                sb.append((char)unicodeValue);
                i += nHexDigits;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown escape code [" + c + "] at index " + i + " in [" + s + "]");
            }
        }
        return i;
    }

    @Deprecated
    public static Set<String> string2Set(@Nullable String in, @Nullable String delimiter, boolean doStrip) {
        if (in == null) {
            return null;
        }
        HashSet<String> out = new HashSet<String>();
        StringUtil.string2Collection(in, delimiter, doStrip, out);
        return out;
    }

    @Deprecated
    private static Collection<String> string2Collection(@Nullable String in, @Nullable String delimiter, boolean doStrip, Collection<String> collection) {
        String interim;
        int pos;
        if (in == null) {
            return null;
        }
        if (collection == null) {
            collection = new ArrayList<String>();
        }
        if (delimiter == null || delimiter.length() == 0) {
            collection.add(in);
            return collection;
        }
        int fromIndex = 0;
        while ((pos = in.indexOf(delimiter, fromIndex)) >= 0) {
            interim = in.substring(fromIndex, pos);
            if (doStrip) {
                interim = StringUtil.strip(interim);
            }
            if (!doStrip || interim.length() > 0) {
                collection.add(interim);
            }
            fromIndex = pos + delimiter.length();
        }
        interim = in.substring(fromIndex);
        if (doStrip) {
            interim = StringUtil.strip(interim);
        }
        if (!doStrip || interim.length() > 0) {
            collection.add(interim);
        }
        return collection;
    }

    public static HashMap<String, String> string2Map(@Nullable String in, @Nullable String delimEntry, @Nullable String delimKey, boolean doStripEntry) {
        if (in == null) {
            return null;
        }
        return StringUtil.stringToMapImpl(new HashMap(), in, delimEntry, delimKey, doStripEntry);
    }

    public static Map<String, String> stringToOrderedMap(@Nullable String in, @Nullable String delimEntry, @Nullable String delimKey, boolean doStripEntry) {
        if (in == null) {
            return null;
        }
        return StringUtil.stringToMapImpl(new LinkedHashMap(), in, delimEntry, delimKey, doStripEntry);
    }

    private static <T extends Map<String, String>> T stringToMapImpl(T out, String in, String delimEntry, String delimKey, boolean doStripEntry) {
        if (Strings.isNullOrEmpty(delimEntry) || Strings.isNullOrEmpty(delimKey)) {
            out.put((String)StringUtil.strip(in), (String)"");
            return out;
        }
        Iterator<String> it = Splitter.on(delimEntry).split(in).iterator();
        int len = delimKey.length();
        while (it.hasNext()) {
            String entry = it.next();
            int pos = entry.indexOf(delimKey);
            if (pos > 0) {
                String value = entry.substring(pos + len);
                if (doStripEntry) {
                    value = StringUtil.strip(value);
                }
                out.put((String)StringUtil.strip(entry.substring(0, pos)), (String)value);
                continue;
            }
            out.put((String)StringUtil.strip(entry), (String)"");
        }
        return out;
    }

    public static <V> Map<String, V> lowercaseKeys(Map<String, V> map) {
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key.toLowerCase())) {
                throw new IllegalArgumentException("Duplicate string key in map when lower casing");
            }
            result.put(key.toLowerCase(), entry.getValue());
        }
        return result;
    }

    @Deprecated
    public static String collapseWhitespace(@Nullable String str) {
        return str == null ? null : CharMatcher.WHITESPACE.collapseFrom(str, ' ');
    }

    @Deprecated
    public static String collapse(@Nullable String str, String chars, String replacement) {
        if (str == null) {
            return null;
        }
        StringBuilder newStr = new StringBuilder();
        boolean prevCharMatched = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (chars.indexOf(c) != -1) {
                if (prevCharMatched) continue;
                prevCharMatched = true;
                newStr.append(replacement);
                continue;
            }
            prevCharMatched = false;
            newStr.append(c);
        }
        return newStr.toString();
    }

    @Deprecated
    public static String stream2String(InputStream is, int maxLength) throws IOException {
        byte[] buffer = new byte[4096];
        StringWriter sw = new StringWriter();
        int totalRead = 0;
        int read = 0;
        do {
            sw.write(new String(buffer, 0, read));
            read = is.read(buffer, 0, buffer.length);
        } while ((-1 == maxLength || (totalRead += read) < maxLength) && read != -1);
        return sw.toString();
    }

    public static String[] parseDelimitedList(String list, char delimiter) {
        String delim = "" + delimiter;
        StringTokenizer st = new StringTokenizer(list + delim + " ", delim, true);
        ArrayList<String> v = new ArrayList<String>();
        String lastToken = "";
        StringBuilder word = new StringBuilder();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (lastToken != null) {
                if (tok.equals(delim)) {
                    word.append(lastToken);
                    if (lastToken.equals(delim)) {
                        tok = null;
                    }
                } else {
                    if (word.length() != 0) {
                        v.add(word.toString());
                    }
                    word.setLength(0);
                }
            }
            lastToken = tok;
        }
        return v.toArray(new String[0]);
    }

    public static String lastToken(String s, String delimiter) {
        return s.substring(CharMatcher.anyOf(delimiter).lastIndexIn(s) + 1);
    }

    public static boolean containsCharRef(String s) {
        return CHARACTER_REFERENCE_PATTERN.matcher(s).find();
    }

    public static boolean isHebrew(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!StringUtil.isHebrew(s.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isHebrew(int codePoint) {
        return Character.UnicodeBlock.HEBREW.equals(Character.UnicodeBlock.of(codePoint));
    }

    public static boolean isCjk(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!StringUtil.isCjk(s.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isCjk(char ch) {
        return StringUtil.isCjk((int)ch);
    }

    public static boolean isCjk(int codePoint) {
        if ((codePoint & 0xFFFFFF00) == 0) {
            return false;
        }
        return CJK_BLOCKS.contains(Character.UnicodeBlock.of(codePoint));
    }

    public static int displayWidth(String s) {
        int width = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            width += StringUtil.displayWidth(s.charAt(i));
        }
        return width;
    }

    public static int displayWidth(char ch) {
        if (ch <= '\u04f9' || ch == '\u05be' || ch >= '\u05d0' && ch <= '\u05ea' || ch == '\u05f3' || ch == '\u05f4' || ch >= '\u0600' && ch <= '\u06ff' || ch >= '\u0750' && ch <= '\u077f' || ch >= '\ufb50' && ch <= '\ufdff' || ch >= '\ufe70' && ch <= '\ufeff' || ch >= '\u1e00' && ch <= '\u20af' || ch >= '\u2100' && ch <= '\u213a' || ch >= '\u0e00' && ch <= '\u0e7f' || ch >= '\uff61' && ch <= '\uffdc') {
            return 1;
        }
        return 2;
    }

    public static String bytesToHexString(byte[] bytes, @Nullable Character delimiter) {
        StringBuilder hex = new StringBuilder(bytes.length * (delimiter == null ? 2 : 3));
        for (int i = 0; i < bytes.length; ++i) {
            int nibble1 = bytes[i] >>> 4 & 0xF;
            int nibble2 = bytes[i] & 0xF;
            if (i > 0 && delimiter != null) {
                hex.append(delimiter.charValue());
            }
            hex.append(hexChars[nibble1]);
            hex.append(hexChars[nibble2]);
        }
        return hex.toString();
    }

    @Deprecated
    public static String toUpperCase(@Nullable String str) {
        return str == null ? null : str.toUpperCase();
    }

    @Deprecated
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String capitalize(String s) {
        char capitalized;
        if (s.isEmpty()) {
            return s;
        }
        char first = s.charAt(0);
        return first == (capitalized = Character.toUpperCase(first)) ? s : capitalized + s.substring(1);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int len = suffix.length();
        return str.regionMatches(true, str.length() - len, suffix, 0, len);
    }

    private static int bytesUtf8(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        if (c < 0x200000) {
            return 4;
        }
        if (c < 0x4000000) {
            return 5;
        }
        return 6;
    }

    public static int bytesStorage(String str) {
        String s = new String(str);
        int len = 0;
        int i = 0;
        while (i < s.length()) {
            len += StringUtil.bytesUtf8(s.codePointAt(i));
            i = s.offsetByCodePoints(i, 1);
        }
        return len;
    }

    public static String truncateStringForUtf8Storage(String str, int maxbytes) {
        int glyphBytes;
        if (maxbytes < 0) {
            throw new IndexOutOfBoundsException();
        }
        String s = new String(str);
        int codepoints = 0;
        int bytesUsed = 0;
        codepoints = 0;
        while (codepoints < s.length() && bytesUsed + (glyphBytes = StringUtil.bytesUtf8(s.codePointAt(codepoints))) <= maxbytes) {
            bytesUsed += glyphBytes;
            codepoints = s.offsetByCodePoints(codepoints, 1);
        }
        return s.substring(0, codepoints);
    }

    public static String truncateIfNecessary(String source, int maxLength) {
        if (source.length() <= maxLength) {
            return source;
        }
        String str = StringUtil.unicodePreservingSubstring(source, 0, maxLength);
        String truncated = CharMatcher.WHITESPACE.trimTrailingFrom(str);
        if (truncated.length() < maxLength) {
            return truncated;
        }
        if (CharMatcher.WHITESPACE.matches(source.charAt(maxLength))) {
            return truncated;
        }
        for (int i = truncated.length() - 1; i >= 0; --i) {
            if (!CharMatcher.WHITESPACE.matches(truncated.charAt(i))) continue;
            String substr = truncated.substring(0, i);
            return CharMatcher.WHITESPACE.trimTrailingFrom(substr);
        }
        return truncated;
    }

    public static String truncateAtMaxLength(String source, int maxLength, boolean addEllipsis) {
        if (source.length() <= maxLength) {
            return source;
        }
        if (addEllipsis && maxLength > 3) {
            return StringUtil.unicodePreservingSubstring(source, 0, maxLength - 3) + "...";
        }
        return StringUtil.unicodePreservingSubstring(source, 0, maxLength);
    }

    @VisibleForTesting
    static int unicodePreservingIndex(String str, int index) {
        if (index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index))) {
            return index - 1;
        }
        return index;
    }

    public static String unicodePreservingSubstring(String str, int begin, int end) {
        return str.substring(StringUtil.unicodePreservingIndex(str, begin), StringUtil.unicodePreservingIndex(str, end));
    }

    public static String unicodePreservingSubstring(String str, int begin) {
        return StringUtil.unicodePreservingSubstring(str, begin, str.length());
    }

    @VisibleForTesting
    static boolean mustEscapeCharInJsString(int codepoint) {
        return JS_ESCAPE_CHARS.contains(codepoint);
    }

    @VisibleForTesting
    static boolean mustEscapeCharInJsonString(int codepoint) {
        return JSON_ESCAPE_CHARS.contains(codepoint);
    }

    @VisibleForTesting
    static boolean mustEscapeCharInJsonOrJsString(int codepoint) {
        return JSON_OR_JS_ESCAPE_CHARS.contains(codepoint);
    }

    static {
        HashMap<String, Character> map = new HashMap<String, Character>(252);
        map.put("&nbsp", Character.valueOf('\u00a0'));
        map.put("&iexcl", Character.valueOf('\u00a1'));
        map.put("&cent", Character.valueOf('\u00a2'));
        map.put("&pound", Character.valueOf('\u00a3'));
        map.put("&curren", Character.valueOf('\u00a4'));
        map.put("&yen", Character.valueOf('\u00a5'));
        map.put("&brvbar", Character.valueOf('\u00a6'));
        map.put("&sect", Character.valueOf('\u00a7'));
        map.put("&uml", Character.valueOf('\u00a8'));
        map.put("&copy", Character.valueOf('\u00a9'));
        map.put("&ordf", Character.valueOf('\u00aa'));
        map.put("&laquo", Character.valueOf('\u00ab'));
        map.put("&not", Character.valueOf('\u00ac'));
        map.put("&shy", Character.valueOf('\u00ad'));
        map.put("&reg", Character.valueOf('\u00ae'));
        map.put("&macr", Character.valueOf('\u00af'));
        map.put("&deg", Character.valueOf('\u00b0'));
        map.put("&plusmn", Character.valueOf('\u00b1'));
        map.put("&sup2", Character.valueOf('\u00b2'));
        map.put("&sup3", Character.valueOf('\u00b3'));
        map.put("&acute", Character.valueOf('\u00b4'));
        map.put("&micro", Character.valueOf('\u00b5'));
        map.put("&para", Character.valueOf('\u00b6'));
        map.put("&middot", Character.valueOf('\u00b7'));
        map.put("&cedil", Character.valueOf('\u00b8'));
        map.put("&sup1", Character.valueOf('\u00b9'));
        map.put("&ordm", Character.valueOf('\u00ba'));
        map.put("&raquo", Character.valueOf('\u00bb'));
        map.put("&frac14", Character.valueOf('\u00bc'));
        map.put("&frac12", Character.valueOf('\u00bd'));
        map.put("&frac34", Character.valueOf('\u00be'));
        map.put("&iquest", Character.valueOf('\u00bf'));
        map.put("&Agrave", Character.valueOf('\u00c0'));
        map.put("&Aacute", Character.valueOf('\u00c1'));
        map.put("&Acirc", Character.valueOf('\u00c2'));
        map.put("&Atilde", Character.valueOf('\u00c3'));
        map.put("&Auml", Character.valueOf('\u00c4'));
        map.put("&Aring", Character.valueOf('\u00c5'));
        map.put("&AElig", Character.valueOf('\u00c6'));
        map.put("&Ccedil", Character.valueOf('\u00c7'));
        map.put("&Egrave", Character.valueOf('\u00c8'));
        map.put("&Eacute", Character.valueOf('\u00c9'));
        map.put("&Ecirc", Character.valueOf('\u00ca'));
        map.put("&Euml", Character.valueOf('\u00cb'));
        map.put("&Igrave", Character.valueOf('\u00cc'));
        map.put("&Iacute", Character.valueOf('\u00cd'));
        map.put("&Icirc", Character.valueOf('\u00ce'));
        map.put("&Iuml", Character.valueOf('\u00cf'));
        map.put("&ETH", Character.valueOf('\u00d0'));
        map.put("&Ntilde", Character.valueOf('\u00d1'));
        map.put("&Ograve", Character.valueOf('\u00d2'));
        map.put("&Oacute", Character.valueOf('\u00d3'));
        map.put("&Ocirc", Character.valueOf('\u00d4'));
        map.put("&Otilde", Character.valueOf('\u00d5'));
        map.put("&Ouml", Character.valueOf('\u00d6'));
        map.put("&times", Character.valueOf('\u00d7'));
        map.put("&Oslash", Character.valueOf('\u00d8'));
        map.put("&Ugrave", Character.valueOf('\u00d9'));
        map.put("&Uacute", Character.valueOf('\u00da'));
        map.put("&Ucirc", Character.valueOf('\u00db'));
        map.put("&Uuml", Character.valueOf('\u00dc'));
        map.put("&Yacute", Character.valueOf('\u00dd'));
        map.put("&THORN", Character.valueOf('\u00de'));
        map.put("&szlig", Character.valueOf('\u00df'));
        map.put("&agrave", Character.valueOf('\u00e0'));
        map.put("&aacute", Character.valueOf('\u00e1'));
        map.put("&acirc", Character.valueOf('\u00e2'));
        map.put("&atilde", Character.valueOf('\u00e3'));
        map.put("&auml", Character.valueOf('\u00e4'));
        map.put("&aring", Character.valueOf('\u00e5'));
        map.put("&aelig", Character.valueOf('\u00e6'));
        map.put("&ccedil", Character.valueOf('\u00e7'));
        map.put("&egrave", Character.valueOf('\u00e8'));
        map.put("&eacute", Character.valueOf('\u00e9'));
        map.put("&ecirc", Character.valueOf('\u00ea'));
        map.put("&euml", Character.valueOf('\u00eb'));
        map.put("&igrave", Character.valueOf('\u00ec'));
        map.put("&iacute", Character.valueOf('\u00ed'));
        map.put("&icirc", Character.valueOf('\u00ee'));
        map.put("&iuml", Character.valueOf('\u00ef'));
        map.put("&eth", Character.valueOf('\u00f0'));
        map.put("&ntilde", Character.valueOf('\u00f1'));
        map.put("&ograve", Character.valueOf('\u00f2'));
        map.put("&oacute", Character.valueOf('\u00f3'));
        map.put("&ocirc", Character.valueOf('\u00f4'));
        map.put("&otilde", Character.valueOf('\u00f5'));
        map.put("&ouml", Character.valueOf('\u00f6'));
        map.put("&divide", Character.valueOf('\u00f7'));
        map.put("&oslash", Character.valueOf('\u00f8'));
        map.put("&ugrave", Character.valueOf('\u00f9'));
        map.put("&uacute", Character.valueOf('\u00fa'));
        map.put("&ucirc", Character.valueOf('\u00fb'));
        map.put("&uuml", Character.valueOf('\u00fc'));
        map.put("&yacute", Character.valueOf('\u00fd'));
        map.put("&thorn", Character.valueOf('\u00fe'));
        map.put("&yuml", Character.valueOf('\u00ff'));
        map.put("&fnof", Character.valueOf('\u0192'));
        map.put("&Alpha", Character.valueOf('\u0391'));
        map.put("&Beta", Character.valueOf('\u0392'));
        map.put("&Gamma", Character.valueOf('\u0393'));
        map.put("&Delta", Character.valueOf('\u0394'));
        map.put("&Epsilon", Character.valueOf('\u0395'));
        map.put("&Zeta", Character.valueOf('\u0396'));
        map.put("&Eta", Character.valueOf('\u0397'));
        map.put("&Theta", Character.valueOf('\u0398'));
        map.put("&Iota", Character.valueOf('\u0399'));
        map.put("&Kappa", Character.valueOf('\u039a'));
        map.put("&Lambda", Character.valueOf('\u039b'));
        map.put("&Mu", Character.valueOf('\u039c'));
        map.put("&Nu", Character.valueOf('\u039d'));
        map.put("&Xi", Character.valueOf('\u039e'));
        map.put("&Omicron", Character.valueOf('\u039f'));
        map.put("&Pi", Character.valueOf('\u03a0'));
        map.put("&Rho", Character.valueOf('\u03a1'));
        map.put("&Sigma", Character.valueOf('\u03a3'));
        map.put("&Tau", Character.valueOf('\u03a4'));
        map.put("&Upsilon", Character.valueOf('\u03a5'));
        map.put("&Phi", Character.valueOf('\u03a6'));
        map.put("&Chi", Character.valueOf('\u03a7'));
        map.put("&Psi", Character.valueOf('\u03a8'));
        map.put("&Omega", Character.valueOf('\u03a9'));
        map.put("&alpha", Character.valueOf('\u03b1'));
        map.put("&beta", Character.valueOf('\u03b2'));
        map.put("&gamma", Character.valueOf('\u03b3'));
        map.put("&delta", Character.valueOf('\u03b4'));
        map.put("&epsilon", Character.valueOf('\u03b5'));
        map.put("&zeta", Character.valueOf('\u03b6'));
        map.put("&eta", Character.valueOf('\u03b7'));
        map.put("&theta", Character.valueOf('\u03b8'));
        map.put("&iota", Character.valueOf('\u03b9'));
        map.put("&kappa", Character.valueOf('\u03ba'));
        map.put("&lambda", Character.valueOf('\u03bb'));
        map.put("&mu", Character.valueOf('\u03bc'));
        map.put("&nu", Character.valueOf('\u03bd'));
        map.put("&xi", Character.valueOf('\u03be'));
        map.put("&omicron", Character.valueOf('\u03bf'));
        map.put("&pi", Character.valueOf('\u03c0'));
        map.put("&rho", Character.valueOf('\u03c1'));
        map.put("&sigmaf", Character.valueOf('\u03c2'));
        map.put("&sigma", Character.valueOf('\u03c3'));
        map.put("&tau", Character.valueOf('\u03c4'));
        map.put("&upsilon", Character.valueOf('\u03c5'));
        map.put("&phi", Character.valueOf('\u03c6'));
        map.put("&chi", Character.valueOf('\u03c7'));
        map.put("&psi", Character.valueOf('\u03c8'));
        map.put("&omega", Character.valueOf('\u03c9'));
        map.put("&thetasym", Character.valueOf('\u03d1'));
        map.put("&upsih", Character.valueOf('\u03d2'));
        map.put("&piv", Character.valueOf('\u03d6'));
        map.put("&bull", Character.valueOf('\u2022'));
        map.put("&hellip", Character.valueOf('\u2026'));
        map.put("&prime", Character.valueOf('\u2032'));
        map.put("&Prime", Character.valueOf('\u2033'));
        map.put("&oline", Character.valueOf('\u203e'));
        map.put("&frasl", Character.valueOf('\u2044'));
        map.put("&weierp", Character.valueOf('\u2118'));
        map.put("&image", Character.valueOf('\u2111'));
        map.put("&real", Character.valueOf('\u211c'));
        map.put("&trade", Character.valueOf('\u2122'));
        map.put("&alefsym", Character.valueOf('\u2135'));
        map.put("&larr", Character.valueOf('\u2190'));
        map.put("&uarr", Character.valueOf('\u2191'));
        map.put("&rarr", Character.valueOf('\u2192'));
        map.put("&darr", Character.valueOf('\u2193'));
        map.put("&harr", Character.valueOf('\u2194'));
        map.put("&crarr", Character.valueOf('\u21b5'));
        map.put("&lArr", Character.valueOf('\u21d0'));
        map.put("&uArr", Character.valueOf('\u21d1'));
        map.put("&rArr", Character.valueOf('\u21d2'));
        map.put("&dArr", Character.valueOf('\u21d3'));
        map.put("&hArr", Character.valueOf('\u21d4'));
        map.put("&forall", Character.valueOf('\u2200'));
        map.put("&part", Character.valueOf('\u2202'));
        map.put("&exist", Character.valueOf('\u2203'));
        map.put("&empty", Character.valueOf('\u2205'));
        map.put("&nabla", Character.valueOf('\u2207'));
        map.put("&isin", Character.valueOf('\u2208'));
        map.put("&notin", Character.valueOf('\u2209'));
        map.put("&ni", Character.valueOf('\u220b'));
        map.put("&prod", Character.valueOf('\u220f'));
        map.put("&sum", Character.valueOf('\u2211'));
        map.put("&minus", Character.valueOf('\u2212'));
        map.put("&lowast", Character.valueOf('\u2217'));
        map.put("&radic", Character.valueOf('\u221a'));
        map.put("&prop", Character.valueOf('\u221d'));
        map.put("&infin", Character.valueOf('\u221e'));
        map.put("&ang", Character.valueOf('\u2220'));
        map.put("&and", Character.valueOf('\u2227'));
        map.put("&or", Character.valueOf('\u2228'));
        map.put("&cap", Character.valueOf('\u2229'));
        map.put("&cup", Character.valueOf('\u222a'));
        map.put("&int", Character.valueOf('\u222b'));
        map.put("&there4", Character.valueOf('\u2234'));
        map.put("&sim", Character.valueOf('\u223c'));
        map.put("&cong", Character.valueOf('\u2245'));
        map.put("&asymp", Character.valueOf('\u2248'));
        map.put("&ne", Character.valueOf('\u2260'));
        map.put("&equiv", Character.valueOf('\u2261'));
        map.put("&le", Character.valueOf('\u2264'));
        map.put("&ge", Character.valueOf('\u2265'));
        map.put("&sub", Character.valueOf('\u2282'));
        map.put("&sup", Character.valueOf('\u2283'));
        map.put("&nsub", Character.valueOf('\u2284'));
        map.put("&sube", Character.valueOf('\u2286'));
        map.put("&supe", Character.valueOf('\u2287'));
        map.put("&oplus", Character.valueOf('\u2295'));
        map.put("&otimes", Character.valueOf('\u2297'));
        map.put("&perp", Character.valueOf('\u22a5'));
        map.put("&sdot", Character.valueOf('\u22c5'));
        map.put("&lceil", Character.valueOf('\u2308'));
        map.put("&rceil", Character.valueOf('\u2309'));
        map.put("&lfloor", Character.valueOf('\u230a'));
        map.put("&rfloor", Character.valueOf('\u230b'));
        map.put("&lang", Character.valueOf('\u2329'));
        map.put("&rang", Character.valueOf('\u232a'));
        map.put("&loz", Character.valueOf('\u25ca'));
        map.put("&spades", Character.valueOf('\u2660'));
        map.put("&clubs", Character.valueOf('\u2663'));
        map.put("&hearts", Character.valueOf('\u2665'));
        map.put("&diams", Character.valueOf('\u2666'));
        map.put("&quot", Character.valueOf('\"'));
        map.put("&amp", Character.valueOf('&'));
        map.put("&lt", Character.valueOf('<'));
        map.put("&gt", Character.valueOf('>'));
        map.put("&OElig", Character.valueOf('\u0152'));
        map.put("&oelig", Character.valueOf('\u0153'));
        map.put("&Scaron", Character.valueOf('\u0160'));
        map.put("&scaron", Character.valueOf('\u0161'));
        map.put("&Yuml", Character.valueOf('\u0178'));
        map.put("&circ", Character.valueOf('\u02c6'));
        map.put("&tilde", Character.valueOf('\u02dc'));
        map.put("&ensp", Character.valueOf('\u2002'));
        map.put("&emsp", Character.valueOf('\u2003'));
        map.put("&thinsp", Character.valueOf('\u2009'));
        map.put("&zwnj", Character.valueOf('\u200c'));
        map.put("&zwj", Character.valueOf('\u200d'));
        map.put("&lrm", Character.valueOf('\u200e'));
        map.put("&rlm", Character.valueOf('\u200f'));
        map.put("&ndash", Character.valueOf('\u2013'));
        map.put("&mdash", Character.valueOf('\u2014'));
        map.put("&lsquo", Character.valueOf('\u2018'));
        map.put("&rsquo", Character.valueOf('\u2019'));
        map.put("&sbquo", Character.valueOf('\u201a'));
        map.put("&ldquo", Character.valueOf('\u201c'));
        map.put("&rdquo", Character.valueOf('\u201d'));
        map.put("&bdquo", Character.valueOf('\u201e'));
        map.put("&dagger", Character.valueOf('\u2020'));
        map.put("&Dagger", Character.valueOf('\u2021'));
        map.put("&permil", Character.valueOf('\u2030'));
        map.put("&lsaquo", Character.valueOf('\u2039'));
        map.put("&rsaquo", Character.valueOf('\u203a'));
        map.put("&euro", Character.valueOf('\u20ac'));
        ESCAPE_STRINGS = Collections.unmodifiableMap(map);
        HEX_LETTER = CharMatcher.inRange('A', 'F').or(CharMatcher.inRange('a', 'f'));
        LT_GT_ESCAPE = new CharEscaperBuilder().addEscape('<', "&lt;").addEscape('>', "&gt;").toEscaper();
        HTML_TAG_PATTERN = Pattern.compile("</?[a-zA-Z][^>]*>");
        CHARACTER_REFERENCE_PATTERN = Pattern.compile("&#?[a-zA-Z0-9]{1,8};");
        HashSet<Character.UnicodeBlock> set = new HashSet<Character.UnicodeBlock>();
        set.add(Character.UnicodeBlock.HANGUL_JAMO);
        set.add(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT);
        set.add(Character.UnicodeBlock.KANGXI_RADICALS);
        set.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
        set.add(Character.UnicodeBlock.HIRAGANA);
        set.add(Character.UnicodeBlock.KATAKANA);
        set.add(Character.UnicodeBlock.BOPOMOFO);
        set.add(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO);
        set.add(Character.UnicodeBlock.KANBUN);
        set.add(Character.UnicodeBlock.BOPOMOFO_EXTENDED);
        set.add(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS);
        set.add(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        set.add(Character.UnicodeBlock.HANGUL_SYLLABLES);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS);
        set.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
        CJK_BLOCKS = Collections.unmodifiableSet(set);
        hexChars = "0123456789abcdef".toCharArray();
        octalChars = "01234567".toCharArray();
        JS_ESCAPE_CHARS = new CodePointSet.Builder().addCodePoint(173).addRange(1536, 1539).addCodePoint(1757).addCodePoint(1807).addRange(6068, 6069).addRange(8203, 8207).addRange(8234, 8238).addRange(8288, 8292).addRange(8298, 8303).addCodePoint(65279).addRange(65529, 65531).addRange(119155, 119162).addCodePoint(917505).addRange(917536, 917631).addCodePoint(0).addCodePoint(10).addCodePoint(13).addRange(8232, 8233).addCodePoint(133).addCodePoint(Character.codePointAt("'", 0)).addCodePoint(Character.codePointAt("\"", 0)).addCodePoint(Character.codePointAt("&", 0)).addCodePoint(Character.codePointAt("<", 0)).addCodePoint(Character.codePointAt(">", 0)).addCodePoint(Character.codePointAt("=", 0)).addCodePoint(Character.codePointAt("\\", 0)).create();
        JSON_ESCAPE_CHARS = new CodePointSet.Builder().addCodePoint(Character.codePointAt("\"", 0)).addCodePoint(Character.codePointAt("\\", 0)).addRange(0, 31).create();
        JSON_OR_JS_ESCAPE_CHARS = JSON_ESCAPE_CHARS.or(JS_ESCAPE_CHARS);
    }

    private static final class CharEscaperBuilder {
        private final Map<Character, String> map = new HashMap<Character, String>();
        private int max = -1;

        public CharEscaperBuilder addEscape(char c, String r) {
            this.map.put(Character.valueOf(c), r);
            if (c > this.max) {
                this.max = c;
            }
            return this;
        }

        public CharEscaperBuilder addEscapes(char[] cs, String r) {
            for (char c : cs) {
                this.addEscape(c, r);
            }
            return this;
        }

        public char[][] toArray() {
            char[][] result = new char[this.max + 1][];
            for (Map.Entry<Character, String> entry : this.map.entrySet()) {
                result[entry.getKey().charValue()] = entry.getValue().toCharArray();
            }
            return result;
        }

        public CharEscaper toEscaper() {
            return new CharArrayDecorator(this.toArray());
        }

        private static class CharArrayDecorator
        extends CharEscaper {
            private final char[][] replacements;
            private final int replaceLength;

            CharArrayDecorator(char[][] replacements) {
                this.replacements = replacements;
                this.replaceLength = replacements.length;
            }

            @Override
            public String escape(String s) {
                int slen = s.length();
                for (int index = 0; index < slen; ++index) {
                    char c = s.charAt(index);
                    if (c >= this.replacements.length || this.replacements[c] == null) continue;
                    return this.escapeSlow(s, index);
                }
                return s;
            }

            @Override
            protected char[] escape(char c) {
                return c < this.replaceLength ? this.replacements[c] : null;
            }
        }
    }

    private static abstract class CharEscaper {
        private static final int DEST_PAD = 32;

        private CharEscaper() {
        }

        public String escape(String string) {
            Preconditions.checkNotNull(string);
            int length = string.length();
            for (int index = 0; index < length; ++index) {
                if (this.escape(string.charAt(index)) == null) continue;
                return this.escapeSlow(string, index);
            }
            return string;
        }

        protected String escapeSlow(String s, int index) {
            int slen = s.length();
            char[] dest = Platform.charBufferFromThreadLocal();
            int destSize = dest.length;
            int destIndex = 0;
            int lastEscape = 0;
            while (index < slen) {
                char[] r = this.escape(s.charAt(index));
                if (r != null) {
                    int charsSkipped = index - lastEscape;
                    int rlen = r.length;
                    int sizeNeeded = destIndex + charsSkipped + rlen;
                    if (destSize < sizeNeeded) {
                        destSize = sizeNeeded + (slen - index) + 32;
                        dest = CharEscaper.growBuffer(dest, destIndex, destSize);
                    }
                    if (charsSkipped > 0) {
                        s.getChars(lastEscape, index, dest, destIndex);
                        destIndex += charsSkipped;
                    }
                    if (rlen > 0) {
                        System.arraycopy(r, 0, dest, destIndex, rlen);
                        destIndex += rlen;
                    }
                    lastEscape = index + 1;
                }
                ++index;
            }
            int charsLeft = slen - lastEscape;
            if (charsLeft > 0) {
                int sizeNeeded = destIndex + charsLeft;
                if (destSize < sizeNeeded) {
                    dest = CharEscaper.growBuffer(dest, destIndex, sizeNeeded);
                }
                s.getChars(lastEscape, slen, dest, destIndex);
                destIndex = sizeNeeded;
            }
            return new String(dest, 0, destIndex);
        }

        protected abstract char[] escape(char var1);

        private static char[] growBuffer(char[] dest, int index, int size) {
            char[] copy = new char[size];
            if (index > 0) {
                System.arraycopy(dest, 0, copy, 0, index);
            }
            return copy;
        }
    }

    private static class CodePointSet {
        boolean[] fastArray;
        Set<Integer> elements;

        private CodePointSet(Set<Integer> codePoints) {
            this.elements = codePoints;
            this.fastArray = new boolean[256];
            for (int i = 0; i < this.fastArray.length; ++i) {
                this.fastArray[i] = this.elements.contains(i);
            }
        }

        boolean contains(int codePoint) {
            if (codePoint < this.fastArray.length) {
                return this.fastArray[codePoint];
            }
            return this.elements.contains(codePoint);
        }

        CodePointSet or(CodePointSet other) {
            return new Builder().addSet(this).addSet(other).create();
        }

        static class Builder {
            Set<Integer> codePoints = new HashSet<Integer>();

            Builder() {
            }

            Builder addCodePoint(int c) {
                this.codePoints.add(c);
                return this;
            }

            Builder addRange(int from, int to) {
                for (int i = from; i <= to; ++i) {
                    this.codePoints.add(i);
                }
                return this;
            }

            Builder addSet(CodePointSet set) {
                for (int i : set.elements) {
                    this.codePoints.add(i);
                }
                return this;
            }

            CodePointSet create() {
                return new CodePointSet(this.codePoints);
            }
        }
    }

    public static enum JsEscapingMode {
        JSON,
        EMBEDDABLE_JS,
        MINIMAL_JS;

    }
}

