/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GoogleInternal
@GwtCompatible
public class ImmutableMapBuilder<K, V> {
    private ImmutableHashMap<K, V> map;

    @Deprecated
    public static <K, V> ImmutableMapBuilder<K, V> fromMap(Map<K, V> map) {
        ImmutableMapBuilder<K, V> builder = new ImmutableMapBuilder<K, V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    @Deprecated
    public ImmutableMapBuilder() {
        this(8);
    }

    @Deprecated
    public ImmutableMapBuilder(int expectedSize) {
        this.map = new ImmutableHashMap(expectedSize);
    }

    @Deprecated
    public ImmutableMapBuilder<K, V> put(@Nullable K key, @Nullable V value) {
        Preconditions.checkState(this.map != null, "map has already been created");
        ((ImmutableHashMap)this.map).secretPut(key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<K, V> getMap() {
        Preconditions.checkState(this.map != null, "map has already been created");
        try {
            ImmutableHashMap<K, V> immutableHashMap = this.map;
            return immutableHashMap;
        }
        finally {
            this.map = null;
        }
    }

    private static class ImmutableHashMap<K, V>
    extends HashMap<K, V> {
        volatile transient Set<K> keySet;
        volatile transient Collection<V> values;
        volatile transient Set<Map.Entry<K, V>> entrySet;
        transient Integer cachedHashCode;
        private static final long serialVersionUID = -5187626034923451074L;

        ImmutableHashMap(int expectedSize) {
            super(expectedSize);
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(super.keySet());
            }
            return this.keySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(super.values());
            }
            return this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Maps.unmodifiableEntrySet(super.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public int hashCode() {
            Integer code = this.cachedHashCode;
            if (code == null) {
                int computed = super.hashCode();
                this.cachedHashCode = computed;
                return computed;
            }
            return code;
        }

        private void secretPut(K key, V value) {
            super.put(key, value);
        }

        @Override
        public V put(K key, V value) {
            throw ImmutableHashMap.up();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw ImmutableHashMap.up();
        }

        @Override
        public V remove(Object key) {
            throw ImmutableHashMap.up();
        }

        @Override
        public void clear() {
            throw ImmutableHashMap.up();
        }

        static UnsupportedOperationException up() {
            return new UnsupportedOperationException();
        }
    }
}

