/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

@GoogleInternal
final class Fingerprint2011
extends AbstractNonStreamingHashFunction {
    private static final long K0 = -6505348102511208375L;
    private static final long K1 = -8261664234251669945L;
    private static final long K2 = -4288712594273399085L;
    private static final long K3 = -4132994306676758123L;
    private static final ArrayGetter arrayGetter;
    private static final String UNSAFE_ARRAY_GETTER_NAME;

    Fingerprint2011() {
    }

    @Override
    public HashCode hashBytes(byte[] input) {
        return HashCodes.fromLong(Fingerprint2011.fingerprint(input));
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] copy = new byte[len];
        System.arraycopy(input, off, copy, 0, len);
        return this.hashBytes(copy);
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        return this.hashBytes(((Object)input).toString().getBytes(charset));
    }

    @Override
    public HashCode hashLong(long input) {
        return this.newHasher(8).putLong(input).hash();
    }

    @Override
    public HashCode hashInt(int input) {
        return this.newHasher(4).putInt(input).hash();
    }

    @Override
    public int bits() {
        return 64;
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes) {
        int length = bytes.length;
        long result = length <= 32 ? Fingerprint2011.murmurHash64WithSeed(bytes, -1397348546323613475L) : (length <= 64 ? Fingerprint2011.hashLength33To64(bytes) : Fingerprint2011.fullFingerprint(bytes));
        long u = length >= 8 ? Fingerprint2011.littleEndianLoad64(bytes, 0) : -6505348102511208375L;
        long v = length >= 9 ? Fingerprint2011.littleEndianLoad64(bytes, length - 8) : -6505348102511208375L;
        result = Fingerprint2011.hash128to64(result + v, u);
        return result == 0L || result == 1L ? result + -2L : result;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    @VisibleForTesting
    static long hash128to64(long high, long low) {
        long a = (low ^ high) * -4132994306676758123L;
        a ^= a >>> 47;
        long b = (high ^ a) * -4132994306676758123L;
        b ^= b >>> 47;
        return b *= -4132994306676758123L;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes, int offset, long seedA, long seedB, long[] output) {
        long part1 = Fingerprint2011.littleEndianLoad64(bytes, offset);
        long part2 = Fingerprint2011.littleEndianLoad64(bytes, offset + 8);
        long part3 = Fingerprint2011.littleEndianLoad64(bytes, offset + 16);
        long part4 = Fingerprint2011.littleEndianLoad64(bytes, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 51);
        long c = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 23)) + c;
    }

    @VisibleForTesting
    static long littleEndianLoad64(byte[] input, int offset) {
        assert (input.length >= offset + 8);
        return arrayGetter.getLongLittleEndian(input, offset);
    }

    private static long fullFingerprint(byte[] bytes) {
        int length = bytes.length;
        long x = Fingerprint2011.littleEndianLoad64(bytes, 0);
        long y = Fingerprint2011.littleEndianLoad64(bytes, length - 16) ^ 0x8D58AC26AFE12E47L;
        long z = Fingerprint2011.littleEndianLoad64(bytes, length - 56) ^ 0xA5B85C5E198ED849L;
        long[] v = new long[2];
        long[] w = new long[2];
        Fingerprint2011.weakHashLength32WithSeeds(bytes, length - 64, length, y, v);
        Fingerprint2011.weakHashLength32WithSeeds(bytes, length - 32, (long)length * -8261664234251669945L, -6505348102511208375L, w);
        x = Long.rotateRight((z += Fingerprint2011.shiftMix(v[1]) * -8261664234251669945L) + x, 39) * -8261664234251669945L;
        y = Long.rotateRight(y, 33) * -8261664234251669945L;
        length = length - 1 & 0xFFFFFFC0;
        int offset = 0;
        do {
            x = Long.rotateRight(x + y + v[0] + Fingerprint2011.littleEndianLoad64(bytes, offset + 16), 37) * -8261664234251669945L;
            y = Long.rotateRight(y + v[1] + Fingerprint2011.littleEndianLoad64(bytes, offset + 48), 42) * -8261664234251669945L;
            z = Long.rotateRight(z ^ w[0], 33);
            Fingerprint2011.weakHashLength32WithSeeds(bytes, offset, v[1] * -8261664234251669945L, (x ^= w[1]) + w[0], v);
            Fingerprint2011.weakHashLength32WithSeeds(bytes, offset + 32, z + w[1], y ^= v[0], w);
            long tmp = z;
            z = x;
            x = tmp;
            offset += 64;
        } while ((length -= 64) != 0);
        return Fingerprint2011.hash128to64(Fingerprint2011.hash128to64(v[0], w[0]) + Fingerprint2011.shiftMix(y) * -8261664234251669945L + z, Fingerprint2011.hash128to64(v[1], w[1]) + x);
    }

    private static long hashLength33To64(byte[] bytes) {
        int length = bytes.length;
        long z = Fingerprint2011.littleEndianLoad64(bytes, 24);
        long a = Fingerprint2011.littleEndianLoad64(bytes, 0) + ((long)length + Fingerprint2011.littleEndianLoad64(bytes, length - 16)) * -6505348102511208375L;
        long b = Long.rotateRight(a + z, 52);
        long c = Long.rotateRight(a, 37);
        long vf = (a += Fingerprint2011.littleEndianLoad64(bytes, 16)) + z;
        long vs = b + Long.rotateRight(a, 31) + (c += Long.rotateRight(a += Fingerprint2011.littleEndianLoad64(bytes, 8), 7));
        a = Fingerprint2011.littleEndianLoad64(bytes, 16) + Fingerprint2011.littleEndianLoad64(bytes, length - 32);
        z = Fingerprint2011.littleEndianLoad64(bytes, length - 8);
        b = Long.rotateRight(a + z, 52);
        c = Long.rotateRight(a, 37);
        long wf = (a += Fingerprint2011.littleEndianLoad64(bytes, length - 16)) + z;
        long ws = b + Long.rotateRight(a, 31) + (c += Long.rotateRight(a += Fingerprint2011.littleEndianLoad64(bytes, length - 24), 7));
        long r = Fingerprint2011.shiftMix((vf + ws) * -4288712594273399085L + (wf + vs) * -6505348102511208375L);
        return Fingerprint2011.shiftMix(r * -6505348102511208375L + vs) * -4288712594273399085L;
    }

    @VisibleForTesting
    static long murmurHash64WithSeed(byte[] bytes, long seed) {
        long mul = -4132994306676758123L;
        int topBit = 7;
        int length = bytes.length;
        int lengthAligned = length & 0xFFFFFFF8;
        int lengthRemainder = length & 7;
        long hash = seed ^ (long)length * -4132994306676758123L;
        for (int i = 0; i < lengthAligned; i += 8) {
            long loaded = Fingerprint2011.littleEndianLoad64(bytes, i);
            long data = Fingerprint2011.shiftMix(loaded * -4132994306676758123L) * -4132994306676758123L;
            hash ^= data;
            hash *= -4132994306676758123L;
        }
        if (lengthRemainder != 0) {
            long data = Fingerprint2011.littleEndianLoadLast64(bytes, lengthAligned);
            hash ^= data;
            hash *= -4132994306676758123L;
        }
        hash = Fingerprint2011.shiftMix(hash) * -4132994306676758123L;
        hash = Fingerprint2011.shiftMix(hash);
        return hash;
    }

    private static long littleEndianLoadLast64(byte[] input, int offset) {
        long result = 0L;
        for (int i = 0; i < 8 && offset + i < input.length; ++i) {
            result |= ((long)input[offset + i] & 0xFFL) << i * 8;
        }
        return result;
    }

    static {
        ArrayGetter theGetter;
        UNSAFE_ARRAY_GETTER_NAME = Fingerprint2011.class.getName() + "$UnsafeArrayGetter";
        try {
            Class<?> theClass = Class.forName(UNSAFE_ARRAY_GETTER_NAME);
            ArrayGetter[] getters = (ArrayGetter[])theClass.getEnumConstants();
            theGetter = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? getters[0] : getters[1];
        }
        catch (Throwable t) {
            theGetter = JavaArrayGetter.INSTANCE;
        }
        arrayGetter = theGetter;
    }

    private static enum JavaArrayGetter implements ArrayGetter
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] src, int off) {
                return Longs.fromBytes(src[off + 7], src[off + 6], src[off + 5], src[off + 4], src[off + 3], src[off + 2], src[off + 1], src[off]);
            }
        };

    }

    private static enum UnsafeArrayGetter implements ArrayGetter
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                return theUnsafe.getLong(array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                long bigEndian = theUnsafe.getLong(array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(bigEndian);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        static {
            theUnsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

                @Override
                public Unsafe run() {
                    try {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                    catch (NoSuchFieldException e) {
                        throw new Error();
                    }
                    catch (IllegalAccessException e) {
                        throw new Error();
                    }
                }
            });
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface ArrayGetter {
        public long getLongLittleEndian(byte[] var1, int var2);
    }
}

