/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.Fingerprint1999;
import com.google.appengine.repackaged.com.google.common.hash.GoogleLegacy32HashFunction;
import com.google.appengine.repackaged.com.google.common.hash.GoogleLegacy64HashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.hash.HashFunction;
import com.google.appengine.repackaged.com.google.common.hash.MessageDigestHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.Murmur2_64AHashFunction;

@GoogleInternal
public final class LegacyHashing {
    private static final int FINGERPRINT_SEED = 102072;
    static final int SEED32 = 314159265;
    static final int CONSTANT32 = -1640531527;
    static final long SEED64 = 3141592653589793238L;
    static final long CONSTANT64 = -2266404186210603134L;
    private static final HashFunction GOOGLE_LEGACY_32 = new GoogleLegacy32HashFunction(314159265, GoogleLegacy32HashFunction.FingerprintStrategy.WORKING);
    private static final HashFunction GOOGLE_LEGACY_64 = new GoogleLegacy64HashFunction(3141592653589793238L);
    private static final HashFunction FPRINT_96 = new MessageDigestHashFunction("SHA-1", 12, "LegacyHashing.fprint96()");
    private static final HashFunction FINGERPRINT_1999 = new Fingerprint1999(LegacyHashing.googleHash32(0), LegacyHashing.googleHash32(102072), "LegacyHashing.fingerprint1999()");
    private static final HashFunction BROKEN_FINGERPRINT_1999 = new Fingerprint1999((HashFunction)new GoogleLegacy32HashFunction(0, GoogleLegacy32HashFunction.FingerprintStrategy.BROKEN), (HashFunction)new GoogleLegacy32HashFunction(102072, GoogleLegacy32HashFunction.FingerprintStrategy.BROKEN), "LegacyHashing.brokenFingerprint1999()");
    private static final HashFunction MURMUR_HASH_2_64 = LegacyHashing.murmur2_64(0L);
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    private LegacyHashing() {
    }

    public static HashFunction googleHash32() {
        return GOOGLE_LEGACY_32;
    }

    public static HashFunction googleHash32(int seed) {
        return new GoogleLegacy32HashFunction(seed, GoogleLegacy32HashFunction.FingerprintStrategy.WORKING);
    }

    public static HashFunction googleHash64() {
        return GOOGLE_LEGACY_64;
    }

    public static HashFunction googleHash64(long seed) {
        return new GoogleLegacy64HashFunction(seed);
    }

    public static HashFunction fprint96() {
        return FPRINT_96;
    }

    public static HashFunction fingerprint1999() {
        return FINGERPRINT_1999;
    }

    public static HashFunction brokenFingerprint1999() {
        return BROKEN_FINGERPRINT_1999;
    }

    public static HashCode mix32(int value) {
        return HashCodes.fromInt(GoogleLegacy32HashFunction.mix32(value, -1640531527, 314159265));
    }

    public static HashCode mix32(int value, int seed) {
        return HashCodes.fromInt(GoogleLegacy32HashFunction.mix32(value, -1640531527, seed));
    }

    public static HashCode mix64(long value) {
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(value, -2266404186210603134L, 3141592653589793238L));
    }

    public static HashCode mix64(long value, long seed) {
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(value, -2266404186210603134L, seed));
    }

    public static HashFunction murmur2_64() {
        return MURMUR_HASH_2_64;
    }

    public static HashFunction murmur2_64(long seed) {
        return new Murmur2_64AHashFunction(seed);
    }

    public static HashCode stringHash64(CharSequence value) {
        long a;
        long b = a = -2266404186210603134L;
        long c = 3141592653589793238L;
        int offset = 0;
        int keylen = value.length();
        while (keylen >= 12) {
            a += LegacyHashing.word64CharAt(value, offset);
            a -= (b += LegacyHashing.word64CharAt(value, offset + 4));
            a -= (c += LegacyHashing.word64CharAt(value, offset + 8));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            keylen -= 12;
            offset += 12;
        }
        c += (long)value.length();
        switch (keylen) {
            case 11: {
                c += ((long)value.charAt(offset + 10) & 0xFFFFL) << 40;
            }
            case 10: {
                c += ((long)value.charAt(offset + 9) & 0xFFFFL) << 24;
            }
            case 9: {
                c += ((long)value.charAt(offset + 8) & 0xFFFFL) << 8;
            }
            case 8: {
                b += LegacyHashing.word64CharAt(value, offset + 4);
                a += LegacyHashing.word64CharAt(value, offset);
                break;
            }
            case 7: {
                b += ((long)value.charAt(offset + 6) & 0xFFFFL) << 32;
            }
            case 6: {
                b += ((long)value.charAt(offset + 5) & 0xFFFFL) << 16;
            }
            case 5: {
                b += (long)value.charAt(offset + 4) & 0xFFFFL;
            }
            case 4: {
                a += LegacyHashing.word64CharAt(value, offset);
                break;
            }
            case 3: {
                a += ((long)value.charAt(offset + 2) & 0xFFFFL) << 32;
            }
            case 2: {
                a += ((long)value.charAt(offset + 1) & 0xFFFFL) << 16;
            }
            case 1: {
                a += (long)value.charAt(offset) & 0xFFFFL;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(a, b, c));
    }

    private static long word64CharAt(CharSequence chars, int offset) {
        return ((long)chars.charAt(offset) & 0xFFFFL) + (((long)chars.charAt(offset + 1) & 0xFFFFL) << 16) + (((long)chars.charAt(offset + 2) & 0xFFFFL) << 32) + (((long)chars.charAt(offset + 3) & 0xFFFFL) << 48);
    }

    public static String toSeparatedString(HashCode hash) {
        Preconditions.checkArgument(hash.bits() % 32 == 0, "HashCode must have a multiple of 32 bits, but had %s bits.", hash.bits());
        byte[] bytes = hash.asBytes();
        StringBuilder builder = new StringBuilder(2 * bytes.length + bytes.length / 4);
        for (int i = 0; i < bytes.length; i += 4) {
            for (int j = 0; j < 4; ++j) {
                byte b = bytes[i + j];
                builder.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
            }
            builder.append('_');
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    public static String toBrokenString(HashCode hash) {
        byte[] bytes = hash.asBytes();
        char[] chars = new char[bytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return new String(chars);
    }
}

