/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.RawValue;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public final class PropertyProjection
extends Projection {
    private final String propertyName;
    private final Class<?> type;

    public PropertyProjection(String propertyName, Class<?> type) {
        Preconditions.checkArgument(type == null || DataTypeTranslator.getTypeMap().containsKey(type), "Unsupported type: " + type);
        this.propertyName = Preconditions.checkNotNull(propertyName);
        this.type = type;
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    String getPropertyName() {
        return this.propertyName;
    }

    @Override
    Object getValue(Map<String, Object> values) {
        Preconditions.checkArgument(values.containsKey(this.propertyName));
        Object value = values.get(this.propertyName);
        if (this.type != null && value != null) {
            Preconditions.checkArgument(value instanceof RawValue);
            value = ((RawValue)value).asType(this.type);
        }
        return value;
    }

    public String toString() {
        return this.propertyName;
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyProjection other = (PropertyProjection)obj;
        if (!this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

