/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.CursorChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import java.io.Serializable;

public final class Cursor
implements Serializable {
    private static final long serialVersionUID = 5983232584697220044L;
    private final String webSafeString;
    private final boolean perResult;

    private Cursor(Builder builder) {
        this.webSafeString = builder.webSafeString;
        this.perResult = builder.perResult;
        this.checkValid();
    }

    public String toWebSafeString() {
        if (this.webSafeString == null) {
            return null;
        }
        boolean bl = this.perResult;
        String string = this.webSafeString;
        return new StringBuilder(6 + String.valueOf(string).length()).append(bl).append(":").append(string).toString();
    }

    public boolean isPerResult() {
        return this.perResult;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Cursor request) {
        return new Builder(request);
    }

    private Cursor checkValid() {
        CursorChecker.checkCursor(this.webSafeString);
        return this;
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer(SearchServicePb.SearchParams.Builder builder) {
        if (this.webSafeString != null) {
            builder.setCursor(this.webSafeString);
        }
        if (this.perResult) {
            builder.setCursorType(SearchServicePb.SearchParams.CursorType.PER_RESULT);
        } else {
            builder.setCursorType(SearchServicePb.SearchParams.CursorType.SINGLE);
        }
        return builder;
    }

    public String toString() {
        return new Util.ToStringHelper("Cursor").addField("webSafeString", this.toWebSafeString()).finish();
    }

    public static final class Builder {
        private String webSafeString;
        private boolean perResult;

        private Builder() {
        }

        private Builder(Cursor request) {
            this.setFromWebSafeString(request.toWebSafeString());
        }

        public Builder setPerResult(boolean perResult) {
            this.perResult = perResult;
            return this;
        }

        public Cursor build(String webSafeString) {
            this.setFromWebSafeString(webSafeString);
            return new Cursor(this);
        }

        private void setFromWebSafeString(String webSafeString) {
            CursorChecker.checkCursor(webSafeString);
            int colon = webSafeString.indexOf(":");
            Preconditions.checkArgument(colon > 0 && colon < webSafeString.length(), "Invalid format for cursor string");
            String booleanString = webSafeString.substring(0, colon);
            Preconditions.checkArgument("true".equals(booleanString) || "false".equals(booleanString), "Invalid format of webSafeString");
            this.perResult = Boolean.parseBoolean(booleanString);
            this.webSafeString = webSafeString.substring(colon + 1);
        }

        public Cursor build() {
            return new Cursor(this);
        }
    }
}

