/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.GeoPoint;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class Field
implements Serializable {
    private static final boolean ONLY_JRE_CLASSES_IN_APIS = Boolean.getBoolean("com.google.appengine.only.jre.classes.in.apis");
    private static final long serialVersionUID = 6829483617830682721L;
    private final String name;
    private final Locale locale;
    private final FieldType type;
    private String text;
    private String html;
    private String atom;
    private Date date;
    private Double number;
    private GeoPoint geoPoint;
    private String untokenizedPrefix;
    private String tokenizedPrefix;
    private List<Double> vector = ONLY_JRE_CLASSES_IN_APIS ? Collections.emptyList() : ImmutableList.of();

    private Field(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        if (builder.type != null) {
            switch (builder.type) {
                case TEXT: {
                    this.text = builder.text;
                    break;
                }
                case HTML: {
                    this.html = builder.html;
                    break;
                }
                case ATOM: {
                    this.atom = builder.atom;
                    break;
                }
                case DATE: {
                    this.date = builder.date;
                    break;
                }
                case NUMBER: {
                    this.number = builder.number;
                    break;
                }
                case GEO_POINT: {
                    this.geoPoint = builder.geoPoint;
                    break;
                }
                case UNTOKENIZED_PREFIX: {
                    this.untokenizedPrefix = builder.untokenizedPrefix;
                    break;
                }
                case TOKENIZED_PREFIX: {
                    this.tokenizedPrefix = builder.tokenizedPrefix;
                    break;
                }
                case VECTOR: {
                    this.vector = builder.vector;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown field type given %s", new Object[]{builder.type}));
                }
            }
        }
        this.locale = builder.locale;
        this.checkValid();
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getHTML() {
        return this.html;
    }

    public String getAtom() {
        return this.atom;
    }

    public Date getDate() {
        return this.date;
    }

    public Double getNumber() {
        return this.number;
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public String getUntokenizedPrefix() {
        return this.untokenizedPrefix;
    }

    public String getTokenizedPrefix() {
        return this.tokenizedPrefix;
    }

    public List<Double> getVector() {
        return this.vector;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return Util.equalObjects(this.name, field.name);
    }

    private Field checkValid() {
        FieldChecker.checkFieldName(this.name);
        if (this.type != null) {
            switch (this.type) {
                case TEXT: {
                    FieldChecker.checkText(this.text);
                    break;
                }
                case HTML: {
                    FieldChecker.checkHTML(this.html);
                    break;
                }
                case ATOM: {
                    FieldChecker.checkAtom(this.atom);
                    break;
                }
                case DATE: {
                    FieldChecker.checkDate(this.date);
                    break;
                }
                case NUMBER: 
                case GEO_POINT: {
                    break;
                }
                case UNTOKENIZED_PREFIX: {
                    FieldChecker.checkPrefix(this.untokenizedPrefix);
                    break;
                }
                case TOKENIZED_PREFIX: {
                    FieldChecker.checkPrefix(this.tokenizedPrefix);
                    break;
                }
                case VECTOR: {
                    FieldChecker.checkVector(this.vector);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
                }
            }
        }
        return this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(DocumentPb.Field field) {
        DocumentPb.FieldValue value = field.getValue();
        Builder fieldBuilder = Field.newBuilder().setName(field.getName());
        if (value.hasLanguage()) {
            fieldBuilder.setLocale(FieldChecker.parseLocale(value.getLanguage()));
        }
        switch (value.getType()) {
            case TEXT: {
                fieldBuilder.setText(value.getStringValue());
                break;
            }
            case HTML: {
                fieldBuilder.setHTML(value.getStringValue());
                break;
            }
            case ATOM: {
                fieldBuilder.setAtom(value.getStringValue());
                break;
            }
            case NUMBER: {
                try {
                    fieldBuilder.setNumber(NumberFormat.getNumberInstance().parse(value.getStringValue()).doubleValue());
                    break;
                }
                catch (ParseException e) {
                    String string = String.valueOf(value.getStringValue());
                    throw new SearchException(string.length() != 0 ? "Failed to parse double: ".concat(string) : new String("Failed to parse double: "));
                }
            }
            case GEO: {
                fieldBuilder.setGeoPoint(GeoPoint.newGeoPoint(value.getGeo()));
                break;
            }
            case DATE: {
                String dateString = value.getStringValue();
                if (dateString == null || dateString.isEmpty()) {
                    throw new SearchException(String.format("date not specified for field %s", field.getName()));
                }
                fieldBuilder.setDate(DateUtil.deserializeDate(dateString));
                break;
            }
            case UNTOKENIZED_PREFIX: {
                fieldBuilder.setUntokenizedPrefix(value.getStringValue());
                break;
            }
            case TOKENIZED_PREFIX: {
                fieldBuilder.setTokenizedPrefix(value.getStringValue());
                break;
            }
            case VECTOR: {
                fieldBuilder.setVector(value.getVectorValueList());
                break;
            }
            default: {
                throw new SearchException(String.format("unknown field value type %s for field %s", value.getType(), field.getName()));
            }
        }
        return fieldBuilder;
    }

    DocumentPb.Field copyToProtocolBuffer() {
        DocumentPb.FieldValue.Builder fieldValueBuilder = DocumentPb.FieldValue.newBuilder();
        if (this.locale != null) {
            fieldValueBuilder.setLanguage(this.locale.toString());
        }
        if (this.type != null) {
            switch (this.type) {
                case TEXT: {
                    if (this.text != null) {
                        fieldValueBuilder.setStringValue(this.text);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.TEXT);
                    break;
                }
                case HTML: {
                    if (this.html != null) {
                        fieldValueBuilder.setStringValue(this.html);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.HTML);
                    break;
                }
                case ATOM: {
                    if (this.atom != null) {
                        fieldValueBuilder.setStringValue(this.atom);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.ATOM);
                    break;
                }
                case DATE: {
                    fieldValueBuilder.setStringValue(DateUtil.serializeDate(this.date));
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.DATE);
                    break;
                }
                case NUMBER: {
                    DecimalFormat format = new DecimalFormat();
                    format.setDecimalSeparatorAlwaysShown(false);
                    format.setGroupingUsed(false);
                    format.setMaximumFractionDigits(Integer.MAX_VALUE);
                    fieldValueBuilder.setStringValue(format.format(this.number));
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.NUMBER);
                    break;
                }
                case GEO_POINT: {
                    fieldValueBuilder.setGeo(this.geoPoint.copyToProtocolBuffer());
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.GEO);
                    break;
                }
                case UNTOKENIZED_PREFIX: {
                    if (this.untokenizedPrefix != null) {
                        fieldValueBuilder.setStringValue(this.untokenizedPrefix);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.UNTOKENIZED_PREFIX);
                    break;
                }
                case TOKENIZED_PREFIX: {
                    if (this.tokenizedPrefix != null) {
                        fieldValueBuilder.setStringValue(this.tokenizedPrefix);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.TOKENIZED_PREFIX);
                    break;
                }
                case VECTOR: {
                    fieldValueBuilder.addAllVectorValue(this.vector);
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.VECTOR);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
                }
            }
        }
        DocumentPb.Field.Builder builder = DocumentPb.Field.newBuilder().setName(this.name).setValue(fieldValueBuilder);
        return builder.build();
    }

    public String toString() {
        return new Util.ToStringHelper("Field").addField("name", this.name).addField("value", this.valueToString()).addField("type", String.valueOf((Object)this.type)).addField("locale", this.locale).finish();
    }

    private String valueToString() throws IllegalArgumentException {
        if (this.type == null) {
            return "null";
        }
        switch (this.type) {
            case TEXT: {
                return this.text;
            }
            case HTML: {
                return this.html;
            }
            case ATOM: {
                return this.atom;
            }
            case DATE: {
                return DateUtil.formatDateTime(this.date);
            }
            case GEO_POINT: {
                return this.geoPoint.toString();
            }
            case NUMBER: {
                DecimalFormat format = new DecimalFormat();
                format.setDecimalSeparatorAlwaysShown(false);
                format.setMaximumFractionDigits(Integer.MAX_VALUE);
                return format.format(this.number);
            }
            case UNTOKENIZED_PREFIX: {
                return this.untokenizedPrefix;
            }
            case TOKENIZED_PREFIX: {
                return this.tokenizedPrefix;
            }
            case VECTOR: {
                return this.vector.toString();
            }
        }
        throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
    }

    public static enum FieldType {
        TEXT,
        HTML,
        ATOM,
        DATE,
        NUMBER,
        GEO_POINT,
        UNTOKENIZED_PREFIX,
        TOKENIZED_PREFIX,
        VECTOR;

    }

    public static final class Builder {
        private String name;
        private Locale locale;
        private FieldType type;
        private String text;
        private String html;
        private String atom;
        private Date date;
        private Double number;
        private GeoPoint geoPoint;
        private String untokenizedPrefix;
        private String tokenizedPrefix;
        private List<Double> vector = Field.access$000() ? Collections.emptyList() : ImmutableList.of();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = FieldChecker.checkFieldName(name);
            return this;
        }

        public Builder setText(String text) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.TEXT;
            this.text = FieldChecker.checkText(text);
            return this;
        }

        public Builder setHTML(String html) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.HTML;
            this.html = FieldChecker.checkHTML(html);
            return this;
        }

        public Builder setAtom(String atom) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.ATOM;
            this.atom = FieldChecker.checkAtom(atom);
            return this;
        }

        public Builder setDate(Date date) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(date != null, "Cannot set date field to null.");
            this.type = FieldType.DATE;
            this.date = FieldChecker.checkDate(date);
            return this;
        }

        public Builder setNumber(double number) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.NUMBER;
            this.number = FieldChecker.checkNumber(number);
            return this;
        }

        public Builder setGeoPoint(GeoPoint geoPoint) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(geoPoint != null, "Cannot set geo field to null.");
            this.type = FieldType.GEO_POINT;
            this.geoPoint = geoPoint;
            return this;
        }

        public Builder setUntokenizedPrefix(String untokenizedPrefix) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.UNTOKENIZED_PREFIX;
            this.untokenizedPrefix = FieldChecker.checkPrefix(untokenizedPrefix);
            return this;
        }

        public Builder setTokenizedPrefix(String tokenizedPrefix) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.TOKENIZED_PREFIX;
            this.tokenizedPrefix = FieldChecker.checkPrefix(tokenizedPrefix);
            return this;
        }

        public Builder setVector(List<Double> vector) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(vector != null, "Cannot set vector field to null");
            ImmutableList<Double> v = ONLY_JRE_CLASSES_IN_APIS ? Collections.unmodifiableList(new ArrayList<Double>(vector)) : ImmutableList.copyOf(vector);
            FieldChecker.checkVector(v);
            this.type = FieldType.VECTOR;
            this.vector = v;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }
}

