/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.GetIndexesRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexImpl;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchService;
import com.google.appengine.api.search.SearchServiceConfig;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import java.util.ArrayList;
import java.util.concurrent.Future;

class SearchServiceImpl
implements SearchService {
    private final SearchApiHelper apiHelper;
    private final SearchServiceConfig config;

    SearchServiceImpl(SearchApiHelper apiHelper, SearchServiceConfig config) {
        this.apiHelper = apiHelper;
        this.config = config.toBuilder().setNamespace(SearchServiceImpl.getAppNamespace(config.getNamespace())).build();
    }

    @Override
    public GetResponse<Index> getIndexes(GetIndexesRequest request) {
        return FutureHelper.quietGet(this.getIndexesAsync(request));
    }

    @Override
    public GetResponse<Index> getIndexes(GetIndexesRequest.Builder builder) {
        return this.getIndexes(builder.build());
    }

    @Override
    public Future<GetResponse<Index>> getIndexesAsync(GetIndexesRequest.Builder builder) {
        return this.getIndexesAsync(builder.build());
    }

    @Override
    public Future<GetResponse<Index>> getIndexesAsync(GetIndexesRequest request) {
        Boolean box = request.isSchemaFetched();
        final boolean fetchSchema = box != null && box != false;
        SearchServicePb.ListIndexesParams.Builder paramsBuilder = request.copyToProtocolBuffer().setNamespace(this.config.getNamespace());
        Future<SearchServicePb.ListIndexesResponse.Builder> future = this.apiHelper.makeAsyncListIndexesCall(paramsBuilder.build(), this.config.getDeadline());
        return new FutureWrapper<SearchServicePb.ListIndexesResponse.Builder, GetResponse<Index>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new GetException(result);
            }

            @Override
            protected GetResponse<Index> wrap(SearchServicePb.ListIndexesResponse.Builder key) throws Exception {
                SearchServicePb.ListIndexesResponse response = key.build();
                OperationResult operationResult = new OperationResult(response.getStatus());
                if (operationResult.getCode() != StatusCode.OK) {
                    throw new GetException(operationResult);
                }
                ArrayList<IndexImpl> indexes = new ArrayList<IndexImpl>(response.getIndexMetadataCount());
                for (SearchServicePb.IndexMetadata metadata : response.getIndexMetadataList()) {
                    SearchServicePb.IndexSpec indexSpec = metadata.getIndexSpec();
                    IndexSpec.Builder builder = IndexSpec.newBuilder().setName(indexSpec.getName());
                    if (indexSpec.hasNamespace()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(SearchServiceImpl.this.config.getNamespace()), String.format("Index with incorrect namespace received '%s' != '%s'", indexSpec.getNamespace(), SearchServiceImpl.this.config.getNamespace()));
                    } else if (!SearchServiceImpl.this.config.getNamespace().isEmpty()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(SearchServiceImpl.this.config.getNamespace()), String.format("Index with incorrect namespace received '' != '%s'", SearchServiceImpl.this.config.getNamespace()));
                    }
                    Long amountUsed = null;
                    Long limit = null;
                    if (metadata.hasStorage()) {
                        amountUsed = metadata.getStorage().getAmountUsed();
                        limit = metadata.getStorage().getLimit();
                    }
                    Schema schema = fetchSchema ? Schema.createSchema(metadata) : null;
                    indexes.add(new IndexImpl(SearchServiceImpl.this.apiHelper, SearchServiceImpl.this.config, builder.build(), schema, amountUsed, limit));
                }
                return new GetResponse<Index>(indexes);
            }
        };
    }

    @Override
    public Index getIndex(IndexSpec.Builder builder) {
        return this.getIndex(builder.build());
    }

    @Override
    public Index getIndex(IndexSpec indexSpec) {
        return new IndexImpl(this.apiHelper, this.config, indexSpec);
    }

    @Override
    public String getNamespace() {
        return this.config.getNamespace();
    }

    private static String getAppNamespace(String namespaceGiven) {
        if (namespaceGiven != null) {
            return namespaceGiven;
        }
        String currentNamespace = NamespaceManager.get();
        return currentNamespace == null ? "" : currentNamespace;
    }
}

