/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.JavaType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public enum FieldType {
    DOUBLE(0, Collection.SCALAR, JavaType.DOUBLE, JavaType.VOID),
    FLOAT(1, Collection.SCALAR, JavaType.FLOAT, JavaType.VOID),
    INT64(2, Collection.SCALAR, JavaType.LONG, JavaType.VOID),
    UINT64(3, Collection.SCALAR, JavaType.LONG, JavaType.VOID),
    INT32(4, Collection.SCALAR, JavaType.INT, JavaType.VOID),
    FIXED64(5, Collection.SCALAR, JavaType.LONG, JavaType.VOID),
    FIXED32(6, Collection.SCALAR, JavaType.INT, JavaType.VOID),
    BOOL(7, Collection.SCALAR, JavaType.BOOLEAN, JavaType.VOID),
    STRING(8, Collection.SCALAR, JavaType.STRING, JavaType.VOID),
    MESSAGE(9, Collection.SCALAR, JavaType.MESSAGE, JavaType.VOID),
    BYTES(10, Collection.SCALAR, JavaType.BYTE_STRING, JavaType.VOID),
    UINT32(11, Collection.SCALAR, JavaType.INT, JavaType.VOID),
    ENUM(12, Collection.SCALAR, JavaType.ENUM, JavaType.VOID),
    SFIXED32(13, Collection.SCALAR, JavaType.INT, JavaType.VOID),
    SFIXED64(14, Collection.SCALAR, JavaType.LONG, JavaType.VOID),
    SINT32(15, Collection.SCALAR, JavaType.INT, JavaType.VOID),
    SINT64(16, Collection.SCALAR, JavaType.LONG, JavaType.VOID),
    GROUP(17, Collection.SCALAR, JavaType.MESSAGE, JavaType.VOID),
    DOUBLE_LIST(18, Collection.VECTOR, JavaType.DOUBLE, JavaType.VOID),
    FLOAT_LIST(19, Collection.VECTOR, JavaType.FLOAT, JavaType.VOID),
    INT64_LIST(20, Collection.VECTOR, JavaType.LONG, JavaType.VOID),
    UINT64_LIST(21, Collection.VECTOR, JavaType.LONG, JavaType.VOID),
    INT32_LIST(22, Collection.VECTOR, JavaType.INT, JavaType.VOID),
    FIXED64_LIST(23, Collection.VECTOR, JavaType.LONG, JavaType.VOID),
    FIXED32_LIST(24, Collection.VECTOR, JavaType.INT, JavaType.VOID),
    BOOL_LIST(25, Collection.VECTOR, JavaType.BOOLEAN, JavaType.VOID),
    STRING_LIST(26, Collection.VECTOR, JavaType.STRING, JavaType.VOID),
    MESSAGE_LIST(27, Collection.VECTOR, JavaType.MESSAGE, JavaType.VOID),
    BYTES_LIST(28, Collection.VECTOR, JavaType.BYTE_STRING, JavaType.VOID),
    UINT32_LIST(29, Collection.VECTOR, JavaType.INT, JavaType.VOID),
    ENUM_LIST(30, Collection.VECTOR, JavaType.ENUM, JavaType.VOID),
    SFIXED32_LIST(31, Collection.VECTOR, JavaType.INT, JavaType.VOID),
    SFIXED64_LIST(32, Collection.VECTOR, JavaType.LONG, JavaType.VOID),
    SINT32_LIST(33, Collection.VECTOR, JavaType.INT, JavaType.VOID),
    SINT64_LIST(34, Collection.VECTOR, JavaType.LONG, JavaType.VOID),
    DOUBLE_LIST_PACKED(35, Collection.PACKED_VECTOR, JavaType.DOUBLE, JavaType.VOID),
    FLOAT_LIST_PACKED(36, Collection.PACKED_VECTOR, JavaType.FLOAT, JavaType.VOID),
    INT64_LIST_PACKED(37, Collection.PACKED_VECTOR, JavaType.LONG, JavaType.VOID),
    UINT64_LIST_PACKED(38, Collection.PACKED_VECTOR, JavaType.LONG, JavaType.VOID),
    INT32_LIST_PACKED(39, Collection.PACKED_VECTOR, JavaType.INT, JavaType.VOID),
    FIXED64_LIST_PACKED(40, Collection.PACKED_VECTOR, JavaType.LONG, JavaType.VOID),
    FIXED32_LIST_PACKED(41, Collection.PACKED_VECTOR, JavaType.INT, JavaType.VOID),
    BOOL_LIST_PACKED(42, Collection.PACKED_VECTOR, JavaType.BOOLEAN, JavaType.VOID),
    UINT32_LIST_PACKED(43, Collection.PACKED_VECTOR, JavaType.INT, JavaType.VOID),
    ENUM_LIST_PACKED(44, Collection.PACKED_VECTOR, JavaType.ENUM, JavaType.VOID),
    SFIXED32_LIST_PACKED(45, Collection.PACKED_VECTOR, JavaType.INT, JavaType.VOID),
    SFIXED64_LIST_PACKED(46, Collection.PACKED_VECTOR, JavaType.LONG, JavaType.VOID),
    SINT32_LIST_PACKED(47, Collection.PACKED_VECTOR, JavaType.INT, JavaType.VOID),
    SINT64_LIST_PACKED(48, Collection.PACKED_VECTOR, JavaType.LONG, JavaType.VOID),
    GROUP_LIST(49, Collection.VECTOR, JavaType.MESSAGE, JavaType.VOID),
    MAP(50, Collection.MAP, JavaType.VOID, JavaType.VOID);

    private final JavaType javaType1;
    private final JavaType javaType2;
    private final int id;
    private final Collection collection;
    private final Class<?> elementType1;
    private final Class<?> elementType2;
    private final boolean primitiveScalar;
    private static final FieldType[] VALUES;
    private static final Type[] EMPTY_TYPES;

    private FieldType(int id, Collection collection, JavaType javaType1, JavaType javaType2) {
        this.id = id;
        this.collection = collection;
        this.javaType1 = javaType1;
        this.javaType2 = javaType2;
        switch (collection) {
            case MAP: {
                this.elementType1 = javaType1.getBoxedType();
                this.elementType2 = javaType2.getBoxedType();
                break;
            }
            case VECTOR: {
                this.elementType1 = javaType1.getBoxedType();
                this.elementType2 = null;
                break;
            }
            default: {
                this.elementType1 = null;
                this.elementType2 = null;
            }
        }
        boolean primitiveScalar = false;
        if (collection == Collection.SCALAR) {
            switch (javaType1) {
                case BYTE_STRING: 
                case MESSAGE: 
                case STRING: {
                    break;
                }
                default: {
                    primitiveScalar = true;
                }
            }
        }
        this.primitiveScalar = primitiveScalar;
    }

    public int id() {
        return this.id;
    }

    public JavaType getJavaType() {
        return this.javaType1;
    }

    public boolean isPacked() {
        return Collection.PACKED_VECTOR.equals((Object)this.collection);
    }

    public boolean isPrimitiveScalar() {
        return this.primitiveScalar;
    }

    public boolean isScalar() {
        return this.collection == Collection.SCALAR;
    }

    public boolean isList() {
        return this.collection.isList();
    }

    public boolean isMap() {
        return this.collection == Collection.MAP;
    }

    public boolean isValidForField(Field field) {
        if (Collection.VECTOR.equals((Object)this.collection)) {
            return this.isValidForList(field);
        }
        return this.javaType1.getType().isAssignableFrom(field.getType());
    }

    private boolean isValidForList(Field field) {
        Type listParameter;
        Class<?> clazz = field.getType();
        if (!this.javaType1.getType().isAssignableFrom(clazz)) {
            return false;
        }
        Type[] types = EMPTY_TYPES;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        }
        if (!((listParameter = FieldType.getListParameter(clazz, types)) instanceof Class)) {
            return true;
        }
        return this.elementType1.isAssignableFrom((Class)listParameter);
    }

    public static FieldType forId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return null;
        }
        return VALUES[id];
    }

    private static Type getGenericSuperList(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Class rawType;
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType2;
            Class rawType2;
            if (!(genericInterface instanceof ParameterizedType) || !List.class.isAssignableFrom(rawType2 = (Class)(parameterizedType2 = (ParameterizedType)genericInterface).getRawType())) continue;
            return genericInterface;
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType && List.class.isAssignableFrom(rawType = (Class)(parameterizedType = (ParameterizedType)type).getRawType())) {
            return type;
        }
        return null;
    }

    private static Type getListParameter(Class<?> clazz, Type[] realTypes) {
        block0: while (clazz != List.class) {
            Type genericType = FieldType.getGenericSuperList(clazz);
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] superArgs = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < superArgs.length; ++i) {
                    Type superArg = superArgs[i];
                    if (!(superArg instanceof TypeVariable)) continue;
                    TypeVariable<Class<T>>[] clazzParams = clazz.getTypeParameters();
                    if (realTypes.length != clazzParams.length) {
                        throw new RuntimeException("Type array mismatch");
                    }
                    boolean foundReplacement = false;
                    for (int j = 0; j < clazzParams.length; ++j) {
                        Type realType;
                        if (superArg != clazzParams[j]) continue;
                        superArgs[i] = realType = realTypes[j];
                        foundReplacement = true;
                        break;
                    }
                    if (foundReplacement) continue;
                    String string = String.valueOf(superArg);
                    throw new RuntimeException(new StringBuilder(31 + String.valueOf(string).length()).append("Unable to find replacement for ").append(string).toString());
                }
                Class<?> parent = (Class<?>)parameterizedType.getRawType();
                realTypes = superArgs;
                clazz = parent;
                continue;
            }
            realTypes = EMPTY_TYPES;
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!List.class.isAssignableFrom(iface)) continue;
                clazz = iface;
                continue block0;
            }
            clazz = clazz.getSuperclass();
        }
        if (realTypes.length != 1) {
            throw new RuntimeException("Unable to identify parameter type for List<T>");
        }
        return realTypes[0];
    }

    static {
        EMPTY_TYPES = new Type[0];
        FieldType[] values = FieldType.values();
        VALUES = new FieldType[values.length];
        FieldType[] fieldTypeArray = values;
        int n = fieldTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FieldType type;
            FieldType.VALUES[type.id] = type = fieldTypeArray[i];
        }
    }

    static enum Collection {
        SCALAR(false),
        VECTOR(true),
        PACKED_VECTOR(true),
        MAP(false);

        private final boolean isList;

        private Collection(boolean isList) {
            this.isList = isList;
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

