/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.DeferredTaskContext;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeferredTaskServlet
extends HttpServlet {
    static final String X_APPENGINE_QUEUENAME = "X-AppEngine-QueueName";
    static final String DEFERRED_TASK_SERVLET_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServlet");
    static final String DEFERRED_TASK_REQUEST_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServletRequest");
    static final String DEFERRED_TASK_RESPONSE_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServletResponse");
    static final String DEFERRED_DO_NOT_RETRY_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".doNotRetry");
    static final String DEFERRED_MARK_RETRY_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".markRetry");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getHeader(X_APPENGINE_QUEUENAME) == null) {
            resp.sendError(403, "Not a taskqueue request.");
            return;
        }
        String method = req.getMethod();
        if (!method.equals("POST")) {
            String msg;
            String protocol = req.getProtocol();
            String string = String.valueOf(method);
            String string2 = msg = string.length() != 0 ? "DeferredTaskServlet does not support method: ".concat(string) : new String("DeferredTaskServlet does not support method: ");
            if (protocol.endsWith("1.1")) {
                resp.sendError(405, msg);
            } else {
                resp.sendError(400, msg);
            }
            return;
        }
        Map<String, Object> attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        attributes.put(DEFERRED_TASK_SERVLET_KEY, (Object)this);
        attributes.put(DEFERRED_TASK_REQUEST_KEY, req);
        attributes.put(DEFERRED_TASK_RESPONSE_KEY, resp);
        attributes.put(DEFERRED_MARK_RETRY_KEY, false);
        try {
            this.performRequest(req, resp);
            if (((Boolean)attributes.get(DEFERRED_MARK_RETRY_KEY)).booleanValue()) {
                resp.setStatus(500);
            } else {
                resp.setStatus(200);
            }
        }
        catch (DeferredTaskException e) {
            resp.setStatus(415);
            String string = String.valueOf(e);
            this.log(new StringBuilder(32 + String.valueOf(string).length()).append("Deferred task failed exception: ").append(string).toString());
            return;
        }
        catch (RuntimeException e) {
            Boolean doNotRetry = (Boolean)attributes.get(DEFERRED_DO_NOT_RETRY_KEY);
            if (doNotRetry == null || !doNotRetry.booleanValue()) {
                throw new ServletException((Throwable)e);
            }
            if (doNotRetry.booleanValue()) {
                resp.setStatus(203);
                String string = DeferredTaskServlet.class.getName();
                String string3 = String.valueOf(e);
                this.log(new StringBuilder(61 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" - Deferred task failed but doNotRetry specified. Exception: ").append(string3).toString());
            }
        }
        finally {
            attributes.remove(DEFERRED_TASK_SERVLET_KEY);
            attributes.remove(DEFERRED_TASK_REQUEST_KEY);
            attributes.remove(DEFERRED_TASK_RESPONSE_KEY);
            attributes.remove(DEFERRED_DO_NOT_RETRY_KEY);
        }
    }

    protected void performRequest(HttpServletRequest req, HttpServletResponse resp) throws DeferredTaskException {
        this.readRequest(req, resp).run();
    }

    protected DeferredTask readRequest(HttpServletRequest req, HttpServletResponse resp) throws DeferredTaskException {
        DeferredTask deferredTask;
        String contentType = req.getHeader("content-type");
        if (contentType == null || !contentType.equals("application/x-binary-app-engine-java-runnable-task")) {
            String string = contentType == null ? "null" : contentType;
            String string2 = "application/x-binary-app-engine-java-runnable-task";
            throw new DeferredTaskException(new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid content-type header. received: '").append(string).append("' expected: '").append(string2).append("'").toString()));
        }
        try {
            ServletInputStream stream = req.getInputStream();
            ObjectInputStream objectStream = new ObjectInputStream(this, (InputStream)stream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader nonPublicLoader = null;
                    boolean hasNonPublicInterface = false;
                    Class[] classObjs = new Class[interfaces.length];
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> cl = Class.forName(interfaces[i], false, classLoader);
                        if ((cl.getModifiers() & 1) == 0) {
                            if (hasNonPublicInterface) {
                                if (nonPublicLoader != cl.getClassLoader()) {
                                    throw new IllegalAccessError("conflicting non-public interface class loaders");
                                }
                            } else {
                                nonPublicLoader = cl.getClassLoader();
                                hasNonPublicInterface = true;
                            }
                        }
                        classObjs[i] = cl;
                    }
                    try {
                        return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : classLoader, classObjs);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClassNotFoundException(null, e);
                    }
                }
            };
            deferredTask = (DeferredTask)objectStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new DeferredTaskException(e);
        }
        catch (IOException e) {
            throw new DeferredTaskException(e);
        }
        catch (ClassCastException e) {
            throw new DeferredTaskException(e);
        }
        return deferredTask;
    }

    protected static class DeferredTaskException
    extends Exception {
        public DeferredTaskException(Exception e) {
            super(e);
        }
    }
}

