/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreServiceInternal;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.GetOrCreateTransactionResult;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PostDeleteFuture;
import com.google.appengine.api.datastore.PostLoadFuture;
import com.google.appengine.api.datastore.PostPutFuture;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionRunner;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MessageLiteOrBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;

abstract class BaseAsyncDatastoreServiceImpl
implements AsyncDatastoreServiceInternal,
CurrentTransactionProvider {
    static final long ARBITRARY_FAILOVER_READ_MS = -1L;
    final DatastoreServiceConfig datastoreServiceConfig;
    final TransactionStack defaultTxnProvider;
    final Logger logger = Logger.getLogger(this.getClass().getName());
    private DatastoreAttributes.DatastoreType datastoreType;
    private final QueryRunner queryRunner;

    BaseAsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider, QueryRunner queryRunner) {
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.defaultTxnProvider = defaultTxnProvider;
        this.queryRunner = queryRunner;
    }

    protected abstract TransactionImpl.InternalTransaction doBeginTransaction(TransactionOptions var1);

    protected abstract Future<Map<Key, Entity>> doBatchGet(Transaction var1, Set<Key> var2, Map<Key, Entity> var3);

    protected abstract Future<List<Key>> doBatchPut(Transaction var1, List<Entity> var2);

    protected abstract Future<Void> doBatchDelete(Transaction var1, Collection<Key> var2);

    static void validateQuery(Query query) {
        Preconditions.checkArgument(query.getFilterPredicates().isEmpty() || query.getFilter() == null, "A query cannot have both a filter and filter predicates set.");
        Preconditions.checkArgument(query.getProjections().isEmpty() || !query.isKeysOnly(), "A query cannot have both projections and keys-only set.");
    }

    GetOrCreateTransactionResult getOrCreateTransaction() {
        Transaction currentTxn = this.getCurrentTransaction(null);
        if (currentTxn != null) {
            return new GetOrCreateTransactionResult(false, currentTxn);
        }
        switch (this.datastoreServiceConfig.getImplicitTransactionManagementPolicy()) {
            case NONE: {
                return new GetOrCreateTransactionResult(false, null);
            }
            case AUTO: {
                return new GetOrCreateTransactionResult(true, this.createTransaction(TransactionOptions.Builder.withDefaults(), false));
            }
        }
        String string = String.valueOf((Object)this.datastoreServiceConfig.getImplicitTransactionManagementPolicy());
        String msg = new StringBuilder(40 + String.valueOf(string).length()).append("Unexpected Transaction Creation Policy: ").append(string).toString();
        this.logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.defaultTxnProvider.peek();
    }

    @Override
    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.defaultTxnProvider.peek(returnedIfNoTxn);
    }

    DatastoreServiceConfig getDatastoreServiceConfig() {
        return this.datastoreServiceConfig;
    }

    @Override
    public Future<Entity> get(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        return this.wrapSingleGet(key, this.get(Arrays.asList(key)));
    }

    @Override
    public Future<Entity> get(Transaction txn, Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        return this.wrapSingleGet(key, this.get(txn, Arrays.asList(key)));
    }

    private Future<Entity> wrapSingleGet(final Key key, Future<Map<Key, Entity>> futureEntities) {
        return new FutureWrapper<Map<Key, Entity>, Entity>(this, futureEntities){

            @Override
            protected Entity wrap(Map<Key, Entity> entities) throws Exception {
                Entity entity = entities.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Key, Entity>> get(final Iterable<Key> keys) {
        return new TransactionRunner<Map<Key, Entity>>(this.getOrCreateTransaction()){

            @Override
            protected Future<Map<Key, Entity>> runInternal(Transaction txn) {
                return BaseAsyncDatastoreServiceImpl.this.get(txn, keys);
            }
        }.runReadInTransaction();
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        ArrayList<Key> keyList = Lists.newArrayList(keys);
        HashMap<Key, Entity> resultMap = new HashMap<Key, Entity>();
        PreGetContext preGetContext = new PreGetContext(this, keyList, resultMap);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreGetCallbacks(preGetContext);
        keyList.removeAll(resultMap.keySet());
        Future<Map<Key, Entity>> result = this.doBatchGet(txn, Sets.newLinkedHashSet(keyList), resultMap);
        return new PostLoadFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), this);
    }

    @Override
    public Future<Key> put(Entity entity) {
        return this.wrapSinglePut(this.put(Arrays.asList(entity)));
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        return this.wrapSinglePut(this.put(txn, Arrays.asList(entity)));
    }

    private Future<Key> wrapSinglePut(Future<List<Key>> futureKeys) {
        return new FutureWrapper<List<Key>, Key>(this, futureKeys){

            @Override
            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<List<Key>> put(final Iterable<Entity> entities) {
        return new TransactionRunner<List<Key>>(this.getOrCreateTransaction()){

            @Override
            protected Future<List<Key>> runInternal(Transaction txn) {
                return BaseAsyncDatastoreServiceImpl.this.put(txn, entities);
            }
        }.runWriteInTransaction();
    }

    @Override
    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        ArrayList<Entity> entityList = entities instanceof List ? (ArrayList<Entity>)entities : Lists.newArrayList(entities);
        PutContext prePutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePrePutCallbacks(prePutContext);
        PostPutFuture result = this.doBatchPut(txn, ImmutableList.copyOf(entities));
        if (txn == null) {
            PutContext postPutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
            result = new PostPutFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), postPutContext);
        } else {
            this.defaultTxnProvider.addPutEntities(txn, entityList);
        }
        return result;
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        return this.delete(Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        return this.delete(txn, Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(final Iterable<Key> keys) {
        return new TransactionRunner<Void>(this.getOrCreateTransaction()){

            @Override
            protected Future<Void> runInternal(Transaction txn) {
                return BaseAsyncDatastoreServiceImpl.this.delete(txn, keys);
            }
        }.runWriteInTransaction();
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        ImmutableList<Key> allKeys = keys instanceof List ? (ImmutableList<Key>)keys : ImmutableList.copyOf(keys);
        DeleteContext preDeleteContext = new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreDeleteCallbacks(preDeleteContext);
        PostDeleteFuture result = this.doBatchDelete(txn, allKeys);
        if (txn == null) {
            result = new PostDeleteFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys));
        } else {
            this.defaultTxnProvider.addDeletedKeys(txn, allKeys);
        }
        return result;
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    protected final <T> Future<T> registerInTransaction(Transaction txn, Future<T> future) {
        if (txn != null) {
            this.defaultTxnProvider.addFuture(txn, future);
            return new FutureHelper.TxnAwareFuture<T>(future, txn, this.defaultTxnProvider);
        }
        return future;
    }

    @Override
    public Future<Transaction> beginTransaction() {
        return this.beginTransaction(TransactionOptions.Builder.withDefaults());
    }

    @Override
    public Future<Transaction> beginTransaction(TransactionOptions options) {
        Transaction txn = this.createTransaction(options, true);
        this.defaultTxnProvider.push(txn);
        return new FutureHelper.FakeFuture<Transaction>(txn);
    }

    private Transaction createTransaction(TransactionOptions options, boolean isExplicit) {
        return new TransactionImpl(this.datastoreServiceConfig.getAppIdNamespace().getAppId(), this.defaultTxnProvider, this.datastoreServiceConfig.getDatastoreCallbacks(), isExplicit, this.doBeginTransaction(options));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.prepare(null, query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        PreQueryContext context = new PreQueryContext((CurrentTransactionProvider)this, query);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreQueryCallbacks(context);
        query = (Query)context.getElements().get(0);
        BaseAsyncDatastoreServiceImpl.validateQuery(query);
        if (this.isGeoQuery(query)) {
            return new PreparedQueryImpl(query, txn, this.queryRunner);
        }
        List<MultiQueryBuilder> queriesToRun = QuerySplitHelper.splitQuery(query);
        query.setFilter(null);
        query.getFilterPredicates().clear();
        if (queriesToRun.size() == 1 && queriesToRun.get(0).isSingleton()) {
            query.getFilterPredicates().addAll(queriesToRun.get(0).getBaseFilters());
            return new PreparedQueryImpl(query, txn, this.queryRunner);
        }
        return new PreparedMultiQuery(query, queriesToRun, txn, this.queryRunner);
    }

    private boolean isGeoQuery(Query query) {
        Query.Filter filter = query.getFilter();
        if (filter == null) {
            return false;
        }
        return this.isGeoFilter(filter);
    }

    private boolean isGeoFilter(Query.Filter filter) {
        if (filter instanceof Query.StContainsFilter) {
            return true;
        }
        if (filter instanceof Query.CompositeFilter) {
            for (Query.Filter f : ((Query.CompositeFilter)filter).getSubFilters()) {
                if (!this.isGeoFilter(f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Future<KeyRange> allocateIds(String kind, long num) {
        return this.allocateIds(null, kind, num);
    }

    protected DatastoreAttributes.DatastoreType getDatastoreType() {
        if (this.datastoreType == null) {
            this.datastoreType = FutureHelper.quietGet(this.getDatastoreAttributes()).getDatastoreType();
        }
        return this.datastoreType;
    }

    @Override
    public Future<DatastoreAttributes> getDatastoreAttributes() {
        String appId = this.datastoreServiceConfig.getAppIdNamespace().getAppId();
        DatastoreAttributes attributes = new DatastoreAttributes(appId);
        return new FutureHelper.FakeFuture<DatastoreAttributes>(attributes);
    }

    abstract class BaseRpcBatcher<S extends Message, R extends MessageLiteOrBuilder, F, T extends MessageLite>
    extends Batcher<R, F, T> {
        BaseRpcBatcher() {
        }

        abstract Future<S> makeCall(R var1);

        @Override
        final int getMaxSize() {
            return BaseAsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxRpcSizeBytes;
        }

        @Override
        final int getMaxGroups() {
            return BaseAsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxEntityGroupsPerRpc;
        }

        final List<Future<S>> makeCalls(Iterator<R> batches) {
            ArrayList<Future<S>> futures = new ArrayList<Future<S>>();
            while (batches.hasNext()) {
                futures.add(this.makeCall((MessageLiteOrBuilder)batches.next()));
            }
            return futures;
        }
    }
}

