/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PrefixTrie;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Ticker;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class MonitoredIndexUsageTracker {
    private static final int DEFAULT_USAGE_REFRESH_PERIOD_SECS = 60;
    private static final double DEFAULT_REFRESH_QUERY_DEADLINE_SECS = 0.2;
    private static final double DEFAULT_PUT_DEADLINE_SECS = 0.2;
    private static final String[] DEFAULT_API_PACKAGE_PREFIXES = new String[]{"com.google.appengine", "com.google.apphosting", "org.datanucleus"};
    static final String REFRESH_PERIOD_SECS_SYS_PROP = "appengine.datastore.indexMonitoring.persistedUsageRefreshPeriodSecs";
    private static final String REFRESH_QUERY_DEADLINE_SECS_SYS_PROP = "appengine.datastore.indexMonitoring.refreshUsageInfoQueryDeadlineSecs";
    private static final String PUT_DEADLINE_SECS_SYS_PROP = "appengine.datastore.indexMonitoring.newUsagePutDeadlineSecs";
    private static final String PACKAGE_PREFIXES_TO_SKIP_SYS_PROP = "appengine.datastore.apiPackagePrefixes";
    private static final String NEW_USAGE_LOGGING_THRESHOLD_SECS_SYS_PROP = "appengine.datastore.indexMonitoring.newUsageLoggingThresholdSecs";
    static final int REFRESH_QUERY_FAILURE_LOGGING_THRESHOLD = 10;
    private static final int MAX_MONITORED_INDEXES = 100;
    private static final int MAX_TRACKED_USAGES_PER_INDEX = 30;
    private static final int MAX_STACK_FRAMES_SAVED = 200;
    private static final String USAGE_ENTITY_KIND_PREFIX = "_ah_datastore_monitored_index_";
    private static final String USAGE_ENTITY_QUERY_PROPERTY = "query";
    private static final String USAGE_ENTITY_CAPTURE_TIME_PROPERTY = "diagnosticCaptureDurationNanos";
    private static final String USAGE_ENTITY_OCCURRENCE_TIME_PROPERTY = "occurrenceTime";
    private static final String USAGE_ENTITY_STACK_TRACE_PROPERTY = "stackTrace";
    private static final String USAGE_ENTITY_APP_VERSION_PROPERTY = "appVersion";
    static Logger logger = Logger.getLogger(MonitoredIndexUsageTracker.class.getName());
    private final int maxUsagesTrackedPerIndex;
    private final UsageIdCache perIndexUsageIds;
    private final Ticker ticker;
    private final long usageRefreshPeriodNanos;
    private final double refreshQueryDeadlineSecs;
    private final double putDeadlineSecs;
    private final long newUsageLoggingThresholdNanos;
    private final PrefixTrie<Boolean> apiPackagePrefixTrie;

    MonitoredIndexUsageTracker() {
        this(100, 30, Ticker.systemTicker());
    }

    MonitoredIndexUsageTracker(int maxIndexesTracked, int maxUsagesPerIndex, Ticker ticker) {
        this.maxUsagesTrackedPerIndex = maxUsagesPerIndex;
        this.ticker = ticker;
        this.usageRefreshPeriodNanos = MonitoredIndexUsageTracker.getUsageRefreshPeriodNanos();
        this.refreshQueryDeadlineSecs = MonitoredIndexUsageTracker.getRefreshQueryDeadlineSecs();
        this.putDeadlineSecs = MonitoredIndexUsageTracker.getPutDeadlineSecs();
        this.newUsageLoggingThresholdNanos = MonitoredIndexUsageTracker.getNewUsageLoggingThresholdNanos();
        this.perIndexUsageIds = new UsageIdCache(maxIndexesTracked);
        this.apiPackagePrefixTrie = MonitoredIndexUsageTracker.getApiPackagePrefixesTrie();
    }

    public void addNewUsage(Collection<Index> monitoredIndexes, Query query) {
        long methodElapsedTimeNanos;
        Preconditions.checkNotNull(monitoredIndexes);
        Preconditions.checkNotNull(query);
        long methodInvocationTimeNanos = this.ticker.read();
        Date occurenceDate = this.newDate();
        LazyApiInvokerStackTrace lazyStackTrace = new LazyApiInvokerStackTrace();
        ArrayList<ExpiringPersistedUsageIds> usageIdsPerIndex = Lists.newArrayListWithExpectedSize(monitoredIndexes.size());
        for (Index index : monitoredIndexes) {
            usageIdsPerIndex.add(this.perIndexUsageIds.get(index.getId()));
        }
        ArrayList<Entity> newUsagesToPersist = Lists.newArrayList();
        Iterator usageIdsPerIndexIter = usageIdsPerIndex.iterator();
        for (Index index : monitoredIndexes) {
            PersistedUsageIds persistedUsageIds = ((ExpiringPersistedUsageIds)usageIdsPerIndexIter.next()).get();
            if (!persistedUsageIds.addNewUsage(MonitoredIndexUsageTracker.getUsageEntityKeyName(query))) continue;
            newUsagesToPersist.add(this.newUsageEntity(index, query, occurenceDate, lazyStackTrace));
        }
        if (!newUsagesToPersist.isEmpty()) {
            this.persistNewUsages(newUsagesToPersist);
        }
        if ((methodElapsedTimeNanos = this.ticker.read() - methodInvocationTimeNanos) > this.newUsageLoggingThresholdNanos) {
            long elapsedTimeSecs = methodElapsedTimeNanos / 1000000000L;
            long elapsedTimeRemNanos = methodElapsedTimeNanos % 1000000000L;
            logger.severe(String.format("WARNING: tracking usage of monitored indexes took %d.%09d secs", elapsedTimeSecs, elapsedTimeRemNanos));
        }
    }

    void persistNewUsages(List<Entity> newUsagesToPersist) {
        AsyncDatastoreService asyncDatastore = this.newAsyncDatastoreService(this.putDeadlineSecs);
        try {
            Future<List<Key>> future = asyncDatastore.put((Transaction)null, newUsagesToPersist);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, String.format("Failed to record monitored index usage: %s", newUsagesToPersist.get(0).toString()), e);
        }
    }

    QueryAndFetchOptions getPersistedUsageRefreshQuery(Long indexId) {
        Query refreshQuery = new Query(MonitoredIndexUsageTracker.getUsageEntityKind(indexId));
        refreshQuery.setKeysOnly();
        return new QueryAndFetchOptions(refreshQuery, FetchOptions.Builder.withLimit(this.maxUsagesTrackedPerIndex));
    }

    private static String getUsageEntityKind(long compositeIndexId) {
        String string = USAGE_ENTITY_KIND_PREFIX;
        return new StringBuilder(20 + String.valueOf(string).length()).append(string).append(compositeIndexId).toString();
    }

    private static String getUsageEntityKeyName(Query query) {
        return Integer.toString(query.hashCodeNoFilterValues());
    }

    Entity newUsageEntity(Index index, Query query, Date occurenceTime, LazyApiInvokerStackTrace lazyStackTrace) {
        String kind = MonitoredIndexUsageTracker.getUsageEntityKind(index.getId());
        Key key = KeyFactory.createKey(kind, MonitoredIndexUsageTracker.getUsageEntityKeyName(query));
        StackTraceInfo stackTraceInfo = lazyStackTrace.get();
        Entity entity = new Entity(key);
        entity.setProperty(USAGE_ENTITY_QUERY_PROPERTY, new Text(query.toString()));
        entity.setProperty(USAGE_ENTITY_CAPTURE_TIME_PROPERTY, stackTraceInfo.captureTimeNanos);
        entity.setProperty(USAGE_ENTITY_OCCURRENCE_TIME_PROPERTY, occurenceTime);
        entity.setProperty(USAGE_ENTITY_STACK_TRACE_PROPERTY, new Text(stackTraceInfo.stackTrace));
        entity.setProperty(USAGE_ENTITY_APP_VERSION_PROPERTY, SystemProperty.applicationVersion.get());
        return entity;
    }

    AsyncDatastoreService newAsyncDatastoreService(double deadlineSecs) {
        return DatastoreServiceFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDatastoreCallbacks(DatastoreCallbacks.NoOpDatastoreCallbacks.INSTANCE).deadline(deadlineSecs));
    }

    Date newDate() {
        return new Date();
    }

    private static long getUsageRefreshPeriodNanos() {
        String usageRefreshPeriodSecsStr = System.getProperty(REFRESH_PERIOD_SECS_SYS_PROP);
        if (usageRefreshPeriodSecsStr != null) {
            double usageRefreshPeriodSecs = Double.parseDouble(usageRefreshPeriodSecsStr);
            return (long)(usageRefreshPeriodSecs * 1000.0 * 1000.0 * 1000.0);
        }
        return TimeUnit.SECONDS.toNanos(60L);
    }

    private static double getRefreshQueryDeadlineSecs() {
        String refreshDeadlineSecsStr = System.getProperty(REFRESH_QUERY_DEADLINE_SECS_SYS_PROP);
        if (refreshDeadlineSecsStr != null) {
            return Double.parseDouble(refreshDeadlineSecsStr);
        }
        return 0.2;
    }

    private static double getPutDeadlineSecs() {
        String putDeadlineSecsStr = System.getProperty(PUT_DEADLINE_SECS_SYS_PROP);
        if (putDeadlineSecsStr != null) {
            return Double.parseDouble(putDeadlineSecsStr);
        }
        return 0.2;
    }

    private static long getNewUsageLoggingThresholdNanos() {
        String newUsageLoggingThreshSecsStr = System.getProperty(NEW_USAGE_LOGGING_THRESHOLD_SECS_SYS_PROP);
        if (newUsageLoggingThreshSecsStr != null) {
            double newUsageLoggingThreshSecs = Double.parseDouble(newUsageLoggingThreshSecsStr);
            return (long)(newUsageLoggingThreshSecs * 1000.0 * 1000.0 * 1000.0);
        }
        return Long.MAX_VALUE;
    }

    private static PrefixTrie<Boolean> getApiPackagePrefixesTrie() {
        PrefixTrie<Boolean> prefixTrie = new PrefixTrie<Boolean>();
        for (String apiPrefix : DEFAULT_API_PACKAGE_PREFIXES) {
            prefixTrie.put(apiPrefix, Boolean.TRUE);
        }
        String sysPropApiPrefixesString = System.getProperty(PACKAGE_PREFIXES_TO_SKIP_SYS_PROP);
        if (sysPropApiPrefixesString != null) {
            String[] sysPropApiPrefixes;
            for (String apiPrefix : sysPropApiPrefixes = sysPropApiPrefixesString.split("\\,")) {
                prefixTrie.put(apiPrefix, Boolean.TRUE);
            }
        }
        return prefixTrie;
    }

    private static String getApiInvokerStackTrace(PrefixTrie<Boolean> apiPackagePrefixes) {
        String className;
        int frameIdx;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (frameIdx = 1; frameIdx < stack.length && apiPackagePrefixes.get(className = stack[frameIdx].getClassName()) != null; ++frameIdx) {
        }
        if (frameIdx >= stack.length) {
            return "";
        }
        int numFrames = stack.length - frameIdx;
        numFrames = Math.min(numFrames, 200);
        StringBuilder sb = new StringBuilder();
        while (frameIdx < stack.length) {
            sb.append(stack[frameIdx]);
            sb.append("\n");
            ++frameIdx;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    class LazyApiInvokerStackTrace {
        private StackTraceInfo stackTraceInfo;

        LazyApiInvokerStackTrace() {
        }

        private StackTraceInfo get() {
            if (this.stackTraceInfo == null) {
                long startNs = MonitoredIndexUsageTracker.this.ticker.read();
                String stackTrace = MonitoredIndexUsageTracker.getApiInvokerStackTrace(MonitoredIndexUsageTracker.this.apiPackagePrefixTrie);
                long captureTimeNanos = MonitoredIndexUsageTracker.this.ticker.read() - startNs;
                this.stackTraceInfo = new StackTraceInfo(stackTrace, captureTimeNanos);
            }
            return this.stackTraceInfo;
        }
    }

    private static class StackTraceInfo {
        final String stackTrace;
        final long captureTimeNanos;

        StackTraceInfo(String stackTrace, long captureTimeNanos) {
            this.stackTrace = stackTrace;
            this.captureTimeNanos = captureTimeNanos;
        }
    }

    private static class PersistedUsageIds {
        private static final PersistedUsageIds TOMBSTONE_INSTANCE = new PersistedUsageIds(0);
        private final Set<String> persistedIds;
        private final int maxIdsPersisted;

        PersistedUsageIds(int maxIdsPersisted) {
            this.persistedIds = Sets.newHashSetWithExpectedSize(maxIdsPersisted);
            this.maxIdsPersisted = maxIdsPersisted;
        }

        synchronized boolean addNewUsage(String usageId) {
            if (this.persistedIds.size() >= this.maxIdsPersisted) {
                return false;
            }
            return this.persistedIds.add(usageId);
        }
    }

    private class ExpiringPersistedUsageIds {
        private final Long creationTimeNanos;
        private final Thread usageLoaderThread;
        private volatile int numContiguousRefreshQueryFailures;
        private volatile PersistedUsageIds usageIds;
        private Iterable<Entity> refreshQueryEntities;

        private ExpiringPersistedUsageIds(Long indexId, ExpiringPersistedUsageIds prevExpiringUsageIds) {
            this.creationTimeNanos = MonitoredIndexUsageTracker.this.ticker.read();
            this.usageLoaderThread = Thread.currentThread();
            if (prevExpiringUsageIds != null) {
                this.usageIds = prevExpiringUsageIds.usageIds;
                this.numContiguousRefreshQueryFailures = prevExpiringUsageIds.numContiguousRefreshQueryFailures;
            } else {
                this.usageIds = PersistedUsageIds.TOMBSTONE_INSTANCE;
                this.numContiguousRefreshQueryFailures = 0;
            }
            QueryAndFetchOptions refreshQuery = MonitoredIndexUsageTracker.this.getPersistedUsageRefreshQuery(indexId);
            AsyncDatastoreService asyncDatastore = MonitoredIndexUsageTracker.this.newAsyncDatastoreService(MonitoredIndexUsageTracker.this.refreshQueryDeadlineSecs);
            PreparedQuery refreshPQ = asyncDatastore.prepare(refreshQuery.query);
            this.refreshQueryEntities = null;
            try {
                this.refreshQueryEntities = refreshPQ.asIterable(refreshQuery.fetchOptions);
            }
            catch (RuntimeException e) {
                ++this.numContiguousRefreshQueryFailures;
                logger.log(Level.SEVERE, String.format("Failed to query existing monitored index usages: %s", refreshPQ.toString()), e);
            }
        }

        private PersistedUsageIds get() {
            if (this.usageLoaderThread != Thread.currentThread() || null == this.refreshQueryEntities) {
                return this.usageIds;
            }
            boolean logException = false;
            RuntimeException throwable = null;
            try {
                PersistedUsageIds existingKeys = new PersistedUsageIds(MonitoredIndexUsageTracker.this.maxUsagesTrackedPerIndex);
                for (Entity persistedEntity : this.refreshQueryEntities) {
                    existingKeys.addNewUsage(persistedEntity.getKey().getName());
                }
                this.usageIds = existingKeys;
                this.numContiguousRefreshQueryFailures = 0;
            }
            catch (ApiProxy.OverQuotaException e) {
                throwable = e;
            }
            catch (DeadlineExceededException e) {
                throwable = e;
            }
            catch (DatastoreTimeoutException e) {
                throwable = e;
            }
            catch (DatastoreFailureException e) {
                throwable = e;
            }
            catch (RuntimeException e) {
                logException = true;
                throwable = e;
            }
            if (throwable != null) {
                ++this.numContiguousRefreshQueryFailures;
                if (this.numContiguousRefreshQueryFailures % 10 == 0) {
                    logException = true;
                }
                if (logException) {
                    logger.log(Level.SEVERE, "Failed to query existing monitored index usage information", throwable);
                }
            }
            this.refreshQueryEntities = null;
            return this.usageIds;
        }

        private boolean isExpired() {
            return MonitoredIndexUsageTracker.this.ticker.read() - this.creationTimeNanos > MonitoredIndexUsageTracker.this.usageRefreshPeriodNanos;
        }
    }

    static class UsageIdCacheMap
    extends LinkedHashMap<Long, ExpiringPersistedUsageIds> {
        static final long serialVersionUID = -5010587885037930115L;
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private static final boolean SORT_ELEMENTS_BY_ACCESS_ORDER = true;
        private final int capacity;

        UsageIdCacheMap(int capacity) {
            super(16, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, ExpiringPersistedUsageIds> eldest) {
            return this.size() > this.capacity;
        }
    }

    private class UsageIdCache {
        final UsageIdCacheMap usageIdMap;

        private UsageIdCache(int capacity) {
            this.usageIdMap = new UsageIdCacheMap(capacity);
        }

        private synchronized ExpiringPersistedUsageIds get(Long indexId) {
            ExpiringPersistedUsageIds usageIds = (ExpiringPersistedUsageIds)this.usageIdMap.get(indexId);
            if (usageIds == null || usageIds.isExpired()) {
                usageIds = new ExpiringPersistedUsageIds(indexId, usageIds);
                this.usageIdMap.put(indexId, usageIds);
            }
            return usageIds;
        }
    }

    static class QueryAndFetchOptions {
        final Query query;
        final FetchOptions fetchOptions;

        QueryAndFetchOptions(Query query, FetchOptions fetchOptions) {
            this.query = query;
            this.fetchOptions = fetchOptions;
        }
    }
}

