/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.search.DocumentPb;

public final class DocumentChecker {
    private static final long MILLIS_UP_TO_1ST_JAN_2011 = 1293840000000L;

    public static String checkDocumentId(String documentId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(documentId), "Document id is null or empty");
        Preconditions.checkArgument(documentId.length() <= 500, "Document id is longer than %d: %s", 500, documentId);
        Preconditions.checkArgument(IndexChecker.isAsciiVisiblePrintable(documentId), "Document id must be ASCII visible printable: %s", documentId);
        Preconditions.checkArgument(!IndexChecker.isReserved(documentId), "Document id must not start with !: %s", documentId);
        return documentId;
    }

    public static void checkFieldSet(DocumentPb.Document document) {
        HashMultimap<String, DocumentPb.FieldValue.ContentType> noRepeatNames = HashMultimap.create();
        for (DocumentPb.Field field : document.getFieldList()) {
            DocumentPb.FieldValue.ContentType type = field.getValue().getType();
            if (type != DocumentPb.FieldValue.ContentType.NUMBER && type != DocumentPb.FieldValue.ContentType.DATE && type != DocumentPb.FieldValue.ContentType.VECTOR || noRepeatNames.put(field.getName(), type)) continue;
            String typeString = type == DocumentPb.FieldValue.ContentType.VECTOR ? "vector" : "date or number";
            String string = document.getId();
            String string2 = field.getName();
            throw new IllegalArgumentException(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(typeString).length()).append("Invalid document ").append(string).append(": field ").append(string2).append(" with type ").append(typeString).append(" may not be repeated.").toString());
        }
    }

    public static DocumentPb.Document checkValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(pb.getSerializedSize() <= 0x100000, "Document length %d is greater than the maximum %d bytes", pb.getSerializedSize(), 0x100000);
        if (pb.hasId()) {
            DocumentChecker.checkUTF8ByteString(pb.getIdBytes(), "Document id has invalid utf8 sequence.", new Object[0]);
            DocumentChecker.checkDocumentId(pb.getId());
        }
        DocumentChecker.mandatoryCheckValid(pb);
        return pb;
    }

    static void mandatoryCheckValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(!pb.getFieldList().isEmpty(), "Empty list of fields in document for indexing");
        DocumentChecker.checkFieldSet(pb);
        DocumentChecker.checkValidUtf8(pb);
    }

    private static void checkUTF8ByteString(ByteString utf8, String format, Object ... args) {
        if (!utf8.isValidUtf8()) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    static void checkValidUtf8(DocumentPb.Document document) {
        DocumentChecker.checkUTF8ByteString(document.getIdBytes(), "Document id has invalid utf8 sequence.", new Object[0]);
        String docId = document.getId();
        DocumentChecker.checkUTF8ByteString(document.getLanguageBytes(), "Invalid utf8 sequence in language of document %s", docId);
        for (DocumentPb.Field field : document.getFieldList()) {
            DocumentChecker.checkUTF8ByteString(field.getNameBytes(), "Invalid utf8 sequence in a field name of document %s", docId);
            DocumentChecker.checkUTF8ByteString(field.getValue().getLanguageBytes(), "Invalid utf8 sequence in language of field %s document %s", field.getName(), docId);
            DocumentChecker.checkUTF8ByteString(field.getValue().getStringValueBytes(), "Invalid utf8 sequence in value of field %s document %s", field.getName(), docId);
        }
        for (DocumentPb.Facet facet : document.getFacetList()) {
            DocumentChecker.checkUTF8ByteString(facet.getNameBytes(), "Invalid utf8 sequence in a facet name of document %s", docId);
            DocumentChecker.checkUTF8ByteString(facet.getValue().getStringValueBytes(), "Invalid utf8 sequence in value of facet %s document %s", facet.getName(), docId);
        }
    }

    public static int getNumberOfSecondsSince() {
        long millisSince = Math.max(0L, (System.currentTimeMillis() - 1293840000000L) / 1000L);
        Preconditions.checkArgument(millisSince <= Integer.MAX_VALUE, "API failure due to date conversion overflow");
        return (int)millisSince;
    }
}

