/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.checkers.GeoPointChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.SearchApiLimits;
import com.google.appengine.api.search.query.ExpressionTreeBuilder;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.apphosting.api.search.DocumentPb;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class FieldChecker {
    public static String checkFieldName(String name) {
        return FieldChecker.checkFieldName(name, "field name");
    }

    public static String checkFieldName(String name, String fieldName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "%s cannot be null or empty", fieldName);
        Preconditions.checkArgument(FieldChecker.bytesInString(name) <= 500, "%s longer than %d: %s", fieldName, 500, name);
        Preconditions.checkArgument(name.matches("^[A-Za-z][A-Za-z0-9_]*$"), "%s should match pattern %s: %s", fieldName, "^[A-Za-z][A-Za-z0-9_]*$", name);
        return name;
    }

    static int bytesInString(String str) {
        return str.getBytes(Charset.forName("UTF-8")).length;
    }

    static boolean nameMatchesPattern(String name) {
        return name.matches("^[A-Za-z][A-Za-z0-9_]*$");
    }

    public static String checkText(String text) {
        if (text != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(text) <= 0x100000, "Field text longer than maximum length %d", 0x100000);
        }
        return text;
    }

    public static String checkHTML(String html) {
        if (html != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(html) <= 0x100000, "html longer than maximum length %d", 0x100000);
        }
        return html;
    }

    public static String checkAtom(String atom) {
        if (atom != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(atom) <= 500, "Field atom longer than maximum length %d", 500);
        }
        return atom;
    }

    public static String checkPrefix(String prefix) {
        if (prefix != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(prefix) <= 500, "Field prefix longer than maximum length %d", 500);
        }
        return prefix;
    }

    public static List<Double> checkVector(List<Double> vector) {
        Preconditions.checkArgument(vector.size() <= 10000, "Vector size greater than %d", 10000);
        for (Double d : vector) {
            Preconditions.checkNotNull(d, "Vector element cannot be null");
            Preconditions.checkArgument(!d.isNaN() && !d.isInfinite(), "Vector element should be a finite number");
        }
        return vector;
    }

    public static Double checkNumber(Double value) {
        if (value != null) {
            Preconditions.checkArgument(-2.147483647E9 <= value, String.format("number value, %f, must be greater than or equal to %f", value, -2.147483647E9));
            Preconditions.checkArgument(value <= 2.147483647E9, String.format("number value, %f, must be less than or equal to %f", value, 2.147483647E9));
        }
        return value;
    }

    public static Date checkDate(Date date) throws IllegalArgumentException {
        if (date != null) {
            Preconditions.checkArgument(SearchApiLimits.MINIMUM_DATE_VALUE.compareTo(date) <= 0, String.format("date %s must be after %s", DateUtil.formatDateTime(date), DateUtil.formatDateTime(SearchApiLimits.MINIMUM_DATE_VALUE)));
            Preconditions.checkArgument(date.compareTo(SearchApiLimits.MAXIMUM_DATE_VALUE) <= 0, String.format("date %s must be before %s", DateUtil.formatDateTime(date), DateUtil.formatDateTime(SearchApiLimits.MAXIMUM_DATE_VALUE)));
        }
        return date;
    }

    private static String checkExpressionHelper(String expression, String mode) {
        Preconditions.checkNotNull(expression, "expression cannot be null");
        ExpressionTreeBuilder parser = new ExpressionTreeBuilder();
        try {
            parser.parse(expression);
        }
        catch (RecognitionException e) {
            String message = String.format("Failed to parse %s expression '%s': parse error at line %d position %d", mode, expression, e.line, e.charPositionInLine);
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static String checkExpression(String expression) {
        return FieldChecker.checkExpressionHelper(expression, "field");
    }

    public static String checkSortExpression(String expression) {
        return FieldChecker.checkExpressionHelper(expression, "sort");
    }

    public static DocumentPb.Field checkValid(DocumentPb.Field field) {
        FieldChecker.checkFieldName(field.getName());
        DocumentPb.FieldValue value = field.getValue();
        switch (value.getType()) {
            case TEXT: {
                FieldChecker.checkText(value.getStringValue());
                break;
            }
            case HTML: {
                FieldChecker.checkHTML(value.getStringValue());
                break;
            }
            case DATE: {
                FieldChecker.checkDate(DateUtil.deserializeDate(value.getStringValue()));
                break;
            }
            case ATOM: {
                FieldChecker.checkAtom(value.getStringValue());
                break;
            }
            case NUMBER: {
                FieldChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                break;
            }
            case GEO: {
                GeoPointChecker.checkValid(value.getGeo());
                break;
            }
            case UNTOKENIZED_PREFIX: 
            case TOKENIZED_PREFIX: {
                FieldChecker.checkPrefix(value.getStringValue());
                break;
            }
            case VECTOR: {
                FieldChecker.checkVector(value.getVectorValueList());
                break;
            }
            default: {
                String string = String.valueOf(value.getType());
                throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported field type ").append(string).toString());
            }
        }
        return field;
    }

    public static Locale parseLocale(String locale) {
        if (locale == null) {
            return null;
        }
        String[] parts = locale.split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        String string = String.valueOf(locale);
        throw new IllegalArgumentException(string.length() != 0 ? "Cannot parse locale ".concat(string) : new String("Cannot parse locale "));
    }
}

