/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.AbstractLogger;
import com.google.appengine.repackaged.com.google.common.flogger.LazyArg;
import com.google.appengine.repackaged.com.google.common.flogger.LogSite;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteStats;
import com.google.appengine.repackaged.com.google.common.flogger.LoggingApi;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.backend.TemplateContext;
import com.google.appengine.repackaged.com.google.common.flogger.parser.MessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class LogContext<LOGGER extends AbstractLogger<API>, API extends LoggingApi<API>>
implements LoggingApi<API>,
LogData {
    private static final String LITERAL_VALUE_MESSAGE = new String();
    private final Level level;
    private final long timestampMicros;
    private MutableMetadata metadata = null;
    private LogSite logSite = null;
    private TemplateContext templateContext = null;
    private Object[] args = null;

    protected LogContext(Level level, boolean isForced) {
        this(level, isForced, Platform.getCurrentTimeMicros());
    }

    protected LogContext(Level level, boolean isForced, long timestampMicros) {
        this.level = Checks.checkNotNull(level, "level");
        this.timestampMicros = timestampMicros;
        if (isForced) {
            this.addMetadata("/forced", Boolean.TRUE);
        }
    }

    protected abstract API api();

    protected abstract LOGGER getLogger();

    protected abstract API noOp();

    protected abstract MessageParser getMessageParser();

    @Override
    public final Level getLevel() {
        return this.level;
    }

    @Override
    public final long getTimestampMicros() {
        return this.timestampMicros;
    }

    @Override
    public final String getLoggerName() {
        return ((AbstractLogger)this.getLogger()).getBackend().getLoggerName();
    }

    @Override
    public final LogSite getLogSite() {
        if (this.logSite == null) {
            throw new IllegalStateException("cannot request log site information prior to postProcess()");
        }
        return this.logSite;
    }

    @Override
    public final TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    @Override
    public final Object[] getArguments() {
        if (this.templateContext == null) {
            throw new IllegalStateException("cannot get arguments unless a template context exists");
        }
        return this.args;
    }

    @Override
    public final Object getLiteralArgument() {
        if (this.templateContext != null) {
            throw new IllegalStateException("cannot get literal argument if a template context exists");
        }
        return this.args[0];
    }

    @Override
    public final boolean wasForced() {
        return this.metadata != null && this.metadata.findValue("/forced") == Boolean.TRUE;
    }

    @Override
    public final Metadata getMetadata() {
        return this.metadata != null ? this.metadata : Metadata.EMPTY;
    }

    protected final void setMetadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new MutableMetadata();
        }
        this.metadata.setValue(key, value);
    }

    protected final void addMetadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new MutableMetadata();
        }
        this.metadata.addValue(key, value);
    }

    protected final void removeMetadata(String key) {
        if (this.metadata != null) {
            this.metadata.removeAllValues(key);
        }
    }

    protected boolean postProcess(@Nullable LogSiteKey logSiteKey) {
        if (this.metadata == null || logSiteKey == null) {
            return true;
        }
        Integer rateLimitCount = (Integer)this.metadata.findValue("/ratelimit count");
        LogSiteStats.RateLimitPeriod rateLimitPeriod = (LogSiteStats.RateLimitPeriod)this.metadata.findValue("/ratelimit period");
        if (rateLimitCount == null && rateLimitPeriod == null) {
            return true;
        }
        LogSiteStats stats = LogSiteStats.getStatsForKey(logSiteKey);
        if (rateLimitCount != null && !stats.incrementAndCheckInvocationCount(rateLimitCount)) {
            return false;
        }
        if (rateLimitPeriod != null) {
            return stats.checkLastTimestamp(this.getTimestampMicros(), rateLimitPeriod);
        }
        return true;
    }

    private boolean shouldLog() {
        if (this.logSite == null) {
            this.logSite = Checks.checkNotNull(((AbstractLogger)this.getLogger()).getBackend().inferLogSite(LogContext.class, 1), "logger backend must not return a null LogSite");
        }
        LogSiteKey logSiteKey = null;
        if (this.logSite != LogSite.INVALID) {
            logSiteKey = this.logSite;
            String uniqueKey = (String)this.getMetadata().findValue("/for unique key");
            if (uniqueKey != null) {
                logSiteKey = new SpecializedLogSiteKey(this.logSite, uniqueKey);
            }
        }
        if (!this.postProcess(logSiteKey)) {
            return false;
        }
        Tags tags = Platform.getInjectedTags();
        if (!tags.isEmpty()) {
            this.addMetadata("/tags", tags);
        }
        return true;
    }

    private final void logImpl(String message, Object ... args) {
        this.args = args;
        for (int n = 0; n < args.length; ++n) {
            if (!(args[n] instanceof LazyArg)) continue;
            args[n] = ((LazyArg)args[n]).evaluate();
        }
        if (message != LITERAL_VALUE_MESSAGE) {
            this.templateContext = new TemplateContext(this.getMessageParser(), message);
        }
        ((AbstractLogger)this.getLogger()).write(this);
    }

    @Override
    public final API withInjectedLogSite(LogSite logSite) {
        this.logSite = logSite;
        return this.api();
    }

    @Override
    public final API withInjectedLogSite(String internalClassName, String methodName, int encodedLineNumber, @Nullable String sourceFileName) {
        this.logSite = LogSite.injectedLogSite(internalClassName, methodName, encodedLineNumber, sourceFileName);
        return this.api();
    }

    @Override
    public final boolean isEnabled() {
        return this.wasForced() || ((AbstractLogger)this.getLogger()).isLoggable(this.level);
    }

    @Override
    public final API perUnique(String longLivedKey) {
        this.setMetadata("/for unique key", longLivedKey);
        return this.api();
    }

    @Override
    public final API withCause(Throwable cause) {
        if (cause != null) {
            this.setMetadata("/cause", cause);
        }
        return this.api();
    }

    @Override
    public final API every(int n) {
        if (this.wasForced()) {
            return this.api();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("rate limit count must be positive");
        }
        if (n > 1) {
            this.setMetadata("/ratelimit count", n);
        }
        return this.api();
    }

    @Override
    public final API atMostEvery(int n, TimeUnit unit) {
        if (this.wasForced()) {
            return this.api();
        }
        if (n < 0) {
            throw new IllegalArgumentException("rate limit period cannot be negative");
        }
        if (n > 0) {
            this.setMetadata("/ratelimit period", LogSiteStats.newRateLimitPeriod(n, unit));
        }
        return this.api();
    }

    @Override
    public final void log() {
        if (this.shouldLog()) {
            this.logImpl(LITERAL_VALUE_MESSAGE, "");
        }
    }

    @Override
    public final void log(Object value) {
        if (this.shouldLog()) {
            this.logImpl(LITERAL_VALUE_MESSAGE, value);
        }
    }

    @Override
    public final void logVarargs(String message, Object[] params) {
        if (this.shouldLog()) {
            this.logImpl(message, Arrays.copyOf(params, params.length));
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1) {
        if (this.shouldLog()) {
            this.logImpl(message, p1);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2, p3);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2, p3, p4);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5, p6);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5, p6, p7);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5, p6, p7, p8);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10) {
        if (this.shouldLog()) {
            this.logImpl(msg, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
        }
    }

    @Override
    public final void log(String msg, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4, @Nullable Object p5, @Nullable Object p6, @Nullable Object p7, @Nullable Object p8, @Nullable Object p9, @Nullable Object p10, Object ... rest) {
        if (this.shouldLog()) {
            Object[] params = new Object[rest.length + 10];
            params[0] = p1;
            params[1] = p2;
            params[2] = p3;
            params[3] = p4;
            params[4] = p5;
            params[5] = p6;
            params[6] = p7;
            params[7] = p8;
            params[8] = p9;
            params[9] = p10;
            System.arraycopy(rest, 0, params, 10, rest.length);
            this.logImpl(msg, params);
        }
    }

    @Override
    public final void log(String message, char p1) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1));
        }
    }

    @Override
    public final void log(String message, byte p1) {
        if (this.shouldLog()) {
            this.logImpl(message, p1);
        }
    }

    @Override
    public final void log(String message, short p1) {
        if (this.shouldLog()) {
            this.logImpl(message, p1);
        }
    }

    @Override
    public final void log(String message, int p1) {
        if (this.shouldLog()) {
            this.logImpl(message, p1);
        }
    }

    @Override
    public final void log(String message, long p1) {
        if (this.shouldLog()) {
            this.logImpl(message, p1);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, @Nullable Object p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, @Nullable Object p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, boolean p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, char p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, byte p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, short p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, int p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, long p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, float p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, double p1, char p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Character.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, boolean p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, byte p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, short p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, int p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, long p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, boolean p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, char p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, byte p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, short p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, int p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, long p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, float p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, double p1, float p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, Float.valueOf(p2));
        }
    }

    @Override
    public final void log(String message, boolean p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, char p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Character.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, byte p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, short p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, int p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, long p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    @Override
    public final void log(String message, float p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, Float.valueOf(p1), p2);
        }
    }

    @Override
    public final void log(String message, double p1, double p2) {
        if (this.shouldLog()) {
            this.logImpl(message, p1, p2);
        }
    }

    private static final class SpecializedLogSiteKey
    implements LogSiteKey {
        private final LogSite logSite;
        private final String extraKey;

        private SpecializedLogSiteKey(LogSite logSite, String extraKey) {
            this.logSite = Checks.checkNotNull(logSite, "log site");
            this.extraKey = Checks.checkNotNull(extraKey, "log site key");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpecializedLogSiteKey)) {
                return false;
            }
            SpecializedLogSiteKey other = (SpecializedLogSiteKey)obj;
            return this.logSite.equals(other.logSite) && this.extraKey.equals(other.extraKey);
        }

        public int hashCode() {
            return this.logSite.hashCode() ^ this.extraKey.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.logSite);
            String string2 = this.extraKey;
            return new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string2).length()).append("SpecializedLogSiteKey{ logSite=").append(string).append(", extraKey='").append(string2).append("' }").toString();
        }
    }

    static final class MutableMetadata
    implements Metadata {
        private static final int INITIAL_KEY_VALUE_CAPACITY = 4;
        private Object[] keyValuePairs = new Object[8];
        private int keyValueCount = 0;

        MutableMetadata() {
        }

        @Override
        public int size() {
            return this.keyValueCount;
        }

        @Override
        public String getKey(int n) {
            if (n >= this.keyValueCount) {
                throw new IndexOutOfBoundsException();
            }
            return (String)this.keyValuePairs[2 * n];
        }

        @Override
        @Nullable
        public Object getValue(int n) {
            if (n >= this.keyValueCount) {
                throw new IndexOutOfBoundsException();
            }
            return this.keyValuePairs[2 * n + 1];
        }

        private int indexOf(String key) {
            for (int index = 0; index < this.keyValueCount; ++index) {
                if (!this.keyValuePairs[2 * index].equals(key)) continue;
                return index;
            }
            return -1;
        }

        @Override
        @Nullable
        public Object findValue(String key) {
            int index = this.indexOf(key);
            return index != -1 ? this.keyValuePairs[2 * index + 1] : null;
        }

        void setValue(String key, Object value) {
            int index = this.indexOf(key);
            if (index == -1) {
                this.addValue(key, value);
            } else {
                this.keyValuePairs[2 * index + 1] = Checks.checkNotNull(value, "metadata value");
            }
        }

        void addValue(String key, Object value) {
            if (2 * (this.keyValueCount + 1) > this.keyValuePairs.length) {
                this.keyValuePairs = Arrays.copyOf(this.keyValuePairs, 2 * this.keyValuePairs.length);
            }
            this.keyValuePairs[2 * this.keyValueCount] = Checks.checkNotNull(key, "metadata key");
            this.keyValuePairs[2 * this.keyValueCount + 1] = Checks.checkNotNull(value, "metadata value");
            ++this.keyValueCount;
        }

        void removeAllValues(String key) {
            int index = this.indexOf(key);
            if (index >= 0) {
                int src;
                int dest = 2 * index;
                for (src = dest + 2; src < 2 * this.keyValueCount; src += 2) {
                    Object nextKey = this.keyValuePairs[src];
                    if (nextKey.equals(key)) continue;
                    this.keyValuePairs[dest] = nextKey;
                    this.keyValuePairs[dest + 1] = this.keyValuePairs[src + 1];
                    dest += 2;
                }
                this.keyValueCount -= src - dest >> 1;
                while (dest < src) {
                    this.keyValuePairs[dest++] = null;
                }
            }
        }

        public String toString() {
            StringBuilder out = new StringBuilder("Metadata{");
            for (int n = 0; n < this.size(); ++n) {
                out.append(" '").append(this.getKey(n)).append("': ").append(this.getValue(n));
            }
            return out.append(" }").toString();
        }
    }

    public static final class Key {
        public static final String LOG_CAUSE = "/cause";
        public static final String LOG_EVERY_N = "/ratelimit count";
        public static final String LOG_AT_MOST_EVERY = "/ratelimit period";
        public static final String LOG_UNIQUE_KEY = "/for unique key";
        public static final String WAS_FORCED = "/forced";
        public static final String TAGS = "/tags";

        private Key() {
        }
    }
}

