/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.AbstractLogger;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class LoggerConfig {
    private static final Map<String, LoggerConfig> strongRefMap = new ConcurrentHashMap<String, LoggerConfig>();
    private final Logger logger;

    public static LoggerConfig of(AbstractLogger<?> fluentLogger) {
        Checks.checkArgument(fluentLogger.getName() != null, "cannot obtain configuration for an anonymous logger");
        return LoggerConfig.getConfig(fluentLogger.getName());
    }

    public static LoggerConfig getConfig(Class<?> clazz) {
        return LoggerConfig.getConfig(clazz.getName());
    }

    public static LoggerConfig getPackageConfig(Class<?> clazz) {
        return LoggerConfig.getConfig(clazz.getPackage().getName());
    }

    public static LoggerConfig getConfig(String name) {
        LoggerConfig config = strongRefMap.get(Checks.checkNotNull(name, "logger name"));
        if (config == null) {
            config = new LoggerConfig(name);
            strongRefMap.put(name, config);
        }
        return config;
    }

    private LoggerConfig(String name) {
        this.logger = Checks.checkNotNull(Logger.getLogger(name), "logger");
    }

    @Nullable
    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    @Nullable
    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    public void setFilter(@Nullable Filter newFilter) throws SecurityException {
        this.logger.setFilter(newFilter);
    }

    @Nullable
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    public void setLevel(@Nullable Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    @Nullable
    public Level getLevel() {
        return this.logger.getLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        Checks.checkNotNull(handler, "handler");
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        Checks.checkNotNull(handler, "handler");
        this.logger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @Nullable
    public Logger getParent() {
        return this.logger.getParent();
    }
}

