/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.spi;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.FactoryProviderRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public final class ServiceFactoryFactory {
    public static final String USE_THREAD_CONTEXT_CLASSLOADER_PROPERTY = "appengine.spi.useThreadContextClassLoader";
    private static AtomicReference<FactoryProviderRegistry> explicitRegistry = new AtomicReference<FactoryProviderRegistry>(new FactoryProviderRegistry());

    public static <T> T getFactory(Class<T> base) {
        FactoryProvider<T> p = RuntimeRegistry.runtimeRegistry.getFactoryProvider(base);
        if (p == null) {
            String string = String.valueOf(base.getCanonicalName());
            throw new IllegalArgumentException(string.length() != 0 ? "No provider was registered for ".concat(string) : new String("No provider was registered for "));
        }
        try {
            return p.getFactoryInstance();
        }
        catch (Exception e) {
            String string = String.valueOf(base.getCanonicalName());
            throw new ServiceConfigurationError(string.length() != 0 ? "Exception while getting factory instance for ".concat(string) : new String("Exception while getting factory instance for "), e);
        }
    }

    public static synchronized <I> void register(FactoryProvider<I> p) {
        FactoryProviderRegistry temp = explicitRegistry.get();
        Preconditions.checkState(temp != null, "No modifications allowed after calls to getFactoryProvider");
        temp.register(p);
    }

    private static List<FactoryProvider<?>> getProvidersUsingServiceLoader() {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<FactoryProvider<?>>>(){

            @Override
            public List<FactoryProvider<?>> run() {
                ServiceLoader<FactoryProvider> providers;
                LinkedList result = new LinkedList();
                ClassLoader classLoader = null;
                if (Boolean.getBoolean(ServiceFactoryFactory.USE_THREAD_CONTEXT_CLASSLOADER_PROPERTY)) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ServiceFactoryFactory.class.getClassLoader();
                }
                if ((providers = ServiceLoader.load(FactoryProvider.class, classLoader)) != null) {
                    for (FactoryProvider provider : providers) {
                        result.add(provider);
                    }
                }
                return result;
            }
        });
    }

    private static final class RuntimeRegistry {
        static final FactoryProviderRegistry runtimeRegistry = new FactoryProviderRegistry();

        private RuntimeRegistry() {
        }

        static {
            FactoryProviderRegistry explicitRegistrations = explicitRegistry.getAndSet(null);
            List providers = ServiceFactoryFactory.getProvidersUsingServiceLoader();
            Collections.sort(providers);
            Iterator<Object> iterator = providers.iterator();
            while (iterator.hasNext()) {
                FactoryProvider<?> previous;
                FactoryProvider factoryProvider;
                String string = String.valueOf(factoryProvider);
                String string2 = String.valueOf(previous);
                factoryProvider = (FactoryProvider)iterator.next();
                Preconditions.checkState(!factoryProvider.equals(previous = runtimeRegistry.register(factoryProvider)), new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Ambiguous providers: ").append(string).append(" versus ").append(string2).toString());
            }
            for (FactoryProvider factoryProvider : explicitRegistrations.getAllProviders()) {
                runtimeRegistry.register(factoryProvider);
            }
        }
    }
}

