/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.PropertyContainer;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.RawValue;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.datastore.v1.ArrayValue;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.NullValue;
import com.google.apphosting.api.ApiProxy;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class DataTypeTranslator {
    static final String ADDITIONAL_APP_IDS_MAP_ATTRIBUTE_KEY = "com.google.appengine.datastore.DataTypeTranslator.AdditionalAppIdsMap";
    private static final RawValueType RAW_VALUE_TYPE = new RawValueType();
    private static final Map<Class<?>, Type<?>> typeMap = Maps.newHashMap();
    private static final Map<Class<? extends Comparable<?>>, Integer> comparableTypeMap;

    public static void addPropertiesToPb(Map<String, Object> map, OnestoreEntity.EntityProto proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            boolean forceIndexedEmbeddedEntity = false;
            boolean indexed = true;
            Object value = entry.getValue();
            if (entry.getValue() instanceof Entity.WrappedValue) {
                Entity.WrappedValue wrappedValue = (Entity.WrappedValue)entry.getValue();
                forceIndexedEmbeddedEntity = wrappedValue.getForceIndexedEmbeddedEntity();
                indexed = wrappedValue.isIndexed();
                value = wrappedValue.getValue();
            }
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                DataTypeTranslator.addListPropertyToPb(proto, name, indexed, values, forceIndexedEmbeddedEntity);
                continue;
            }
            DataTypeTranslator.addPropertyToPb(name, value, indexed, forceIndexedEmbeddedEntity, false, proto);
        }
    }

    private static void addListPropertyToPb(OnestoreEntity.EntityProto proto, String name, boolean indexed, Collection<?> values, boolean forceIndexedEmbeddedEntity) {
        if (values.isEmpty()) {
            OnestoreEntity.Property property = new OnestoreEntity.Property();
            property.setName(name);
            property.setMultiple(false);
            if (DatastoreServiceConfig.getEmptyListSupport()) {
                property.setMeaning(OnestoreEntity.Property.Meaning.EMPTY_LIST);
            }
            property.getMutableValue();
            if (indexed) {
                proto.addProperty(property);
            } else {
                proto.addRawProperty(property);
            }
        } else {
            for (Object listValue : values) {
                DataTypeTranslator.addPropertyToPb(name, listValue, indexed, forceIndexedEmbeddedEntity, true, proto);
            }
        }
    }

    private static void addPropertyToPb(String name, Object value, boolean indexed, boolean forceIndexedEmbeddedEntity, boolean multiple, OnestoreEntity.EntityProto entity) {
        OnestoreEntity.Property property = new OnestoreEntity.Property();
        property.setName(name);
        property.setMultiple(multiple);
        OnestoreEntity.PropertyValue newValue = property.getMutableValue();
        if (value != null) {
            Type<?> type = DataTypeTranslator.getType(value.getClass());
            OnestoreEntity.Property.Meaning meaning = type.getV3Meaning();
            if (meaning != property.getMeaningEnum()) {
                property.setMeaning(meaning);
            }
            type.toV3Value(value, newValue);
            if (indexed && forceIndexedEmbeddedEntity && DataTypeUtils.isUnindexableType(value.getClass())) {
                throw new UnsupportedOperationException("Value must be indexable.");
            }
            if (!forceIndexedEmbeddedEntity || !(value instanceof EmbeddedEntity)) {
                indexed &= type.canBeIndexed();
            }
        }
        if (indexed) {
            entity.addProperty(property);
        } else {
            entity.addRawProperty(property);
        }
    }

    static OnestoreEntity.PropertyValue toV3Value(Object value) {
        OnestoreEntity.PropertyValue propertyValue = new OnestoreEntity.PropertyValue();
        if (value != null) {
            DataTypeTranslator.getType(value.getClass()).toV3Value(value, propertyValue);
        }
        return propertyValue;
    }

    public static void extractIndexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.propertys()) {
            DataTypeTranslator.addPropertyToMap(property, true, map);
        }
    }

    private static void extractUnindexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.rawPropertys()) {
            DataTypeTranslator.addPropertyToMap(property, false, map);
        }
    }

    public static void extractPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        DataTypeTranslator.extractIndexedPropertiesFromPb(proto, map);
        DataTypeTranslator.extractUnindexedPropertiesFromPb(proto, map);
    }

    public static void extractImplicitPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : DataTypeTranslator.getImplicitProperties(proto)) {
            DataTypeTranslator.addPropertyToMap(property, true, map);
        }
    }

    private static Iterable<OnestoreEntity.Property> getImplicitProperties(OnestoreEntity.EntityProto proto) {
        return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
    }

    private static OnestoreEntity.Property buildImplicitKeyProperty(OnestoreEntity.EntityProto proto) {
        OnestoreEntity.Property keyProp = new OnestoreEntity.Property();
        keyProp.setName("__key__");
        OnestoreEntity.PropertyValue propVal = new OnestoreEntity.PropertyValue();
        propVal.setReferenceValue(KeyType.toReferenceValue(proto.getKey()));
        keyProp.setValue(propVal);
        return keyProp;
    }

    public static Collection<OnestoreEntity.Property> findIndexedPropertiesOnPb(OnestoreEntity.EntityProto proto, String propertyName) {
        if (propertyName.equals("__key__")) {
            return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
        }
        ArrayList<OnestoreEntity.Property> matchingMultipleProps = new ArrayList<OnestoreEntity.Property>();
        for (OnestoreEntity.Property prop : proto.propertys()) {
            if (!prop.getName().equals(propertyName)) continue;
            if (!prop.isMultiple()) {
                return Collections.singleton(prop);
            }
            matchingMultipleProps.add(prop);
        }
        return matchingMultipleProps;
    }

    private static Object wrapIfUnindexed(boolean indexed, Object value) {
        return indexed ? value : new Entity.UnindexedValue(value);
    }

    private static void addPropertyToMap(OnestoreEntity.Property property, boolean indexed, Map<String, Object> map) {
        String name = property.getName();
        if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
            ArrayList emptyListValue = DatastoreServiceConfig.getEmptyListSupport() ? new ArrayList() : null;
            map.put(name, DataTypeTranslator.wrapIfUnindexed(indexed, emptyListValue));
        } else {
            Object value = DataTypeTranslator.getPropertyValue(property);
            if (property.isMultiple()) {
                ArrayList<Object> resultList = (ArrayList<Object>)PropertyContainer.unwrapValue(map.get(name));
                if (resultList == null) {
                    resultList = new ArrayList<Object>();
                    map.put(name, indexed ? resultList : new Entity.UnindexedValue(resultList));
                }
                if (indexed && value instanceof EmbeddedEntity) {
                    map.put(name, new Entity.WrappedValueImpl(resultList, true, true));
                }
                resultList.add(value);
            } else {
                if (indexed && value instanceof EmbeddedEntity) {
                    value = new Entity.WrappedValueImpl(value, true, true);
                } else if (!indexed) {
                    value = new Entity.UnindexedValue(value);
                }
                map.put(name, value);
            }
        }
    }

    public static Object getPropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        for (Type<?> type : typeMap.values()) {
            if (!type.isType(property.getMeaningEnum(), value)) continue;
            return type.getValue(value);
        }
        return null;
    }

    static void addPropertiesToPb(Map<String, Object> map, Entity.Builder proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            proto.putProperties(entry.getKey(), DataTypeTranslator.toV1Value(entry.getValue()).build());
        }
    }

    static void extractPropertiesFromPb(EntityOrBuilder proto, boolean indexOnly, Map<String, Object> map) {
        if (indexOnly) {
            for (Map.Entry<String, Value> prop : proto.getPropertiesMap().entrySet()) {
                map.put(prop.getKey(), new RawValue(prop.getValue()));
            }
        } else {
            for (Map.Entry<String, Value> prop : proto.getPropertiesMap().entrySet()) {
                DataTypeTranslator.addPropertyToMap(prop.getKey(), prop.getValue(), map);
            }
        }
    }

    static Value.Builder toV1ValueForQuery(Object value) {
        Value.Builder valueBuilder = DataTypeTranslator.toV1Value(value, true, false);
        valueBuilder.clearExcludeFromIndexes();
        if (value != null && DataTypeUtils.isUnindexableType(value.getClass())) {
            valueBuilder.clearMeaning();
        }
        return valueBuilder;
    }

    static Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
        if (value == null) {
            Value.Builder builder = Value.newBuilder();
            builder.setNullValue(NullValue.NULL_VALUE);
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }
        if (indexed && forceIndexedEmbeddedEntity && DataTypeUtils.isUnindexableType(value.getClass())) {
            throw new UnsupportedOperationException("Value must be indexable.");
        }
        return DataTypeTranslator.getType(value.getClass()).toV1Value(value, indexed, forceIndexedEmbeddedEntity);
    }

    private static Value.Builder toV1Value(Object value) {
        boolean indexed = true;
        boolean forceIndexedEmbeddedEntity = false;
        if (value instanceof Entity.WrappedValue) {
            Entity.WrappedValue wrappedValue = (Entity.WrappedValue)value;
            indexed = wrappedValue.isIndexed();
            forceIndexedEmbeddedEntity = wrappedValue.getForceIndexedEmbeddedEntity();
            value = wrappedValue.getValue();
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                if (DatastoreServiceConfig.getEmptyListSupport()) {
                    return Value.newBuilder().setExcludeFromIndexes(!indexed).setArrayValue(ArrayValue.newBuilder());
                }
                return DataTypeTranslator.toV1Value(null, indexed, forceIndexedEmbeddedEntity);
            }
            Value.Builder valueBuilder = Value.newBuilder();
            for (Object listValue : values) {
                valueBuilder.getArrayValueBuilder().addValues(DataTypeTranslator.toV1Value(listValue, indexed, forceIndexedEmbeddedEntity));
            }
            return valueBuilder;
        }
        return DataTypeTranslator.toV1Value(value, indexed, forceIndexedEmbeddedEntity);
    }

    private static void addPropertyToMap(String name, Value value, Map<String, Object> map) {
        boolean indexed;
        Object result;
        boolean isOrContainsIndexedEntityValue = false;
        if (DatastoreServiceConfig.getEmptyListSupport() && value.getValueTypeCase() == Value.ValueTypeCase.ARRAY_VALUE && value.getArrayValue().getValuesCount() == 0) {
            result = new ArrayList();
            indexed = !value.getExcludeFromIndexes();
        } else if (value.getArrayValue().getValuesCount() > 0) {
            indexed = false;
            ArrayList<Object> resultList = new ArrayList<Object>(value.getArrayValue().getValuesCount());
            for (Value subValue : value.getArrayValue().getValuesList()) {
                if (subValue.getValueTypeCase() == Value.ValueTypeCase.ARRAY_VALUE) {
                    throw new IllegalArgumentException("Invalid Entity PB: list within a list.");
                }
                result = DataTypeTranslator.getValue(subValue);
                if (!subValue.getExcludeFromIndexes()) {
                    indexed = true;
                    if (result instanceof EmbeddedEntity) {
                        isOrContainsIndexedEntityValue = true;
                    }
                }
                resultList.add(result);
            }
            result = resultList;
        } else {
            indexed = !value.getExcludeFromIndexes();
            result = DataTypeTranslator.getValue(value);
            if (indexed && result instanceof EmbeddedEntity) {
                isOrContainsIndexedEntityValue = true;
            }
        }
        if (isOrContainsIndexedEntityValue) {
            result = new Entity.WrappedValueImpl(result, true, true);
        } else if (!indexed) {
            result = new Entity.UnindexedValue(result);
        }
        map.put(name, result);
    }

    private static Object getValue(Value value) {
        for (Type<?> type : typeMap.values()) {
            if (!type.isType(value)) continue;
            return type.getValue(value);
        }
        return null;
    }

    private static OnestoreEntity.Property.Meaning getV3MeaningOf(ValueOrBuilder value) {
        return OnestoreEntity.Property.Meaning.valueOf(value.getMeaning());
    }

    private static AppIdNamespace toAppIdNamespace(PartitionIdOrBuilder partitionId) {
        if (partitionId.getProjectId().equals(DatastoreApiHelper.getCurrentProjectId())) {
            return new AppIdNamespace(DatastoreApiHelper.getCurrentAppId(), partitionId.getNamespaceId());
        }
        Map<String, String> additionalProjectIdToAppIdMap = DataTypeTranslator.getAdditionalProjectIdToAppIdMap();
        if (additionalProjectIdToAppIdMap.containsKey(partitionId.getProjectId())) {
            return new AppIdNamespace(additionalProjectIdToAppIdMap.get(partitionId.getProjectId()), partitionId.getNamespaceId());
        }
        throw new IllegalStateException(String.format("Could not determine app id corresponding to project id \"%s\". Please add the app id to %s.", partitionId.getProjectId(), "DATASTORE_ADDITIONAL_APP_IDS"));
    }

    private static Map<String, String> getAdditionalProjectIdToAppIdMap() {
        Object attribute;
        if (ApiProxy.getCurrentEnvironment() != null && (attribute = ApiProxy.getCurrentEnvironment().getAttributes().get(ADDITIONAL_APP_IDS_MAP_ATTRIBUTE_KEY)) != null) {
            return (Map)attribute;
        }
        return Collections.emptyMap();
    }

    private static PartitionId.Builder toV1PartitionId(AppIdNamespace appNs) {
        PartitionId.Builder builder = PartitionId.newBuilder();
        builder.setProjectId(DatastoreApiHelper.toProjectId(appNs.getAppId()));
        if (!appNs.getNamespace().isEmpty()) {
            builder.setNamespaceId(appNs.getNamespace());
        }
        return builder;
    }

    static Key.Builder toV1Key(Key key) {
        Key.Builder builder = com.google.appengine.repackaged.com.google.datastore.v1.Key.newBuilder();
        builder.setPartitionId(DataTypeTranslator.toV1PartitionId(key.getAppIdNamespace()));
        ArrayList<Key.PathElement> pathElementList = new ArrayList<Key.PathElement>();
        do {
            Key.PathElement.Builder pathElement = Key.PathElement.newBuilder();
            pathElement.setKind(key.getKind());
            if (key.getName() != null) {
                pathElement.setName(key.getName());
            } else if (key.getId() != 0L) {
                pathElement.setId(key.getId());
            }
            pathElementList.add(pathElement.build());
        } while ((key = key.getParent()) != null);
        builder.addAllPath(Lists.reverse(pathElementList));
        return builder;
    }

    static Key toKey(KeyOrBuilder proto) {
        if (proto.getPathCount() == 0) {
            throw new IllegalArgumentException("Invalid Key PB: no elements.");
        }
        AppIdNamespace appIdNamespace = DataTypeTranslator.toAppIdNamespace(proto.getPartitionId());
        Key key = null;
        for (Key.PathElement e : proto.getPathList()) {
            String kind = e.getKind();
            key = new Key(kind, key, e.getId(), e.getIdTypeCase() == Key.PathElement.IdTypeCase.NAME ? e.getName() : null, appIdNamespace);
        }
        return key;
    }

    static Entity toEntity(EntityOrBuilder entityV1) {
        Entity entity = new Entity(DataTypeTranslator.toKey(entityV1.getKey()));
        DataTypeTranslator.extractPropertiesFromPb(entityV1, false, entity.getPropertyMap());
        return entity;
    }

    static Entity toEntity(EntityOrBuilder entityV1, Collection<Projection> projections) {
        Entity entity = new Entity(DataTypeTranslator.toKey(entityV1.getKey()));
        HashMap<String, Object> values = Maps.newHashMap();
        DataTypeTranslator.extractPropertiesFromPb(entityV1, true, values);
        for (Projection projection : projections) {
            entity.setProperty(projection.getName(), projection.getValue(values));
        }
        return entity;
    }

    static Entity.Builder toV1Entity(Entity entity) {
        Entity.Builder entityV1 = com.google.appengine.repackaged.com.google.datastore.v1.Entity.newBuilder();
        entityV1.setKey(DataTypeTranslator.toV1Key(entity.getKey()));
        DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), entityV1);
        return entityV1;
    }

    public static Comparable<Object> getComparablePropertyValue(OnestoreEntity.Property property) {
        return RAW_VALUE_TYPE.asComparable(new RawValue(property.getValue()));
    }

    static Comparable<Object> getComparablePropertyValue(Object value) {
        return value == null ? null : DataTypeTranslator.getType(value.getClass()).asComparable(value);
    }

    public static int getTypeRank(Class<? extends Comparable> datastoreType) {
        return comparableTypeMap.get(datastoreType);
    }

    private static <T> Type<T> getType(Class<T> clazz) {
        if (typeMap.containsKey(clazz)) {
            return typeMap.get(clazz);
        }
        String string = String.valueOf(clazz.getName());
        throw new UnsupportedOperationException(string.length() != 0 ? "Unsupported data type: ".concat(string) : new String("Unsupported data type: "));
    }

    private static Value makeUnindexedValue(String value) {
        return Value.newBuilder().setStringValue(value).setExcludeFromIndexes(true).build();
    }

    static Map<Class<?>, Type<?>> getTypeMap() {
        return typeMap;
    }

    private DataTypeTranslator() {
    }

    static {
        typeMap.put(RawValue.class, RAW_VALUE_TYPE);
        typeMap.put(Float.class, new DoubleType());
        typeMap.put(Double.class, new DoubleType());
        typeMap.put(Byte.class, new Int64Type());
        typeMap.put(Short.class, new Int64Type());
        typeMap.put(Integer.class, new Int64Type());
        typeMap.put(Long.class, new Int64Type());
        typeMap.put(Date.class, new DateType());
        typeMap.put(Rating.class, new RatingType());
        typeMap.put(String.class, new StringType());
        typeMap.put(Link.class, new LinkType());
        typeMap.put(ShortBlob.class, new ShortBlobType());
        typeMap.put(Category.class, new CategoryType());
        typeMap.put(PhoneNumber.class, new PhoneNumberType());
        typeMap.put(PostalAddress.class, new PostalAddressType());
        typeMap.put(Email.class, new EmailType());
        typeMap.put(IMHandle.class, new IMHandleType());
        typeMap.put(BlobKey.class, new BlobKeyType());
        typeMap.put(Blob.class, new BlobType());
        typeMap.put(Text.class, new TextType());
        typeMap.put(EmbeddedEntity.class, new EmbeddedEntityType());
        typeMap.put(Boolean.class, new BoolType());
        typeMap.put(User.class, new UserType());
        typeMap.put(Key.class, new KeyType());
        typeMap.put(GeoPt.class, new GeoPtType());
        if (!$assertionsDisabled && !typeMap.keySet().equals(DataTypeUtils.getSupportedTypes())) {
            String string = String.valueOf(typeMap.keySet());
            String string2 = String.valueOf(DataTypeUtils.getSupportedTypes());
            throw new AssertionError((Object)new StringBuilder(90 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Warning:  DataTypeUtils and DataTypeTranslator do not agree about supported classes: ").append(string).append(" vs. ").append(string2).toString());
        }
        comparableTypeMap = new HashMap();
        comparableTypeMap.put(ComparableByteArray.class, 3);
        comparableTypeMap.put(Long.class, 1);
        comparableTypeMap.put(Double.class, 4);
        comparableTypeMap.put(Boolean.class, 2);
        comparableTypeMap.put(User.class, 8);
        comparableTypeMap.put(Key.class, 12);
        comparableTypeMap.put(GeoPt.class, 5);
    }

    public static final class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] bytes;

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            byte[] otherBytes = other.bytes;
            for (int i = 0; i < Math.min(this.bytes.length, otherBytes.length); ++i) {
                int v1 = this.bytes[i] & 0xFF;
                int v2 = otherBytes[i] & 0xFF;
                if (v1 == v2) continue;
                return v1 - v2;
            }
            return this.bytes.length - otherBytes.length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return Arrays.equals(this.bytes, ((ComparableByteArray)obj).bytes);
        }

        public int hashCode() {
            int result = 1;
            for (byte b : this.bytes) {
                result = 31 * result + b;
            }
            return result;
        }
    }

    private static final class IMHandleType
    extends BaseStringType<IMHandle> {
        private IMHandleType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_IM;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((IMHandle)value).toDatastoreString();
        }

        @Override
        protected IMHandle fromDatastoreValue(String datastoreString) {
            return IMHandle.fromDatastoreString(datastoreString);
        }
    }

    private static final class PhoneNumberType
    extends BaseStringType<PhoneNumber> {
        private PhoneNumberType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_PHONENUMBER;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((PhoneNumber)value).getNumber();
        }

        @Override
        protected PhoneNumber fromDatastoreValue(String datastoreString) {
            return new PhoneNumber(datastoreString);
        }
    }

    private static final class PostalAddressType
    extends BaseStringType<PostalAddress> {
        private PostalAddressType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_POSTALADDRESS;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((PostalAddress)value).getAddress();
        }

        @Override
        protected PostalAddress fromDatastoreValue(String datastoreString) {
            return new PostalAddress(datastoreString);
        }
    }

    private static final class EmailType
    extends BaseStringType<Email> {
        private EmailType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_EMAIL;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Email)value).getEmail();
        }

        @Override
        protected Email fromDatastoreValue(String datastoreString) {
            return new Email(datastoreString);
        }
    }

    private static final class RatingType
    extends BaseInt64Type<Rating> {
        private RatingType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_RATING;
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Rating)value).getRating();
        }

        @Override
        protected Rating fromDatastoreValue(Long datastoreLong) {
            return new Rating(datastoreLong.intValue());
        }
    }

    private static final class CategoryType
    extends BaseStringType<Category> {
        private CategoryType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ATOM_CATEGORY;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Category)value).getCategory();
        }

        @Override
        protected Category fromDatastoreValue(String datastoreString) {
            return new Category(datastoreString);
        }
    }

    private static final class LinkType
    extends BaseStringType<Link> {
        private LinkType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ATOM_LINK;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Link)value).getValue();
        }

        @Override
        protected Link fromDatastoreValue(String datastoreValue) {
            return new Link(datastoreValue);
        }
    }

    private static final class DateType
    extends BaseInt64Type<Date> {
        private static final long RFC_3339_MIN_MILLISECONDS_INCLUSIVE = -62135596800000L;
        private static final long RFC_3339_MAX_MILLISECONDS_INCLUSIVE = 253402300799999L;

        private DateType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_WHEN;
        }

        @Override
        public boolean isType(Value propertyValue) {
            return DateType.isTimestampValue(propertyValue) || DateType.isNonRfc3339Value(propertyValue);
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.TIMESTAMP_VALUE || DateType.isNonRfc3339Value(propertyValue) || DateType.isIndexValue(propertyValue);
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder;
            Date date = (Date)value;
            if (DateType.isInRfc3339Bounds(date)) {
                builder = DatastoreHelper.makeValue(date);
            } else {
                builder = Value.newBuilder();
                builder.setIntegerValue(this.toDatastoreValue(date));
                builder.setMeaning(OnestoreEntity.Property.Meaning.GD_WHEN.getValue());
            }
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public Date getValue(Value propertyValue) {
            if (DateType.isNonRfc3339Value(propertyValue) || DateType.isIndexValue(propertyValue)) {
                return this.fromDatastoreValue(propertyValue.getIntegerValue());
            }
            long datastoreValue = DatastoreHelper.getTimestamp(propertyValue);
            return this.fromDatastoreValue(datastoreValue);
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Date)value).getTime() * 1000L;
        }

        @Override
        protected Date fromDatastoreValue(Long datastoreValue) {
            return new Date(datastoreValue / 1000L);
        }

        private static boolean isTimestampValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.TIMESTAMP_VALUE && propertyValue.getMeaning() == 0;
        }

        private static boolean isNonRfc3339Value(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE && propertyValue.getMeaning() == OnestoreEntity.Property.Meaning.GD_WHEN.getValue();
        }

        private static boolean isIndexValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE && DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE;
        }

        private static boolean isInRfc3339Bounds(Date date) {
            return date.getTime() >= -62135596800000L && date.getTime() <= 253402300799999L;
        }
    }

    private static final class BlobKeyType
    extends BaseStringType<BlobKey> {
        private BlobKeyType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BLOBKEY;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setStringValue(this.toDatastoreValue(value));
            builder.setMeaning(OnestoreEntity.Property.Meaning.BLOBKEY.getValue());
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public BlobKey getValue(Value propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValue());
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((BlobKey)value).getKeyString();
        }

        @Override
        protected BlobKey fromDatastoreValue(String datastoreString) {
            return new BlobKey(datastoreString);
        }
    }

    private static final class TextType
    extends BaseStringType<Text> {
        private TextType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.TEXT;
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            super.toV3Value(value, propertyValue);
        }

        @Override
        public boolean canBeIndexed() {
            return false;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            return super.toV1Value(value, false, false);
        }

        @Override
        protected Text fromDatastoreValue(String datastoreString) {
            return new Text(datastoreString);
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Text)value).getValue();
        }

        @Override
        public ComparableByteArray asComparable(Object value) {
            return null;
        }
    }

    private static final class EmbeddedEntityType
    extends Type<EmbeddedEntity> {
        private EmbeddedEntityType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ENTITY_PROTO;
        }

        @Override
        public boolean isType(Value propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.ENTITY_VALUE;
        }

        @Override
        public EmbeddedEntity getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            boolean parsed = proto.mergeFrom(propertyValue.getStringValueAsBytes());
            if (!parsed) {
                throw new IllegalArgumentException("Could not parse EntityProto value");
            }
            EmbeddedEntity result = new EmbeddedEntity();
            if (proto.hasKey() && !proto.getKey().getApp().isEmpty()) {
                result.setKey(KeyTranslator.createFromPb(proto.getKey()));
            }
            DataTypeTranslator.extractPropertiesFromPb(proto, result.getPropertyMap());
            return result;
        }

        @Override
        public EmbeddedEntity getValue(Value propertyValue) {
            EmbeddedEntity result = new EmbeddedEntity();
            com.google.appengine.repackaged.com.google.datastore.v1.Entity proto = propertyValue.getEntityValue();
            if (proto.hasKey()) {
                result.setKey(DataTypeTranslator.toKey(proto.getKey()));
            }
            DataTypeTranslator.extractPropertiesFromPb(proto, false, result.getPropertyMap());
            return result;
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            EmbeddedEntity structProp = (EmbeddedEntity)value;
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            if (structProp.getKey() != null) {
                proto.setKey(KeyTranslator.convertToPb(structProp.getKey()));
            }
            DataTypeTranslator.addPropertiesToPb(structProp.getPropertyMap(), proto);
            propertyValue.setStringValueAsBytes(proto.toByteArray());
        }

        @Override
        public boolean canBeIndexed() {
            return false;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            EmbeddedEntity structProp = (EmbeddedEntity)value;
            Value.Builder builder = Value.newBuilder();
            Entity.Builder proto = builder.getEntityValueBuilder();
            if (structProp.getKey() != null) {
                proto.setKey(DataTypeTranslator.toV1Key(structProp.getKey()));
            }
            DataTypeTranslator.addPropertiesToPb(structProp.getPropertyMap(), proto);
            builder.setExcludeFromIndexes(!indexed || !forceIndexedEmbeddedEntity);
            return builder;
        }

        @Override
        public Comparable<?> asComparable(Object value) {
            return null;
        }
    }

    private static class ShortBlobType
    extends BaseBlobType<ShortBlob> {
        private ShortBlobType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BYTESTRING;
        }

        @Override
        public boolean isType(Value propertyValue) {
            if (!this.hasValue(propertyValue)) {
                return false;
            }
            if (propertyValue.getExcludeFromIndexes()) {
                return DataTypeTranslator.getV3MeaningOf(propertyValue) == this.getV3Meaning();
            }
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = super.toV1Value(value, indexed, forceIndexedEmbeddedEntity);
            if (!indexed) {
                builder.setMeaning(this.getV3Meaning().getValue());
            }
            return builder;
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.BLOB_VALUE || DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE;
        }

        @Override
        public ShortBlob getValue(Value propertyValue) {
            if (DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE) {
                return this.fromDatastoreValue(propertyValue.getStringValueBytes().toByteArray());
            }
            return this.fromDatastoreValue(propertyValue.getBlobValue().toByteArray());
        }

        @Override
        protected byte[] toDatastoreValue(Object value) {
            return ((ShortBlob)value).getBytes();
        }

        @Override
        protected ShortBlob fromDatastoreValue(byte[] datastoreValue) {
            return new ShortBlob(datastoreValue);
        }

        @Override
        public boolean isIndexable() {
            return true;
        }
    }

    private static class BlobType
    extends BaseBlobType<Blob> {
        private BlobType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BLOB;
        }

        @Override
        public boolean isType(Value propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING && propertyValue.getExcludeFromIndexes() && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.BLOB_VALUE;
        }

        @Override
        public Blob getValue(Value propertyValue) {
            return this.fromDatastoreValue(propertyValue.getBlobValue().toByteArray());
        }

        @Override
        protected Blob fromDatastoreValue(byte[] datastoreValue) {
            return new Blob(datastoreValue);
        }

        @Override
        protected byte[] toDatastoreValue(Object value) {
            return ((Blob)value).getBytes();
        }

        @Override
        public boolean isIndexable() {
            return false;
        }
    }

    private static final class KeyType
    extends Type<Key> {
        private KeyType() {
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.Reference keyRef = KeyTranslator.convertToPb((Key)value);
            propertyValue.setReferenceValue(KeyType.toReferenceValue(keyRef));
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setKeyValue(DataTypeTranslator.toV1Key((Key)value));
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public Key getValue(OnestoreEntity.PropertyValue propertyValue) {
            return KeyTranslator.createFromPb(KeyType.toReference(propertyValue.getReferenceValue()));
        }

        @Override
        public Key getValue(Value propertyValue) {
            return DataTypeTranslator.toKey(propertyValue.getKeyValue());
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasReferenceValue();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE;
        }

        public Key asComparable(Object value) {
            return (Key)value;
        }

        private static OnestoreEntity.PropertyValue.ReferenceValue toReferenceValue(OnestoreEntity.Reference keyRef) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = new OnestoreEntity.PropertyValue.ReferenceValue();
            refValue.setApp(keyRef.getApp());
            if (keyRef.hasNameSpace()) {
                refValue.setNameSpace(keyRef.getNameSpace());
            }
            OnestoreEntity.Path path = keyRef.getPath();
            for (OnestoreEntity.Path.Element element : path.elements()) {
                OnestoreEntity.PropertyValue.ReferenceValuePathElement newElement = new OnestoreEntity.PropertyValue.ReferenceValuePathElement();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                refValue.addPathElement(newElement);
            }
            return refValue;
        }

        private static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue refValue) {
            OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
            reference.setApp(refValue.getApp());
            if (refValue.hasNameSpace()) {
                reference.setNameSpace(refValue.getNameSpace());
            }
            OnestoreEntity.Path path = new OnestoreEntity.Path();
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                OnestoreEntity.Path.Element newElement = new OnestoreEntity.Path.Element();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                path.addElement(newElement);
            }
            reference.setPath(path);
            return reference;
        }
    }

    private static class GeoPtType
    extends Type<GeoPt> {
        private GeoPtType() {
        }

        @Override
        public boolean isType(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.GEO_POINT_VALUE && propertyValue.getMeaning() == 0;
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            GeoPt geoPt = (GeoPt)value;
            OnestoreEntity.PropertyValue.PointValue pv = new OnestoreEntity.PropertyValue.PointValue().setX(geoPt.getLatitude()).setY(geoPt.getLongitude());
            propertyValue.setPointValue(pv);
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public final Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            GeoPt geoPt = (GeoPt)value;
            Value.Builder builder = Value.newBuilder();
            builder.getGeoPointValueBuilder().setLatitude(geoPt.getLatitude()).setLongitude(geoPt.getLongitude());
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public GeoPt getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.PointValue pv = propertyValue.getPointValue();
            return new GeoPt((float)pv.getX(), (float)pv.getY());
        }

        @Override
        public GeoPt getValue(Value propertyValue) {
            return new GeoPt((float)propertyValue.getGeoPointValue().getLatitude(), (float)propertyValue.getGeoPointValue().getLongitude());
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasPointValue();
        }

        @Override
        public final boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.GEO_POINT_VALUE;
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GEORSS_POINT;
        }

        @Override
        public final Comparable<GeoPt> asComparable(Object value) {
            return (GeoPt)value;
        }
    }

    private static final class UserType
    extends BasePredefinedEntityType<User> {
        public static final int MEANING_PREDEFINED_ENTITY_USER = 20;
        public static final String PROPERTY_NAME_EMAIL = "email";
        public static final String PROPERTY_NAME_AUTH_DOMAIN = "auth_domain";
        public static final String PROPERTY_NAME_USER_ID = "user_id";

        private UserType() {
        }

        @Override
        public int getV1Meaning() {
            return 20;
        }

        @Override
        public com.google.appengine.repackaged.com.google.datastore.v1.Entity getEntity(Object value) {
            User user = (User)value;
            Entity.Builder builder = com.google.appengine.repackaged.com.google.datastore.v1.Entity.newBuilder();
            builder.putProperties(PROPERTY_NAME_EMAIL, DataTypeTranslator.makeUnindexedValue(user.getEmail()));
            builder.putProperties(PROPERTY_NAME_AUTH_DOMAIN, DataTypeTranslator.makeUnindexedValue(user.getAuthDomain()));
            if (user.getUserId() != null) {
                builder.putProperties(PROPERTY_NAME_USER_ID, DataTypeTranslator.makeUnindexedValue(user.getUserId()));
            }
            return builder.build();
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            User user = (User)value;
            OnestoreEntity.PropertyValue.UserValue userValue = new OnestoreEntity.PropertyValue.UserValue();
            userValue.setEmail(user.getEmail());
            userValue.setAuthDomain(user.getAuthDomain());
            if (user.getUserId() != null) {
                userValue.setObfuscatedGaiaid(user.getUserId());
            }
            userValue.setGaiaid(0L);
            propertyValue.setUserValue(userValue);
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public User getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.UserValue userValue = propertyValue.getUserValue();
            String userId = userValue.hasObfuscatedGaiaid() ? userValue.getObfuscatedGaiaid() : null;
            return new User(userValue.getEmail(), userValue.getAuthDomain(), userId);
        }

        @Override
        public User getValue(Value propertyValue) {
            String email = "";
            String authDomain = "";
            String userId = null;
            for (Map.Entry<String, Value> prop : propertyValue.getEntityValueOrBuilder().getPropertiesMap().entrySet()) {
                if (prop.getKey().equals(PROPERTY_NAME_EMAIL)) {
                    email = prop.getValue().getStringValue();
                    continue;
                }
                if (prop.getKey().equals(PROPERTY_NAME_AUTH_DOMAIN)) {
                    authDomain = prop.getValue().getStringValue();
                    continue;
                }
                if (!prop.getKey().equals(PROPERTY_NAME_USER_ID)) continue;
                userId = prop.getValue().getStringValue();
            }
            return new User(email, authDomain, userId);
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasUserValue();
        }

        @Override
        public final Comparable<User> asComparable(Object value) {
            return (User)value;
        }
    }

    private static final class BoolType
    extends Type<Boolean> {
        private BoolType() {
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setBooleanValue((Boolean)value);
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setBooleanValue((Boolean)value);
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public Boolean getValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.isBooleanValue();
        }

        @Override
        public Boolean getValue(Value propertyValue) {
            return propertyValue.getBooleanValue();
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasBooleanValue();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.BOOLEAN_VALUE;
        }

        public Boolean asComparable(Object value) {
            return (Boolean)value;
        }
    }

    private static final class DoubleType
    extends Type<Double> {
        private DoubleType() {
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setDoubleValue(((Number)value).doubleValue());
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setDoubleValue(((Number)value).doubleValue());
            builder.setExcludeFromIndexes(!indexed);
            return builder;
        }

        @Override
        public Double getValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getDoubleValue();
        }

        @Override
        public Double getValue(Value propertyValue) {
            return propertyValue.getDoubleValue();
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.DOUBLE_VALUE;
        }

        public Double asComparable(Object value) {
            return ((Number)value).doubleValue();
        }
    }

    private static final class Int64Type
    extends BaseInt64Type<Long> {
        private Int64Type() {
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Number)value).longValue();
        }

        @Override
        protected Long fromDatastoreValue(Long datastoreValue) {
            return datastoreValue;
        }
    }

    private static final class StringType
    extends BaseStringType<String> {
        private StringType() {
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return value.toString();
        }

        @Override
        protected String fromDatastoreValue(String datastoreValue) {
            return datastoreValue;
        }
    }

    private static final class RawValueType
    extends Type<RawValue> {
        private RawValueType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.INDEX_VALUE;
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return true;
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return true;
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canBeIndexed() {
            return false;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RawValue getValue(OnestoreEntity.PropertyValue propertyValue) {
            return new RawValue(propertyValue);
        }

        @Override
        public RawValue getValue(Value propertyValue) {
            return new RawValue(propertyValue);
        }

        @Override
        public Comparable<?> asComparable(Object value) {
            if ((value = ((RawValue)value).getValue()) instanceof byte[]) {
                return new ComparableByteArray((byte[])value);
            }
            return (Comparable)value;
        }
    }

    private static abstract class BaseInt64Type<T>
    extends BaseVariantType<Long, T> {
        private BaseInt64Type() {
        }

        @Override
        public final void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setInt64Value((Long)this.toDatastoreValue(value));
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setIntegerValue((Long)this.toDatastoreValue(value));
            builder.setExcludeFromIndexes(!indexed);
            builder.setMeaning(this.getV3Meaning().getValue());
            return builder;
        }

        @Override
        public T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getInt64Value());
        }

        @Override
        public T getValue(Value propertyValue) {
            return this.fromDatastoreValue(propertyValue.getIntegerValue());
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE;
        }

        public Long asComparable(Object value) {
            return (Long)this.toDatastoreValue(value);
        }
    }

    private static abstract class BasePredefinedEntityType<T>
    extends Type<T> {
        private BasePredefinedEntityType() {
        }

        protected abstract int getV1Meaning();

        protected abstract com.google.appengine.repackaged.com.google.datastore.v1.Entity getEntity(Object var1);

        @Override
        public final boolean isType(Value propertyValue) {
            return propertyValue.getMeaning() == this.getV1Meaning() && this.hasValue(propertyValue);
        }

        @Override
        public final boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.ENTITY_VALUE;
        }

        @Override
        public final Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setEntityValue(this.getEntity(value));
            builder.setExcludeFromIndexes(!indexed);
            builder.setMeaning(this.getV1Meaning());
            return builder;
        }
    }

    private static abstract class BaseBlobType<T>
    extends BaseVariantType<byte[], T> {
        private BaseBlobType() {
        }

        protected abstract boolean isIndexable();

        @Override
        public final boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public final void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setStringValueAsBytes((byte[])this.toDatastoreValue(value));
        }

        @Override
        public boolean canBeIndexed() {
            return this.isIndexable();
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setBlobValue(ByteString.copyFrom((byte[])this.toDatastoreValue(value)));
            builder.setExcludeFromIndexes(!indexed || !this.isIndexable());
            return builder;
        }

        @Override
        public final T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValueAsBytes());
        }

        public final ComparableByteArray asComparable(Object value) {
            return this.isIndexable() ? new ComparableByteArray((byte[])this.toDatastoreValue(value)) : null;
        }
    }

    private static abstract class BaseStringType<T>
    extends BaseVariantType<String, T> {
        private BaseStringType() {
        }

        @Override
        public void toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setStringValue((String)this.toDatastoreValue(value));
        }

        @Override
        public boolean canBeIndexed() {
            return true;
        }

        @Override
        public Value.Builder toV1Value(Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Value.Builder builder = Value.newBuilder();
            builder.setStringValue((String)this.toDatastoreValue(value));
            builder.setExcludeFromIndexes(!indexed);
            builder.setMeaning(this.getV3Meaning().getValue());
            return builder;
        }

        @Override
        public final T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValue());
        }

        @Override
        public T getValue(Value propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValue());
        }

        @Override
        public final boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public boolean hasValue(Value propertyValue) {
            return propertyValue.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE;
        }

        public ComparableByteArray asComparable(Object value) {
            return new ComparableByteArray(ProtocolSupport.toBytesUtf8((String)this.toDatastoreValue(value)));
        }
    }

    private static abstract class BaseVariantType<S, T>
    extends Type<T> {
        private BaseVariantType() {
        }

        protected abstract S toDatastoreValue(Object var1);

        protected abstract T fromDatastoreValue(S var1);
    }

    static abstract class Type<T> {
        Type() {
        }

        public final boolean isType(OnestoreEntity.Property.Meaning meaning, OnestoreEntity.PropertyValue propertyValue) {
            return meaning == this.getV3Meaning() && this.hasValue(propertyValue);
        }

        public boolean isType(Value propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == this.getV3Meaning() && this.hasValue(propertyValue);
        }

        public abstract Comparable<?> asComparable(Object var1);

        public abstract void toV3Value(Object var1, OnestoreEntity.PropertyValue var2);

        public abstract boolean canBeIndexed();

        public abstract Value.Builder toV1Value(Object var1, boolean var2, boolean var3);

        public abstract T getValue(OnestoreEntity.PropertyValue var1);

        public abstract T getValue(Value var1);

        public abstract boolean hasValue(OnestoreEntity.PropertyValue var1);

        public abstract boolean hasValue(Value var1);

        protected OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.NO_MEANING;
        }
    }
}

