/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AutoValue_CloudDatastoreRemoteServiceConfig;
import com.google.appengine.api.datastore.AutoValue_CloudDatastoreRemoteServiceConfig_AppId;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.LocationMapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import java.security.PrivateKey;
import java.util.Set;
import javax.annotation.Nullable;

@AutoValue
public abstract class CloudDatastoreRemoteServiceConfig {
    public static void setConfig(CloudDatastoreRemoteServiceConfig config) {
        DatastoreServiceGlobalConfig.setConfig(config.toInternalConfig());
    }

    public static void clear() {
        DatastoreServiceGlobalConfig.clear();
    }

    private DatastoreServiceGlobalConfig toInternalConfig() {
        return DatastoreServiceGlobalConfig.builder().appId(this.appId().appIdString()).emulatorHost(this.emulatorHost()).hostOverride(this.hostOverride()).additionalAppIds(this.additionalAppIdsAsStrings()).serviceAccount(this.serviceAccount()).privateKey(this.privateKey()).useComputeEngineCredential(this.useComputeEngineCredential()).installApiProxyEnvironment(this.installApiProxyEnvironment()).maxRetries(this.maxRetries()).httpConnectTimeoutMillis(this.httpConnectTimeoutMillis()).build();
    }

    @Nullable
    abstract AppId appId();

    @Nullable
    abstract String emulatorHost();

    @Nullable
    abstract String hostOverride();

    @Nullable
    abstract ImmutableSet<AppId> additionalAppIds();

    abstract boolean installApiProxyEnvironment();

    @Nullable
    abstract String serviceAccount();

    @Nullable
    abstract PrivateKey privateKey();

    abstract boolean useComputeEngineCredential();

    abstract int maxRetries();

    abstract int httpConnectTimeoutMillis();

    @Nullable
    ImmutableSet<String> additionalAppIdsAsStrings() {
        if (this.additionalAppIds() == null) {
            return null;
        }
        ImmutableSet.Builder appIds = ImmutableSet.builder();
        for (AppId appId : this.additionalAppIds()) {
            appIds.add(appId.toString());
        }
        return appIds.build();
    }

    public static Builder builder() {
        return new AutoValue_CloudDatastoreRemoteServiceConfig.Builder().installApiProxyEnvironment(true).useComputeEngineCredential(false).maxRetries(3).httpConnectTimeoutMillis(20000);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder appId(AppId var1);

        public abstract Builder emulatorHost(String var1);

        public abstract Builder hostOverride(String var1);

        public abstract Builder additionalAppIds(Set<AppId> var1);

        public abstract Builder installApiProxyEnvironment(boolean var1);

        public abstract Builder useComputeEngineCredential(boolean var1);

        public abstract Builder maxRetries(int var1);

        public abstract Builder httpConnectTimeoutMillis(int var1);

        public Builder useServiceAccountCredential(String serviceAccountId, PrivateKey privateKey) {
            return this.serviceAccount(serviceAccountId).privateKey(privateKey);
        }

        abstract Builder serviceAccount(String var1);

        abstract Builder privateKey(PrivateKey var1);

        abstract CloudDatastoreRemoteServiceConfig autoBuild();

        public CloudDatastoreRemoteServiceConfig build() {
            CloudDatastoreRemoteServiceConfig config = this.autoBuild();
            config.toInternalConfig();
            return config;
        }
    }

    @AutoValue
    public static abstract class AppId {
        abstract Location location();

        abstract String projectId();

        public static AppId create(Location location, String projectId) {
            return new AutoValue_CloudDatastoreRemoteServiceConfig_AppId(location, projectId);
        }

        String appIdString() {
            return String.format("%s~%s", LocationMapper.getPartitionId(this.location()), this.projectId());
        }

        static AppId fromString(String appIdString) {
            String[] parts = appIdString.split("~");
            if (parts.length != 2) {
                String string = String.valueOf(appIdString);
                throw new IllegalArgumentException(string.length() != 0 ? "Invalid app ID string: ".concat(string) : new String("Invalid app ID string: "));
            }
            Location location = LocationMapper.getLocation(parts[0]);
            if (location == null) {
                String string = String.valueOf(parts[0]);
                throw new IllegalArgumentException(string.length() != 0 ? "Unknown location: ".concat(string) : new String("Unknown location: "));
            }
            return AppId.create(location, parts[1]);
        }

        public static enum Location {
            US_CENTRAL,
            EUROPE_WEST,
            US_EAST1,
            ASIA_NORTHEAST1,
            US_EAST4,
            AUSTRALIA_SOUTHEAST1,
            EUROPE_WEST1,
            EUROPE_WEST3;


            public static Location fromString(String locationString) {
                return Location.valueOf(locationString.toUpperCase().replaceAll("-", "_"));
            }
        }
    }
}

