/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.serviceapp;

import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.apphosting.client.serviceapp.RpcException;
import javax.annotation.Nullable;

public interface RpcHandler<R extends MessageLite, S extends MessageLite> {
    public Parser<R> getParser();

    public Class<R> getRequestClass();

    public S call(CallOptions var1, R var2) throws RpcException;

    public MessageLite makeError(Codes.Code var1, String var2);

    public RequestPermissions getRequiredPermissions(R var1);

    @Nullable
    public MessageLite getRequestHeader(R var1);

    public static enum RequestPermissions {
        READ,
        READ_WRITE;

    }

    public static class CallOptions {
        public static final int DEFAULT_MAX_RESPONSE_BYTES = 0x1E00000;
        public static final CallOptions DEFAULT = new CallOptions(0x1E00000, null);
        private final int maxResponseBytes;
        private final Instant deadline;

        public CallOptions(int maxResponseBytes, Instant deadline) {
            this.maxResponseBytes = maxResponseBytes;
            this.deadline = deadline;
        }

        public CallOptions(int maxResponseBytes, long deadlineMillis) {
            this(maxResponseBytes, new Instant(deadlineMillis));
        }

        public int getMaxResponseBytes() {
            return this.maxResponseBytes;
        }

        public Instant getDeadline() {
            return this.deadline;
        }
    }
}

