/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.SqlClient;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    protected final SqlClientFactory clientFactory;
    static final String MULTIPLE_PROVIDER_ERROR = "Cannot register multiple SqlClientFactory implementations.";
    static final String NO_PROVIDER_ERROR = "No SqlClientFactory implementation was registered.";

    protected Driver(SqlClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public final boolean acceptsURL(String url) {
        return Url.acceptsUrl(url);
    }

    @Override
    public Connection connect(String urlStr, Properties info) throws SQLException {
        SqlClient client;
        if (!this.acceptsURL(urlStr)) {
            return null;
        }
        Url url = Url.create(urlStr, info);
        try {
            client = this.clientFactory.create(url);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newDriverCanNotCreateClient(e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw Exceptions.newDriverCanNotCreateClient(e.getMessage(), e);
        }
        if (client == null) {
            throw Exceptions.newDriverCanNotCreateClient();
        }
        OpenConnectionResponse response = client.openConnection(SqlRpcOptions.defaultOptions(url), url);
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return new Connection(url, client, response.getConnectionId());
    }

    @Override
    public final int getMajorVersion() {
        return 1;
    }

    @Override
    public final int getMinorVersion() {
        return 0;
    }

    @Override
    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return Url.create(url, info).getDriverPropertyInfos();
    }

    @Override
    public final boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(Driver.class.getCanonicalName());
    }
}

