/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import java.sql.SQLException;
import java.util.Arrays;

public final class BoundValue {
    private final Object value;
    private final JdbcType dataType;
    private final Client.BindVariableProto.Direction direction;

    private BoundValue(Object value, JdbcType dataType, Client.BindVariableProto.Direction direction) {
        this.value = value;
        this.dataType = dataType;
        this.direction = direction;
    }

    public static BoundValue nullValue(JdbcType dataType) {
        return new BoundValue(null, dataType, Client.BindVariableProto.Direction.IN);
    }

    public static BoundValue nullValue(JdbcType dataType, Client.BindVariableProto.Direction direction) {
        return new BoundValue(null, dataType, direction);
    }

    public static BoundValue of(Object value, JdbcType dataType) {
        return new BoundValue(value, dataType, Client.BindVariableProto.Direction.IN);
    }

    public static BoundValue of(Object value, JdbcType dataType, Client.BindVariableProto.Direction direction) {
        return new BoundValue(value, dataType, direction);
    }

    public static BoundValue withNewType(BoundValue old, JdbcType dataType) {
        return new BoundValue(old.value, dataType, old.direction);
    }

    public Object getValue() {
        return this.value;
    }

    public ByteString getValueAsByteString() throws SQLException {
        return this.dataType.getConverter().toByteString(this.value);
    }

    public JdbcType getDataType() {
        return this.dataType;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Client.BindVariableProto.Direction getDirection() {
        return this.direction;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.value, this.dataType, this.direction});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BoundValue)) {
            return false;
        }
        BoundValue that = (BoundValue)other;
        return this.dataType == that.dataType && this.direction == that.direction && Util.equal(this.value, that.value);
    }

    public Client.BindVariableProto.Builder toBindVariableProtoBuilder() throws SQLException {
        Client.BindVariableProto.Builder builder = Client.BindVariableProto.newBuilder().setDirection(this.direction).setType(this.dataType.getCode());
        if (this.value != null) {
            builder.setValue(this.getValueAsByteString());
        }
        return builder;
    }

    public String toString() {
        return "JDBC data type: " + (Object)((Object)this.dataType) + ", Direction: " + this.direction + ", Value: " + String.valueOf(this.value);
    }
}

