/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.oauth;

import com.google.appengine.api.oauth.InvalidOAuthParametersException;
import com.google.appengine.api.oauth.InvalidOAuthTokenException;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFailureException;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;
import java.util.Arrays;
import java.util.Objects;

final class OAuthServiceImpl
implements OAuthService {
    static final String GET_OAUTH_USER_RESPONSE_KEY = "com.google.appengine.api.oauth.OAuthService.get_oauth_user_response";
    static final String GET_OAUTH_USER_SCOPE_KEY = "com.google.appengine.api.oauth.OAuthService.get_oauth_user_scope";
    static final String REQUEST_WRITER_PERMISSION_KEY = "com.google.appengine.api.oauth.OAuthService.request_writer_permission";
    private static final String PACKAGE = "user";
    private static final String GET_OAUTH_USER_METHOD = "GetOAuthUser";

    OAuthServiceImpl() {
    }

    @Override
    public User getCurrentUser() throws OAuthRequestException {
        return this.getCurrentUser((String[])null);
    }

    @Override
    public User getCurrentUser(String scope) throws OAuthRequestException {
        String[] scopes = new String[]{scope};
        return this.getCurrentUser(scopes);
    }

    @Override
    public User getCurrentUser(String ... scopes) throws OAuthRequestException {
        UserServicePb.GetOAuthUserResponse response = this.getGetOAuthUserResponse(scopes);
        return new User(response.getEmail(), response.getAuthDomain(), response.getUserId());
    }

    @Override
    public boolean isUserAdmin() throws OAuthRequestException {
        return this.isUserAdmin((String[])null);
    }

    @Override
    public boolean isUserAdmin(String scope) throws OAuthRequestException {
        String[] scopes = new String[]{scope};
        return this.isUserAdmin(scopes);
    }

    @Override
    public boolean isUserAdmin(String ... scopes) throws OAuthRequestException {
        return this.getGetOAuthUserResponse(scopes).isIsAdmin();
    }

    @Override
    public String getOAuthConsumerKey() throws OAuthRequestException {
        throw new OAuthRequestException("Two-legged OAuth1 is not supported any more");
    }

    @Override
    public String getClientId(String scope) throws OAuthRequestException {
        String[] scopes = new String[]{scope};
        return this.getClientId(scopes);
    }

    @Override
    public String getClientId(String ... scopes) throws OAuthRequestException {
        UserServicePb.GetOAuthUserResponse response = this.getGetOAuthUserResponse(scopes);
        return response.getClientId();
    }

    @Override
    public String[] getAuthorizedScopes(String ... scopes) throws OAuthRequestException {
        UserServicePb.GetOAuthUserResponse response = this.getGetOAuthUserResponse(scopes);
        return response.scopess().toArray(new String[response.scopesSize()]);
    }

    private UserServicePb.GetOAuthUserResponse getGetOAuthUserResponse(String[] scopes) throws OAuthRequestException {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        UserServicePb.GetOAuthUserResponse response = (UserServicePb.GetOAuthUserResponse)environment.getAttributes().get(GET_OAUTH_USER_RESPONSE_KEY);
        String scopesKey = "[]";
        if (scopes != null && scopes.length > 0) {
            Object[] scopesCopy = (String[])scopes.clone();
            Arrays.sort(scopesCopy);
            scopesKey = Arrays.toString(scopesCopy);
        }
        String lastScopesKey = (String)environment.getAttributes().get(GET_OAUTH_USER_SCOPE_KEY);
        if (response == null || !Objects.equals(lastScopesKey, scopesKey)) {
            byte[] responseBytes;
            boolean parsed;
            Boolean requestWriterPermission;
            UserServicePb.GetOAuthUserRequest request = new UserServicePb.GetOAuthUserRequest();
            if (scopes != null) {
                for (String scope : scopes) {
                    request.addScopes(scope);
                }
            }
            if ((requestWriterPermission = (Boolean)environment.getAttributes().get(REQUEST_WRITER_PERMISSION_KEY)) != null && requestWriterPermission.booleanValue()) {
                request.setRequestWriterPermission(true);
            }
            if (!(parsed = (response = new UserServicePb.GetOAuthUserResponse()).mergeFrom(responseBytes = this.makeSyncCall(GET_OAUTH_USER_METHOD, request))) || !response.isInitialized()) {
                throw new OAuthServiceFailureException("Could not parse GetOAuthUserResponse");
            }
            environment.getAttributes().put(GET_OAUTH_USER_RESPONSE_KEY, response);
            environment.getAttributes().put(GET_OAUTH_USER_SCOPE_KEY, scopesKey);
        }
        return response;
    }

    private byte[] makeSyncCall(String methodName, ProtocolMessage request) throws OAuthRequestException {
        byte[] responseBytes;
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.valueOf(ex.getApplicationError());
            switch (errorCode) {
                case NOT_ALLOWED: 
                case OAUTH_INVALID_REQUEST: {
                    throw new InvalidOAuthParametersException(ex.getErrorDetail());
                }
                case OAUTH_INVALID_TOKEN: {
                    throw new InvalidOAuthTokenException(ex.getErrorDetail());
                }
            }
            throw new OAuthServiceFailureException(ex.getErrorDetail());
        }
        return responseBytes;
    }
}

