/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LifecycleManager {
    private static final LifecycleManager instance = new LifecycleManager();
    private volatile boolean shuttingDown = false;
    private volatile long deadline = -1L;
    private Map<String, ShutdownHook> hooks = new HashMap<String, ShutdownHook>();

    private LifecycleManager() {
    }

    public static LifecycleManager getInstance() {
        return instance;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public synchronized void setShutdownHook(ShutdownHook hook) {
        this.hooks.put(this.currentAppVersionId(), hook);
    }

    public void interruptAllRequests() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(this){

            @Override
            public Void run() {
                List<Thread> threads = ApiProxy.getRequestThreads();
                if (threads != null) {
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                }
                return null;
            }
        });
    }

    public long getRemainingShutdownTime() {
        long value = this.deadline;
        if (value == -1L) {
            return -1L;
        }
        return value - System.currentTimeMillis();
    }

    public synchronized void beginShutdown(long deadline) {
        this.shuttingDown = true;
        this.deadline = deadline;
        ShutdownHook hook = this.hooks.get(this.currentAppVersionId());
        if (hook != null) {
            hook.shutdown();
        }
    }

    private String currentAppVersionId() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env == null) {
            throw new NullPointerException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        String string = env.getAppId();
        String string2 = env.getVersionId();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

