/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.io.protocol.MutableBridge;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.TypeRegistry;
import com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool.DescriptorPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class MutableDescriptorPool
implements DescriptorPool {
    private final HashMap<String, Descriptors.FileDescriptor> fileNameToFileDescriptor = new HashMap();
    private final HashMap<String, Descriptors.Descriptor> typeNameToDescriptor = new HashMap();
    private final HashMap<String, Descriptors.EnumDescriptor> enumNameToDescriptor = new HashMap();
    private final HashMap<String, Descriptors.ServiceDescriptor> serviceNameToDescriptor = new HashMap();
    private final HashMap<String, HashMap<Integer, Descriptors.FieldDescriptor>> typeNameToExtensions = new HashMap();
    private final HashMap<String, Descriptors.FieldDescriptor> fieldNameToExtensions = new HashMap();

    @Override
    @Nullable
    public Descriptors.Descriptor getDescriptorForTypeName(String typeName) {
        return this.typeNameToDescriptor.get(typeName);
    }

    @Override
    @Nullable
    public Descriptors.FileDescriptor getFileDescriptorForFileName(String fileName) {
        return this.fileNameToFileDescriptor.get(fileName);
    }

    @Override
    @Nullable
    public Descriptors.EnumDescriptor getEnumDescriptorForName(String enumName) {
        return this.enumNameToDescriptor.get(enumName);
    }

    @Override
    @Nullable
    public Descriptors.ServiceDescriptor getServiceDescriptorForName(String serviceName) {
        return this.serviceNameToDescriptor.get(serviceName);
    }

    @Nullable
    public Descriptors.FileDescriptor getFileDescriptorForSymbol(String symbol) {
        Descriptors.Descriptor typeDesc = this.typeNameToDescriptor.get(symbol);
        if (typeDesc != null) {
            return typeDesc.getFile();
        }
        Descriptors.EnumDescriptor enumDesc = this.enumNameToDescriptor.get(symbol);
        if (enumDesc != null) {
            return enumDesc.getFile();
        }
        Descriptors.ServiceDescriptor serviceDesc = this.serviceNameToDescriptor.get(symbol);
        if (serviceDesc != null) {
            return serviceDesc.getFile();
        }
        Descriptors.FieldDescriptor fieldDesc = this.fieldNameToExtensions.get(symbol);
        if (fieldDesc != null) {
            return fieldDesc.getFile();
        }
        fieldDesc = this.findField(symbol);
        if (fieldDesc != null) {
            return fieldDesc.getFile();
        }
        return null;
    }

    @Nullable
    private Descriptors.FieldDescriptor findField(String fullFieldName) {
        int index = fullFieldName.lastIndexOf(46);
        if (index != -1) {
            String fieldName = fullFieldName.substring(index + 1);
            String messageName = fullFieldName.substring(0, index);
            Descriptors.Descriptor messageDesc = this.typeNameToDescriptor.get(messageName);
            if (messageDesc != null) {
                return messageDesc.findFieldByName(fieldName);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Descriptors.FieldDescriptor getExtension(String containingName, int extensionNumber) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(containingName);
        return fieldIdToExtension == null ? null : fieldIdToExtension.get(extensionNumber);
    }

    @Override
    @Nullable
    public ImmutableList<Descriptors.FieldDescriptor> getAllExtensionsForTypeName(String typeName) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(typeName);
        return fieldIdToExtension == null ? null : ImmutableList.copyOf(fieldIdToExtension.values());
    }

    public void populateFromMessageType(Message message) {
        Descriptors.Descriptor desc = message.getDescriptorForType();
        this.addFile(desc.getFile());
    }

    public void populateFromFileDescriptor(Descriptors.FileDescriptor file) {
        this.addFile(file);
    }

    public void populateFromFileDescriptorProto(DescriptorProtos.FileDescriptorProto file) throws Descriptors.DescriptorValidationException {
        if (this.fileNameToFileDescriptor.containsKey(file.getName())) {
            return;
        }
        ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
        for (String dependencyPath : file.getDependencyList()) {
            Descriptors.FileDescriptor dependency = this.fileNameToFileDescriptor.get(dependencyPath);
            Preconditions.checkArgument(dependency != null, "Missing .proto file dependency: %s", (Object)dependencyPath);
            dependencies.add(dependency);
        }
        this.addFile(Descriptors.FileDescriptor.buildFrom(file, dependencies.toArray(new Descriptors.FileDescriptor[0])));
    }

    public void populateFromFileDescriptorSet(DescriptorProtos.FileDescriptorSet descriptorSet) throws Descriptors.DescriptorValidationException {
        HashMap<String, DescriptorProtos.FileDescriptorProto> descriptorMap = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        for (DescriptorProtos.FileDescriptorProto file : descriptorSet.getFileList()) {
            descriptorMap.put(file.getName(), file);
        }
        for (String fileName : descriptorMap.keySet()) {
            this.recursivePopulateFromFileDescriptorProtoInSet(fileName, descriptorMap);
        }
    }

    public TypeRegistry createTypeRegistry() {
        return TypeRegistry.newBuilder().add(this.typeNameToDescriptor.values()).build();
    }

    private void recursivePopulateFromFileDescriptorProtoInSet(String fileName, Map<String, DescriptorProtos.FileDescriptorProto> descriptorMap) throws Descriptors.DescriptorValidationException {
        if (this.fileNameToFileDescriptor.containsKey(fileName)) {
            return;
        }
        DescriptorProtos.FileDescriptorProto file = descriptorMap.get(fileName);
        Preconditions.checkArgument(file != null, "Missing .proto file dependency: %s", (Object)fileName);
        for (String dependencyPath : file.getDependencyList()) {
            this.recursivePopulateFromFileDescriptorProtoInSet(dependencyPath, descriptorMap);
        }
        this.populateFromFileDescriptorProto(file);
    }

    private void addFile(Descriptors.FileDescriptor file) {
        if (this.fileNameToFileDescriptor.put(file.getName(), file) != null) {
            return;
        }
        for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
            this.addFile(dependency);
        }
        for (Descriptors.Descriptor type : file.getMessageTypes()) {
            this.addMessageType(type);
        }
        for (Descriptors.FieldDescriptor extension : file.getExtensions()) {
            this.addExtension(extension);
        }
        for (Descriptors.EnumDescriptor enumDesc : file.getEnumTypes()) {
            this.enumNameToDescriptor.put(enumDesc.getFullName(), enumDesc);
        }
        for (Descriptors.ServiceDescriptor serviceDesc : file.getServices()) {
            this.serviceNameToDescriptor.put(serviceDesc.getFullName(), serviceDesc);
        }
    }

    void addExtension(Descriptors.FieldDescriptor extension) {
        this.fieldNameToExtensions.put(extension.getFullName(), extension);
        String containingName = extension.getContainingType().getFullName();
        HashMap<Integer, Descriptors.FieldDescriptor> fieldIdToExtension = this.typeNameToExtensions.get(containingName);
        if (fieldIdToExtension == null) {
            fieldIdToExtension = new HashMap();
            this.typeNameToExtensions.put(containingName, fieldIdToExtension);
        }
        fieldIdToExtension.put(extension.getNumber(), extension);
    }

    private void addMessageType(Descriptors.Descriptor type) {
        if (this.typeNameToDescriptor.put(type.getFullName(), type) != null) {
            return;
        }
        if (type.getContainingType() != null) {
            this.typeNameToDescriptor.put(MutableBridge.DescriptorDowngrader.getProto1Name(type), type);
        }
        for (Descriptors.Descriptor nested : type.getNestedTypes()) {
            this.addMessageType(nested);
        }
        for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
            this.addExtension(extension);
        }
        for (Descriptors.EnumDescriptor enumDesc : type.getEnumTypes()) {
            this.enumNameToDescriptor.put(enumDesc.getFullName(), enumDesc);
        }
    }
}

