/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.AmbiguousFlagException;
import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.ExternalFlagsLoadException;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import com.google.appengine.repackaged.com.google.common.flags.FlagException;
import com.google.appengine.repackaged.com.google.common.flags.FlagInfo;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.Identifiability;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagSyntaxException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagsException;
import com.google.appengine.repackaged.com.google.common.flags.UnrecognizedFlagException;
import com.google.appengine.repackaged.com.google.common.flags.XmlSupport;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class Flags {
    private static final Collection<Runnable> completionHooks = new ArrayList<Runnable>();
    private static final String DISABLE_EXIT = "com.google.appengine.repackaged.com.google.common.flags.noExit";
    private static PrintStream outputStream = System.out;
    public static final String DISABLE_CHECKING = "com.google.appengine.repackaged.com.google.common.flags.disableStateChecking";
    private static final String CLASS_LOADER = "com.google.appengine.repackaged.com.google.common.flags.classLoader";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static ParseState parseState = ParseState.NOT_STARTED;
    @Nullable
    private static Throwable parseStackTrace;
    @Nullable
    private static String usagePrefix;
    private static final Set<String> preferredClasses;
    @Nullable
    private static ClassLoader flagClassLoader;
    private static final String UNDEF_OK_FLAG_NAME = "undefok";
    @Nullable
    private static final String CACHED_MAIN_CLASS_NAME;
    @GuardedBy(value="allFlags")
    private static final Set<Flag<?>> allFlags;
    @FlagSpec(name="force_ignore_nonflag_arguments", help="Emergency override Flags.parse()'s strictness: Ignore non-flag arguments instead of throwing an exception. For emergencies only: Instead of setting this flag, switch to parseAndReturnLeftovers() when possible.")
    static final Flag<Boolean> forceIgnoreNonflagArguments;
    @FlagSpec(name="show_all_arguments_for_nonflag_errors", help="When Flags.parse() detects non-flag arguments, make the exception message include all arguments instead of only the non-flag arguments.")
    private static final Flag<Boolean> showAllArgumentsForNonflagErrors;
    private static final String NON_FLAG_MESSAGE = "Received unexpected non-flag argument (see <http://go/non-flag-parameter>). ";
    private static final Pattern HELP_PATTERN;
    private static final Pattern HELPFULL_PATTERN;
    private static final Pattern XML_HELP_PATTERN;
    private static final Pattern ONLY_CHECK_ARGS_PATTERN;
    private static final Pattern FLAG_PATTERN;
    private static final Pattern FLAG_FILE_PATTERN;
    private static final Pattern FLAG_RESOURCE_PATTERN;
    private static final Pattern BLANK_LINE_PATTERN;
    private static final Pattern COMMENT_LINE_PATTERN;
    private static final boolean IS_ANDROID;
    private static final int HELP_LINE_LIMIT = 70;
    private static final Pattern FLAG_NAME_PATTERN;

    private Flags() {
    }

    static void setOutputStreamForTesting(PrintStream stream) {
        outputStream = stream;
    }

    static void resetOutputStreamForTesting() {
        outputStream = System.out;
    }

    @Nullable
    private static String getMainClassNameFromStackTrace(StackTraceElement[] stack) {
        StackTraceElement stackRoot;
        String methodName;
        if (stack.length > 0 && ("main".equals(methodName = (stackRoot = stack[stack.length - 1]).getMethodName()) || "<clinit>".equals(methodName))) {
            return stackRoot.getClassName();
        }
        return null;
    }

    public static void setFlagClassLoader(@Nullable ClassLoader loader) {
        flagClassLoader = loader;
    }

    static Map<String, FlagDescription> canonicalFlagMap() {
        Map<String, FlagDescription> canonicalFlagMap = FlagMapHolder.canonicalFlagMap;
        if (canonicalFlagMap == null) {
            canonicalFlagMap = Flags.initCanonicalFlagMap();
        }
        return canonicalFlagMap;
    }

    private static Map<String, Set<FlagDescription>> expandedFlagMap() {
        Map<String, Set<FlagDescription>> expandedFlagMap = FlagMapHolder.expandedFlagMap;
        if (expandedFlagMap == null) {
            expandedFlagMap = Flags.initExpandedFlagMap();
        }
        return expandedFlagMap;
    }

    private static Map<String, Set<FlagDescription>> perClassFlagMap() {
        Map<String, Set<FlagDescription>> perClassFlagMap = FlagMapHolder.perClassFlagMap;
        if (perClassFlagMap == null) {
            perClassFlagMap = Flags.initPerClassFlagMap();
        }
        return perClassFlagMap;
    }

    @Nullable
    static FlagDescription getBestFlag(String flag) {
        return Flags.getBestFlag(Flags.expandedFlagMap().get(flag));
    }

    private static FlagDescription getBestFlag(Set<FlagDescription> allDesc) {
        if (allDesc == null) {
            return null;
        }
        if (allDesc.size() == 1) {
            return allDesc.iterator().next();
        }
        FlagDescription result = null;
        for (FlagDescription desc : allDesc) {
            if (!preferredClasses.contains(desc.getContainerClassName())) continue;
            if (result != null) {
                return null;
            }
            result = desc;
        }
        return result;
    }

    private static void checkForAmbiguousBooleanFlag(@Nullable FlagDescription description, String flag) throws AmbiguousFlagException {
        if (description != null) {
            return;
        }
        Set<FlagDescription> allDesc = Flags.expandedFlagMap().get(flag);
        if (allDesc == null || allDesc.size() <= 1) {
            return;
        }
        throw new AmbiguousFlagException(flag, allDesc);
    }

    private static Map<String, Flag<?>> manuallyRegisteredFlags() {
        return FlagMapHolder.manuallyRegisteredFlags;
    }

    private static Map<String, FlagDescription> longNameMap() {
        return FlagMapHolder.longNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFlag(Flag<?> flag) {
        Set<Flag<?>> set = allFlags;
        synchronized (set) {
            allFlags.add(flag);
        }
    }

    static void clearFlagMapsForTesting() {
        Flags.reallyClearFlagMapsForTesting();
        FlagMapHolder.longNameMap = Flags.loadFlagManifests();
    }

    static void reallyClearFlagMapsForTesting() {
        parseState = ParseState.NOT_STARTED;
        FlagMapHolder.longNameMap.clear();
        FlagMapHolder.canonicalFlagMap = null;
        FlagMapHolder.expandedFlagMap = null;
        FlagMapHolder.perClassFlagMap = null;
        FlagMapHolder.manuallyRegisteredFlags.clear();
        FlagMapHolder.shortFlagNameAllowedPrefixes = null;
        FlagMapHolder.unrecognizedFlags = null;
        FlagMapHolder.acceptableUnrecognizedFlags = null;
        Flags.resetPreferredClasses();
    }

    public static void clearFlagData() {
        if (parseState != ParseState.DONE) {
            throw new IllegalStateException("Flag parsing must be completed");
        }
        FlagMapHolder.manuallyRegisteredFlags.clear();
        FlagMapHolder.canonicalFlagMap = Collections.emptyMap();
        FlagMapHolder.expandedFlagMap = Collections.emptyMap();
        FlagMapHolder.perClassFlagMap = Collections.emptyMap();
        FlagMapHolder.shortFlagNameAllowedPrefixes = null;
        FlagMapHolder.longNameMap = Collections.emptyMap();
    }

    private static Map<String, Set<FlagDescription>> initExpandedFlagMap() {
        FlagMapHolder.expandedFlagMap = Flags.expandFlagMap(Flags.longNameMap().values());
        return FlagMapHolder.expandedFlagMap;
    }

    @CanIgnoreReturnValue
    private static Map<String, FlagDescription> initCanonicalFlagMap() {
        FlagMapHolder.canonicalFlagMap = Flags.createCanonicalFlagMap(Flags.longNameMap().values(), Flags.initExpandedFlagMap());
        return FlagMapHolder.canonicalFlagMap;
    }

    private static Map<String, Set<FlagDescription>> initPerClassFlagMap() {
        FlagMapHolder.perClassFlagMap = Flags.createPerClassFlagMap(Flags.longNameMap().values());
        return FlagMapHolder.perClassFlagMap;
    }

    private static void initMaps() {
        Flags.initCanonicalFlagMap();
    }

    private static Map<String, FlagDescription> loadFlagManifests() {
        HashMap<String, FlagDescription> map = new HashMap<String, FlagDescription>();
        ClassLoader myLoader = Flags.getFlagManifestClassLoader();
        try {
            Enumeration<URL> flagURLs = myLoader.getResources("flags.xml");
            if (!flagURLs.hasMoreElements()) {
                throw new UnsupportedOperationException("No flags.xml files found");
            }
            while (flagURLs.hasMoreElements()) {
                URL url = flagURLs.nextElement();
                try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
                    XmlSupport.fromXml(is, map);
                }
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return map;
    }

    private static ClassLoader getFlagManifestClassLoader() {
        String className = System.getProperty(CLASS_LOADER);
        if (className != null && className.length() > 0) {
            try {
                ClassLoader loader = (ClassLoader)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                String string = String.valueOf(className);
                FlagsLogger.logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.flags.Flags", "getFlagManifestClassLoader", string.length() != 0 ? "User specified classloader: ".concat(string) : new String("User specified classloader: "));
                return loader;
            }
            catch (ReflectiveOperationException e) {
                FlagsLogger.logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.flags.Flags", "getFlagManifestClassLoader", String.format("Couldn't instantiate ClassLoader '%s'", className), e);
            }
        }
        return FlagDescription.checkStateNotNull(Flags.class.getClassLoader());
    }

    static List<String> getAllNamesForFlag(FlagDescription flag) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        if (Flags.isShortFlagNameAllowed(flag)) {
            if (flag.getAltName() != null) {
                aliases.add(flag.getAltName());
            }
            aliases.add(flag.getShortFlagName());
        }
        aliases.add(flag.getLongFlagName());
        if (!flag.isShortFlagNameSpecified()) {
            aliases.add(flag.getFullyQualifiedFieldName());
        }
        if (flag.isShortFlagNameSpecified() && flag.getAltName() != null) {
            String string = flag.getContainerClassName();
            String string2 = flag.getAltName();
            aliases.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('.').append(string2).toString());
        }
        if (flag.getType().equals("java.lang.Boolean")) {
            aliases.addAll(Flags.getNoPrefixedAliases(aliases));
        }
        return new ArrayList<String>(aliases);
    }

    private static List<String> getNoPrefixedAliases(Iterable<String> names) {
        ArrayList<String> noPrefixedAliases = new ArrayList<String>();
        for (String name : names) {
            String string = String.valueOf(name);
            noPrefixedAliases.add(string.length() != 0 ? "no".concat(string) : new String("no"));
        }
        return noPrefixedAliases;
    }

    private static boolean isShortFlagNameAllowed(FlagDescription flag) {
        Collection<String> shortFlagNameAllowedPrefixes = FlagMapHolder.shortFlagNameAllowedPrefixes;
        if (shortFlagNameAllowedPrefixes == null) {
            return true;
        }
        String fullyQualifiedFieldName = flag.isField() ? flag.getFullyQualifiedFieldName() : "";
        for (String prefix : shortFlagNameAllowedPrefixes) {
            if (!prefix.equals(flag.getLongFlagName()) && (!flag.isField() || !prefix.equals(fullyQualifiedFieldName)) && (!prefix.endsWith(".") || !flag.getLongFlagName().startsWith(prefix))) continue;
            return true;
        }
        return false;
    }

    static Map<String, Set<FlagDescription>> expandFlagMap(Collection<FlagDescription> flags) {
        HashMap<String, HashSet<FlagDescription>> allNames = new HashMap<String, HashSet<FlagDescription>>();
        for (FlagDescription flagDescription : flags) {
            FlagDescription flagDescription2 = FlagDescription.checkStateNotNull(flagDescription);
            for (String alias : Flags.getAllNamesForFlag(flagDescription2)) {
                HashSet<FlagDescription> dups = (HashSet<FlagDescription>)allNames.get(alias);
                if (dups == null) {
                    dups = new HashSet<FlagDescription>();
                    allNames.put(alias, dups);
                }
                dups.add(flagDescription2);
            }
        }
        for (Map.Entry entry : allNames.entrySet()) {
            String key = (String)entry.getKey();
            Set dups = FlagDescription.checkStateNotNull((Set)entry.getValue());
            if (dups.size() <= 1 || Flags.getBestFlag(dups) != null) continue;
            StringBuilder b = new StringBuilder();
            for (FlagDescription d : dups) {
                b.append(d.getLongFlagName());
                b.append(',');
            }
            FlagsLogger.logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.common.flags.Flags", "expandFlagMap", "Flag {0} is not a unique short form because {1} flags use it: {2}", new Object[]{key, dups.size(), b});
        }
        return Collections.unmodifiableMap(allNames);
    }

    static Map<String, FlagDescription> createCanonicalFlagMap(Collection<FlagDescription> flags, Map<String, Set<FlagDescription>> expandedFlagMap) {
        HashMap<String, FlagDescription> canonicalMap = new HashMap<String, FlagDescription>();
        for (FlagDescription flag : flags) {
            String bestFlagName = Flags.getBestFlagName(flag = FlagDescription.checkStateNotNull(flag), expandedFlagMap);
            if (bestFlagName == null) continue;
            canonicalMap.put(bestFlagName, flag);
        }
        return canonicalMap;
    }

    static Map<String, Set<FlagDescription>> createPerClassFlagMap(Collection<FlagDescription> flags) {
        HashMap<String, HashSet<FlagDescription>> allClasses = new HashMap<String, HashSet<FlagDescription>>();
        for (FlagDescription flag : flags) {
            HashSet<FlagDescription> classFlags = (HashSet<FlagDescription>)allClasses.get((flag = FlagDescription.checkStateNotNull(flag)).getContainerClassName());
            if (classFlags == null) {
                classFlags = new HashSet<FlagDescription>();
                allClasses.put(flag.getContainerClassName(), classFlags);
            }
            classFlags.add(flag);
        }
        return Collections.unmodifiableMap(allClasses);
    }

    private static String getBestFlagName(FlagDescription flag, Map<String, Set<FlagDescription>> expandedFlagMap) {
        boolean found = false;
        for (String alias : Flags.getAllNamesForFlag(flag)) {
            Set<FlagDescription> descs = expandedFlagMap.get(alias = FlagDescription.checkStateNotNull(alias));
            if (descs == null) continue;
            found = true;
            if (descs.size() != 1) continue;
            return alias;
        }
        if (!found) {
            throw new AssertionError((Object)"Must be at least one name for flag?!");
        }
        return null;
    }

    private static void maybeSyslogOnStart(String[] args) {
        try {
            ProcessBuilder pb;
            String mainClassName = Flags.getMainClassName();
            if (mainClassName == null) {
                return;
            }
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            if (!hostname.contains(".corp.google.com")) {
                return;
            }
            Class<?> cls = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object clsObj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method clsMeth = cls.getMethod("getUid", new Class[0]);
            Object result = clsMeth.invoke(clsObj, new Object[0]);
            Long uid = (Long)result;
            String string = String.valueOf(uid);
            long l = System.currentTimeMillis() / 1000L;
            String string2 = Flags.getLoggingOsString();
            String toolLogProtoStr = new StringBuilder(127 + String.valueOf(mainClassName).length() + String.valueOf(string).length() + String.valueOf(hostname).length() + String.valueOf(string2).length()).append(" log_path:\"").append(mainClassName).append("\" language:\"java\" tool_type:\"cmdline\" uid:").append(string).append(" host_name:\"").append(hostname).append("\" log_timestamp:").append(l).append(" logger:\"logger_java\" os: ").append(string2).toString();
            StringBuilder argvStr = new StringBuilder();
            for (String argv : args) {
                String escaped = argv.replace("\\", "\\\\").replace("\"", "\\\"");
                argvStr.append(" argv:\"").append(escaped).append("\"");
            }
            String loggerPath = "/usr/lib/crudd/log_usage";
            if (new File("/usr/lib/crudd/log_usage").exists()) {
                String[] stringArray = new String[3];
                stringArray[0] = "/usr/lib/crudd/log_usage";
                stringArray[1] = "--tool_log_proto";
                String string3 = String.valueOf(argvStr);
                stringArray[2] = new StringBuilder(String.valueOf(toolLogProtoStr).length() + String.valueOf(string3).length()).append(toolLogProtoStr).append(string3).toString();
                pb = new ProcessBuilder(stringArray);
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = "/usr/bin/logger";
                String string4 = String.valueOf(toolLogProtoStr);
                stringArray[1] = string4.length() != 0 ? "ToolLogProto: logjam_tag=tattler_initgoogle ".concat(string4) : new String("ToolLogProto: logjam_tag=tattler_initgoogle ");
                pb = new ProcessBuilder(stringArray);
            }
            Process p = pb.start();
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getLoggingOsString() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if ("Mac OS X".equals(osName)) {
                return "MAC_OS";
            }
            if ("Linux".equals(osName)) {
                return "LINUX_OS";
            }
            if (osName.contains("Windows")) {
                return "WINDOWS";
            }
        }
        return "UNSPECIFIED";
    }

    public static void parse(String[] args) {
        String[] result = Flags.parseAndReturnLeftovers(args);
        if (result.length > 0 && !FlagDescription.checkStateNotNull(forceIgnoreNonflagArguments.get()).booleanValue()) {
            if (FlagDescription.checkStateNotNull(showAllArgumentsForNonflagErrors.get()).booleanValue()) {
                String string = String.valueOf("Received unexpected non-flag argument (see <http://go/non-flag-parameter>). Full argument list: ");
                String string2 = String.valueOf(Flags.asJavaSourceString(args));
                throw new IllegalArgumentException(string2.length() != 0 ? string.concat(string2) : new String(string));
            }
            String string = String.valueOf("Received unexpected non-flag argument (see <http://go/non-flag-parameter>). Unexpected argument(s): ");
            String string3 = String.valueOf(Flags.asJavaSourceString(result));
            throw new IllegalArgumentException(string3.length() != 0 ? string.concat(string3) : new String(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parseAndReturnLeftovers(String[] args) {
        Runnable[] completionHooks;
        String[] result;
        FlagDescription.checkNotNull(args, "args array cannot be null");
        Flags.checkNotAndroid();
        Flags.maybeSyslogOnStart(args);
        try {
            Flags.setParseState(ParseState.IN_PROGRESS);
            result = Flags.parseInternal(args);
            Runnable[] runnableArray = Flags.class;
            synchronized (Flags.class) {
                Flags.setParseState(ParseState.DONE);
                completionHooks = Flags.completionHooks.toArray(new Runnable[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        catch (FlagException ex) {
            Flags.logFatalFlagError(ex.getMessage());
            throw new InvalidFlagsException(ex.getMessage(), ex);
        }
        {
            for (Runnable r : completionHooks) {
                r.run();
            }
            String string = String.valueOf(Charset.defaultCharset().name());
            FlagsLogger.logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.common.flags.Flags", "parseAndReturnLeftovers", string.length() != 0 ? "The current default charset is ".concat(string) : new String("The current default charset is "));
            return result;
        }
    }

    private static String asJavaSourceString(String[] in) {
        Object[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Flags.asJavaSourceString(in[i]);
        }
        return Arrays.toString(out);
    }

    private static String asJavaSourceString(String s) {
        String content = s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\b", "\\\\b").replaceAll("\\\t", "\\\\t").replaceAll("\\\n", "\\\\n").replaceAll("\\\f", "\\\\f").replaceAll("\\\r", "\\\\r").replaceAll("\\\"", "\\\\\"");
        return new StringBuilder(2 + String.valueOf(content).length()).append('\"').append(content).append('\"').toString();
    }

    private static boolean printRequestedHelp(String arg) {
        if (HELP_PATTERN.matcher(arg).matches()) {
            Flags.usage(outputStream, true, usagePrefix);
            return true;
        }
        if (HELPFULL_PATTERN.matcher(arg).matches()) {
            Flags.usage(outputStream, false, usagePrefix);
            return true;
        }
        if (XML_HELP_PATTERN.matcher(arg).matches()) {
            Flags.xmlUsage(new PrintWriter(outputStream));
            return true;
        }
        return false;
    }

    private static void exitUnlessDisabled(int status) {
        if (!Boolean.getBoolean(DISABLE_EXIT)) {
            System.exit(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] parseInternal(String[] commandLineArgs) throws AmbiguousFlagException, ExternalFlagsLoadException, InvalidFlagSyntaxException, InvalidFlagValueException, UnrecognizedFlagException {
        List<String> unknownFlags;
        Flags.initMaps();
        String[] args = Flags.loadExternalFlags(commandLineArgs);
        boolean exitAfterCheckingArgs = false;
        ArrayList<String> nonFlagArgs = new ArrayList<String>();
        ArrayList<String> unrecognizedFlags = new ArrayList<String>();
        TreeSet<String> acceptableUnrecognizedFlags = new TreeSet<String>();
        for (int i = 0; i < args.length; ++i) {
            boolean guessingNextArgIsValue;
            String valueString;
            String rawValueString;
            String flagName;
            String rawFlagName;
            block21: {
                FlagDescription description;
                String arg;
                block22: {
                    arg = args[i];
                    if (!arg.startsWith("-")) {
                        nonFlagArgs.add(arg);
                        continue;
                    }
                    if (arg.equals("--")) {
                        while (++i < args.length) {
                            nonFlagArgs.add(args[i]);
                        }
                        break;
                    }
                    if (ONLY_CHECK_ARGS_PATTERN.matcher(arg).matches()) {
                        exitAfterCheckingArgs = true;
                        continue;
                    }
                    if (Flags.printRequestedHelp(arg)) {
                        List<String> unknownFlags2 = Flags.getUnknownFlags(unrecognizedFlags, acceptableUnrecognizedFlags);
                        if (!unknownFlags2.isEmpty()) {
                            String string = String.valueOf(unknownFlags2);
                            outputStream.println(new StringBuilder(20 + String.valueOf(string).length()).append("Unrecognized flags: ").append(string).toString());
                        }
                        Flags.exitUnlessDisabled(unknownFlags2.isEmpty() ? 0 : 1);
                        return EMPTY_STRING_ARRAY;
                    }
                    Matcher m = FLAG_PATTERN.matcher(arg);
                    if (!m.matches()) {
                        throw new InvalidFlagSyntaxException(arg);
                    }
                    rawFlagName = m.group(1);
                    flagName = rawFlagName;
                    if (flagName.trim().equals("")) {
                        throw new InvalidFlagSyntaxException(arg);
                    }
                    valueString = rawValueString = m.group(2);
                    description = Flags.getBestFlag(flagName);
                    guessingNextArgIsValue = false;
                    if (valueString != null) break block22;
                    if (description != null && Flags.isBooleanFlag(description)) {
                        valueString = String.valueOf(description.isPositiveFormOfName(flagName));
                        flagName = description.getLongFlagName();
                        break block21;
                    } else if (Flags.isLegitimateFlag(description) || UNDEF_OK_FLAG_NAME.equals(flagName)) {
                        if (i == args.length - 1) {
                            throw new InvalidFlagSyntaxException(String.valueOf(arg).concat(" is missing a value"));
                        }
                        valueString = FlagDescription.checkStateNotNull(args[++i]);
                        guessingNextArgIsValue = true;
                        break block21;
                    } else {
                        Flags.checkForAmbiguousBooleanFlag(description, flagName);
                        unrecognizedFlags.add(flagName);
                        continue;
                    }
                }
                if (description != null && Flags.isBooleanFlag(description) && !description.isPositiveFormOfName(flagName)) {
                    throw new InvalidFlagSyntaxException(arg);
                }
            }
            if (UNDEF_OK_FLAG_NAME.equals(flagName)) {
                for (String fn : valueString.split(",")) {
                    acceptableUnrecognizedFlags.add(fn);
                }
                continue;
            }
            try {
                Flags.processFlagInternal(rawFlagName, flagName, rawValueString, valueString);
                continue;
            }
            catch (UnrecognizedFlagException e) {
                unrecognizedFlags.add(flagName);
                if (!guessingNextArgIsValue) continue;
                --i;
            }
        }
        if ((unknownFlags = Flags.getUnknownFlags(unrecognizedFlags, acceptableUnrecognizedFlags)).size() > 0) {
            throw new UnrecognizedFlagException(unknownFlags);
        }
        FlagMapHolder.acceptableUnrecognizedFlags = acceptableUnrecognizedFlags;
        FlagMapHolder.unrecognizedFlags = unrecognizedFlags;
        if (exitAfterCheckingArgs) {
            Flags.exitUnlessDisabled(0);
        }
        return nonFlagArgs.toArray(EMPTY_STRING_ARRAY);
    }

    private static List<String> getUnknownFlags(List<String> unrecognizedFlags, Set<String> acceptableUnrecognizedFlags) {
        ArrayList<String> unknownFlags = new ArrayList<String>();
        for (String flagName : unrecognizedFlags) {
            if (acceptableUnrecognizedFlags.contains(flagName) || flagName.startsWith("no") && acceptableUnrecognizedFlags.contains(flagName.substring(2))) continue;
            unknownFlags.add(flagName);
        }
        return unknownFlags;
    }

    private static String[] loadExternalFlags(String[] args) throws InvalidFlagSyntaxException, ExternalFlagsLoadException {
        ArrayList<String> collatedArgs = new ArrayList<String>();
        for (String arg : args) {
            arg = FlagDescription.checkStateNotNull(arg);
            try {
                Matcher fileMatcher = FLAG_FILE_PATTERN.matcher(arg);
                Matcher resourceMatcher = FLAG_RESOURCE_PATTERN.matcher(arg);
                if (fileMatcher.matches()) {
                    String file = FlagDescription.checkStateNotNull(fileMatcher.group(1));
                    Flags.appendExternalFlagsFromFile(collatedArgs, file, arg);
                    continue;
                }
                if (resourceMatcher.matches()) {
                    String resource = FlagDescription.checkStateNotNull(resourceMatcher.group(1));
                    Flags.appendExternalFlagsFromResource(collatedArgs, resource, arg);
                    continue;
                }
                collatedArgs.add(arg);
            }
            catch (IOException exc) {
                throw new ExternalFlagsLoadException(arg);
            }
        }
        return collatedArgs.toArray(EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendExternalFlagsFromResource(List<String> collatedArgs, String resource, String arg) throws ExternalFlagsLoadException, InvalidFlagSyntaxException, IOException {
        ClassLoader contextClassLoader;
        InputStream resourceStream = Flags.class.getResourceAsStream(resource);
        if (resourceStream == null && (contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            resourceStream = contextClassLoader.getResourceAsStream(resource);
        }
        if (resourceStream == null) {
            throw new ExternalFlagsLoadException(arg);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
            Flags.appendExternalFlags(reader, collatedArgs);
        }
        finally {
            resourceStream.close();
        }
    }

    private static void appendExternalFlagsFromFile(List<String> collatedArgs, String file, String arg) throws InvalidFlagSyntaxException, IOException, ExternalFlagsLoadException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            Flags.appendExternalFlags(reader, collatedArgs);
        }
    }

    private static void appendExternalFlags(BufferedReader reader, List<String> collatedArgs) throws InvalidFlagSyntaxException, ExternalFlagsLoadException, IOException {
        String line = reader.readLine();
        while (line != null) {
            if (FLAG_PATTERN.matcher(line).matches()) {
                if (FLAG_FILE_PATTERN.matcher(line).matches() || FLAG_RESOURCE_PATTERN.matcher(line).matches()) {
                    String[] fileFlag = new String[]{line};
                    collatedArgs.addAll(Arrays.asList(Flags.loadExternalFlags(fileFlag)));
                } else {
                    collatedArgs.add(line);
                }
            } else if (!BLANK_LINE_PATTERN.matcher(line).matches() && !COMMENT_LINE_PATTERN.matcher(line).matches()) {
                throw new InvalidFlagSyntaxException(line);
            }
            line = reader.readLine();
        }
    }

    public static Identifiability getIdentifiability(String flagName) {
        FlagDescription.checkNotNull(flagName);
        Set<FlagDescription> allDesc = Flags.expandedFlagMap().get(flagName);
        if (allDesc == null || allDesc.isEmpty()) {
            return Identifiability.UNDEFINED;
        }
        if (allDesc.size() == 1) {
            return Identifiability.UNIQUE;
        }
        return Flags.getBestFlag(flagName) == null ? Identifiability.AMBIGUOUS : Identifiability.IDENTIFIABLE;
    }

    public static void processFlag(String flagName, @Nullable String flagValue) throws UnrecognizedFlagException, InvalidFlagValueException, AmbiguousFlagException {
        Flags.processFlagInternal(flagName, flagName, flagValue, flagValue);
    }

    private static void processFlagInternal(String rawFlagName, String flagName, @Nullable String rawFlagValue, @Nullable String flagValue) throws UnrecognizedFlagException, InvalidFlagValueException, AmbiguousFlagException {
        Flags.checkNotAndroid();
        FlagDescription.checkNotNull(flagName);
        FlagDescription desc = Flags.getBestFlag(flagName);
        if (desc == null) {
            Set<FlagDescription> allDesc = Flags.expandedFlagMap().get(flagName);
            if (allDesc == null || allDesc.size() == 0) {
                throw new UnrecognizedFlagException(flagName);
            }
            throw new AmbiguousFlagException(flagName, allDesc);
        }
        try {
            Flags.flag(desc).setFromNameAndString(rawFlagName, flagValue, rawFlagValue);
        }
        catch (NullPointerException e) {
            InvalidFlagValueException newException = new InvalidFlagValueException("NullPointerException");
            newException.flagName = desc.getLongFlagName();
            newException.flagValue = "null";
            throw newException;
        }
        catch (InvalidFlagValueException e) {
            e.flagName = desc.getLongFlagName();
            e.flagValue = flagValue;
            throw e;
        }
    }

    private static boolean computeIsAndroid() {
        try {
            String value = System.getProperties().getProperty("java.runtime.name");
            return value != null && value.contains("Android");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static void checkNotAndroid() {
        if (IS_ANDROID) {
            throw new UnsupportedOperationException("Under Android, common.flags is untested, does not automatically read command-line parameters, and has historically had bugs. We have disabled most methods of setting flags there. Note that even *reading* the value of a flag under Android may cause problems. The safest bet is to avoid linking in the flags code at all.");
        }
    }

    private static boolean isBooleanFlag(FlagDescription desc) {
        return desc.getType().equals("java.lang.Boolean");
    }

    private static boolean isLegitimateFlag(@Nullable FlagDescription description) {
        return description != null;
    }

    static FlagInfo getFlagInfo(Flag<?> flag) {
        if (Flags.manuallyRegisteredFlags().containsValue(flag)) {
            throw new IllegalStateException("manually registered flags should already have FlagInfo computed.");
        }
        if (flag.declaringClassName == null) {
            return null;
        }
        Set<FlagDescription> flagsForClass = Flags.perClassFlagMap().get(flag.declaringClassName);
        if (flagsForClass == null) {
            return null;
        }
        for (FlagDescription desc : flagsForClass) {
            boolean equal = flag == Flags.flag(desc);
            if (!equal) continue;
            return new FlagInfoImpl(desc);
        }
        return null;
    }

    static Flag<?> flag(FlagDescription desc) {
        Flag<?> flag = Flags.manuallyRegisteredFlags().get(desc.getLongFlagName());
        if (flag != null) {
            return flag;
        }
        try {
            Class<?> containerClass = Flags.loadClass(desc.getContainerClassName());
            Field field = containerClass.getDeclaredField(desc.getSimpleFieldName());
            field.setAccessible(true);
            return (Flag)field.get(null);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            String string = desc.getFullyQualifiedFieldName();
            String string2 = ex.toString();
            throw new LinkageError(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Class for flag field ").append(string).append(" present in manifest, absent at runtime: ").append(string2).toString());
        }
        catch (NoSuchFieldException ex) {
            String string = desc.getFullyQualifiedFieldName();
            String string3 = ex.toString();
            throw new LinkageError(new StringBuilder(52 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Flag field ").append(string).append(" present in manifest, absent at runtime: ").append(string3).toString());
        }
        catch (IllegalAccessException ex) {
            String string = desc.getFullyQualifiedFieldName();
            String string4 = ex.toString();
            throw new LinkageError(new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Unable to get flag field ").append(string).append(": ").append(string4).toString());
        }
        catch (NullPointerException ex) {
            String string = desc.getFullyQualifiedFieldName();
            String string5 = ex.toString();
            throw new LinkageError(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string5).length()).append("Forgot to make the flag static? ").append(string).append(": ").append(string5).toString());
        }
        catch (ClassCastException ex) {
            String string = desc.getSimpleFieldName();
            String string6 = desc.getFullyQualifiedFieldName();
            String string7 = ex.toString();
            throw new LinkageError(new StringBuilder(54 + String.valueOf(string).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append("Cannot convert field ").append(string).append(" to a Flag in order to resolve ").append(string6).append(": ").append(string7).toString());
        }
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        while (true) {
            try {
                if (flagClassLoader != null) {
                    return Class.forName(name, true, flagClassLoader);
                }
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                int idx = name.lastIndexOf(46);
                if (idx < 0) {
                    throw e;
                }
                String string = name.substring(0, idx);
                String string2 = name.substring(idx + 1, name.length());
                name = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("$").append(string2).toString();
                continue;
            }
            break;
        }
    }

    private static void formatFlag(PrintStream printStream, String flagName, String flagDescription, @Nullable String defaultString, @Nullable String details) {
        StringBuilder b = new StringBuilder().append("   --").append(flagName).append(" ").append(flagDescription);
        if (defaultString != null) {
            b.append("; default: ").append(defaultString);
        }
        if (details != null) {
            b.append("; ").append(details);
        }
        while (b.length() > 70) {
            int space = b.lastIndexOf(" ", 70);
            if (space == -1) {
                space = b.indexOf(" ", 70);
            }
            if (space < 10) break;
            printStream.println(b.substring(0, space));
            b.replace(0, space + 1, "      ");
        }
        if (b.length() != 0) {
            printStream.println(b);
        }
    }

    private static void formatFlag(PrintStream printStream, String flagName, String flagDescription) {
        Flags.formatFlag(printStream, flagName, flagDescription, null, null);
    }

    static Set<Map.Entry<String, FlagDescription>> sortFlags(boolean shortForm) {
        String mainClassName = Flags.getMainClassName();
        TreeSet<Map.Entry<String, FlagDescription>> entries = new TreeSet<Map.Entry<String, FlagDescription>>(new Comparator<Map.Entry<String, FlagDescription>>(){

            @Override
            public int compare(Map.Entry<String, FlagDescription> o1, Map.Entry<String, FlagDescription> o2) {
                FlagDescription d1 = FlagDescription.checkStateNotNull(o1.getValue());
                FlagDescription d2 = FlagDescription.checkStateNotNull(o2.getValue());
                int cls = d1.getContainerClassName().compareTo(d2.getContainerClassName());
                return cls == 0 ? d1.getShortFlagName().compareTo(d2.getShortFlagName()) : cls;
            }
        });
        for (Map.Entry<String, FlagDescription> e : Flags.canonicalFlagMap().entrySet()) {
            FlagDescription descr = FlagDescription.checkStateNotNull(e.getValue());
            if (!Flags.isShortFlagNameAllowed(descr) || shortForm && mainClassName != null && !descr.getContainerClassName().equals(mainClassName)) continue;
            entries.add(e);
        }
        return entries;
    }

    public static void setUsagePrefix(@Nullable String usgPrefix) {
        usagePrefix = usgPrefix;
    }

    @Nullable
    public static String getUsagePrefix() {
        return usagePrefix;
    }

    public static void usage(PrintStream printStream) {
        Flags.usage(printStream, false, usagePrefix);
    }

    public static void usage(PrintStream printStream, @Nullable String usgPrefix) {
        Flags.usage(printStream, false, usgPrefix);
    }

    public static void usage(PrintStream printStream, boolean shortForm, @Nullable String usgPrefix) {
        FlagDescription.checkNotNull(printStream);
        if (usgPrefix == null) {
            usgPrefix = String.format("Usage: java [jvm-flags...] %s [flags...] [args...]", Flags.getProgramName());
        }
        Flags.initMaps();
        printStream.println(usgPrefix);
        printStream.println("where flags are");
        printStream.println(" Standard flags:");
        Flags.formatFlag(printStream, "help", "describes the main class' flags");
        Flags.formatFlag(printStream, "helpfull", "describes all flags");
        Flags.formatFlag(printStream, "helpxml", "emits XML description of all flags");
        Flags.formatFlag(printStream, "only_check_args", "exits after parsing flags");
        String previousClass = "";
        for (Map.Entry<String, FlagDescription> e : Flags.sortFlags(shortForm)) {
            String flagName = FlagDescription.checkStateNotNull(e.getKey());
            FlagDescription descr = FlagDescription.checkStateNotNull(e.getValue());
            if (descr.getDocLevel() != DocLevel.PUBLIC) continue;
            if (!descr.getContainerClassName().equals(previousClass)) {
                printStream.println();
                String string = descr.getContainerClassName();
                printStream.println(new StringBuilder(13 + String.valueOf(string).length()).append("  Flags for ").append(string).append(":").toString());
                previousClass = descr.getContainerClassName();
            }
            Flag<?> flag = Flags.flag(descr);
            Flags.formatFlag(printStream, flagName, descr.getDoc(), Flags.getDefaultAsString(flag), flag.getDetails());
        }
    }

    @Nullable
    public static String getMainClassName() {
        return CACHED_MAIN_CLASS_NAME;
    }

    private static String valueToString(@Nullable Object defaultValue) {
        StringBuilder b = new StringBuilder();
        if (defaultValue instanceof List) {
            List v = (List)defaultValue;
            boolean first = true;
            for (Object o : v) {
                if (!first) {
                    b.append(",");
                }
                b.append(o);
                first = false;
            }
        } else if (defaultValue instanceof Class) {
            b.append(((Class)defaultValue).getName());
        } else {
            b.append(defaultValue);
        }
        return b.toString();
    }

    @Nullable
    private static <T> String getDefaultAsString(Flag<T> flag) {
        T defaultValue = flag.getDefault();
        if (defaultValue == null) {
            return null;
        }
        try {
            return flag.parsableStringValue(defaultValue);
        }
        catch (UnsupportedOperationException uoe) {
            return Flags.valueToString(defaultValue);
        }
    }

    @Nullable
    private static String getAsString(Flag<?> flag) {
        try {
            return flag.parsableStringValue();
        }
        catch (UnsupportedOperationException uoe) {
            return Flags.valueToString(flag.get());
        }
    }

    public static void xmlUsage(PrintWriter out) {
        FlagDescription.checkNotNull(out);
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><AllFlags>");
        out.print(XmlSupport.toXmlElement("program", Flags.getProgramName()));
        out.print(XmlSupport.toXmlElement("usage", Flags.getProgramName()));
        TreeMap<String, FlagDescription> sortedMap = new TreeMap<String, FlagDescription>(Flags.canonicalFlagMap());
        for (Map.Entry e : sortedMap.entrySet()) {
            String name = (String)e.getKey();
            FlagDescription description = FlagDescription.checkStateNotNull((FlagDescription)e.getValue());
            if (!Flags.isShortFlagNameAllowed(description)) continue;
            Flag<?> flag = Flags.flag(description);
            out.print("<flag>");
            out.print(XmlSupport.toXmlElement("file", description.getContainerClassName()));
            String string = String.valueOf(name);
            out.print(XmlSupport.toXmlElement("name", string.length() != 0 ? "--".concat(string) : new String("--")));
            if (description.getAltName() != null) {
                String string2 = String.valueOf(description.getShortFlagName());
                out.print(XmlSupport.toXmlElement("shortname", string2.length() != 0 ? "--".concat(string2) : new String("--")));
            }
            String doc = description.getDoc();
            if (description.getDocLevel() == DocLevel.SECRET) {
                String string3 = String.valueOf(doc);
                doc = string3.length() != 0 ? "(secret) ".concat(string3) : new String("(secret) ");
            }
            out.print(XmlSupport.toXmlElement("meaning", doc));
            out.print(XmlSupport.toXmlElement("default", String.valueOf(Flags.getDefaultAsString(flag))));
            out.print(XmlSupport.toXmlElement("current", String.valueOf(Flags.getAsString(flag))));
            out.print(XmlSupport.toXmlElement("type", Flags.simpleType(description.getType())));
            out.print("</flag>");
        }
        out.print("</AllFlags>");
        out.flush();
    }

    private static String getProgramName() {
        String progname = "unknown";
        StackTraceElement[] frames = new Throwable().getStackTrace();
        if (frames != null && frames.length > 0) {
            progname = frames[frames.length - 1].getClassName();
        }
        return progname;
    }

    private static String simpleType(String typeClassName) {
        switch (typeClassName) {
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "java.lang.Double": {
                return "double";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Long": {
                return "long";
            }
            case "java.lang.String": {
                return "string";
            }
        }
        return typeClassName;
    }

    public static synchronized void registerFlag(String containerClassName, String simpleName, String doc, @Nullable String altName, DocLevel doclevel, String type, Flag<?> flag) {
        FlagDescription.checkNotNull(new Object[]{containerClassName, simpleName, doc, doclevel, type, flag});
        FlagDescription description = FlagDescription.createManuallyRegisteredFlag(simpleName, containerClassName).doc(doc).altName(altName).docLevel(doclevel).type(type).build();
        if (altName != null && !FLAG_NAME_PATTERN.matcher(altName).matches()) {
            throw new IllegalArgumentException("Alternate flag name can only contain alphanumeric characters and underscores.");
        }
        Map<String, FlagDescription> longNameMap = Flags.longNameMap();
        if (longNameMap.containsKey(description.getLongFlagName()) && !Flags.stateCheckingDisabled()) {
            String string = String.valueOf(description.getLongFlagName());
            throw new IllegalStateException(string.length() != 0 ? "Duplicate flag ".concat(string) : new String("Duplicate flag "));
        }
        longNameMap.put(description.getLongFlagName(), description);
        Flags.manuallyRegisteredFlags().put(description.getLongFlagName(), flag);
        flag.setInfo(new FlagInfoImpl(description));
        FlagMapHolder.canonicalFlagMap = null;
        FlagMapHolder.expandedFlagMap = null;
    }

    public static void setAllowedFlags(@Nullable Collection<String> shortFlagNameAllowedPrefixes) {
        FlagMapHolder.shortFlagNameAllowedPrefixes = shortFlagNameAllowedPrefixes == null ? null : new LinkedHashSet<String>(shortFlagNameAllowedPrefixes);
        FlagMapHolder.expandedFlagMap = null;
        FlagMapHolder.canonicalFlagMap = null;
    }

    @Nullable
    public static Collection<String> getAllowedFlags() {
        if (FlagMapHolder.shortFlagNameAllowedPrefixes == null) {
            return null;
        }
        return new LinkedHashSet<String>(FlagMapHolder.shortFlagNameAllowedPrefixes);
    }

    public static void addPreferredClass(String className) {
        FlagDescription.checkNotNull(className);
        preferredClasses.add(className);
    }

    public static void addPreferredClass(Class<?> clazz) {
        FlagDescription.checkNotNull(clazz);
        Flags.addPreferredClass(clazz.getName());
    }

    public static void resetPreferredClasses() {
        preferredClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompletionHook(Runnable callback) {
        FlagDescription.checkNotNull(callback);
        Class<Flags> clazz = Flags.class;
        synchronized (Flags.class) {
            boolean parseDone = parseState == ParseState.DONE;
            completionHooks.add(callback);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (parseDone) {
                callback.run();
            }
            return;
        }
    }

    private static synchronized void setParseState(ParseState newState) {
        if (newState == ParseState.IN_PROGRESS && parseState != ParseState.NOT_STARTED && !Flags.stateCheckingDisabled()) {
            String string = String.valueOf(Flags.getStackTraceAsString(parseStackTrace));
            throw new IllegalStateException(string.length() != 0 ? "Cannot call parse more than once.  Here is the stacktrace of the previous call:\n".concat(string) : new String("Cannot call parse more than once.  Here is the stacktrace of the previous call:\n"));
        }
        parseState = newState;
        parseStackTrace = newState == ParseState.DONE ? new Throwable("The stack trace associated with the PREVIOUS call to parse") : null;
    }

    static boolean isParseInProgress() {
        return parseState == ParseState.IN_PROGRESS;
    }

    public static boolean stateCheckingDisabled() {
        return Boolean.getBoolean(DISABLE_CHECKING);
    }

    public static void disableStateCheckingForTest() {
        Properties props = System.getProperties();
        props.setProperty(DISABLE_CHECKING, "true");
    }

    public static void enableStateCheckingForTest() {
        Properties props = System.getProperties();
        props.setProperty(DISABLE_CHECKING, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAllFlagsForTest() {
        ArrayList needReset;
        Set<Flag<?>> set = allFlags;
        synchronized (set) {
            needReset = new ArrayList(allFlags);
        }
        for (Flag flag : needReset) {
            if (flag.getInfo() == null) continue;
            flag.resetForTest();
        }
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    public static void resetSomeFlagsForTest(String ... flagNames) {
        for (String flagName : flagNames) {
            Flags.verifyAndResetFlag(FlagDescription.checkNotNull(flagName));
        }
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    public static void resetFlagForTest(Class<?> cls, String member) {
        FlagDescription.checkNotNull(cls);
        String string = cls.getName();
        String string2 = member.replaceFirst("^FLAG_", "");
        Flags.verifyAndResetFlag(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    private static void verifyAndResetFlag(String flagName) {
        FlagDescription desc = Flags.longNameMap().get(flagName);
        if (desc == null) {
            String string = String.valueOf(flagName);
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid flag name: ".concat(string) : new String("Invalid flag name: "));
        }
        try {
            Flags.flag(desc).resetForTest();
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private static Collection<FlagInfoImpl> allFlagsInternal() {
        TreeSet<FlagInfoImpl> result = new TreeSet<FlagInfoImpl>();
        for (FlagDescription desc : Flags.longNameMap().values()) {
            result.add(new FlagInfoImpl(FlagDescription.checkStateNotNull(desc)));
        }
        return result;
    }

    public static Collection<FlagInfo> allFlags() {
        return Collections.unmodifiableCollection(Flags.allFlagsInternal());
    }

    public static Collection<String> allAcceptableUnrecognizedFlags() {
        if (FlagMapHolder.acceptableUnrecognizedFlags == null) {
            throw new IllegalStateException("Must parse flags before calling allAcceptableUnrecognizedFlags()");
        }
        return Collections.unmodifiableCollection(FlagMapHolder.acceptableUnrecognizedFlags);
    }

    public static Collection<String> allUnrecognizedFlags() {
        if (FlagMapHolder.unrecognizedFlags == null) {
            throw new IllegalStateException("Must parse flags before calling allUnrecognizedFlags()");
        }
        return Collections.unmodifiableCollection(FlagMapHolder.unrecognizedFlags);
    }

    public static Collection<FlagInfo> exposedFlags() {
        Collection<FlagInfoImpl> allFlags = Flags.allFlagsInternal();
        Iterator<FlagInfoImpl> it = allFlags.iterator();
        while (it.hasNext()) {
            FlagInfoImpl flag = FlagDescription.checkStateNotNull(it.next());
            if (flag.desc.getDocLevel() == DocLevel.PUBLIC && Flags.isShortFlagNameAllowed(flag.desc)) continue;
            it.remove();
        }
        return Collections.unmodifiableCollection(allFlags);
    }

    private static String getStackTraceAsString(@Nullable Throwable t) {
        if (t == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private static void logFatalFlagError(String message) {
        for (ErrorLogger errorLogger : ServiceLoader.load(ErrorLogger.class)) {
            try {
                errorLogger.logError(message);
            }
            catch (RuntimeException e) {
                FlagsLogger.logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.flags.Flags", "logFatalFlagError", String.format("Exception while trying to log flag error with %s", errorLogger), e);
            }
        }
    }

    static /* synthetic */ Map access$000() {
        return Flags.loadFlagManifests();
    }

    static {
        usagePrefix = null;
        preferredClasses = new HashSet<String>();
        flagClassLoader = null;
        String mainClassName = Flags.getMainClassNameFromStackTrace(Thread.currentThread().getStackTrace());
        if (mainClassName == null) {
            try {
                StackTraceElement[] stack;
                Iterator<StackTraceElement[]> iterator = Thread.getAllStackTraces().values().iterator();
                while (iterator.hasNext() && (mainClassName = Flags.getMainClassNameFromStackTrace(FlagDescription.checkStateNotNull(stack = iterator.next()))) == null) {
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        CACHED_MAIN_CLASS_NAME = mainClassName;
        allFlags = Collections.newSetFromMap(new WeakHashMap());
        forceIgnoreNonflagArguments = Flag.value(false);
        showAllArgumentsForNonflagErrors = Flag.value(false);
        HELP_PATTERN = Pattern.compile("-+help(short)?(=true)?");
        HELPFULL_PATTERN = Pattern.compile("-+helpfull(=true)?");
        XML_HELP_PATTERN = Pattern.compile("-+helpxml(=true)?");
        ONLY_CHECK_ARGS_PATTERN = Pattern.compile("-+only_check_args(=true)?");
        FLAG_PATTERN = Pattern.compile("-+([^=]*)(?:=(.*))?", 40);
        FLAG_FILE_PATTERN = Pattern.compile("-+flagfile=(.+)");
        FLAG_RESOURCE_PATTERN = Pattern.compile("-+flagresource=(.+)");
        BLANK_LINE_PATTERN = Pattern.compile("\\s*");
        COMMENT_LINE_PATTERN = Pattern.compile("\\s*#.*");
        IS_ANDROID = Flags.computeIsAndroid();
        FLAG_NAME_PATTERN = Pattern.compile("\\w[_\\w]*");
    }

    public static interface ErrorLogger {
        public void logError(String var1);
    }

    static class FlagInfoImpl
    implements FlagInfo,
    Comparable<FlagInfoImpl> {
        private volatile List<String> names;
        final FlagDescription desc;

        FlagInfoImpl(FlagDescription desc) {
            this.desc = desc;
        }

        @Override
        public String longFlagName() {
            return this.desc.getLongFlagName();
        }

        @Override
        public List<String> names() {
            if (this.names == null) {
                List<String> allNames = Flags.getAllNamesForFlag(this.desc);
                ArrayList<String> unambiguousNames = new ArrayList<String>();
                for (String name : allNames) {
                    if (Flags.getBestFlag(name) != this.desc) continue;
                    unambiguousNames.add(name);
                }
                this.names = Collections.unmodifiableList(unambiguousNames);
            }
            return this.names;
        }

        @Override
        public String containerClass() {
            return this.desc.getContainerClassName();
        }

        @Override
        @Nullable
        public String fieldName() {
            return this.desc.isField() ? this.desc.getSimpleFieldName() : null;
        }

        @Override
        public String type() {
            return this.desc.getType();
        }

        @Override
        @Nullable
        public Object value() {
            return Flags.flag((FlagDescription)this.desc).value;
        }

        @Override
        public boolean accessed() {
            return Flags.flag((FlagDescription)this.desc).accessed;
        }

        @Override
        public boolean hasAltName() {
            return this.desc.getAltName() != null;
        }

        @Override
        @Nullable
        public String parsableStringValue() {
            return Flags.flag(this.desc).parsableStringValue();
        }

        @Override
        public boolean wasSetFromString() {
            return Flags.flag(this.desc).wasSetFromString();
        }

        @Override
        @Nullable
        public Object defaultValue() {
            return Flags.flag((FlagDescription)this.desc).defaultValue;
        }

        @Override
        public int compareTo(FlagInfoImpl other) {
            return this.desc.compareTo(other.desc);
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof FlagInfoImpl)) {
                return false;
            }
            FlagInfoImpl otherFlag = (FlagInfoImpl)that;
            return this.desc.equals(otherFlag.desc);
        }

        public int hashCode() {
            return this.desc.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.desc);
            return new StringBuilder(11 + String.valueOf(string).length()).append("[FlagInfo ").append(string).append("]").toString();
        }

        @Override
        public String doc() {
            return this.desc.getDoc();
        }

        @Override
        public String shortFlagName() {
            return this.desc.getShortFlagName();
        }

        @Override
        public String altName() {
            return this.desc.getAltName();
        }

        @Override
        public boolean isDeprecated() {
            return this.desc.isDeprecated();
        }
    }

    private static class FlagMapHolder {
        static Map<String, FlagDescription> longNameMap = Flags.access$000();
        @Nullable
        static volatile Map<String, FlagDescription> canonicalFlagMap;
        @Nullable
        static volatile Map<String, Set<FlagDescription>> expandedFlagMap;
        @Nullable
        static volatile Map<String, Set<FlagDescription>> perClassFlagMap;
        static final Map<String, Flag<?>> manuallyRegisteredFlags;
        @Nullable
        static Collection<String> shortFlagNameAllowedPrefixes;
        @Nullable
        static Collection<String> unrecognizedFlags;
        @Nullable
        static Collection<String> acceptableUnrecognizedFlags;

        private FlagMapHolder() {
        }

        static {
            manuallyRegisteredFlags = new HashMap();
            shortFlagNameAllowedPrefixes = null;
            unrecognizedFlags = null;
            acceptableUnrecognizedFlags = null;
        }
    }

    private static enum ParseState {
        NOT_STARTED,
        IN_PROGRESS,
        DONE;

    }

    static class FlagsLogger {
        private static final Logger logger = Logger.getLogger(Flags.class.getName());

        FlagsLogger() {
        }
    }
}

