/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.context;

import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.LogLevelMap;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.MustBeClosed;
import java.io.Closeable;
import java.util.concurrent.Callable;

public abstract class ScopedLoggingContext {
    @CheckReturnValue
    public static ScopedLoggingContext getInstance() {
        return ContextDataProvider.getInstance().getContextApiSingleton();
    }

    protected ScopedLoggingContext() {
    }

    @CheckReturnValue
    public Builder newScope() {
        return new Builder(){

            @Override
            public Closeable install() {
                LogLevelMap logLevelMap;
                Closeable scope = ScopedLoggingContext.this.withNewScope();
                Tags tags = this.getTags();
                if (tags != null && !tags.isEmpty()) {
                    ScopedLoggingContext.this.addTags(tags);
                }
                if ((logLevelMap = this.getLogLevelMap()) != null) {
                    ScopedLoggingContext.this.applyLogLevelMap(logLevelMap);
                }
                return scope;
            }
        };
    }

    @Deprecated
    @CheckReturnValue
    @MustBeClosed
    public abstract Closeable withNewScope();

    @Deprecated
    @CheckReturnValue
    public final Runnable wrap(Runnable r) {
        return this.newScope().wrap(r);
    }

    @Deprecated
    @CheckReturnValue
    public final <R> Callable<R> wrap(Callable<R> c) {
        return this.newScope().wrap(c);
    }

    @Deprecated
    public final void run(Runnable r) {
        this.newScope().run(r);
    }

    @Deprecated
    public final <R> R call(Callable<R> c) throws Exception {
        return this.newScope().call(c);
    }

    public abstract boolean addTags(Tags var1);

    public abstract boolean applyLogLevelMap(LogLevelMap var1);

    private static void closeAndMaybePropagateError(Closeable scope, boolean callerHasError) {
        block2: {
            try {
                scope.close();
            }
            catch (Throwable e) {
                if (callerHasError) break block2;
                throw e instanceof InvalidLoggingScopeStateException ? (InvalidLoggingScopeStateException)e : new InvalidLoggingScopeStateException("invalid logging context state", e);
            }
        }
    }

    public static final class InvalidLoggingScopeStateException
    extends IllegalStateException {
        public InvalidLoggingScopeStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidLoggingScopeStateException(String message) {
            super(message);
        }
    }

    public abstract class Builder {
        private Tags tags = null;
        private LogLevelMap logLevelMap = null;

        protected Builder(ScopedLoggingContext this$0) {
        }

        @CheckReturnValue
        public final Builder withTags(Tags tags) {
            Checks.checkState(this.tags == null, "tags already set");
            Checks.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        @CheckReturnValue
        public final Builder withLogLevelMap(LogLevelMap logLevelMap) {
            Checks.checkState(this.logLevelMap == null, "log level map already set");
            Checks.checkNotNull(logLevelMap, "log level map");
            this.logLevelMap = logLevelMap;
            return this;
        }

        @CheckReturnValue
        public final Runnable wrap(final Runnable r) {
            return new Runnable(){

                @Override
                public void run() {
                    Closeable scope = Builder.this.install();
                    boolean hasError = true;
                    try {
                        r.run();
                        hasError = false;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(scope, hasError);
                    }
                }
            };
        }

        @CheckReturnValue
        public final <R> Callable<R> wrap(final Callable<R> c) {
            return new Callable<R>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R call() throws Exception {
                    Closeable scope = Builder.this.install();
                    boolean hasError = true;
                    try {
                        Object result = c.call();
                        hasError = false;
                        Object v = result;
                        return v;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(scope, hasError);
                    }
                }
            };
        }

        public final void run(Runnable r) {
            this.wrap(r).run();
        }

        public final <R> R call(Callable<R> c) throws Exception {
            return this.wrap(c).call();
        }

        @CheckReturnValue
        @MustBeClosed
        public abstract Closeable install();

        protected final Tags getTags() {
            return this.tags;
        }

        protected final LogLevelMap getLogLevelMap() {
            return this.logLevelMap;
        }
    }
}

