/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.api.proto2api.DatastorePb;
import java.util.concurrent.Future;

class InternalTransactionV3
implements TransactionImpl.InternalTransaction {
    private final ApiProxy.ApiConfig apiConfig;
    private final String app;
    private final Future<DatastorePb.Transaction> beginTxnFuture;

    InternalTransactionV3(ApiProxy.ApiConfig apiConfig, String app, Future<DatastorePb.Transaction> beginTxnFuture) {
        this.apiConfig = apiConfig;
        this.app = app;
        this.beginTxnFuture = beginTxnFuture;
    }

    private long getHandle() {
        return FutureHelper.quietGet(this.beginTxnFuture).getHandle();
    }

    <T extends ProtocolMessage<T>> Future<Void> makeAsyncCall(DatastorePb.DatastoreService_3.Method method, ProtocolMessage<?> request, T response) {
        Future<T> resultProto = DatastoreApiHelper.makeAsyncCall(this.apiConfig, method, request, response);
        return new FutureWrapper<T, Void>(this, resultProto){

            @Override
            protected Void wrap(T ignore) throws Exception {
                return null;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private <T extends ProtocolMessage<T>> Future<Void> makeAsyncTxnCall(DatastorePb.DatastoreService_3.Method method, T response) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction();
        txn.setApp(this.app);
        txn.setHandle(this.getHandle());
        return this.makeAsyncCall(method, txn, response);
    }

    @Override
    public Future<Void> doCommitAsync() {
        return this.makeAsyncTxnCall(DatastorePb.DatastoreService_3.Method.Commit, new DatastorePb.CommitResponse());
    }

    @Override
    public Future<Void> doRollbackAsync() {
        return this.makeAsyncTxnCall(DatastorePb.DatastoreService_3.Method.Rollback, new ApiBasePb.VoidProto());
    }

    @Override
    public String getId() {
        return Long.toString(this.getHandle());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransactionV3 that = (InternalTransactionV3)o;
        return this.getHandle() == that.getHandle();
    }

    @Override
    public int hashCode() {
        return (int)(this.getHandle() ^ this.getHandle() >>> 32);
    }

    static DatastorePb.Transaction toProto(Transaction txn) {
        DatastorePb.Transaction txnProto = new DatastorePb.Transaction();
        txnProto.setApp(txn.getApp());
        txnProto.setHandle(Long.parseLong(txn.getId()));
        return txnProto;
    }

    static DatastorePb.Transaction toProto2(Transaction txn) {
        return DatastorePb.Transaction.newBuilder().setApp(txn.getApp()).setHandle(Long.parseLong(txn.getId())).build();
    }
}

