/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFailureException;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;
import java.util.Set;

final class UserServiceImpl
implements UserService {
    static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    static final String FEDERATED_IDENTITY_KEY = "com.google.appengine.api.users.UserService.federated_identity";
    static final String FEDERATED_AUTHORITY_KEY = "com.google.appengine.api.users.UserService.federated_authority";
    static final String IS_FEDERATED_USER_KEY = "com.google.appengine.api.users.UserService.is_federated_user";
    private static final String PACKAGE = "user";
    private static final String LOGIN_URL_METHOD = "CreateLoginURL";
    private static final String LOGOUT_URL_METHOD = "CreateLogoutURL";
    private static final String OPENID_DECOMMISSION_ERROR = "Open ID 2.0 support in the App Engine Users service is decommissioned. Please see https://cloud.google.com/appengine/docs/deprecations/open_id for details.";

    UserServiceImpl() {
    }

    @Override
    public String createLoginURL(String destinationURL) {
        return this.createLoginURL(destinationURL, null);
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain) {
        UserServicePb.CreateLoginURLResponse response;
        UserServicePb.CreateLoginURLRequest.Builder request = UserServicePb.CreateLoginURLRequest.newBuilder().setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        byte[] responseBytes = this.makeSyncCall(LOGIN_URL_METHOD, request.build(), destinationURL);
        try {
            response = UserServicePb.CreateLoginURLResponse.parseFrom(responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
        }
        catch (InvalidProtocolBufferException | UninitializedMessageException e) {
            throw new UserServiceFailureException("Could not parse CreateLoginURLResponse", e);
        }
        return response.getLoginUrl();
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain, String federatedIdentity, Set<String> attributesRequest) {
        if (federatedIdentity != null) {
            throw new IllegalArgumentException(OPENID_DECOMMISSION_ERROR);
        }
        return this.createLoginURL(destinationURL, authDomain);
    }

    @Override
    public String createLogoutURL(String destinationURL) {
        return this.createLogoutURL(destinationURL, null);
    }

    @Override
    public String createLogoutURL(String destinationURL, String authDomain) {
        UserServicePb.CreateLogoutURLResponse response;
        UserServicePb.CreateLogoutURLRequest.Builder request = UserServicePb.CreateLogoutURLRequest.newBuilder().setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        byte[] responseBytes = this.makeSyncCall(LOGOUT_URL_METHOD, request.build(), destinationURL);
        try {
            response = UserServicePb.CreateLogoutURLResponse.parseFrom(responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
        }
        catch (InvalidProtocolBufferException | UninitializedMessageException e) {
            throw new UserServiceFailureException("Could not parse CreateLogoutURLResponse", e);
        }
        return response.getLogoutUrl();
    }

    @Override
    public boolean isUserLoggedIn() {
        ApiProxy.Environment environment = UserServiceImpl.getCurrentEnvironmentOrThrow();
        return environment.isLoggedIn();
    }

    @Override
    public boolean isUserAdmin() {
        if (this.isUserLoggedIn()) {
            return UserServiceImpl.getCurrentEnvironmentOrThrow().isAdmin();
        }
        throw new IllegalStateException("The current user is not logged in.");
    }

    @Override
    public User getCurrentUser() {
        ApiProxy.Environment environment = UserServiceImpl.getCurrentEnvironmentOrThrow();
        if (!environment.isLoggedIn()) {
            return null;
        }
        String userId = (String)environment.getAttributes().get(USER_ID_KEY);
        Boolean isFederated = (Boolean)environment.getAttributes().get(IS_FEDERATED_USER_KEY);
        if (isFederated == null || !isFederated.booleanValue()) {
            return new User(environment.getEmail(), environment.getAuthDomain(), userId);
        }
        return new User(environment.getEmail(), (String)environment.getAttributes().get(FEDERATED_AUTHORITY_KEY), userId, (String)environment.getAttributes().get(FEDERATED_IDENTITY_KEY));
    }

    private byte[] makeSyncCall(String methodName, MessageLite request, String destinationURL) {
        byte[] responseBytes;
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.forNumber(ex.getApplicationError());
            switch (errorCode) {
                case REDIRECT_URL_TOO_LONG: {
                    String string = String.valueOf(destinationURL);
                    throw new IllegalArgumentException(string.length() != 0 ? "URL too long: ".concat(string) : new String("URL too long: "));
                }
                case NOT_ALLOWED: {
                    String string = String.valueOf(destinationURL);
                    throw new IllegalArgumentException(string.length() != 0 ? "The requested URL was not allowed: ".concat(string) : new String("The requested URL was not allowed: "));
                }
            }
            throw new UserServiceFailureException(ex.getErrorDetail());
        }
        return responseBytes;
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return environment;
    }
}

