/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ScoredDocument
extends Document
implements Serializable {
    private static final long serialVersionUID = 3062767930105951671L;
    private final List<Double> scores;
    private final List<Field> expressions;
    private final @Nullable Cursor cursor;

    private ScoredDocument(Builder builder) {
        super(builder);
        this.scores = Collections.unmodifiableList(builder.scores);
        this.expressions = Collections.unmodifiableList(builder.expressions);
        this.cursor = builder.cursor;
    }

    @Deprecated
    public List<Double> getSortScores() {
        return this.scores;
    }

    public List<Field> getExpressions() {
        return this.expressions;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(DocumentPb.Document document) {
        Builder docBuilder = ScoredDocument.newBuilder();
        docBuilder.setId(document.getId());
        if (document.hasLanguage()) {
            docBuilder.setLocale(FieldChecker.parseLocale(document.getLanguage()));
        }
        for (DocumentPb.Field field : document.getFieldList()) {
            docBuilder.addField(Field.newBuilder(field));
        }
        if (document.hasOrderId()) {
            docBuilder.setRank(document.getOrderId());
        }
        return docBuilder;
    }

    @Override
    public String toString() {
        return new Util.ToStringHelper("ScoredDocument").addField("documentId", this.getId()).addIterableField("fields", this.getFields(), 10).addField("locale", this.getLocale()).addField("rank", this.getRank()).addIterableField("scores", this.scores).addIterableField("expressions", this.expressions).addField("cursor", this.cursor).finish();
    }

    public static final class Builder
    extends Document.Builder {
        private final List<Double> scores = new ArrayList<Double>();
        private final List<Field> expressions = new ArrayList<Field>();
        private @Nullable Cursor cursor;

        private Builder() {
        }

        public Builder setCursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder addScore(double score) {
            this.scores.add(score);
            return this;
        }

        public Builder addExpression(Field expression) {
            Preconditions.checkNotNull(expression, "expression cannot be null");
            this.expressions.add(expression);
            return this;
        }

        @Override
        public ScoredDocument build() {
            return new ScoredDocument(this);
        }
    }
}

