/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.AbstractLogRecord;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;

public final class GoogleLoggerShutdownHandler {
    private static Handler shutdownLogHandler = null;

    public static void enterShutdownModeUsingHandler(Handler handler) {
        shutdownLogHandler = handler;
    }

    static void shutdownFallbackLog(AbstractLogRecord record) {
        if (shutdownLogHandler != null) {
            shutdownLogHandler.publish(record);
        } else {
            GoogleLoggerShutdownHandler.logToStderr(record);
        }
    }

    public static void flush() {
        if (shutdownLogHandler != null) {
            shutdownLogHandler.flush();
        }
    }

    private static void logToStderr(AbstractLogRecord record) {
        LogData data = record.getLogData();
        String levelName = data.getLevel().getName();
        System.err.printf("%1$ty%1$tm%1$td %1$tT.%1$tL:%2$s %3$s [%4$s] [%5$s.%6$s:%7$d] %8$s%n", TimeUnit.NANOSECONDS.toMillis(data.getTimestampNanos()), Character.valueOf(!levelName.isEmpty() ? levelName.charAt(0) : (char)'?'), Thread.currentThread().getId(), Thread.currentThread().getName(), data.getLogSite().getClassName(), data.getLogSite().getMethodName(), data.getLogSite().getLineNumber(), record.getFormattedMessage());
    }

    private GoogleLoggerShutdownHandler() {
    }
}

