/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.context;

import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.LogLevelMap;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopeMetadata;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.MustBeClosed;
import java.io.Closeable;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ScopedLoggingContext {
    @CheckReturnValue
    public static ScopedLoggingContext getInstance() {
        return ContextDataProvider.getInstance().getContextApiSingleton();
    }

    protected ScopedLoggingContext() {
    }

    @CheckReturnValue
    public abstract Builder newScope();

    @Deprecated
    @CheckReturnValue
    @MustBeClosed
    public final LoggingScope withNewScope() {
        return this.newScope().install();
    }

    @Deprecated
    @CheckReturnValue
    public final Runnable wrap(Runnable r) {
        return this.newScope().wrap(r);
    }

    @Deprecated
    @CheckReturnValue
    public final <R> Callable<R> wrap(Callable<R> c) {
        return this.newScope().wrap(c);
    }

    @Deprecated
    public final void run(Runnable r) {
        this.newScope().run(r);
    }

    @Deprecated
    public final <R> R call(Callable<R> c) throws Exception {
        return this.newScope().call(c);
    }

    public boolean addTags(Tags tags) {
        Checks.checkNotNull(tags, "tags");
        return false;
    }

    public <T> boolean addMetadata(MetadataKey<T> key, T value) {
        Checks.checkNotNull(key, "key");
        Checks.checkNotNull(value, "value");
        return false;
    }

    public boolean applyLogLevelMap(LogLevelMap logLevelMap) {
        Checks.checkNotNull(logLevelMap, "log level map");
        return false;
    }

    private static void closeAndMaybePropagateError(LoggingScope context, boolean callerHasError) {
        block2: {
            try {
                context.close();
            }
            catch (RuntimeException e) {
                if (callerHasError) break block2;
                throw e instanceof InvalidLoggingScopeStateException ? (InvalidLoggingScopeStateException)e : new InvalidLoggingScopeStateException("invalid logging context state", e);
            }
        }
    }

    public static final class InvalidLoggingScopeStateException
    extends IllegalStateException {
        public InvalidLoggingScopeStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidLoggingScopeStateException(String message) {
            super(message);
        }
    }

    public static abstract class Builder {
        private Tags tags = null;
        private ScopeMetadata.Builder metadata = null;
        private LogLevelMap logLevelMap = null;

        protected Builder() {
        }

        @CheckReturnValue
        public final Builder withTags(Tags tags) {
            Checks.checkState(this.tags == null, "tags already set");
            Checks.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        @CheckReturnValue
        public final <T> Builder withMetadata(MetadataKey<T> key, T value) {
            if (this.metadata == null) {
                this.metadata = ScopeMetadata.builder();
            }
            this.metadata.add(key, value);
            return this;
        }

        @CheckReturnValue
        public final Builder withLogLevelMap(LogLevelMap logLevelMap) {
            Checks.checkState(this.logLevelMap == null, "log level map already set");
            Checks.checkNotNull(logLevelMap, "log level map");
            this.logLevelMap = logLevelMap;
            return this;
        }

        @CheckReturnValue
        public final Runnable wrap(final Runnable r) {
            return new Runnable(){

                @Override
                public void run() {
                    LoggingScope context = Builder.this.install();
                    boolean hasError = true;
                    try {
                        r.run();
                        hasError = false;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(context, hasError);
                    }
                }
            };
        }

        @CheckReturnValue
        public final <R> Callable<R> wrap(final Callable<R> c) {
            return new Callable<R>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R call() throws Exception {
                    LoggingScope context = Builder.this.install();
                    boolean hasError = true;
                    try {
                        Object result = c.call();
                        hasError = false;
                        Object v = result;
                        return v;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(context, hasError);
                    }
                }
            };
        }

        public final void run(Runnable r) {
            this.wrap(r).run();
        }

        public final <R> R call(Callable<R> c) throws Exception {
            return this.wrap(c).call();
        }

        @CheckReturnValue
        @MustBeClosed
        public abstract LoggingScope install();

        @NullableDecl
        protected final Tags getTags() {
            return this.tags;
        }

        @NullableDecl
        protected final ScopeMetadata getMetadata() {
            return this.metadata != null ? this.metadata.build() : null;
        }

        @NullableDecl
        protected final LogLevelMap getLogLevelMap() {
            return this.logLevelMap;
        }
    }

    public static interface LoggingScope
    extends Closeable {
        @Override
        public void close();
    }
}

