/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTTPResponse
implements Serializable {
    static final long serialVersionUID = -4270789523885950851L;
    private final int responseCode;
    private final List<HTTPHeader> headers = new ArrayList<HTTPHeader>();
    private final HashMap<String, String> combinedHeadersMap = new LinkedHashMap<String, String>();
    private final byte @Nullable [] content;
    private final @Nullable URL finalUrl;

    public HTTPResponse(int responseCode, byte @Nullable [] content, @Nullable URL finalUrl, List<HTTPHeader> headers) {
        this.responseCode = responseCode;
        this.content = content;
        this.finalUrl = finalUrl;
        for (HTTPHeader header : headers) {
            this.headers.add(header);
            String combinedValue = this.combinedHeadersMap.get(header.getName());
            if (combinedValue == null) {
                this.combinedHeadersMap.put(header.getName(), header.getValue());
                continue;
            }
            String string = header.getValue();
            this.combinedHeadersMap.put(header.getName(), new StringBuilder(2 + String.valueOf(combinedValue).length() + String.valueOf(string).length()).append(combinedValue).append(", ").append(string).toString());
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public byte @Nullable [] getContent() {
        return this.content;
    }

    public @Nullable URL getFinalUrl() {
        return this.finalUrl;
    }

    public List<HTTPHeader> getHeadersUncombined() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<HTTPHeader> getHeaders() {
        ArrayList<HTTPHeader> combinedHeaders = new ArrayList<HTTPHeader>();
        for (Map.Entry<String, String> entry : this.combinedHeadersMap.entrySet()) {
            combinedHeaders.add(new HTTPHeader(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableList(combinedHeaders);
    }
}

