/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import com.google.appengine.repackaged.com.google.common.math.DoubleMath;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.devtools.staticanalysis.errorprone.inlineme.InlineMe;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;

@GwtIncompatible
public final class Instants {
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final int MICROS_PER_SECOND = 1000000;
    private static final Instant SATURATED_MAX_MILLIS = Instant.ofEpochMilli(Long.MAX_VALUE);
    private static final Instant SATURATED_MIN_MILLIS = Instant.ofEpochMilli(Long.MIN_VALUE);
    private static final Instant SATURATED_MAX_MICROS = Instants.ofEpochMicros(Long.MAX_VALUE);
    private static final Instant SATURATED_MIN_MICROS = Instants.ofEpochMicros(Long.MIN_VALUE);
    private static final Instant SATURATED_MAX_NANOS = Instants.ofEpochNanos(Long.MAX_VALUE);
    private static final Instant SATURATED_MIN_NANOS = Instants.ofEpochNanos(Long.MIN_VALUE);
    private static final long MIN_SECOND = Instant.MIN.getEpochSecond();
    private static final long MAX_SECOND = Instant.MAX.getEpochSecond();

    private Instants() {
    }

    public static double toEpochSeconds(Instant instant) {
        return (double)instant.getEpochSecond() + (double)instant.getNano() / 1.0E9;
    }

    public static Instant ofEpochSeconds(double seconds) {
        long wholeSeconds = DoubleMath.roundToLong(seconds, RoundingMode.FLOOR);
        long nanos = DoubleMath.roundToLong((seconds - (double)wholeSeconds) * 1.0E9, RoundingMode.FLOOR);
        return Instant.ofEpochSecond(wholeSeconds, nanos);
    }

    @Deprecated
    @InlineMe(replacement="Instant.ofEpochSecond(seconds)", imports={"java.time.Instant"})
    public static Instant ofEpochSeconds(long seconds) {
        return Instant.ofEpochSecond(seconds);
    }

    public static long toEpochMicros(Instant instant) {
        if (instant.getEpochSecond() < -9223372036854L) {
            return LongMath.checkedAdd(LongMath.checkedMultiply(instant.getEpochSecond() + 1L, 1000000L), instant.getNano() / 1000 - 1000000);
        }
        long micros = LongMath.checkedMultiply(instant.getEpochSecond(), 1000000L);
        return LongMath.checkedAdd(micros, instant.getNano() / 1000);
    }

    public static Instant ofEpochMicros(long micros) {
        long seconds = LongMath.divide(micros, 1000000L, RoundingMode.FLOOR);
        int microsOfSecond = LongMath.mod(micros, 1000000);
        return Instant.ofEpochSecond(seconds, microsOfSecond * 1000);
    }

    public static long toEpochNanos(Instant instant) {
        if (instant.getEpochSecond() < -9223372036L) {
            return LongMath.checkedAdd(LongMath.checkedMultiply(instant.getEpochSecond() + 1L, 1000000000L), instant.getNano() - 1000000000);
        }
        long nanos = LongMath.checkedMultiply(instant.getEpochSecond(), 1000000000L);
        return LongMath.checkedAdd(nanos, instant.getNano());
    }

    public static Instant ofEpochNanos(long nanos) {
        long seconds = LongMath.divide(nanos, 1000000000L, RoundingMode.FLOOR);
        int nanosOfSecond = LongMath.mod(nanos, 1000000000);
        return Instant.ofEpochSecond(seconds, nanosOfSecond);
    }

    public static long toEpochMillisSaturated(Instant instant) {
        if (instant.isAfter(SATURATED_MAX_MILLIS)) {
            return Long.MAX_VALUE;
        }
        if (instant.isBefore(SATURATED_MIN_MILLIS)) {
            return Long.MIN_VALUE;
        }
        return instant.toEpochMilli();
    }

    public static long toEpochMicrosSaturated(Instant instant) {
        if (instant.isAfter(SATURATED_MAX_MICROS)) {
            return Long.MAX_VALUE;
        }
        if (instant.isBefore(SATURATED_MIN_MICROS)) {
            return Long.MIN_VALUE;
        }
        return Instants.toEpochMicros(instant);
    }

    public static long toEpochNanosSaturated(Instant instant) {
        if (instant.isAfter(SATURATED_MAX_NANOS)) {
            return Long.MAX_VALUE;
        }
        if (instant.isBefore(SATURATED_MIN_NANOS)) {
            return Long.MIN_VALUE;
        }
        return Instants.toEpochNanos(instant);
    }

    public static Instant saturatedAdd(Instant instant, Duration duration) {
        long seconds = LongMath.saturatedAdd(instant.getEpochSecond(), duration.getSeconds());
        int nanos = instant.getNano() + duration.getNano();
        if (nanos >= 1000000000) {
            nanos -= 1000000000;
            seconds = LongMath.saturatedAdd(seconds, 1L);
        }
        return Instants.safeCreate(seconds, nanos);
    }

    public static Instant saturatedSubtract(Instant instant, Duration duration) {
        long seconds = LongMath.saturatedSubtract(instant.getEpochSecond(), duration.getSeconds());
        int nanos = instant.getNano() - duration.getNano();
        if (nanos < 0) {
            nanos += 1000000000;
            seconds = LongMath.saturatedSubtract(seconds, 1L);
        }
        return Instants.safeCreate(seconds, nanos);
    }

    private static Instant safeCreate(long seconds, int nanos) {
        if (seconds > MAX_SECOND) {
            return Instant.MAX;
        }
        if (seconds < MIN_SECOND) {
            return Instant.MIN;
        }
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public static DiscreteDomain<Instant> domain() {
        return InstantDomain.INSTANCE;
    }

    private static final class InstantDomain
    extends DiscreteDomain<Instant> {
        private static final InstantDomain INSTANCE = new InstantDomain();

        private InstantDomain() {
        }

        @Override
        public Instant minValue() {
            return Instant.MIN;
        }

        @Override
        public Instant maxValue() {
            return Instant.MAX;
        }

        @Override
        public Instant next(Instant value) {
            return value.equals(this.maxValue()) ? null : value.plusNanos(1L);
        }

        @Override
        public Instant previous(Instant value) {
            return value.equals(this.minValue()) ? null : value.minusNanos(1L);
        }

        @Override
        public long distance(Instant start, Instant end) {
            long seconds = LongMath.saturatedSubtract(end.getEpochSecond(), start.getEpochSecond());
            long nanos = LongMath.saturatedMultiply(seconds, 1000000000L);
            return LongMath.saturatedAdd(nanos, end.getNano() - start.getNano());
        }

        public String toString() {
            return "Instants.domain()";
        }
    }
}

