/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import java.time.LocalDate;

@GwtIncompatible
public final class LocalDates {
    private LocalDates() {
    }

    public static DiscreteDomain<LocalDate> domain() {
        return LocalDateDomain.INSTANCE;
    }

    private static final class LocalDateDomain
    extends DiscreteDomain<LocalDate> {
        private static final LocalDateDomain INSTANCE = new LocalDateDomain();

        private LocalDateDomain() {
        }

        @Override
        public LocalDate minValue() {
            return LocalDate.MIN;
        }

        @Override
        public LocalDate maxValue() {
            return LocalDate.MAX;
        }

        @Override
        public LocalDate next(LocalDate value) {
            return value.equals(this.maxValue()) ? null : value.plusDays(1L);
        }

        @Override
        public LocalDate previous(LocalDate value) {
            return value.equals(this.minValue()) ? null : value.minusDays(1L);
        }

        @Override
        public long distance(LocalDate start, LocalDate end) {
            return end.toEpochDay() - start.toEpochDay();
        }

        public String toString() {
            return "LocalDates.domain()";
        }
    }
}

