/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class User
implements Serializable,
Comparable<User> {
    static final long serialVersionUID = 8691571286358652288L;
    private String email;
    private String authDomain;
    private @Nullable String userId;
    private String federatedIdentity;

    private User() {
    }

    public User(String email, String authDomain) {
        this(email, authDomain, null);
    }

    public User(String email, String authDomain, @Nullable String userId) {
        if (email == null) {
            throw new NullPointerException("email must be specified");
        }
        if (authDomain == null) {
            throw new NullPointerException("authDomain must be specified");
        }
        this.email = email;
        this.authDomain = authDomain;
        this.userId = userId;
    }

    public User(String email, @Nullable String authDomain, @Nullable String userId, String federatedIdentity) {
        if (federatedIdentity == null) {
            throw new NullPointerException("Identity must be specified");
        }
        this.authDomain = authDomain == null ? "" : authDomain;
        this.userId = userId == null ? "" : userId;
        this.email = email;
        this.federatedIdentity = federatedIdentity;
    }

    public String getNickname() {
        String string = String.valueOf(this.authDomain);
        int indexOfDomain = this.email.indexOf(string.length() != 0 ? "@".concat(string) : new String("@"));
        if (indexOfDomain == -1) {
            return this.email;
        }
        return this.email.substring(0, indexOfDomain);
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public String getEmail() {
        return this.email;
    }

    public @Nullable String getUserId() {
        return this.userId;
    }

    public String getFederatedIdentity() {
        return this.federatedIdentity;
    }

    public String toString() {
        return this.email;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        if (this.federatedIdentity != null && !this.federatedIdentity.isEmpty()) {
            return user.federatedIdentity.equals(this.federatedIdentity);
        }
        return user.email.equals(this.email) && user.authDomain.equals(this.authDomain);
    }

    public int hashCode() {
        return 17 * this.email.hashCode() + this.authDomain.hashCode();
    }

    @Override
    public int compareTo(User user) {
        return this.email.compareTo(user.email);
    }
}

