/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreCallbacksImpl;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DatastoreServiceConfig {
    public static final String DATASTORE_EMPTY_LIST_SUPPORT = "DATASTORE_EMPTY_LIST_SUPPORT";
    static final int DEFAULT_RPC_SIZE_LIMIT_BYTES = 0x100000;
    static final int DEFAULT_MAX_BATCH_GET_KEYS = 1000;
    static final int DEFAULT_MAX_BATCH_WRITE_ENTITIES = 500;
    static final String DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP = "appengine.datastore.defaultMaxEntityGroupsPerRpc";
    static final int DEFAULT_MAX_ENTITY_GROUPS_PER_RPC = DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc();
    static final String CALLBACKS_CONFIG_SYS_PROP = "appengine.datastore.callbacksConfig";
    static volatile @Nullable DatastoreCallbacks CALLBACKS = null;
    private static final String CALLBACKS_CONFIG_FILE = "/META-INF/datastorecallbacks.xml";
    private final @Nullable DatastoreCallbacks instanceDatastoreCallbacks;
    private ImplicitTransactionManagementPolicy implicitTransactionManagementPolicy = ImplicitTransactionManagementPolicy.NONE;
    private ReadPolicy readPolicy = new ReadPolicy(ReadPolicy.Consistency.STRONG);
    private Double deadline;
    private AppIdNamespace appIdNamespace;
    int maxRpcSizeBytes = 0x100000;
    int maxBatchWriteEntities = 500;
    int maxBatchReadEntities = 1000;
    int maxBatchAllocateIdKeys = 500;
    int maxEntityGroupsPerRpc = DEFAULT_MAX_ENTITY_GROUPS_PER_RPC;

    public static boolean getEmptyListSupport() {
        String value = System.getProperty(DATASTORE_EMPTY_LIST_SUPPORT);
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    static int getDefaultMaxEntityGroupsPerRpc() {
        return DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc(DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP, 10);
    }

    static int getDefaultMaxEntityGroupsPerRpc(String sysPropName, int defaultVal) {
        String sysPropVal = System.getProperty(sysPropName);
        return sysPropVal == null ? defaultVal : Integer.parseInt(sysPropVal);
    }

    private static InputStream getCallbacksConfigInputStream() {
        String callbacksConfig = System.getProperty(CALLBACKS_CONFIG_SYS_PROP);
        InputStream is = callbacksConfig != null ? new ByteArrayInputStream(callbacksConfig.getBytes()) : DatastoreServiceConfig.class.getResourceAsStream(CALLBACKS_CONFIG_FILE);
        return is;
    }

    private DatastoreServiceConfig(@Nullable DatastoreCallbacks datastoreCallbacks) {
        this.instanceDatastoreCallbacks = datastoreCallbacks;
    }

    DatastoreServiceConfig(DatastoreServiceConfig config) {
        this.implicitTransactionManagementPolicy = config.implicitTransactionManagementPolicy;
        this.readPolicy = config.readPolicy;
        this.deadline = config.deadline;
        this.maxRpcSizeBytes = config.maxRpcSizeBytes;
        this.maxBatchWriteEntities = config.maxBatchWriteEntities;
        this.maxBatchReadEntities = config.maxBatchReadEntities;
        this.maxEntityGroupsPerRpc = config.maxEntityGroupsPerRpc;
        this.instanceDatastoreCallbacks = config.instanceDatastoreCallbacks;
        this.appIdNamespace = config.appIdNamespace;
    }

    public DatastoreServiceConfig implicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
        if (p == null) {
            throw new NullPointerException("implicit transaction management policy must not be null");
        }
        this.implicitTransactionManagementPolicy = p;
        return this;
    }

    public DatastoreServiceConfig readPolicy(ReadPolicy readPolicy) {
        if (readPolicy == null) {
            throw new NullPointerException("read policy must not be null");
        }
        this.readPolicy = readPolicy;
        return this;
    }

    public DatastoreServiceConfig deadline(double deadline) {
        if (deadline <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(50).append("deadline must be > 0, got ").append(deadline).toString());
        }
        this.deadline = deadline;
        return this;
    }

    DatastoreServiceConfig appIdNamespace(AppIdNamespace appIdNamespace) {
        this.appIdNamespace = appIdNamespace;
        return this;
    }

    DatastoreServiceConfig maxBatchWriteEntities(int maxBatchWriteEntities) {
        if (maxBatchWriteEntities <= 0) {
            throw new IllegalArgumentException(new StringBuilder(50).append("maxBatchWriteEntities must be > 0, got ").append(maxBatchWriteEntities).toString());
        }
        this.maxBatchWriteEntities = maxBatchWriteEntities;
        return this;
    }

    DatastoreServiceConfig maxBatchReadEntities(int maxBatchReadEntities) {
        if (maxBatchReadEntities <= 0) {
            throw new IllegalArgumentException(new StringBuilder(49).append("maxBatchReadEntities must be > 0, got ").append(maxBatchReadEntities).toString());
        }
        this.maxBatchReadEntities = maxBatchReadEntities;
        return this;
    }

    DatastoreServiceConfig maxRpcSizeBytes(int maxRpcSizeBytes) {
        if (maxRpcSizeBytes < 0) {
            throw new IllegalArgumentException(new StringBuilder(45).append("maxRpcSizeBytes must be >= 0, got ").append(maxRpcSizeBytes).toString());
        }
        this.maxRpcSizeBytes = maxRpcSizeBytes;
        return this;
    }

    public DatastoreServiceConfig maxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
        if (maxEntityGroupsPerRpc <= 0) {
            throw new IllegalArgumentException(new StringBuilder(50).append("maxEntityGroupsPerRpc must be > 0, got ").append(maxEntityGroupsPerRpc).toString());
        }
        this.maxEntityGroupsPerRpc = maxEntityGroupsPerRpc;
        return this;
    }

    public ImplicitTransactionManagementPolicy getImplicitTransactionManagementPolicy() {
        return this.implicitTransactionManagementPolicy;
    }

    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    public Integer getMaxEntityGroupsPerRpc() {
        return this.getMaxEntityGroupsPerRpcInternal();
    }

    int getMaxEntityGroupsPerRpcInternal() {
        return this.maxEntityGroupsPerRpc;
    }

    public Double getDeadline() {
        return this.deadline;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace == null ? DatastoreApiHelper.getCurrentAppIdNamespace() : this.appIdNamespace;
    }

    DatastoreCallbacks getDatastoreCallbacks() {
        if (this.instanceDatastoreCallbacks != null) {
            return this.instanceDatastoreCallbacks;
        }
        if (CALLBACKS == null) {
            InputStream is = DatastoreServiceConfig.getCallbacksConfigInputStream();
            CALLBACKS = is == null ? DatastoreCallbacks.NoOpDatastoreCallbacks.INSTANCE : new DatastoreCallbacksImpl(is, false);
        }
        return CALLBACKS;
    }

    ApiProxy.ApiConfig constructApiConfig() {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(this.deadline);
        return apiConfig;
    }

    public static final class Builder {
        public static DatastoreServiceConfig withImplicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
            return Builder.withDefaults().implicitTransactionManagementPolicy(p);
        }

        public static DatastoreServiceConfig withReadPolicy(ReadPolicy readPolicy) {
            return Builder.withDefaults().readPolicy(readPolicy);
        }

        public static DatastoreServiceConfig withDeadline(double deadline) {
            return Builder.withDefaults().deadline(deadline);
        }

        public static DatastoreServiceConfig withMaxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
            return Builder.withDefaults().maxEntityGroupsPerRpc(maxEntityGroupsPerRpc);
        }

        static DatastoreServiceConfig withDatastoreCallbacks(DatastoreCallbacks datastoreCallbacks) {
            Preconditions.checkNotNull(datastoreCallbacks);
            return new DatastoreServiceConfig(datastoreCallbacks);
        }

        public static DatastoreServiceConfig withDefaults() {
            return new DatastoreServiceConfig(null);
        }

        private Builder() {
        }
    }
}

