/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jspecify.nullness.Nullable;

class FlagDescription
implements Comparable<FlagDescription> {
    private final String shortFlagName;
    private final String containerClassName;
    private final @Nullable String simpleFieldName;
    private final String type;
    private final String doc;
    private final DocLevel docLevel;
    private final @Nullable String altName;
    private final String longFlagName;
    private final boolean isDeprecated;

    private FlagDescription(@Nullable String shortFlagName, String containerClassName, @Nullable String simpleFieldName, String type, String doc, DocLevel docLevel, @Nullable String altName, boolean isDeprecated) {
        this.shortFlagName = FlagDescription.computeShortFlagName(shortFlagName, simpleFieldName);
        this.containerClassName = containerClassName;
        this.simpleFieldName = simpleFieldName;
        this.type = type;
        this.doc = doc;
        this.docLevel = docLevel;
        this.altName = FlagDescription.emptyStringToNull(altName);
        this.isDeprecated = isDeprecated;
        FlagDescription.checkNotReserved(this.getShortFlagName());
        FlagDescription.checkNotReserved(this.getAltName());
        String string = this.getShortFlagName();
        this.longFlagName = new StringBuilder(1 + String.valueOf(containerClassName).length() + String.valueOf(string).length()).append(containerClassName).append(".").append(string).toString();
    }

    private static void checkNotReserved(@Nullable String s) {
        if (s != null && (s.equals("help") || s.equals("helpxml") || s.equals("flagfile") || s.equals("flagresource"))) {
            throw new IllegalArgumentException(new StringBuilder(47 + String.valueOf(s).length()).append("The ").append(s).append(" flag is built-in and may not be registered").toString());
        }
    }

    static Builder createFlagFromField(String fullyQualifiedFieldName) {
        int lastDotIndex = FlagDescription.findLastDotIndex(fullyQualifiedFieldName);
        return new Builder(fullyQualifiedFieldName.substring(0, lastDotIndex), fullyQualifiedFieldName.substring(lastDotIndex + 1));
    }

    static Builder createManuallyRegisteredFlag(String shortFlagName, String containerClassName) {
        return new Builder(containerClassName, null).shortFlagName(shortFlagName);
    }

    String getLongFlagName() {
        return this.longFlagName;
    }

    String getFullyQualifiedFieldName() {
        String string = this.getContainerClassName();
        String string2 = this.getSimpleFieldName();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
    }

    String getSimpleFieldName() {
        String simpleFieldName = this.simpleFieldName;
        if (simpleFieldName == null) {
            String string = this.getLongFlagName();
            throw new UnsupportedOperationException(new StringBuilder(36 + String.valueOf(string).length()).append("Flag ").append(string).append(" is not associated with a field").toString());
        }
        return simpleFieldName;
    }

    boolean isField() {
        return this.simpleFieldName != null;
    }

    String getShortFlagName() {
        return this.shortFlagName;
    }

    String getContainerClassName() {
        return this.containerClassName;
    }

    String getType() {
        return this.type;
    }

    String getDoc() {
        return this.doc;
    }

    DocLevel getDocLevel() {
        return this.docLevel;
    }

    @Nullable String getAltName() {
        return this.altName;
    }

    @Nullable String getLongAltName() {
        String string;
        if (this.altName != null) {
            String string2 = this.containerClassName;
            String string3 = this.altName;
            string = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(".").append(string3).toString();
        } else {
            string = null;
        }
        return string;
    }

    boolean isDeprecated() {
        return this.isDeprecated;
    }

    boolean isPositiveFormOfName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.getShortFlagName()) || name.equals(this.getAltName()) || name.equals(this.getLongFlagName()) || name.equals(this.getLongAltName());
    }

    public String toString() {
        return this.getLongFlagName();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FlagDescription)) {
            return false;
        }
        FlagDescription o = (FlagDescription)other;
        return o.shortFlagName.equals(this.shortFlagName) && o.containerClassName.equals(this.containerClassName) && FlagDescription.nullSafeEquals(o.simpleFieldName, this.simpleFieldName) && o.type.equals(this.type) && o.doc.equals(this.doc) && o.docLevel.equals((Object)this.docLevel) && FlagDescription.nullSafeEquals(o.altName, this.altName);
    }

    public int hashCode() {
        return this.getLongFlagName().hashCode();
    }

    @Override
    public int compareTo(FlagDescription o) {
        return this.getLongFlagName().compareTo(o.getLongFlagName());
    }

    private static String stripFlagPrefix(String flagName) {
        return flagName.startsWith("FLAG_") ? flagName.substring(5) : flagName;
    }

    private static String computeShortFlagName(@Nullable String shortFlagName, @Nullable String simpleFieldName) {
        if (shortFlagName != null && !shortFlagName.isEmpty()) {
            return shortFlagName;
        }
        if (simpleFieldName != null && !(simpleFieldName = FlagDescription.stripFlagPrefix(simpleFieldName)).isEmpty()) {
            return simpleFieldName;
        }
        throw new NullPointerException();
    }

    private static int findLastDotIndex(String name) {
        int idx = name.lastIndexOf(".");
        if (idx <= 0) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "Package name required in name: ".concat(string) : new String("Package name required in name: "));
        }
        return idx;
    }

    private static boolean nullSafeEquals(@Nullable Object left, @Nullable Object right) {
        return left == null ? left == right : left.equals(right);
    }

    private static @Nullable String emptyStringToNull(@Nullable String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    @CanIgnoreReturnValue
    static <T> T checkNotNull(@Nullable T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    static <T> void checkNotNull(T ... os) {
        for (T o : os) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    @CanIgnoreReturnValue
    static <T> T checkNotNull(@Nullable T o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
        return o;
    }

    @CanIgnoreReturnValue
    static <T> T checkStateNotNull(@Nullable T o) {
        if (o == null) {
            throw new IllegalStateException();
        }
        return o;
    }

    static class Builder {
        private final String containerClassName;
        private final @Nullable String simpleFieldName;
        private @Nullable String shortFlagName;
        private @Nullable String type;
        private @Nullable String doc;
        private @Nullable DocLevel docLevel;
        private @Nullable String altName;
        private boolean isDeprecated;

        private Builder(String containerClassName, @Nullable String simpleFieldName) {
            this.containerClassName = containerClassName;
            this.simpleFieldName = simpleFieldName;
        }

        Builder shortFlagName(@Nullable String shortFlagName) {
            this.shortFlagName = shortFlagName;
            return this;
        }

        Builder type(String type) {
            this.type = FlagDescription.checkNotNull(type);
            return this;
        }

        Builder doc(String doc) {
            this.doc = FlagDescription.checkNotNull(doc);
            return this;
        }

        Builder altName(@Nullable String altName) {
            this.altName = altName;
            return this;
        }

        Builder docLevel(DocLevel docLevel) {
            this.docLevel = FlagDescription.checkNotNull(docLevel);
            return this;
        }

        Builder isDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        FlagDescription build() {
            return new FlagDescription(this.shortFlagName, this.containerClassName, this.simpleFieldName, FlagDescription.checkStateNotNull(this.type), FlagDescription.checkStateNotNull(this.doc), FlagDescription.checkStateNotNull(this.docLevel), this.altName, this.isDeprecated);
        }
    }
}

