/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.SortedLists;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jspecify.nullness.NullMarked;

@NullMarked
@ElementTypesAreNonnullByDefault
@GoogleInternal
@GwtIncompatible
final class SecondGranularityHorizonRateLimiter
extends RateLimiter {
    private int permitsWithinHorizon;
    private final int horizonSec;
    private final List<Integer> permitGrantsSec = new ArrayList<Integer>();
    private Integer latestPermitGrantSec;

    SecondGranularityHorizonRateLimiter(RateLimiter.SleepingStopwatch stopwatch, int permitsWithinHorizon, int horizonSec) {
        super(stopwatch);
        this.doSetPermitsWithinHorizon(permitsWithinHorizon);
        Preconditions.checkArgument(horizonSec > 0, "horizonSec (%s) must be positive", horizonSec);
        this.horizonSec = horizonSec;
    }

    @Override
    void doSetRate(double permitsPerSecond, long nowMicros) {
        this.permitsWithinHorizon = SecondGranularityHorizonRateLimiter.roundedPermitsPerTime(permitsPerSecond, this.horizonSec);
    }

    @Override
    double doGetRate() {
        return (double)this.permitsWithinHorizon / (double)this.horizonSec;
    }

    @Override
    long queryEarliestAvailable(long nowMicros) {
        int nowSec = SecondGranularityHorizonRateLimiter.microsToSec(nowMicros);
        int nextAvailableTimeSec = this.nextAvailableTimeSec(nowSec);
        return TimeUnit.SECONDS.toMicros(nextAvailableTimeSec);
    }

    @Override
    long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        int nowSec = SecondGranularityHorizonRateLimiter.microsToSec(nowMicros);
        int nextAvailableTimeSec = this.nextAvailableTimeSec(nowSec);
        this.recordGrants(requiredPermits, nextAvailableTimeSec);
        return TimeUnit.SECONDS.toMicros(nextAvailableTimeSec);
    }

    private int nextAvailableTimeSec(int nowSec) {
        this.pruneEvents(nowSec);
        return this.permitGrantsSec.size() < this.permitsWithinHorizon ? nowSec : this.permitGrantsSec.get(this.permitGrantsSec.size() - this.permitsWithinHorizon) + this.horizonSec;
    }

    private void pruneEvents(int nowSec) {
        int lastTimeOutsideWindow = nowSec - this.horizonSec;
        int index = SortedLists.binarySearch(this.permitGrantsSec, lastTimeOutsideWindow, SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        this.permitGrantsSec.subList(0, index).clear();
    }

    @Override
    int doLatestPermitAgeSec(long nowMicros) {
        Preconditions.checkState(this.latestPermitGrantSec != null, "No permits have been granted yet");
        int nowSec = SecondGranularityHorizonRateLimiter.microsToSec(nowMicros);
        return nowSec - this.latestPermitGrantSec;
    }

    @Override
    void doForceAcquire(long nowMicros) {
        int nowSec = SecondGranularityHorizonRateLimiter.microsToSec(nowMicros);
        this.recordGrants(1, nowSec);
    }

    private void recordGrants(int permitCount, int grantSec) {
        for (int i = 0; i < permitCount; ++i) {
            this.permitGrantsSec.add(grantSec);
        }
        this.latestPermitGrantSec = grantSec;
    }

    @Override
    void doSetPermitsWithinHorizon(int permitsWithinHorizon) {
        Preconditions.checkArgument(permitsWithinHorizon > 0, "permitsWithinHorizon (%s) must be positive", permitsWithinHorizon);
        this.permitsWithinHorizon = permitsWithinHorizon;
    }
}

