/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.appengine.repackaged.com.google.common.xml.XmlNamespace;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.checkerframework.checker.nullness.qual.Nullable;

@GoogleInternal
@GwtIncompatible
public class XmlWriter {
    public static final CharMatcher LEGAL_XML_1_0 = CharMatcher.inRange(' ', '\ud7ff').or(CharMatcher.anyOf("\t\n\r")).or(CharMatcher.inRange('\ue000', '\ufffd'));
    protected final Set<WriterFlags> flags;
    private static final String DEFAULT_INDENTATION_UNIT = "\t";
    protected final Writer writer;
    private final Stack<Element> elementStack;
    private String defaultNamespace;
    protected @Nullable String encoding;
    private String nextDefaultNamespace;
    private Boolean standalone;
    private String indentationUnit = "\t";
    private static final CharMatcher CONTROL_MATCHER = CharMatcher.anyOf("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff");

    public XmlWriter(Writer w, Set<WriterFlags> f, String encoding, boolean standalone) throws IOException {
        this(w, f, encoding);
        this.standalone = standalone;
    }

    public XmlWriter(Writer w, @Nullable Set<WriterFlags> f, @Nullable String encoding) throws IOException {
        this.writer = w;
        this.flags = f != null ? f : EnumSet.noneOf(WriterFlags.class);
        this.encoding = encoding;
        this.elementStack = new Stack();
        Element rootElement = this.createElement(null, null, null);
        rootElement.openTagEnded = true;
        this.elementStack.push(rootElement);
    }

    public XmlWriter(Writer w) throws IOException {
        this(w, null, null);
    }

    public XmlWriter(Writer w, String encoding) throws IOException {
        this(w, EnumSet.of(WriterFlags.WRITE_HEADER), encoding);
    }

    @Deprecated
    public XmlWriter(Writer w, boolean includeHeader) throws IOException {
        this(w, EnumSet.of(WriterFlags.WRITE_HEADER), null);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void setDefaultNamespace(XmlNamespace namespace) {
        if (!namespace.uri.equals(this.defaultNamespace)) {
            this.nextDefaultNamespace = namespace.uri;
        }
    }

    protected Element createElement(String nsAlias, String nsUri, String name) {
        return new Element(nsAlias, nsUri, name);
    }

    protected Element currentElement() {
        try {
            return this.elementStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    protected Element parentElement() {
        return (Element)this.elementStack.get(this.elementStack.size() - 1 - 1);
    }

    public void startElement(String name) throws IOException {
        this.startElement(null, name, null, null);
    }

    public void startElement(XmlNamespace namespace, String name, Collection<Attribute> attrs, Collection<? extends XmlNamespace> namespaceDecls) throws IOException {
        if (this.elementStack.size() == 1) {
            this.writeBeginOutput();
            if (this.shouldWriteHeaderAndFooter()) {
                this.writeHeader(this.encoding);
            }
        }
        this.endOpenTag();
        Element element = namespace != null ? this.createElement(namespace.alias, namespace.uri, name) : this.createElement(null, null, name);
        Element parentElement = this.currentElement();
        if (parentElement != null) {
            element.xmlLang = parentElement.xmlLang;
            element.unformattedChildren = parentElement.unformattedChildren;
            if (parentElement.repeatingCount != -1) {
                element.repeatingIndex = parentElement.repeatingCount++;
            }
        }
        this.elementStack.push(element);
        element.enclosingDefaultNamespace = this.defaultNamespace;
        if (this.nextDefaultNamespace != null) {
            XmlNamespace defaultNs = new XmlNamespace(this.nextDefaultNamespace);
            this.defaultNamespace = this.nextDefaultNamespace;
            element.addNamespace(defaultNs);
            this.nextDefaultNamespace = null;
        }
        if (namespaceDecls != null) {
            for (XmlNamespace xmlNamespace : namespaceDecls) {
                this.ensureNamespace(xmlNamespace);
            }
        }
        if (namespace != null) {
            element.nsAlias = this.ensureNamespace(namespace);
        }
        this.writeOpenTagStart(element.nsAlias, name);
        for (XmlNamespace xmlNamespace : element.nsDecls) {
            if (xmlNamespace.alias != null && xmlNamespace.alias.length() > 0) {
                this.writeAttribute("xmlns", xmlNamespace.alias, xmlNamespace.uri);
                continue;
            }
            this.writeAttribute(null, "xmlns", xmlNamespace.uri);
        }
        if (attrs != null) {
            for (Attribute attribute : attrs) {
                if (attribute.name.equals("lang") && "xml".equals(attribute.nsAlias)) {
                    if (attribute.value.equals(element.xmlLang)) continue;
                    element.xmlLang = attribute.value;
                }
                this.writeAttribute(attribute.nsAlias, attribute.name, attribute.value);
            }
        }
        if (this.flags.contains((Object)WriterFlags.EXPAND_EMPTY)) {
            this.endOpenTag();
        }
    }

    private boolean shouldWriteHeaderAndFooter() {
        return this.flags.contains((Object)WriterFlags.WRITE_HEADER) || this.encoding != null || this.standalone != null;
    }

    protected void endOpenTag() throws IOException {
        Element element = this.currentElement();
        if (!element.openTagEnded) {
            this.writeOpenTagEnd();
            element.openTagEnded = true;
        }
    }

    public void endElement(XmlNamespace namespace, String name) throws IOException {
        this.endElement();
    }

    public void endElement() throws IOException {
        Element element = this.currentElement();
        this.writeCloseTag(element.nsAlias, element.name);
        this.defaultNamespace = element.enclosingDefaultNamespace;
        this.elementStack.pop();
        if (this.elementStack.size() == 1) {
            if (this.shouldWriteHeaderAndFooter()) {
                this.writeFooter();
            }
            this.writeEndOutput();
        }
    }

    public void simpleElement(String name, String value) throws IOException {
        this.simpleElement(null, name, null, value);
    }

    public void simpleElement(XmlNamespace namespace, String name, List<Attribute> attrs, String value) throws IOException {
        this.startElement(namespace, name, attrs, null);
        this.characters(value);
        this.endElement(namespace, name);
    }

    public void startRepeatingElement() throws IOException {
        Element currentElement = this.currentElement();
        if (currentElement.repeatingCount != -1) {
            throw new IllegalStateException("Existing repeating element is active");
        }
        currentElement.repeatingCount = 0;
    }

    public void endRepeatingElement() throws IOException {
        this.currentElement().repeatingCount = -1;
    }

    private String checkNamespace(String namespaceUri) {
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.elementStack.get(i);
            for (XmlNamespace ns : element.nsDecls) {
                if (ns.alias == null || !ns.uri.equals(namespaceUri)) continue;
                return ns.alias;
            }
        }
        return null;
    }

    private boolean isPrettyPrintingEnabled() {
        return this.flags.contains((Object)WriterFlags.PRETTY_PRINT) && !this.currentElement().unformattedChildren;
    }

    private int getIndentationLevel() {
        return this.elementStack.size() - 2;
    }

    private void writeNewline() throws IOException {
        this.writer.write("\n");
    }

    private void writeIndentation() throws IOException {
        this.writeUnitsOfIndentation(this.getIndentationLevel());
    }

    private void writeUnitsOfIndentation(int i) throws IOException {
        while (i > 0) {
            this.writer.write(this.indentationUnit);
            --i;
        }
    }

    @CanIgnoreReturnValue
    protected String ensureNamespace(XmlNamespace namespace) {
        if (namespace.uri.equals(this.defaultNamespace)) {
            return null;
        }
        String alias = this.checkNamespace(namespace.uri);
        if (alias == null) {
            Element current = this.currentElement();
            namespace = this.ensureUniqueNamespaceAlias(current, namespace);
            current.addNamespace(namespace);
            alias = namespace.alias;
        }
        return alias;
    }

    private XmlNamespace ensureUniqueNamespaceAlias(Element element, XmlNamespace namespace) {
        boolean unique;
        int serial = 0;
        block0: do {
            unique = true;
            for (XmlNamespace ns : element.nsDecls) {
                if (!namespace.alias.equals(ns.alias)) continue;
                unique = false;
                String string = String.valueOf(String.valueOf(++serial));
                namespace = new XmlNamespace(string.length() != 0 ? "ns".concat(string) : new String("ns"), namespace.uri);
                continue block0;
            }
        } while (!unique);
        return namespace;
    }

    protected String getNamespaceUri(String nsAlias) {
        if (nsAlias == null) {
            return this.defaultNamespace;
        }
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.elementStack.get(i);
            for (XmlNamespace ns : element.nsDecls) {
                if (!ns.getAlias().equals(nsAlias)) continue;
                return ns.getUri();
            }
        }
        return null;
    }

    protected void writeBeginOutput() throws IOException {
    }

    protected void writeEndOutput() throws IOException {
    }

    protected void writeHeader(String enc) throws IOException {
        this.writer.write("<?xml");
        this.writeAttribute("version", "1.0");
        if (enc != null) {
            this.writeAttribute("encoding", enc);
        }
        if (this.standalone != null) {
            this.writeAttribute("standalone", this.standalone != false ? "yes" : "no");
        }
        this.writer.write("?>");
    }

    protected void writeFooter() throws IOException {
    }

    protected void writeQualifiedName(String nsAlias, String name) throws IOException {
        if (nsAlias != null && nsAlias.length() > 0) {
            this.writer.write(nsAlias);
            this.writer.write(58);
        }
        this.writer.write(name);
    }

    protected void writeOpenTagStart(String nsAlias, String name) throws IOException {
        if (this.isPrettyPrintingEnabled()) {
            if (this.getIndentationLevel() > 0 || this.shouldWriteHeaderAndFooter()) {
                this.writeNewline();
            }
            this.writeIndentation();
        }
        this.writer.write(60);
        this.writeQualifiedName(nsAlias, name);
    }

    protected void writeOpenTagEnd() throws IOException {
        this.writer.write(62);
    }

    protected void writeCloseTag(String nsAlias, String name) throws IOException {
        Element element = this.currentElement();
        if (element.openTagEnded) {
            if (this.isPrettyPrintingEnabled()) {
                this.writeNewline();
                this.writeIndentation();
            }
            this.writer.write("</");
            this.writeQualifiedName(nsAlias, name);
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    protected void writeAttribute(String name, String value) throws IOException {
        this.writeAttribute(null, name, value);
    }

    protected void writeAttribute(String nsAlias, String name, String value) throws IOException {
        this.writer.write(" ");
        this.writeQualifiedName(nsAlias, name);
        this.writer.write(61);
        this.writer.write(39);
        if (value != null) {
            this.writer.write(XmlEscapers.xmlAttributeEscaper().escape(value));
        }
        this.writer.write(39);
    }

    public void characters(String s) throws IOException {
        this.characters(s, false);
    }

    public void characters(String s, boolean useCData) throws IOException {
        String escaped;
        if (s == null) {
            return;
        }
        this.endOpenTag();
        this.currentElement().unformattedChildren = true;
        if (useCData) {
            String string = XmlWriter.xmlCDataEscape(s);
            escaped = new StringBuilder(12 + String.valueOf(string).length()).append("<![CDATA[").append(string).append("]]>").toString();
        } else {
            escaped = XmlEscapers.xmlContentEscaper().escape(s);
        }
        this.writer.write(escaped);
    }

    public void innerXml(String xml) throws IOException {
        if (xml == null) {
            return;
        }
        this.writeUnescaped(xml);
    }

    public void writeUnescaped(String s) throws IOException {
        this.endOpenTag();
        this.currentElement().unformattedChildren = true;
        this.writer.write(s);
    }

    public void setIndentationUnit(String indentationUnit) {
        this.indentationUnit = indentationUnit;
    }

    @VisibleForTesting
    static String xmlCDataEscape(String s) {
        int found = (s = CONTROL_MATCHER.replaceFrom((CharSequence)s, '\ufffd')).indexOf("]]>");
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        do {
            sb.append(s.substring(prev, found + 3));
            sb.append("]]&gt;<![CDATA[");
        } while ((found = s.indexOf("]]>", prev = found + 3)) != -1);
        sb.append(s.substring(prev));
        return sb.toString();
    }

    protected static class Element {
        public static final int NOT_REPEATING = -1;
        public List<XmlNamespace> nsDecls = new ArrayList<XmlNamespace>();
        public String nsAlias;
        public final String nsUri;
        public final String name;
        public String xmlLang;
        public boolean hasAttributes;
        public boolean unformattedChildren;
        public int repeatingCount = -1;
        public int repeatingIndex = -1;
        public String enclosingDefaultNamespace;
        public boolean openTagEnded;

        protected Element(String nsAlias, String nsUri, String name) {
            this.nsAlias = nsAlias;
            this.nsUri = nsUri;
            this.name = name;
        }

        public void addNamespace(XmlNamespace ns) {
            if (!this.nsDecls.contains(ns)) {
                this.nsDecls.add(ns);
            }
        }
    }

    public static final class Attribute {
        public final String nsAlias;
        public final String name;
        public final String value;

        public Attribute(String name, String value) {
            this(null, name, value);
        }

        public Attribute(String nsAlias, String name, String value) {
            int separator;
            if (nsAlias == null && (separator = name.indexOf(58)) > 0) {
                nsAlias = name.substring(0, separator);
                name = name.substring(separator + 1);
            }
            this.nsAlias = nsAlias;
            this.name = name;
            this.value = value;
        }

        public Attribute(String name, boolean value) {
            this(null, name, value ? "true" : "false");
        }
    }

    @Deprecated
    public static final class Namespace
    extends XmlNamespace {
        public Namespace(String alias, String uri) {
            super(alias, uri);
        }
    }

    public static enum WriterFlags {
        WRITE_HEADER,
        EXPAND_EMPTY,
        PRETTY_PRINT;

    }
}

