/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PeriodType
implements Serializable {
    private static final long serialVersionUID = 2274324892792009998L;
    private static final Map<PeriodType, Object> cTypes = new HashMap<PeriodType, Object>(32);
    static int YEAR_INDEX = 0;
    static int MONTH_INDEX = 1;
    static int WEEK_INDEX = 2;
    static int DAY_INDEX = 3;
    static int HOUR_INDEX = 4;
    static int MINUTE_INDEX = 5;
    static int SECOND_INDEX = 6;
    static int MILLI_INDEX = 7;
    private static PeriodType cStandard;
    private static PeriodType cYMDTime;
    private static PeriodType cYMD;
    private static PeriodType cYWDTime;
    private static PeriodType cYWD;
    private static PeriodType cYDTime;
    private static PeriodType cYD;
    private static PeriodType cDTime;
    private static PeriodType cTime;
    private static PeriodType cYears;
    private static PeriodType cMonths;
    private static PeriodType cWeeks;
    private static PeriodType cDays;
    private static PeriodType cHours;
    private static PeriodType cMinutes;
    private static PeriodType cSeconds;
    private static PeriodType cMillis;
    private final String iName;
    private final DurationFieldType[] iTypes;
    private final int[] iIndices;

    public static PeriodType standard() {
        PeriodType type = cStandard;
        if (type == null) {
            cStandard = type = new PeriodType("Standard", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return type;
    }

    public static PeriodType yearMonthDayTime() {
        PeriodType type = cYMDTime;
        if (type == null) {
            cYMDTime = type = new PeriodType("YearMonthDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, -1, 2, 3, 4, 5, 6});
        }
        return type;
    }

    public static PeriodType yearMonthDay() {
        PeriodType type = cYMD;
        if (type == null) {
            cYMD = type = new PeriodType("YearMonthDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days()}, new int[]{0, 1, -1, 2, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType yearWeekDayTime() {
        PeriodType type = cYWDTime;
        if (type == null) {
            cYWDTime = type = new PeriodType("YearWeekDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, 1, 2, 3, 4, 5, 6});
        }
        return type;
    }

    public static PeriodType yearWeekDay() {
        PeriodType type = cYWD;
        if (type == null) {
            cYWD = type = new PeriodType("YearWeekDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days()}, new int[]{0, -1, 1, 2, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType yearDayTime() {
        PeriodType type = cYDTime;
        if (type == null) {
            cYDTime = type = new PeriodType("YearDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, -1, 1, 2, 3, 4, 5});
        }
        return type;
    }

    public static PeriodType yearDay() {
        PeriodType type = cYD;
        if (type == null) {
            cYD = type = new PeriodType("YearDay", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days()}, new int[]{0, -1, -1, 1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType dayTime() {
        PeriodType type = cDTime;
        if (type == null) {
            cDTime = type = new PeriodType("DayTime", new DurationFieldType[]{DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, 0, 1, 2, 3, 4});
        }
        return type;
    }

    public static PeriodType time() {
        PeriodType type = cTime;
        if (type == null) {
            cTime = type = new PeriodType("Time", new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return type;
    }

    public static PeriodType years() {
        PeriodType type = cYears;
        if (type == null) {
            cYears = type = new PeriodType("Years", new DurationFieldType[]{DurationFieldType.years()}, new int[]{0, -1, -1, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType months() {
        PeriodType type = cMonths;
        if (type == null) {
            cMonths = type = new PeriodType("Months", new DurationFieldType[]{DurationFieldType.months()}, new int[]{-1, 0, -1, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType weeks() {
        PeriodType type = cWeeks;
        if (type == null) {
            cWeeks = type = new PeriodType("Weeks", new DurationFieldType[]{DurationFieldType.weeks()}, new int[]{-1, -1, 0, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType days() {
        PeriodType type = cDays;
        if (type == null) {
            cDays = type = new PeriodType("Days", new DurationFieldType[]{DurationFieldType.days()}, new int[]{-1, -1, -1, 0, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType hours() {
        PeriodType type = cHours;
        if (type == null) {
            cHours = type = new PeriodType("Hours", new DurationFieldType[]{DurationFieldType.hours()}, new int[]{-1, -1, -1, -1, 0, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType minutes() {
        PeriodType type = cMinutes;
        if (type == null) {
            cMinutes = type = new PeriodType("Minutes", new DurationFieldType[]{DurationFieldType.minutes()}, new int[]{-1, -1, -1, -1, -1, 0, -1, -1});
        }
        return type;
    }

    public static PeriodType seconds() {
        PeriodType type = cSeconds;
        if (type == null) {
            cSeconds = type = new PeriodType("Seconds", new DurationFieldType[]{DurationFieldType.seconds()}, new int[]{-1, -1, -1, -1, -1, -1, 0, -1});
        }
        return type;
    }

    public static PeriodType millis() {
        PeriodType type = cMillis;
        if (type == null) {
            cMillis = type = new PeriodType("Millis", new DurationFieldType[]{DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, -1, -1, -1, 0});
        }
        return type;
    }

    public static synchronized PeriodType forFields(DurationFieldType[] types) {
        PeriodType inPartType;
        Object cached;
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("Types array must not be null or empty");
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != null) continue;
            throw new IllegalArgumentException("Types array must not contain null");
        }
        Map<PeriodType, Object> cache = cTypes;
        if (cache.isEmpty()) {
            cache.put(PeriodType.standard(), PeriodType.standard());
            cache.put(PeriodType.yearMonthDayTime(), PeriodType.yearMonthDayTime());
            cache.put(PeriodType.yearMonthDay(), PeriodType.yearMonthDay());
            cache.put(PeriodType.yearWeekDayTime(), PeriodType.yearWeekDayTime());
            cache.put(PeriodType.yearWeekDay(), PeriodType.yearWeekDay());
            cache.put(PeriodType.yearDayTime(), PeriodType.yearDayTime());
            cache.put(PeriodType.yearDay(), PeriodType.yearDay());
            cache.put(PeriodType.dayTime(), PeriodType.dayTime());
            cache.put(PeriodType.time(), PeriodType.time());
            cache.put(PeriodType.years(), PeriodType.years());
            cache.put(PeriodType.months(), PeriodType.months());
            cache.put(PeriodType.weeks(), PeriodType.weeks());
            cache.put(PeriodType.days(), PeriodType.days());
            cache.put(PeriodType.hours(), PeriodType.hours());
            cache.put(PeriodType.minutes(), PeriodType.minutes());
            cache.put(PeriodType.seconds(), PeriodType.seconds());
            cache.put(PeriodType.millis(), PeriodType.millis());
        }
        if ((cached = cache.get(inPartType = new PeriodType(null, types, null))) instanceof PeriodType) {
            return (PeriodType)cached;
        }
        if (cached != null) {
            String string = String.valueOf(cached);
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("PeriodType does not support fields: ").append(string).toString());
        }
        PeriodType type = PeriodType.standard();
        ArrayList<DurationFieldType> list = new ArrayList<DurationFieldType>(Arrays.asList(types));
        if (!list.remove(DurationFieldType.years())) {
            type = type.withYearsRemoved();
        }
        if (!list.remove(DurationFieldType.months())) {
            type = type.withMonthsRemoved();
        }
        if (!list.remove(DurationFieldType.weeks())) {
            type = type.withWeeksRemoved();
        }
        if (!list.remove(DurationFieldType.days())) {
            type = type.withDaysRemoved();
        }
        if (!list.remove(DurationFieldType.hours())) {
            type = type.withHoursRemoved();
        }
        if (!list.remove(DurationFieldType.minutes())) {
            type = type.withMinutesRemoved();
        }
        if (!list.remove(DurationFieldType.seconds())) {
            type = type.withSecondsRemoved();
        }
        if (!list.remove(DurationFieldType.millis())) {
            type = type.withMillisRemoved();
        }
        if (list.size() > 0) {
            cache.put(inPartType, list);
            String string = String.valueOf(list);
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("PeriodType does not support fields: ").append(string).toString());
        }
        PeriodType checkPartType = new PeriodType(null, type.iTypes, null);
        PeriodType checkedType = (PeriodType)cache.get(checkPartType);
        if (checkedType != null) {
            cache.put(checkPartType, checkedType);
            return checkedType;
        }
        cache.put(checkPartType, type);
        return type;
    }

    protected PeriodType(String name, DurationFieldType[] types, int[] indices) {
        this.iName = name;
        this.iTypes = types;
        this.iIndices = indices;
    }

    public String getName() {
        return this.iName;
    }

    public int size() {
        return this.iTypes.length;
    }

    public DurationFieldType getFieldType(int index) {
        return this.iTypes[index];
    }

    public boolean isSupported(DurationFieldType type) {
        return this.indexOf(type) >= 0;
    }

    public int indexOf(DurationFieldType type) {
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            if (this.iTypes[i] != type) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        String string = this.getName();
        return new StringBuilder(12 + String.valueOf(string).length()).append("PeriodType[").append(string).append("]").toString();
    }

    int getIndexedField(ReadablePeriod period, int index) {
        int realIndex = this.iIndices[index];
        return realIndex == -1 ? 0 : period.getValue(realIndex);
    }

    boolean setIndexedField(ReadablePeriod period, int index, int[] values, int newValue) {
        int realIndex = this.iIndices[index];
        if (realIndex == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        values[realIndex] = newValue;
        return true;
    }

    boolean addIndexedField(ReadablePeriod period, int index, int[] values, int valueToAdd) {
        if (valueToAdd == 0) {
            return false;
        }
        int realIndex = this.iIndices[index];
        if (realIndex == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        values[realIndex] = FieldUtils.safeAdd(values[realIndex], valueToAdd);
        return true;
    }

    public PeriodType withYearsRemoved() {
        return this.withFieldRemoved(0, "NoYears");
    }

    public PeriodType withMonthsRemoved() {
        return this.withFieldRemoved(1, "NoMonths");
    }

    public PeriodType withWeeksRemoved() {
        return this.withFieldRemoved(2, "NoWeeks");
    }

    public PeriodType withDaysRemoved() {
        return this.withFieldRemoved(3, "NoDays");
    }

    public PeriodType withHoursRemoved() {
        return this.withFieldRemoved(4, "NoHours");
    }

    public PeriodType withMinutesRemoved() {
        return this.withFieldRemoved(5, "NoMinutes");
    }

    public PeriodType withSecondsRemoved() {
        return this.withFieldRemoved(6, "NoSeconds");
    }

    public PeriodType withMillisRemoved() {
        return this.withFieldRemoved(7, "NoMillis");
    }

    private PeriodType withFieldRemoved(int indicesIndex, String name) {
        int fieldIndex = this.iIndices[indicesIndex];
        if (fieldIndex == -1) {
            return this;
        }
        DurationFieldType[] types = new DurationFieldType[this.size() - 1];
        for (int i = 0; i < this.iTypes.length; ++i) {
            if (i < fieldIndex) {
                types[i] = this.iTypes[i];
                continue;
            }
            if (i <= fieldIndex) continue;
            types[i - 1] = this.iTypes[i];
        }
        int[] indices = new int[8];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i < indicesIndex ? this.iIndices[i] : (i > indicesIndex ? (this.iIndices[i] == -1 ? -1 : this.iIndices[i] - 1) : -1);
        }
        String string = String.valueOf(this.getName());
        String string2 = String.valueOf(name);
        return new PeriodType(string2.length() != 0 ? string.concat(string2) : new String(string), types, indices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PeriodType)) {
            return false;
        }
        PeriodType other = (PeriodType)obj;
        return Arrays.equals(this.iTypes, other.iTypes);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.iTypes.length; ++i) {
            hash += this.iTypes[i].hashCode();
        }
        return hash;
    }
}

