/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.html.types.BuilderUtils;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtml;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtmls;
import com.google.appengine.repackaged.com.google.common.html.types.SafeScript;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyle;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyleSheet;
import com.google.appengine.repackaged.com.google.common.html.types.SafeUrl;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@GwtCompatible
@NotThreadSafe
public final class SafeHtmlBuilder {
    private static final String VALID_ELEMENT_NAMES_REGEXP = "[a-z0-9-]+";
    private static final String VALID_DATA_ATTRIBUTES_REGEXP = "data-[a-zA-Z-]+";
    private static final ImmutableSet<String> UNSUPPORTED_ELEMENTS = ImmutableSet.of("applet", "base", "embed", "math", "meta", "object", new String[]{"svg", "template"});
    private static final ImmutableSet<String> SCRIPT_ELEMENTS = ImmutableSet.of("script");
    private static final ImmutableSet<String> STYLESHEET_ELEMENTS = ImmutableSet.of("style");
    private static final ImmutableSet<String> VOID_ELEMENTS = ImmutableSet.of("area", "br", "col", "hr", "img", "input", new String[]{"link", "param", "source", "track", "wbr"});
    private final String elementName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<String> contents = new ArrayList<String>();
    private boolean useSlashOnVoid = false;
    private AttributeContract hrefValueContract = AttributeContract.TRUSTED_RESOURCE_URL;
    private static final ImmutableSet<String> ACCEPT_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input");
    private static final ImmutableSet<String> ACTION_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("form");
    private static final ImmutableSet<String> DEFER_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("script");
    private static final ImmutableSet<String> FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("button", "input");
    private static final ImmutableSet<String> FORMMETHOD_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("button", "input");
    private static final ImmutableSet<String> HREF_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("a", "area");
    private static final ImmutableSet<String> LINK_HREF_SAFE_URL_REL_ALLOWLIST = ImmutableSet.of("alternate", "author", "bookmark", "canonical", "cite", "help", new String[]{"icon", "license", "next", "prefetch", "dns-prefetch", "prerender", "preconnect", "preload", "prev", "search", "subresource"});
    private static final ImmutableSet<String> METHOD_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("form");
    private static final ImmutableSet<String> PATTERN_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input");
    private static final ImmutableSet<String> READONLY_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input", "textarea");
    private static final ImmutableSet<String> SRC_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("audio", "img", "input", "source", "video");
    private static final ImmutableSet<String> SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST = ImmutableSet.of("iframe");

    public SafeHtmlBuilder(@CompileTimeConstant String elementName) {
        if (elementName == null) {
            throw new NullPointerException();
        }
        if (!elementName.matches(VALID_ELEMENT_NAMES_REGEXP)) {
            throw new IllegalArgumentException(new StringBuilder(73 + String.valueOf(elementName).length()).append("Invalid element name \"").append(elementName).append("\". Only lowercase letters, numbers and '-' allowed.").toString());
        }
        if (UNSUPPORTED_ELEMENTS.contains(elementName)) {
            throw new IllegalArgumentException(new StringBuilder(28 + String.valueOf(elementName).length()).append("Element \"").append(elementName).append("\" is not supported.").toString());
        }
        this.elementName = elementName;
    }

    public SafeHtmlBuilder useSlashOnVoid() {
        this.useSlashOnVoid = true;
        return this;
    }

    public SafeHtmlBuilder setAccept(String value) {
        if (!ACCEPT_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(ACCEPT_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(90 + String.valueOf(string).length()).append("Attribute \"accept\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("accept", value);
    }

    public SafeHtmlBuilder setAction(SafeUrl value) {
        if (!ACTION_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(ACTION_SAFE_URL_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(91 + String.valueOf(string).length()).append("Attribute \"action\" with a SafeUrl value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("action", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setAlign(String value) {
        return this.setAttribute("align", value);
    }

    public SafeHtmlBuilder setAlt(String value) {
        return this.setAttribute("alt", value);
    }

    public SafeHtmlBuilder setAriaActivedescendant(@CompileTimeConstant String value) {
        return this.setAttribute("aria-activedescendant", value);
    }

    public SafeHtmlBuilder setAriaActivedescendantWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-activedescendant", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setAriaAtomic(String value) {
        return this.setAttribute("aria-atomic", value);
    }

    public SafeHtmlBuilder setAriaAutocomplete(String value) {
        return this.setAttribute("aria-autocomplete", value);
    }

    public SafeHtmlBuilder setAriaBusy(String value) {
        return this.setAttribute("aria-busy", value);
    }

    public SafeHtmlBuilder setAriaChecked(String value) {
        return this.setAttribute("aria-checked", value);
    }

    public SafeHtmlBuilder setAriaControls(@CompileTimeConstant String value) {
        return this.setAttribute("aria-controls", value);
    }

    public SafeHtmlBuilder setAriaControlsWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-controls", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setAriaCurrent(String value) {
        return this.setAttribute("aria-current", value);
    }

    public SafeHtmlBuilder setAriaDisabled(String value) {
        return this.setAttribute("aria-disabled", value);
    }

    public SafeHtmlBuilder setAriaDropeffect(String value) {
        return this.setAttribute("aria-dropeffect", value);
    }

    public SafeHtmlBuilder setAriaExpanded(String value) {
        return this.setAttribute("aria-expanded", value);
    }

    public SafeHtmlBuilder setAriaHaspopup(String value) {
        return this.setAttribute("aria-haspopup", value);
    }

    public SafeHtmlBuilder setAriaHidden(String value) {
        return this.setAttribute("aria-hidden", value);
    }

    public SafeHtmlBuilder setAriaInvalid(String value) {
        return this.setAttribute("aria-invalid", value);
    }

    public SafeHtmlBuilder setAriaLabel(String value) {
        return this.setAttribute("aria-label", value);
    }

    public SafeHtmlBuilder setAriaLabelledby(@CompileTimeConstant String value) {
        return this.setAttribute("aria-labelledby", value);
    }

    public SafeHtmlBuilder setAriaLabelledbyWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-labelledby", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setAriaLevel(String value) {
        return this.setAttribute("aria-level", value);
    }

    public SafeHtmlBuilder setAriaLive(String value) {
        return this.setAttribute("aria-live", value);
    }

    public SafeHtmlBuilder setAriaMultiline(String value) {
        return this.setAttribute("aria-multiline", value);
    }

    public SafeHtmlBuilder setAriaMultiselectable(String value) {
        return this.setAttribute("aria-multiselectable", value);
    }

    public SafeHtmlBuilder setAriaOrientation(String value) {
        return this.setAttribute("aria-orientation", value);
    }

    public SafeHtmlBuilder setAriaOwns(@CompileTimeConstant String value) {
        return this.setAttribute("aria-owns", value);
    }

    public SafeHtmlBuilder setAriaOwnsWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-owns", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setAriaPosinset(String value) {
        return this.setAttribute("aria-posinset", value);
    }

    public SafeHtmlBuilder setAriaPressed(String value) {
        return this.setAttribute("aria-pressed", value);
    }

    public SafeHtmlBuilder setAriaReadonly(String value) {
        return this.setAttribute("aria-readonly", value);
    }

    public SafeHtmlBuilder setAriaRelevant(String value) {
        return this.setAttribute("aria-relevant", value);
    }

    public SafeHtmlBuilder setAriaRequired(String value) {
        return this.setAttribute("aria-required", value);
    }

    public SafeHtmlBuilder setAriaSelected(String value) {
        return this.setAttribute("aria-selected", value);
    }

    public SafeHtmlBuilder setAriaSetsize(String value) {
        return this.setAttribute("aria-setsize", value);
    }

    public SafeHtmlBuilder setAriaSort(String value) {
        return this.setAttribute("aria-sort", value);
    }

    public SafeHtmlBuilder setAriaValuemax(String value) {
        return this.setAttribute("aria-valuemax", value);
    }

    public SafeHtmlBuilder setAriaValuemin(String value) {
        return this.setAttribute("aria-valuemin", value);
    }

    public SafeHtmlBuilder setAriaValuenow(String value) {
        return this.setAttribute("aria-valuenow", value);
    }

    public SafeHtmlBuilder setAriaValuetext(String value) {
        return this.setAttribute("aria-valuetext", value);
    }

    public SafeHtmlBuilder setAsync(AsyncValue value) {
        return this.setAttribute("async", value.toString());
    }

    public SafeHtmlBuilder setAutocapitalize(String value) {
        return this.setAttribute("autocapitalize", value);
    }

    public SafeHtmlBuilder setAutocomplete(String value) {
        return this.setAttribute("autocomplete", value);
    }

    public SafeHtmlBuilder setAutocorrect(String value) {
        return this.setAttribute("autocorrect", value);
    }

    public SafeHtmlBuilder setAutofocus(String value) {
        return this.setAttribute("autofocus", value);
    }

    public SafeHtmlBuilder setAutoplay(String value) {
        return this.setAttribute("autoplay", value);
    }

    public SafeHtmlBuilder setBgcolor(String value) {
        return this.setAttribute("bgcolor", value);
    }

    public SafeHtmlBuilder setBorder(String value) {
        return this.setAttribute("border", value);
    }

    public SafeHtmlBuilder setCellpadding(String value) {
        return this.setAttribute("cellpadding", value);
    }

    public SafeHtmlBuilder setCellspacing(String value) {
        return this.setAttribute("cellspacing", value);
    }

    public SafeHtmlBuilder setChecked(String value) {
        return this.setAttribute("checked", value);
    }

    public SafeHtmlBuilder setCite(SafeUrl value) {
        return this.setAttribute("cite", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setClass(String value) {
        return this.setAttribute("class", value);
    }

    public SafeHtmlBuilder setColor(String value) {
        return this.setAttribute("color", value);
    }

    public SafeHtmlBuilder setCols(String value) {
        return this.setAttribute("cols", value);
    }

    public SafeHtmlBuilder setColspan(String value) {
        return this.setAttribute("colspan", value);
    }

    public SafeHtmlBuilder setContenteditable(String value) {
        return this.setAttribute("contenteditable", value);
    }

    public SafeHtmlBuilder setControls(String value) {
        return this.setAttribute("controls", value);
    }

    public SafeHtmlBuilder setDatetime(String value) {
        return this.setAttribute("datetime", value);
    }

    public SafeHtmlBuilder setDefer(String value) {
        if (!DEFER_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(DEFER_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(string).length()).append("Attribute \"defer\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("defer", value);
    }

    public SafeHtmlBuilder setDir(DirValue value) {
        return this.setAttribute("dir", value.toString());
    }

    public SafeHtmlBuilder setDisabled(String value) {
        return this.setAttribute("disabled", value);
    }

    public SafeHtmlBuilder setDownload(String value) {
        return this.setAttribute("download", value);
    }

    public SafeHtmlBuilder setDraggable(String value) {
        return this.setAttribute("draggable", value);
    }

    public SafeHtmlBuilder setEnctype(String value) {
        return this.setAttribute("enctype", value);
    }

    public SafeHtmlBuilder setFace(String value) {
        return this.setAttribute("face", value);
    }

    public SafeHtmlBuilder setFor(@CompileTimeConstant String value) {
        return this.setAttribute("for", value);
    }

    public SafeHtmlBuilder setForWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("for", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setFormaction(SafeUrl value) {
        if (!FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(95 + String.valueOf(string).length()).append("Attribute \"formaction\" with a SafeUrl value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("formaction", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setFormenctype(String value) {
        return this.setAttribute("formenctype", value);
    }

    public SafeHtmlBuilder setFormmethod(String value) {
        if (!FORMMETHOD_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(FORMMETHOD_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(94 + String.valueOf(string).length()).append("Attribute \"formmethod\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("formmethod", value);
    }

    public SafeHtmlBuilder setFrameborder(String value) {
        return this.setAttribute("frameborder", value);
    }

    public SafeHtmlBuilder setHeight(String value) {
        return this.setAttribute("height", value);
    }

    public SafeHtmlBuilder setHidden(String value) {
        return this.setAttribute("hidden", value);
    }

    public SafeHtmlBuilder setHref(SafeUrl value) {
        if (!HREF_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName) && !this.elementName.equals("link")) {
            String string = String.valueOf(HREF_SAFE_URL_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(string).length()).append("Attribute \"href\" with a SafeUrl value can only be used by one of the following elements: ").append(string).toString());
        }
        if (this.elementName.equals("link")) {
            SafeHtmlBuilder.checkLinkDependentAttributes(this.attributes.get("rel"), AttributeContract.SAFE_URL);
        }
        this.hrefValueContract = AttributeContract.SAFE_URL;
        return this.setAttribute("href", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setHref(TrustedResourceUrl value) {
        this.hrefValueContract = AttributeContract.TRUSTED_RESOURCE_URL;
        return this.setAttribute("href", value.getTrustedResourceUrlString());
    }

    public SafeHtmlBuilder setHreflang(String value) {
        return this.setAttribute("hreflang", value);
    }

    public SafeHtmlBuilder setId(@CompileTimeConstant String value) {
        return this.setAttribute("id", value);
    }

    public SafeHtmlBuilder setIdWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("id", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setIsmap(String value) {
        return this.setAttribute("ismap", value);
    }

    public SafeHtmlBuilder setItemid(String value) {
        return this.setAttribute("itemid", value);
    }

    public SafeHtmlBuilder setItemprop(String value) {
        return this.setAttribute("itemprop", value);
    }

    public SafeHtmlBuilder setItemref(String value) {
        return this.setAttribute("itemref", value);
    }

    public SafeHtmlBuilder setItemscope(String value) {
        return this.setAttribute("itemscope", value);
    }

    public SafeHtmlBuilder setItemtype(String value) {
        return this.setAttribute("itemtype", value);
    }

    public SafeHtmlBuilder setLabel(String value) {
        return this.setAttribute("label", value);
    }

    public SafeHtmlBuilder setLang(String value) {
        return this.setAttribute("lang", value);
    }

    public SafeHtmlBuilder setList(@CompileTimeConstant String value) {
        return this.setAttribute("list", value);
    }

    public SafeHtmlBuilder setListWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("list", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setLoading(LoadingValue value) {
        return this.setAttribute("loading", value.toString());
    }

    public SafeHtmlBuilder setLoop(String value) {
        return this.setAttribute("loop", value);
    }

    public SafeHtmlBuilder setMax(String value) {
        return this.setAttribute("max", value);
    }

    public SafeHtmlBuilder setMaxlength(String value) {
        return this.setAttribute("maxlength", value);
    }

    public SafeHtmlBuilder setMedia(String value) {
        return this.setAttribute("media", value);
    }

    public SafeHtmlBuilder setMethod(String value) {
        if (!METHOD_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(METHOD_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(90 + String.valueOf(string).length()).append("Attribute \"method\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("method", value);
    }

    public SafeHtmlBuilder setMin(String value) {
        return this.setAttribute("min", value);
    }

    public SafeHtmlBuilder setMinlength(String value) {
        return this.setAttribute("minlength", value);
    }

    public SafeHtmlBuilder setMultiple(String value) {
        return this.setAttribute("multiple", value);
    }

    public SafeHtmlBuilder setMuted(String value) {
        return this.setAttribute("muted", value);
    }

    public SafeHtmlBuilder setName(@CompileTimeConstant String value) {
        return this.setAttribute("name", value);
    }

    public SafeHtmlBuilder setNameWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("name", new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(value).length()).append(prefix).append("-").append(value).toString());
    }

    public SafeHtmlBuilder setNonce(String value) {
        return this.setAttribute("nonce", value);
    }

    public SafeHtmlBuilder setOpen(String value) {
        return this.setAttribute("open", value);
    }

    public SafeHtmlBuilder setPattern(String value) {
        if (!PATTERN_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(PATTERN_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(91 + String.valueOf(string).length()).append("Attribute \"pattern\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("pattern", value);
    }

    public SafeHtmlBuilder setPlaceholder(String value) {
        return this.setAttribute("placeholder", value);
    }

    public SafeHtmlBuilder setPoster(SafeUrl value) {
        return this.setAttribute("poster", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setPreload(String value) {
        return this.setAttribute("preload", value);
    }

    public SafeHtmlBuilder setReadonly(String value) {
        if (!READONLY_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(READONLY_STRING_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(92 + String.valueOf(string).length()).append("Attribute \"readonly\" with a String value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("readonly", value);
    }

    public SafeHtmlBuilder setRel(String value) {
        if (this.elementName.equals("link")) {
            SafeHtmlBuilder.checkLinkDependentAttributes(value, this.hrefValueContract);
        }
        return this.setAttribute("rel", value);
    }

    public SafeHtmlBuilder setRequired(String value) {
        return this.setAttribute("required", value);
    }

    public SafeHtmlBuilder setReversed(String value) {
        return this.setAttribute("reversed", value);
    }

    public SafeHtmlBuilder setRole(String value) {
        return this.setAttribute("role", value);
    }

    public SafeHtmlBuilder setRows(String value) {
        return this.setAttribute("rows", value);
    }

    public SafeHtmlBuilder setRowspan(String value) {
        return this.setAttribute("rowspan", value);
    }

    public SafeHtmlBuilder setSelected(String value) {
        return this.setAttribute("selected", value);
    }

    public SafeHtmlBuilder setShape(String value) {
        return this.setAttribute("shape", value);
    }

    public SafeHtmlBuilder setSize(String value) {
        return this.setAttribute("size", value);
    }

    public SafeHtmlBuilder setSizes(String value) {
        return this.setAttribute("sizes", value);
    }

    public SafeHtmlBuilder setSlot(String value) {
        return this.setAttribute("slot", value);
    }

    public SafeHtmlBuilder setSpan(String value) {
        return this.setAttribute("span", value);
    }

    public SafeHtmlBuilder setSpellcheck(String value) {
        return this.setAttribute("spellcheck", value);
    }

    public SafeHtmlBuilder setSrc(SafeUrl value) {
        if (!SRC_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(SRC_SAFE_URL_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(88 + String.valueOf(string).length()).append("Attribute \"src\" with a SafeUrl value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("src", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setSrc(TrustedResourceUrl value) {
        return this.setAttribute("src", value.getTrustedResourceUrlString());
    }

    public SafeHtmlBuilder setSrcdoc(SafeHtml value) {
        if (!SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            String string = String.valueOf(SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST);
            throw new IllegalArgumentException(new StringBuilder(92 + String.valueOf(string).length()).append("Attribute \"srcdoc\" with a SafeHtml value can only be used by one of the following elements: ").append(string).toString());
        }
        return this.setAttribute("srcdoc", value.getSafeHtmlString());
    }

    public SafeHtmlBuilder setStart(String value) {
        return this.setAttribute("start", value);
    }

    public SafeHtmlBuilder setStep(String value) {
        return this.setAttribute("step", value);
    }

    public SafeHtmlBuilder setStyle(SafeStyle value) {
        return this.setAttribute("style", value.getSafeStyleString());
    }

    public SafeHtmlBuilder setSummary(String value) {
        return this.setAttribute("summary", value);
    }

    public SafeHtmlBuilder setTabindex(String value) {
        return this.setAttribute("tabindex", value);
    }

    public SafeHtmlBuilder setTarget(TargetValue value) {
        return this.setAttribute("target", value.toString());
    }

    public SafeHtmlBuilder setTitle(String value) {
        return this.setAttribute("title", value);
    }

    public SafeHtmlBuilder setTranslate(String value) {
        return this.setAttribute("translate", value);
    }

    public SafeHtmlBuilder setType(String value) {
        return this.setAttribute("type", value);
    }

    public SafeHtmlBuilder setValign(String value) {
        return this.setAttribute("valign", value);
    }

    public SafeHtmlBuilder setValue(String value) {
        return this.setAttribute("value", value);
    }

    public SafeHtmlBuilder setWidth(String value) {
        return this.setAttribute("width", value);
    }

    public SafeHtmlBuilder setWrap(String value) {
        return this.setAttribute("wrap", value);
    }

    public SafeHtmlBuilder setDataAttribute(@CompileTimeConstant String name, String value) {
        if (!name.matches(VALID_DATA_ATTRIBUTES_REGEXP)) {
            throw new IllegalArgumentException(new StringBuilder(95 + String.valueOf(name).length()).append("Invalid data attribute name \"").append(name).append("\".Name must start with \"data-\" and be followed by letters and '-'.").toString());
        }
        return this.setAttribute(name, value);
    }

    public SafeHtmlBuilder appendContent(SafeHtml ... htmls) {
        this.appendContent(Arrays.asList(htmls));
        return this;
    }

    public SafeHtmlBuilder appendContent(Iterable<SafeHtml> htmls) {
        this.appendContent(htmls.iterator());
        return this;
    }

    public SafeHtmlBuilder appendContent(Iterator<SafeHtml> htmls) {
        this.checkSafeHtmlElement();
        while (htmls.hasNext()) {
            this.contents.add(htmls.next().getSafeHtmlString());
        }
        return this;
    }

    public SafeHtmlBuilder appendScriptContent(SafeScript script) {
        this.checkSafeScriptElement();
        this.contents.add(script.getSafeScriptString());
        return this;
    }

    public SafeHtmlBuilder appendStyleContent(SafeStyleSheet style) {
        this.checkSafeStyleSheetElement();
        this.contents.add(style.getSafeStyleSheetString());
        return this;
    }

    private static void checkLinkDependentAttributes(@Nullable String relValue, AttributeContract hrefValueContract) {
        if (hrefValueContract.equals((Object)AttributeContract.SAFE_URL) && relValue != null && !LINK_HREF_SAFE_URL_REL_ALLOWLIST.contains(relValue.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException(new StringBuilder(113 + String.valueOf(relValue).length()).append("SafeUrl values for the href attribute are not allowed on <link rel=").append(relValue).append(">. Did you intend to use a TrustedResourceUrl?").toString());
        }
    }

    private void checkSafeHtmlElement() {
        this.checkNotVoidElement();
        String string = this.elementName;
        Preconditions.checkState(!SCRIPT_ELEMENTS.contains(this.elementName), new StringBuilder(62 + String.valueOf(string).length()).append("Element \"").append(string).append("\" requires SafeScript contents, not SafeHTML or text.").toString());
        string = this.elementName;
        Preconditions.checkState(!STYLESHEET_ELEMENTS.contains(this.elementName), new StringBuilder(66 + String.valueOf(string).length()).append("Element \"").append(string).append("\" requires SafeStyleSheet contents, not SafeHTML or text.").toString());
    }

    private void checkSafeScriptElement() {
        String string = this.elementName;
        Preconditions.checkState(SCRIPT_ELEMENTS.contains(this.elementName), new StringBuilder(39 + String.valueOf(string).length()).append("Element \"").append(string).append("\" must not contain SafeScript.").toString());
    }

    private void checkSafeStyleSheetElement() {
        String string = this.elementName;
        Preconditions.checkState(STYLESHEET_ELEMENTS.contains(this.elementName), new StringBuilder(43 + String.valueOf(string).length()).append("Element \"").append(string).append("\" must not contain SafeStyleSheet.").toString());
    }

    private void checkNotVoidElement() {
        String string = this.elementName;
        Preconditions.checkState(!VOID_ELEMENTS.contains(this.elementName), new StringBuilder(56 + String.valueOf(string).length()).append("Element \"").append(string).append("\" is a void element and so cannot have content.").toString());
    }

    public SafeHtmlBuilder escapeAndAppendContent(String text) {
        return this.appendContent(SafeHtmls.htmlEscape(text));
    }

    @CheckReturnValue
    public SafeHtml build() {
        String string = String.valueOf(this.elementName);
        StringBuilder sb = new StringBuilder(string.length() != 0 ? "<".concat(string) : new String("<"));
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String string2 = entry.getKey();
            String string3 = BuilderUtils.escapeHtmlInternal(entry.getValue());
            sb.append(new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(" ").append(string2).append("=\"").append(string3).append("\"").toString());
        }
        boolean isVoid = VOID_ELEMENTS.contains(this.elementName);
        if (isVoid && this.useSlashOnVoid) {
            sb.append("/");
        }
        sb.append(">");
        if (!isVoid) {
            for (String content : this.contents) {
                sb.append(content);
            }
            String string4 = this.elementName;
            sb.append(new StringBuilder(3 + String.valueOf(string4).length()).append("</").append(string4).append(">").toString());
        }
        return SafeHtmls.create(sb.toString());
    }

    private SafeHtmlBuilder setAttribute(@CompileTimeConstant String name, String value) {
        if (value == null) {
            throw new NullPointerException("setAttribute requires a non-null value.");
        }
        this.attributes.put(name, BuilderUtils.coerceToInterchangeValid(value));
        return this;
    }

    public static enum TargetValue {
        BLANK("_blank"),
        SELF("_self");

        private final String value;

        private TargetValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LoadingValue {
        EAGER("eager"),
        LAZY("lazy");

        private final String value;

        private LoadingValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DirValue {
        AUTO("auto"),
        LTR("ltr"),
        RTL("rtl");

        private final String value;

        private DirValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AsyncValue {
        ASYNC("async");

        private final String value;

        private AsyncValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static enum AttributeContract {
        SAFE_URL,
        TRUSTED_RESOURCE_URL;

    }
}

