/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.gson.internal;

import com.google.appengine.repackaged.com.google.gson.InstanceCreator;
import com.google.appengine.repackaged.com.google.gson.JsonIOException;
import com.google.appengine.repackaged.com.google.gson.internal.LinkedTreeMap;
import com.google.appengine.repackaged.com.google.gson.internal.ObjectConstructor;
import com.google.appengine.repackaged.com.google.gson.internal.UnsafeAllocator;
import com.google.appengine.repackaged.com.google.gson.internal.reflect.ReflectionHelper;
import com.google.appengine.repackaged.com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;
    private final boolean useJdkUnsafe;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> instanceCreators, boolean useJdkUnsafe) {
        this.instanceCreators = instanceCreators;
        this.useJdkUnsafe = useJdkUnsafe;
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        final Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        final InstanceCreator<?> typeCreator = this.instanceCreators.get(type);
        if (typeCreator != null) {
            return new ObjectConstructor<T>(this){

                @Override
                public T construct() {
                    return typeCreator.createInstance(type);
                }
            };
        }
        final InstanceCreator<?> rawTypeCreator = this.instanceCreators.get(rawType);
        if (rawTypeCreator != null) {
            return new ObjectConstructor<T>(this){

                @Override
                public T construct() {
                    return rawTypeCreator.createInstance(type);
                }
            };
        }
        ObjectConstructor<T> defaultConstructor = this.newDefaultConstructor(rawType);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ObjectConstructor<T> defaultImplementation = this.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return this.newUnsafeAllocator(rawType);
    }

    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> rawType) {
        Constructor<? super T> constructor;
        try {
            constructor = rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        final String exceptionMessage = ReflectionHelper.tryMakeAccessible(constructor);
        if (exceptionMessage != null) {
            return new ObjectConstructor<T>(this){

                @Override
                public T construct() {
                    throw new JsonIOException(exceptionMessage);
                }
            };
        }
        return new ObjectConstructor<T>(this){

            @Override
            public T construct() {
                try {
                    Object newInstance = constructor.newInstance(new Object[0]);
                    return newInstance;
                }
                catch (InstantiationException e) {
                    String string = String.valueOf(constructor);
                    throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), e);
                }
                catch (InvocationTargetException e) {
                    String string = String.valueOf(constructor);
                    throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), e.getTargetException());
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(final Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        if (type instanceof ParameterizedType) {
                            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (elementType instanceof Class) {
                                return EnumSet.noneOf((Class)elementType);
                            }
                            String string = String.valueOf(type.toString());
                            throw new JsonIOException(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                        }
                        String string = String.valueOf(type.toString());
                        throw new JsonIOException(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new ArrayDeque();
                    }
                };
            }
            return new ObjectConstructor<T>(this){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new ConcurrentSkipListMap();
                    }
                };
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new ConcurrentHashMap();
                    }
                };
            }
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return new ObjectConstructor<T>(this){

                    @Override
                    public T construct() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new ObjectConstructor<T>(this){

                @Override
                public T construct() {
                    return new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(final Class<? super T> rawType) {
        if (this.useJdkUnsafe) {
            return new ObjectConstructor<T>(this){
                private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

                @Override
                public T construct() {
                    try {
                        Object newInstance = this.unsafeAllocator.newInstance(rawType);
                        return newInstance;
                    }
                    catch (Exception e) {
                        String string = String.valueOf(rawType);
                        throw new RuntimeException(new StringBuilder(147 + String.valueOf(string).length()).append("Unable to create instance of ").append(string).append(". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.").toString(), e);
                    }
                }
            };
        }
        String string = String.valueOf(rawType);
        final String exceptionMessage = new StringBuilder(210 + String.valueOf(string).length()).append("Unable to create instance of ").append(string).append("; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.").toString();
        return new ObjectConstructor<T>(this){

            @Override
            public T construct() {
                throw new JsonIOException(exceptionMessage);
            }
        };
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

