/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.cache;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Stopwatch;
import com.google.appengine.repackaged.com.google.common.cache.AbstractCache;
import com.google.appengine.repackaged.com.google.common.cache.AsyncCacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.AsyncLoadingCache;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.CacheStats;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.common.cache.LongAddable;
import com.google.appengine.repackaged.com.google.common.cache.LongAddables;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Futures;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;
import org.jspecify.nullness.Nullable;

@NullMarked
@GoogleInternal
@GwtIncompatible
final class ShimAsyncCache<K, V>
implements AsyncLoadingCache<K, V> {
    private static final StatsFixer NULL_STATS_FIXER = new StatsFixer(){

        @Override
        public void fixHits(int amount) {
        }

        @Override
        public void fixMisses(int amount) {
        }

        @Override
        public long hitsOffset() {
            return 0L;
        }

        @Override
        public long missOffset() {
            return 0L;
        }
    };
    private final LoadingCache<K, Entry<K, V>> cache;
    private final ThreadLocal<@Nullable Map<K, SettableFuture<V>>> batch;
    private final AsyncCacheLoader<K, V> defaultLoader;
    private final AbstractCache.StatsCounter statsCounter;
    private final StatsFixer statsFixer;

    private ShimAsyncCache(LoadingCache<K, Entry<K, V>> cache, ThreadLocal<@Nullable Map<K, SettableFuture<V>>> batch, AsyncCacheLoader<K, V> loader, AbstractCache.StatsCounter statsCounter, StatsFixer statsFixer) {
        this.cache = cache;
        this.batch = batch;
        this.defaultLoader = loader;
        this.statsCounter = statsCounter;
        this.statsFixer = statsFixer;
    }

    @Override
    public ListenableFuture<V> get(K key) {
        return this.cache.getUnchecked(key).getOrLoadFuture();
    }

    @Override
    public ImmutableMap<K, ListenableFuture<V>> getAll(Iterable<? extends K> keys) {
        return this.getAll(keys, this.defaultLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMap<K, ListenableFuture<V>> getAll(Iterable<? extends K> keys, AsyncCacheLoader<K, V> loader) {
        Map<K, SettableFuture<V>> batched;
        Preconditions.checkNotNull(keys, "keys must not be null");
        Preconditions.checkNotNull(loader, "loader must not be null");
        Preconditions.checkState(this.batch.get() == null, "Cannot call getAll() recursively.");
        ImmutableMap.Builder<K, ListenableFuture<V>> results = ImmutableMap.builder();
        this.batch.set(new LinkedHashMap());
        try {
            for (K key : keys) {
                Entry<K, V> entry = this.cache.getUnchecked(key);
                results.put(key, entry.getOrLoadFuture());
            }
            batched = Objects.requireNonNull(this.batch.get());
        }
        finally {
            this.batch.remove();
        }
        if (!batched.isEmpty()) {
            K key;
            ImmutableSet<K> batchedKeys = ImmutableSet.copyOf(batched.keySet());
            Map<K, ListenableFuture<V>> loadedMap = ShimAsyncCache.loadAllNullHostile(loader, batchedKeys);
            for (Map.Entry<K, ListenableFuture<V>> entry : loadedMap.entrySet()) {
                key = entry.getKey();
                ListenableFuture<V> future = entry.getValue();
                SettableFuture<V> async = batched.remove(key);
                if (async != null) {
                    async.setFuture(future);
                    if (!future.isDone()) continue;
                    results.put(key, future);
                    continue;
                }
                this.makeEntry(key, loader).addFuture(future, RecordCompletion.YES);
            }
            for (Map.Entry<K, ListenableFuture<V>> entry : batched.entrySet()) {
                key = entry.getKey();
                SettableFuture async = (SettableFuture)entry.getValue();
                ListenableFuture<V> loaded = ShimAsyncCache.loadNullHostile(loader, key);
                async.setFuture(loaded);
                if (!loaded.isDone()) continue;
                results.put(key, loaded);
            }
        }
        return results.buildKeepingLast();
    }

    private static <K, V> ListenableFuture<V> loadNullHostile(AsyncCacheLoader<K, V> loader, K key) {
        try {
            return ShimAsyncCache.nullHostileFuture(loader.load(key));
        }
        catch (RuntimeException e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    private static <K, V> Map<K, ListenableFuture<V>> loadAllNullHostile(AsyncCacheLoader<K, V> loader, Set<K> keys) {
        try {
            return Maps.transformValues(loader.loadAll(keys), ShimAsyncCache::nullHostileFuture);
        }
        catch (RuntimeException e) {
            return Maps.toMap(keys, key -> Futures.immediateFailedFuture(e));
        }
    }

    private static <T> ListenableFuture<T> nullHostileFuture(ListenableFuture<T> future) {
        ListenableFuture out = Futures.transform(future, value -> Preconditions.checkNotNull(value, "AsyncLoadingCache is null-hostile."), MoreExecutors.directExecutor());
        return out;
    }

    private Entry<K, V> makeEntry(K key, AsyncCacheLoader<K, V> loader) {
        Entry<K, V> entry = new Entry<K, V>(this.cache, loader, this.batch, key, this.statsCounter, this.statsFixer);
        Entry<K, V> prev = this.cache.asMap().putIfAbsent(key, entry);
        return prev != null ? prev : entry;
    }

    @Override
    @CheckForNull
    public V getIfPresent(Object key) {
        Entry entry = (Entry)this.cache.getIfPresent(key);
        return entry != null ? (V)entry.getIfPresent() : null;
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(value);
        Entry<K, V> entry = (Entry<K, V>)this.cache.getIfPresent(key);
        if (entry == null) {
            this.statsFixer.fixMisses(-1);
            entry = this.makeEntry(key, this.defaultLoader);
        } else {
            this.statsFixer.fixHits(-1);
        }
        entry.addFuture(Futures.immediateFuture(value), RecordCompletion.NO);
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public CacheStats stats() {
        CacheStats hitMissAndEvictionStats = this.cache.stats();
        if (hitMissAndEvictionStats == CacheBuilder.EMPTY_STATS) {
            return CacheBuilder.EMPTY_STATS;
        }
        CacheStats loadExceptionAndTimeStats = this.statsCounter.snapshot();
        return new CacheStats(hitMissAndEvictionStats.hitCount() + this.statsFixer.hitsOffset(), hitMissAndEvictionStats.missCount() + this.statsFixer.missOffset(), loadExceptionAndTimeStats.loadSuccessCount(), loadExceptionAndTimeStats.loadExceptionCount(), loadExceptionAndTimeStats.totalLoadTime(), hitMissAndEvictionStats.evictionCount());
    }

    static <K, V> ShimAsyncCache<K, V> from(CacheBuilder<Object, Object> builder, final AsyncCacheLoader<K, V> loader) {
        Preconditions.checkNotNull(loader);
        final ThreadLocal<@Nullable Map<K, SettableFuture<V>>> batch = new ThreadLocal<Map<K, SettableFuture<V>>>();
        final CacheHolder holder = new CacheHolder();
        final AbstractCache.StatsCounter statsCounter = builder.getStatsCounterSupplier().get();
        final StatsFixer statsFixer = builder.getStatsCounterSupplier() == CacheBuilder.NULL_STATS_COUNTER ? NULL_STATS_FIXER : new SimpleStatsFixer();
        holder.cache = builder.build(new CacheLoader<K, Entry<K, V>>(){

            @Override
            public Entry<K, V> load(K key) {
                return new Entry(holder.cache, loader, batch, key, statsCounter, statsFixer);
            }

            @Override
            public ListenableFuture<Entry<K, V>> reload(K key, Entry<K, V> old) {
                old.maybeLoad(LoadWhen.ALWAYS);
                return Futures.immediateFuture(old);
            }
        });
        return new ShimAsyncCache(holder.cache, batch, loader, statsCounter, statsFixer);
    }

    private static class SimpleStatsFixer
    implements StatsFixer {
        private final LongAddable hitsOffset = LongAddables.create();
        private final LongAddable missOffset = LongAddables.create();

        private SimpleStatsFixer() {
        }

        @Override
        public void fixHits(int amount) {
            this.hitsOffset.add(amount);
        }

        @Override
        public void fixMisses(int amount) {
            this.missOffset.add(amount);
        }

        @Override
        public long hitsOffset() {
            return this.hitsOffset.sum();
        }

        @Override
        public long missOffset() {
            return this.missOffset.sum();
        }
    }

    private static interface StatsFixer {
        public void fixMisses(int var1);

        public void fixHits(int var1);

        public long missOffset();

        public long hitsOffset();
    }

    private static class CacheHolder<K, V> {
        LoadingCache<K, Entry<K, V>> cache;

        private CacheHolder() {
        }
    }

    private static class Entry<K, V> {
        final ConcurrentMap<K, Entry<K, V>> cache;
        final AsyncCacheLoader<K, V> loader;
        final ThreadLocal<@Nullable Map<K, SettableFuture<V>>> batch;
        final K key;
        final AtomicReference<EntryState<V>> state = new AtomicReference<Waiting>(new Waiting(PersistentQueue.empty(), SettableFuture.create(), false));
        final AbstractCache.StatsCounter statsCounter;
        final StatsFixer statsFixer;

        Entry(LoadingCache<K, Entry<K, V>> cache, AsyncCacheLoader<K, V> loader, ThreadLocal<@Nullable Map<K, SettableFuture<V>>> batch, K key, AbstractCache.StatsCounter statsCounter, StatsFixer statsFixer) {
            this.cache = cache.asMap();
            this.loader = loader;
            this.batch = batch;
            this.key = key;
            this.statsCounter = statsCounter;
            this.statsFixer = statsFixer;
        }

        @CheckForNull
        V getIfPresent() {
            return this.state.get().getIfPresent();
        }

        ListenableFuture<V> getOrLoadFuture() {
            return this.state.get().getOrLoadFuture();
        }

        void maybeLoad(LoadWhen when) {
            this.state.get().maybeLoad(when);
        }

        void addFuture(ListenableFuture<V> future, RecordCompletion recordCompletion) {
            this.refreshEntry();
            this.state.get().addFuture(future);
            this.listen(future, recordCompletion);
        }

        void refreshEntry() {
            this.cache.replace(this.key, this, this);
        }

        void listen(ListenableFuture<V> future, RecordCompletion recordCompletion) {
            Stopwatch timer = recordCompletion == RecordCompletion.YES ? Stopwatch.createStarted() : null;
            future.addListener(() -> this.state.get().handleCompletion(future, timer), MoreExecutors.directExecutor());
        }

        void loadOrBatch(SettableFuture<V> async) {
            this.refreshEntry();
            this.listen(async, RecordCompletion.YES);
            Map<K, SettableFuture<SettableFuture<V>>> batched = this.batch.get();
            if (batched != null) {
                batched.put(this.key, async);
            } else {
                async.setFuture(ShimAsyncCache.loadNullHostile(this.loader, this.key));
            }
        }

        class Value
        implements EntryState<V> {
            final V value;
            final PersistentQueue<V> futures;

            Value(V value, PersistentQueue<V> futures) {
                this.value = value;
                this.futures = futures;
            }

            @Override
            public ListenableFuture<V> getOrLoadFuture() {
                return Futures.immediateFuture(this.value);
            }

            @Override
            public V getIfPresent() {
                return this.value;
            }

            @Override
            public void maybeLoad(LoadWhen when) {
                if (when == LoadWhen.ALWAYS) {
                    SettableFuture future = SettableFuture.create();
                    if (Entry.this.state.compareAndSet(this, new Value(this.value, this.futures.add(future)))) {
                        Entry.this.loadOrBatch(future);
                    } else {
                        Entry.this.state.get().maybeLoad(when);
                    }
                }
            }

            @Override
            public void addFuture(ListenableFuture<V> future) {
                if (!Entry.this.state.compareAndSet(this, new Value(this.value, this.futures.add(future)))) {
                    Entry.this.state.get().addFuture(future);
                }
            }

            @Override
            public void handleCompletion(ListenableFuture<V> future, @CheckForNull Stopwatch stopwatch) {
                PersistentQueue newFutures;
                Object newValue = this.value;
                boolean successful = false;
                try {
                    newValue = Uninterruptibles.getUninterruptibly(future);
                    successful = true;
                    newFutures = this.futures.retainNewer(future);
                }
                catch (ExecutionException thrown) {
                    newFutures = this.futures.remove(future);
                }
                catch (RuntimeException thrown) {
                    newFutures = this.futures.remove(future);
                }
                if (newFutures.size() == this.futures.size()) {
                    return;
                }
                if (Entry.this.state.compareAndSet(this, new Value(newValue, newFutures))) {
                    if (stopwatch != null) {
                        long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
                        if (successful) {
                            Entry.this.refreshEntry();
                            Entry.this.statsCounter.recordLoadSuccess(elapsed);
                        } else {
                            Entry.this.statsCounter.recordLoadException(elapsed);
                        }
                    }
                } else {
                    Entry.this.state.get().handleCompletion(future, stopwatch);
                }
            }
        }

        class Waiting
        implements EntryState<V> {
            final PersistentQueue<V> futures;
            final SettableFuture<V> result;
            final boolean fixMissCount;

            Waiting(PersistentQueue<V> futures, SettableFuture<V> result, boolean fixHitMissCount) {
                this.futures = futures;
                this.result = result;
                this.fixMissCount = fixHitMissCount;
            }

            @Override
            public ListenableFuture<V> getOrLoadFuture() {
                this.maybeLoad(LoadWhen.NOT_PENDING_OR_AVAILABLE);
                return Futures.nonCancellationPropagating(this.result);
            }

            @Override
            @CheckForNull
            public V getIfPresent() {
                return null;
            }

            @Override
            public void maybeLoad(LoadWhen when) {
                if (when == LoadWhen.ALWAYS || this.futures.size() == 0) {
                    SettableFuture future = SettableFuture.create();
                    if (Entry.this.state.compareAndSet(this, new Waiting(this.futures.add(future), this.result, false))) {
                        if (this.fixMissCount) {
                            Entry.this.statsFixer.fixHits(-1);
                            Entry.this.statsFixer.fixMisses(1);
                        }
                        Entry.this.loadOrBatch(future);
                    } else {
                        Entry.this.state.get().maybeLoad(when);
                    }
                }
            }

            @Override
            public void addFuture(ListenableFuture<V> future) {
                if (!Entry.this.state.compareAndSet(this, new Waiting(this.futures.add(future), this.result, false))) {
                    Entry.this.state.get().addFuture(future);
                }
            }

            @Override
            public void handleCompletion(ListenableFuture<V> future, @CheckForNull Stopwatch stopwatch) {
                try {
                    Object value = Uninterruptibles.getUninterruptibly(future);
                    if (Entry.this.state.compareAndSet(this, new Value(value, this.futures.retainNewer(future)))) {
                        Entry.this.refreshEntry();
                        if (stopwatch != null) {
                            Entry.this.statsCounter.recordLoadSuccess(stopwatch.elapsed(TimeUnit.NANOSECONDS));
                        }
                        this.result.set(value);
                    } else {
                        Entry.this.state.get().handleCompletion(future, stopwatch);
                    }
                }
                catch (ExecutionException thrown) {
                    this.handleFailure(future, thrown.getCause(), stopwatch);
                }
                catch (RuntimeException thrown) {
                    this.handleFailure(future, thrown, stopwatch);
                }
            }

            private void handleFailure(ListenableFuture<V> future, Throwable cause, @CheckForNull Stopwatch stopwatch) {
                SettableFuture newResult = SettableFuture.create();
                if (Entry.this.state.compareAndSet(this, new Waiting(this.futures.remove(future), newResult, true))) {
                    if (stopwatch != null) {
                        Entry.this.statsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
                    }
                    this.result.setException(cause);
                } else {
                    Entry.this.state.get().handleCompletion(future, stopwatch);
                }
            }
        }

        static interface EntryState<V> {
            @CheckForNull
            public V getIfPresent();

            public ListenableFuture<V> getOrLoadFuture();

            public void maybeLoad(LoadWhen var1);

            public void addFuture(ListenableFuture<V> var1);

            public void handleCompletion(ListenableFuture<V> var1, @CheckForNull Stopwatch var2);
        }
    }

    private static enum RecordCompletion {
        YES,
        NO;

    }

    private static enum LoadWhen {
        NOT_PENDING_OR_AVAILABLE,
        ALWAYS;

    }

    private static class PersistentQueue<V> {
        final ImmutableList<ListenableFuture<V>> futures;

        PersistentQueue(ImmutableList<ListenableFuture<V>> futures) {
            this.futures = futures;
        }

        @CheckReturnValue
        PersistentQueue<V> add(ListenableFuture<V> future) {
            return new PersistentQueue<V>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(future)).addAll(this.futures)).build());
        }

        @CheckReturnValue
        PersistentQueue<V> retainNewer(ListenableFuture<V> last) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenableFuture listenableFuture : this.futures) {
                if (listenableFuture == last) {
                    return new PersistentQueue<V>(builder.build());
                }
                builder.add(listenableFuture);
            }
            return this;
        }

        @CheckReturnValue
        PersistentQueue<V> remove(ListenableFuture<V> toRemove) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenableFuture listenableFuture : this.futures) {
                if (listenableFuture.equals(toRemove)) continue;
                builder.add(listenableFuture);
            }
            return new PersistentQueue<V>(builder.build());
        }

        int size() {
            return this.futures.size();
        }

        static <V> PersistentQueue<V> empty() {
            return new PersistentQueue<V>(ImmutableList.of());
        }
    }
}

