/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FetchOptions
implements Serializable {
    static final long serialVersionUID = 3904557385413253999L;
    public static final boolean DEFAULT_ALLOW_TRUNCATE = false;
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    public static final @Nullable Double DEFAULT_DEADLINE = null;
    private boolean allowTruncate = false;
    private boolean followRedirects = true;
    private @Nullable Double deadline = DEFAULT_DEADLINE;
    private CertificateValidationBehavior certificateValidationBehavior = CertificateValidationBehavior.DEFAULT;

    private FetchOptions() {
    }

    public FetchOptions allowTruncate() {
        this.allowTruncate = true;
        return this;
    }

    public FetchOptions disallowTruncate() {
        this.allowTruncate = false;
        return this;
    }

    public FetchOptions followRedirects() {
        this.followRedirects = true;
        return this;
    }

    public FetchOptions validateCertificate() {
        this.certificateValidationBehavior = CertificateValidationBehavior.VALIDATE;
        return this;
    }

    public FetchOptions doNotValidateCertificate() {
        this.certificateValidationBehavior = CertificateValidationBehavior.DO_NOT_VALIDATE;
        return this;
    }

    public FetchOptions setDeadline(Double deadline) {
        if (deadline != null && deadline <= 0.0) {
            String string = String.valueOf(deadline);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Deadline must be > 0, got ").append(string).toString());
        }
        this.deadline = deadline;
        return this;
    }

    public FetchOptions doNotFollowRedirects() {
        this.followRedirects = false;
        return this;
    }

    public boolean getAllowTruncate() {
        return this.allowTruncate;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    CertificateValidationBehavior getCertificateValidationBehavior() {
        if (this.certificateValidationBehavior == CertificateValidationBehavior.DEFAULT && Boolean.getBoolean("appengine.api.urlfetch.defaultTlsValidation")) {
            return CertificateValidationBehavior.VALIDATE;
        }
        return this.certificateValidationBehavior;
    }

    public @Nullable Double getDeadline() {
        return this.deadline;
    }

    public boolean getValidateCertificate() {
        return this.certificateValidationBehavior == CertificateValidationBehavior.VALIDATE;
    }

    public static final class Builder {
        public static FetchOptions allowTruncate() {
            return Builder.withDefaults().allowTruncate();
        }

        public static FetchOptions disallowTruncate() {
            return Builder.withDefaults().disallowTruncate();
        }

        public static FetchOptions followRedirects() {
            return Builder.withDefaults().followRedirects();
        }

        public static FetchOptions doNotFollowRedirects() {
            return Builder.withDefaults().doNotFollowRedirects();
        }

        public static FetchOptions validateCertificate() {
            return Builder.withDefaults().validateCertificate();
        }

        public static FetchOptions doNotValidateCertificate() {
            return Builder.withDefaults().doNotValidateCertificate();
        }

        public static FetchOptions withDeadline(double deadline) {
            return Builder.withDefaults().setDeadline(deadline);
        }

        public static FetchOptions withDefaults() {
            return new FetchOptions();
        }

        private Builder() {
        }
    }

    static enum CertificateValidationBehavior {
        DEFAULT,
        VALIDATE,
        DO_NOT_VALIDATE;

    }
}

