/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.compilation;

import com.google.appengine.api.datastore.CallbackContext;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.PostDelete;
import com.google.appengine.api.datastore.PostLoad;
import com.google.appengine.api.datastore.PostLoadContext;
import com.google.appengine.api.datastore.PostPut;
import com.google.appengine.api.datastore.PreDelete;
import com.google.appengine.api.datastore.PreGet;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PrePut;
import com.google.appengine.api.datastore.PreQuery;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.tools.compilation.DatastoreCallbacksConfigWriter;
import com.google.auto.common.MoreElements;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.google.appengine.api.datastore.PrePut", "com.google.appengine.api.datastore.PostPut", "com.google.appengine.api.datastore.PreDelete", "com.google.appengine.api.datastore.PostDelete", "com.google.appengine.api.datastore.PreGet", "com.google.appengine.api.datastore.PostLoad", "com.google.appengine.api.datastore.PreQuery"})
@SupportedOptions(value={"debug"})
public class DatastoreCallbacksProcessor
extends AbstractProcessor {
    private static final String CALLBACKS_CONFIG_FILE = "META-INF/datastorecallbacks.xml";
    private final OutputStream configOutputStream;
    private DatastoreCallbacksConfigWriter callbacksConfigWriter;
    private final Set<Element> verifiedClasses = Sets.newHashSet();
    final Map<Class<? extends Annotation>, CallbackVerifier> callbackVerifiers = new ImmutableMap.Builder<Class<PrePut>, SingleParamCallbackVerifier>().put(PrePut.class, new SingleParamCallbackVerifier(this, PrePut.class, PutContext.class)).put(PostPut.class, new SingleParamCallbackVerifier(this, PostPut.class, PutContext.class)).put(PreDelete.class, new SingleParamCallbackVerifier(this, PreDelete.class, DeleteContext.class)).put(PostDelete.class, new SingleParamCallbackVerifier(this, PostDelete.class, DeleteContext.class)).put(PreGet.class, new SingleParamCallbackVerifier(this, PreGet.class, PreGetContext.class)).put(PostLoad.class, new SingleParamCallbackVerifier(this, PostLoad.class, PostLoadContext.class)).put(PreQuery.class, new SingleParamCallbackVerifier(this, PreQuery.class, PreQueryContext.class)).buildOrThrow();

    public DatastoreCallbacksProcessor() {
        this(null);
    }

    @VisibleForTesting
    DatastoreCallbacksProcessor(OutputStream configOutputStream) {
        this.configOutputStream = configOutputStream;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (RuntimeException e) {
            this.error(Throwables.getStackTraceAsString(e), null);
            return false;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.callbacksConfigWriter == null) {
            this.loadCallbacksConfigWriter();
        }
        if (roundEnv.processingOver()) {
            if (roundEnv.errorRaised()) {
                this.log("Not writing config file due to errors.");
            } else {
                this.generateConfigFiles();
            }
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void loadCallbacksConfigWriter() {
        try {
            FileObject existingFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", CALLBACKS_CONFIG_FILE);
            InputStream inputStream = null;
            if (existingFile != null) {
                try {
                    inputStream = existingFile.openInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.callbacksConfigWriter = new DatastoreCallbacksConfigWriter(inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read %s", CALLBACKS_CONFIG_FILE), e);
        }
    }

    OutputStream getConfigOutputStream() throws IOException {
        if (this.configOutputStream != null) {
            return this.configOutputStream;
        }
        Filer filer = this.processingEnv.getFiler();
        FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", CALLBACKS_CONFIG_FILE, new Element[0]);
        return fileObject.openOutputStream();
    }

    private void generateConfigFiles() {
        try (OutputStream outputStream = this.getConfigOutputStream();){
            this.callbacksConfigWriter.store(outputStream);
            this.log("Wrote config: " + this.callbacksConfigWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to create %s", CALLBACKS_CONFIG_FILE), e);
        }
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedMethods = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedMethods) {
                String enclosingClass = this.getBinaryName(MoreElements.asType((Element)element.getEnclosingElement()));
                String method = element.getSimpleName().toString();
                Set<String> kinds = this.verifyCallback(MoreElements.asExecutable((Element)element), typeElement, enclosingClass, method);
                if (roundEnv.errorRaised()) continue;
                this.callbacksConfigWriter.addCallback(kinds, typeElement.getSimpleName().toString(), enclosingClass, method);
            }
        }
    }

    private Set<String> extractKindsFromCallbackAnnotation(Element annotatedMethod, AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValueMap = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
        LinkedHashSet<String> kinds = Sets.newLinkedHashSet();
        for (ExecutableElement executableElement : annotationValueMap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals("kinds")) continue;
            Object value = annotationValueMap.get(executableElement).getValue();
            if (value instanceof String) {
                this.addKind((String)value, annotatedMethod, kinds);
                break;
            }
            for (AnnotationValue av : (List)value) {
                this.addKind(av.getValue().toString(), annotatedMethod, kinds);
            }
        }
        return kinds;
    }

    private void addKind(String kind, Element annotatedMethod, Set<String> kinds) {
        if ((kind = kind.trim()).isEmpty()) {
            this.error("A callback cannot be associated with an empty kind.", annotatedMethod);
        } else {
            kinds.add(kind);
        }
    }

    private Set<String> verifyCallback(ExecutableElement annotatedMethod, TypeElement annotationElement, String cls, String method) {
        CallbackVerifier verifier;
        Element classElement = annotatedMethod.getEnclosingElement();
        if (this.verifiedClasses.add(classElement)) {
            boolean hasNoArgConstructor = false;
            for (ExecutableElement ctor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                if (!ctor.getParameters().isEmpty()) continue;
                hasNoArgConstructor = true;
                break;
            }
            if (!hasNoArgConstructor) {
                this.error("A class with a callback method must have a no-arg constructor.", classElement);
            }
        }
        if (this.callbacksConfigWriter.hasCallback(cls, method)) {
            this.error("Method can only have one callback annotation.", annotatedMethod);
        }
        if (annotatedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            this.error("Callback method must not be static.", annotatedMethod);
        }
        if (!annotatedMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            this.error("Return type of callback method must be void.", annotatedMethod);
        }
        for (TypeMirror typeMirror : annotatedMethod.getThrownTypes()) {
            if (this.isSubTypeOfOneOf(typeMirror, RuntimeException.class, Error.class)) continue;
            this.error("Callback methods cannot throw checked exceptions.", annotatedMethod);
        }
        AnnotationMirror annotationMirror = this.getAnnotationMirror(annotatedMethod, annotationElement);
        Set<String> set = this.extractKindsFromCallbackAnnotation(annotatedMethod, annotationMirror);
        try {
            verifier = this.callbackVerifiers.get(Class.forName(annotationElement.getQualifiedName().toString()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (verifier == null) {
            throw new RuntimeException("No verifier registered for " + annotationElement.getQualifiedName());
        }
        verifier.verify(annotatedMethod);
        return set;
    }

    private boolean isSubTypeOfOneOf(TypeMirror typeMirror, Class<?> ... classes) {
        for (Class<?> cls : classes) {
            if (!this.processingEnv.getTypeUtils().isSubtype(typeMirror, this.getTypeMirror(cls))) continue;
            return true;
        }
        return false;
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(Element element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = MoreElements.asPackage((Element)enclosingElement);
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        return this.getBinaryNameImpl(enclosingElement, enclosingElement.getSimpleName() + "$" + className);
    }

    private AnnotationMirror getAnnotationMirror(Element annotatedMethod, TypeElement annotationElement) {
        return Iterables.find(annotatedMethod.getAnnotationMirrors(), mirror -> {
            DeclaredType type = mirror.getAnnotationType();
            TypeElement typeElement = MoreElements.asType((Element)type.asElement());
            return typeElement.getQualifiedName().contentEquals(annotationElement.getQualifiedName());
        });
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Datastore Callbacks: " + msg);
        }
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Datastore Callbacks: " + msg, element);
    }

    private TypeMirror getTypeMirror(Class<?> cls) {
        return this.processingEnv.getElementUtils().getTypeElement(cls.getName()).asType();
    }

    class SingleParamCallbackVerifier
    extends BaseCallbackVerifier {
        private final Class<? extends CallbackContext<?>> callbackContextClass;

        SingleParamCallbackVerifier(DatastoreCallbacksProcessor this$0, Class<? extends Annotation> callbackType, Class<? extends CallbackContext<?>> callbackContextClass) {
            super(callbackType);
            this.callbackContextClass = callbackContextClass;
        }

        @Override
        public void verify(ExecutableElement annotatedMethod) {
            this.verifySingleParamIsOfProperType(annotatedMethod, this.callbackContextClass);
        }
    }

    abstract class BaseCallbackVerifier
    implements CallbackVerifier {
        final Class<? extends Annotation> callbackType;

        BaseCallbackVerifier(Class<? extends Annotation> callbackType) {
            this.callbackType = callbackType;
        }

        void verifySingleParamIsOfProperType(ExecutableElement annotatedMethod, Class<? extends CallbackContext<?>> expectedType) {
            if (annotatedMethod.getParameters().size() != 1 || !DatastoreCallbacksProcessor.this.processingEnv.getTypeUtils().isSameType(annotatedMethod.getParameters().get(0).asType(), DatastoreCallbacksProcessor.this.getTypeMirror(expectedType))) {
                DatastoreCallbacksProcessor.this.error(String.format("%s method must have a single argument of type '%s'.", this.callbackType.getSimpleName(), expectedType.getName()), annotatedMethod);
            }
        }
    }

    static interface CallbackVerifier {
        public void verify(ExecutableElement var1);
    }
}

