/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.html.types.BuilderUtils;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtml;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtmls;
import com.google.appengine.repackaged.com.google.common.html.types.SafeScript;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyle;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyleSheet;
import com.google.appengine.repackaged.com.google.common.html.types.SafeUrl;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@CheckReturnValue
@GwtCompatible
@NotThreadSafe
public final class SafeHtmlBuilder {
    private static final String VALID_ELEMENT_NAMES_REGEXP = "[a-z0-9-]+";
    private static final String VALID_DATA_ATTRIBUTES_REGEXP = "data-[a-zA-Z-]+";
    private static final ImmutableSet<String> UNSUPPORTED_ELEMENTS = ImmutableSet.of("applet", "base", "embed", "math", "meta", "object", new String[]{"svg", "template"});
    private static final ImmutableSet<String> SCRIPT_ELEMENTS = ImmutableSet.of("script");
    private static final ImmutableSet<String> STYLESHEET_ELEMENTS = ImmutableSet.of("style");
    private static final ImmutableSet<String> VOID_ELEMENTS = ImmutableSet.of("area", "br", "col", "hr", "img", "input", new String[]{"link", "param", "source", "track", "wbr"});
    private final String elementName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<String> contents = new ArrayList<String>();
    private boolean useSlashOnVoid = false;
    private AttributeContract hrefValueContract = AttributeContract.TRUSTED_RESOURCE_URL;
    private static final ImmutableSet<String> ACCEPT_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input");
    private static final ImmutableSet<String> ACTION_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("form");
    private static final ImmutableSet<String> DEFER_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("script");
    private static final ImmutableSet<String> FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("button", "input");
    private static final ImmutableSet<String> FORMMETHOD_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("button", "input");
    private static final ImmutableSet<String> HREF_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("a", "area");
    private static final ImmutableSet<String> LINK_HREF_SAFE_URL_REL_ALLOWLIST = ImmutableSet.of("alternate", "author", "bookmark", "canonical", "cite", "help", new String[]{"icon", "license", "next", "prefetch", "dns-prefetch", "prerender", "preconnect", "preload", "prev", "search", "subresource"});
    private static final ImmutableSet<String> METHOD_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("form");
    private static final ImmutableSet<String> PATTERN_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input");
    private static final ImmutableSet<String> READONLY_STRING_ELEMENT_ALLOWLIST = ImmutableSet.of("input", "textarea");
    private static final ImmutableSet<String> SRC_SAFE_URL_ELEMENT_ALLOWLIST = ImmutableSet.of("audio", "img", "input", "source", "video");
    private static final ImmutableSet<String> SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST = ImmutableSet.of("iframe");

    public SafeHtmlBuilder(@CompileTimeConstant String elementName) {
        if (elementName == null) {
            throw new NullPointerException();
        }
        if (!elementName.matches(VALID_ELEMENT_NAMES_REGEXP)) {
            throw new IllegalArgumentException("Invalid element name \"" + elementName + "\". Only lowercase letters, numbers and '-' allowed.");
        }
        if (UNSUPPORTED_ELEMENTS.contains(elementName)) {
            throw new IllegalArgumentException("Element \"" + elementName + "\" is not supported.");
        }
        this.elementName = elementName;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder useSlashOnVoid() {
        this.useSlashOnVoid = true;
        return this;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAccept(String value) {
        if (!ACCEPT_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"accept\" with a String value can only be used by one of the following elements: " + ACCEPT_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("accept", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAction(SafeUrl value) {
        if (!ACTION_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"action\" with a SafeUrl value can only be used by one of the following elements: " + ACTION_SAFE_URL_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("action", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAlign(String value) {
        return this.setAttribute("align", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAlt(String value) {
        return this.setAttribute("alt", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaActivedescendant(@CompileTimeConstant String value) {
        return this.setAttribute("aria-activedescendant", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaActivedescendantWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-activedescendant", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaAtomic(String value) {
        return this.setAttribute("aria-atomic", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaAutocomplete(String value) {
        return this.setAttribute("aria-autocomplete", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaBusy(String value) {
        return this.setAttribute("aria-busy", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaChecked(String value) {
        return this.setAttribute("aria-checked", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaControls(@CompileTimeConstant String value) {
        return this.setAttribute("aria-controls", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaControlsWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-controls", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaCurrent(String value) {
        return this.setAttribute("aria-current", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaDisabled(String value) {
        return this.setAttribute("aria-disabled", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaDropeffect(String value) {
        return this.setAttribute("aria-dropeffect", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaExpanded(String value) {
        return this.setAttribute("aria-expanded", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaHaspopup(String value) {
        return this.setAttribute("aria-haspopup", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaHidden(String value) {
        return this.setAttribute("aria-hidden", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaInvalid(String value) {
        return this.setAttribute("aria-invalid", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaLabel(String value) {
        return this.setAttribute("aria-label", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaLabelledby(@CompileTimeConstant String value) {
        return this.setAttribute("aria-labelledby", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaLabelledbyWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-labelledby", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaLevel(String value) {
        return this.setAttribute("aria-level", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaLive(String value) {
        return this.setAttribute("aria-live", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaMultiline(String value) {
        return this.setAttribute("aria-multiline", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaMultiselectable(String value) {
        return this.setAttribute("aria-multiselectable", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaOrientation(String value) {
        return this.setAttribute("aria-orientation", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaOwns(@CompileTimeConstant String value) {
        return this.setAttribute("aria-owns", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaOwnsWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("aria-owns", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaPosinset(String value) {
        return this.setAttribute("aria-posinset", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaPressed(String value) {
        return this.setAttribute("aria-pressed", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaReadonly(String value) {
        return this.setAttribute("aria-readonly", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaRelevant(String value) {
        return this.setAttribute("aria-relevant", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaRequired(String value) {
        return this.setAttribute("aria-required", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaSelected(String value) {
        return this.setAttribute("aria-selected", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaSetsize(String value) {
        return this.setAttribute("aria-setsize", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaSort(String value) {
        return this.setAttribute("aria-sort", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaValuemax(String value) {
        return this.setAttribute("aria-valuemax", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaValuemin(String value) {
        return this.setAttribute("aria-valuemin", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaValuenow(String value) {
        return this.setAttribute("aria-valuenow", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAriaValuetext(String value) {
        return this.setAttribute("aria-valuetext", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAsync(AsyncValue value) {
        return this.setAttribute("async", value.toString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAutocapitalize(String value) {
        return this.setAttribute("autocapitalize", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAutocomplete(String value) {
        return this.setAttribute("autocomplete", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAutocorrect(String value) {
        return this.setAttribute("autocorrect", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAutofocus(String value) {
        return this.setAttribute("autofocus", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setAutoplay(String value) {
        return this.setAttribute("autoplay", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setBgcolor(String value) {
        return this.setAttribute("bgcolor", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setBorder(String value) {
        return this.setAttribute("border", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setCellpadding(String value) {
        return this.setAttribute("cellpadding", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setCellspacing(String value) {
        return this.setAttribute("cellspacing", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setChecked(String value) {
        return this.setAttribute("checked", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setCite(SafeUrl value) {
        return this.setAttribute("cite", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setClass(String value) {
        return this.setAttribute("class", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setColor(String value) {
        return this.setAttribute("color", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setCols(String value) {
        return this.setAttribute("cols", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setColspan(String value) {
        return this.setAttribute("colspan", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setContenteditable(String value) {
        return this.setAttribute("contenteditable", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setControls(String value) {
        return this.setAttribute("controls", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDatetime(String value) {
        return this.setAttribute("datetime", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDefer(String value) {
        if (!DEFER_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"defer\" with a String value can only be used by one of the following elements: " + DEFER_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("defer", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDir(DirValue value) {
        return this.setAttribute("dir", value.toString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDisabled(String value) {
        return this.setAttribute("disabled", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDownload(String value) {
        return this.setAttribute("download", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDraggable(String value) {
        return this.setAttribute("draggable", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setEnctype(String value) {
        return this.setAttribute("enctype", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFace(String value) {
        return this.setAttribute("face", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFor(@CompileTimeConstant String value) {
        return this.setAttribute("for", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setForWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("for", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFormaction(SafeUrl value) {
        if (!FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"formaction\" with a SafeUrl value can only be used by one of the following elements: " + FORMACTION_SAFE_URL_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("formaction", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFormenctype(String value) {
        return this.setAttribute("formenctype", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFormmethod(String value) {
        if (!FORMMETHOD_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"formmethod\" with a String value can only be used by one of the following elements: " + FORMMETHOD_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("formmethod", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setFrameborder(String value) {
        return this.setAttribute("frameborder", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setHeight(String value) {
        return this.setAttribute("height", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setHidden(String value) {
        return this.setAttribute("hidden", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setHref(SafeUrl value) {
        if (!HREF_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName) && !this.elementName.equals("link")) {
            throw new IllegalArgumentException("Attribute \"href\" with a SafeUrl value can only be used by one of the following elements: " + HREF_SAFE_URL_ELEMENT_ALLOWLIST);
        }
        if (this.elementName.equals("link")) {
            SafeHtmlBuilder.checkLinkDependentAttributes(this.attributes.get("rel"), AttributeContract.SAFE_URL);
        }
        this.hrefValueContract = AttributeContract.SAFE_URL;
        return this.setAttribute("href", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setHref(TrustedResourceUrl value) {
        this.hrefValueContract = AttributeContract.TRUSTED_RESOURCE_URL;
        return this.setAttribute("href", value.getTrustedResourceUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setHreflang(String value) {
        return this.setAttribute("hreflang", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setId(@CompileTimeConstant String value) {
        return this.setAttribute("id", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setIdWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("id", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setIsmap(String value) {
        return this.setAttribute("ismap", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setItemid(String value) {
        return this.setAttribute("itemid", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setItemprop(String value) {
        return this.setAttribute("itemprop", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setItemref(String value) {
        return this.setAttribute("itemref", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setItemscope(String value) {
        return this.setAttribute("itemscope", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setItemtype(String value) {
        return this.setAttribute("itemtype", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setLabel(String value) {
        return this.setAttribute("label", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setLang(String value) {
        return this.setAttribute("lang", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setList(@CompileTimeConstant String value) {
        return this.setAttribute("list", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setListWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("list", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setLoading(LoadingValue value) {
        return this.setAttribute("loading", value.toString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setLoop(String value) {
        return this.setAttribute("loop", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMax(String value) {
        return this.setAttribute("max", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMaxlength(String value) {
        return this.setAttribute("maxlength", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMedia(String value) {
        return this.setAttribute("media", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMethod(String value) {
        if (!METHOD_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"method\" with a String value can only be used by one of the following elements: " + METHOD_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("method", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMin(String value) {
        return this.setAttribute("min", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMinlength(String value) {
        return this.setAttribute("minlength", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMultiple(String value) {
        return this.setAttribute("multiple", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setMuted(String value) {
        return this.setAttribute("muted", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setName(@CompileTimeConstant String value) {
        return this.setAttribute("name", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setNameWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("name", prefix + "-" + value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setNonce(String value) {
        return this.setAttribute("nonce", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setOpen(String value) {
        return this.setAttribute("open", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setPattern(String value) {
        if (!PATTERN_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"pattern\" with a String value can only be used by one of the following elements: " + PATTERN_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("pattern", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setPlaceholder(String value) {
        return this.setAttribute("placeholder", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setPoster(SafeUrl value) {
        return this.setAttribute("poster", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setPreload(String value) {
        return this.setAttribute("preload", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setReadonly(String value) {
        if (!READONLY_STRING_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"readonly\" with a String value can only be used by one of the following elements: " + READONLY_STRING_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("readonly", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setRel(String value) {
        if (this.elementName.equals("link")) {
            SafeHtmlBuilder.checkLinkDependentAttributes(value, this.hrefValueContract);
        }
        return this.setAttribute("rel", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setRequired(String value) {
        return this.setAttribute("required", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setReversed(String value) {
        return this.setAttribute("reversed", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setRole(String value) {
        return this.setAttribute("role", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setRows(String value) {
        return this.setAttribute("rows", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setRowspan(String value) {
        return this.setAttribute("rowspan", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSelected(String value) {
        return this.setAttribute("selected", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setShape(String value) {
        return this.setAttribute("shape", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSize(String value) {
        return this.setAttribute("size", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSizes(String value) {
        return this.setAttribute("sizes", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSlot(String value) {
        return this.setAttribute("slot", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSpan(String value) {
        return this.setAttribute("span", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSpellcheck(String value) {
        return this.setAttribute("spellcheck", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSrc(SafeUrl value) {
        if (!SRC_SAFE_URL_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"src\" with a SafeUrl value can only be used by one of the following elements: " + SRC_SAFE_URL_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("src", value.getSafeUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSrc(TrustedResourceUrl value) {
        return this.setAttribute("src", value.getTrustedResourceUrlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSrcdoc(SafeHtml value) {
        if (!SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"srcdoc\" with a SafeHtml value can only be used by one of the following elements: " + SRCDOC_SAFE_HTML_ELEMENT_ALLOWLIST);
        }
        return this.setAttribute("srcdoc", value.getSafeHtmlString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setStart(String value) {
        return this.setAttribute("start", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setStep(String value) {
        return this.setAttribute("step", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setStyle(SafeStyle value) {
        return this.setAttribute("style", value.getSafeStyleString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setSummary(String value) {
        return this.setAttribute("summary", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setTabindex(String value) {
        return this.setAttribute("tabindex", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setTarget(TargetValue value) {
        return this.setAttribute("target", value.toString());
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setTitle(String value) {
        return this.setAttribute("title", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setTranslate(String value) {
        return this.setAttribute("translate", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setType(String value) {
        return this.setAttribute("type", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setValign(String value) {
        return this.setAttribute("valign", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setValue(String value) {
        return this.setAttribute("value", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setWidth(String value) {
        return this.setAttribute("width", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setWrap(String value) {
        return this.setAttribute("wrap", value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder setDataAttribute(@CompileTimeConstant String name, String value) {
        if (!name.matches(VALID_DATA_ATTRIBUTES_REGEXP)) {
            throw new IllegalArgumentException("Invalid data attribute name \"" + name + "\".Name must start with \"data-\" and be followed by letters and '-'.");
        }
        return this.setAttribute(name, value);
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder appendContent(SafeHtml ... htmls) {
        this.appendContent(Arrays.asList(htmls));
        return this;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder appendContent(Iterable<SafeHtml> htmls) {
        this.appendContent(htmls.iterator());
        return this;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder appendContent(Iterator<SafeHtml> htmls) {
        this.checkSafeHtmlElement();
        while (htmls.hasNext()) {
            this.contents.add(htmls.next().getSafeHtmlString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder appendScriptContent(SafeScript script) {
        this.checkSafeScriptElement();
        this.contents.add(script.getSafeScriptString());
        return this;
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder appendStyleContent(SafeStyleSheet style) {
        this.checkSafeStyleSheetElement();
        this.contents.add(style.getSafeStyleSheetString());
        return this;
    }

    private static void checkLinkDependentAttributes(@Nullable String relValue, AttributeContract hrefValueContract) {
        if (hrefValueContract.equals((Object)AttributeContract.SAFE_URL) && relValue != null && !LINK_HREF_SAFE_URL_REL_ALLOWLIST.contains(relValue.toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException("SafeUrl values for the href attribute are not allowed on <link rel=" + relValue + ">. Did you intend to use a TrustedResourceUrl?");
        }
    }

    private void checkSafeHtmlElement() {
        this.checkNotVoidElement();
        Preconditions.checkState(!SCRIPT_ELEMENTS.contains(this.elementName), "Element \"" + this.elementName + "\" requires SafeScript contents, not SafeHTML or text.");
        Preconditions.checkState(!STYLESHEET_ELEMENTS.contains(this.elementName), "Element \"" + this.elementName + "\" requires SafeStyleSheet contents, not SafeHTML or text.");
    }

    private void checkSafeScriptElement() {
        Preconditions.checkState(SCRIPT_ELEMENTS.contains(this.elementName), "Element \"" + this.elementName + "\" must not contain SafeScript.");
    }

    private void checkSafeStyleSheetElement() {
        Preconditions.checkState(STYLESHEET_ELEMENTS.contains(this.elementName), "Element \"" + this.elementName + "\" must not contain SafeStyleSheet.");
    }

    private void checkNotVoidElement() {
        Preconditions.checkState(!VOID_ELEMENTS.contains(this.elementName), "Element \"" + this.elementName + "\" is a void element and so cannot have content.");
    }

    @CanIgnoreReturnValue
    public SafeHtmlBuilder escapeAndAppendContent(String text) {
        return this.appendContent(SafeHtmls.htmlEscape(text));
    }

    public SafeHtml build() {
        StringBuilder sb = new StringBuilder("<" + this.elementName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sb.append(" " + entry.getKey() + "=\"" + BuilderUtils.escapeHtmlInternal(entry.getValue()) + "\"");
        }
        boolean isVoid = VOID_ELEMENTS.contains(this.elementName);
        if (isVoid && this.useSlashOnVoid) {
            sb.append("/");
        }
        sb.append(">");
        if (!isVoid) {
            for (String content : this.contents) {
                sb.append(content);
            }
            sb.append("</" + this.elementName + ">");
        }
        return SafeHtmls.create(sb.toString());
    }

    @CanIgnoreReturnValue
    private SafeHtmlBuilder setAttribute(@CompileTimeConstant String name, String value) {
        if (value == null) {
            throw new NullPointerException("setAttribute requires a non-null value.");
        }
        this.attributes.put(name, BuilderUtils.coerceToInterchangeValid(value));
        return this;
    }

    private static enum AttributeContract {
        SAFE_URL,
        TRUSTED_RESOURCE_URL;

    }

    public static enum AsyncValue {
        ASYNC("async");

        private final String value;

        private AsyncValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DirValue {
        AUTO("auto"),
        LTR("ltr"),
        RTL("rtl");

        private final String value;

        private DirValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LoadingValue {
        EAGER("eager"),
        LAZY("lazy");

        private final String value;

        private LoadingValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TargetValue {
        BLANK("_blank"),
        SELF("_self");

        private final String value;

        private TargetValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

