/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.base.protos.Codes;
import java.util.Collection;
import java.util.HashSet;

@AppEngineInternal
public final class RequestStatusUtil {
    private static final ImmutableMap<SearchServicePb.SearchServiceError.ErrorCode, Codes.Code> REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put(SearchServicePb.SearchServiceError.ErrorCode.OK, Codes.Code.OK).put(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, Codes.Code.INVALID_ARGUMENT).put(SearchServicePb.SearchServiceError.ErrorCode.TRANSIENT_ERROR, Codes.Code.UNAVAILABLE).put(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, Codes.Code.INTERNAL).put(SearchServicePb.SearchServiceError.ErrorCode.PERMISSION_DENIED, Codes.Code.PERMISSION_DENIED).put(SearchServicePb.SearchServiceError.ErrorCode.TIMEOUT, Codes.Code.DEADLINE_EXCEEDED).put(SearchServicePb.SearchServiceError.ErrorCode.CONCURRENT_TRANSACTION, Codes.Code.ABORTED).build();

    public static Codes.Code toCanonicalCode(SearchServicePb.SearchServiceError.ErrorCode appCode) {
        return Preconditions.checkNotNull(REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING.get(appCode));
    }

    public static SearchServicePb.RequestStatus.Builder newStatusBuilder(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        SearchServicePb.RequestStatus.Builder builder = SearchServicePb.RequestStatus.newBuilder();
        builder.setCode(code).setCanonicalCode(RequestStatusUtil.toCanonicalCode(code).getNumber());
        if (message != null) {
            builder.setErrorDetail(message);
        }
        return builder;
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        return RequestStatusUtil.newStatusBuilder(code, message).build();
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code) {
        return RequestStatusUtil.newStatusBuilder(code, null).build();
    }

    public static SearchServicePb.RequestStatus newInvalidRequestStatus(IllegalArgumentException e) {
        Preconditions.checkNotNull(e.getMessage());
        return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, e.getMessage());
    }

    public static SearchServicePb.RequestStatus newUnknownIndexStatus(SearchServicePb.IndexSpec indexSpec) {
        return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK, String.format("Index '%s' in namespace '%s' does not exist", indexSpec.getName(), indexSpec.getNamespace()));
    }

    public static SearchServicePb.RequestStatus reduce(Collection<SearchServicePb.RequestStatus> statuses) {
        if (statuses.isEmpty()) {
            return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK);
        }
        if (statuses.size() == 1) {
            return Iterables.getOnlyElement(statuses);
        }
        SearchServicePb.SearchServiceError.ErrorCode errorCode = SearchServicePb.SearchServiceError.ErrorCode.OK;
        HashSet<String> errorDetails = null;
        for (SearchServicePb.RequestStatus status : statuses) {
            if (status.getCode() == SearchServicePb.SearchServiceError.ErrorCode.OK) continue;
            if (errorDetails == null) {
                errorDetails = new HashSet<String>();
            }
            errorDetails.add(status.getErrorDetail());
            if (status.getCode().getNumber() <= errorCode.getNumber()) continue;
            errorCode = status.getCode();
        }
        if (errorDetails == null) {
            return RequestStatusUtil.newStatus(errorCode);
        }
        return RequestStatusUtil.newStatus(errorCode, Joiner.on("; ").join(errorDetails));
    }
}

