package com.google.appengine.api.datastore;

import com.google.common.collect.ImmutableSet;
import java.security.PrivateKey;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DatastoreServiceGlobalConfig extends DatastoreServiceGlobalConfig {

  private final boolean useApiProxy;

  private final String hostOverride;

  private final ImmutableSet<String> additionalAppIds;

  private final boolean installApiProxyEnvironment;

  private final String appId;

  private final String projectId;

  private final boolean useProjectIdAsAppId;

  private final String emulatorHost;

  private final String accessToken;

  private final String serviceAccount;

  private final PrivateKey privateKey;

  private final String privateKeyFile;

  private final boolean useComputeEngineCredential;

  private final int maxRetries;

  private final int httpConnectTimeoutMillis;

  private final boolean asyncStackTraceCaptureEnabled;

  private AutoValue_DatastoreServiceGlobalConfig(
      boolean useApiProxy,
      @Nullable String hostOverride,
      @Nullable ImmutableSet<String> additionalAppIds,
      boolean installApiProxyEnvironment,
      @Nullable String appId,
      @Nullable String projectId,
      boolean useProjectIdAsAppId,
      @Nullable String emulatorHost,
      @Nullable String accessToken,
      @Nullable String serviceAccount,
      @Nullable PrivateKey privateKey,
      @Nullable String privateKeyFile,
      boolean useComputeEngineCredential,
      int maxRetries,
      int httpConnectTimeoutMillis,
      boolean asyncStackTraceCaptureEnabled) {
    this.useApiProxy = useApiProxy;
    this.hostOverride = hostOverride;
    this.additionalAppIds = additionalAppIds;
    this.installApiProxyEnvironment = installApiProxyEnvironment;
    this.appId = appId;
    this.projectId = projectId;
    this.useProjectIdAsAppId = useProjectIdAsAppId;
    this.emulatorHost = emulatorHost;
    this.accessToken = accessToken;
    this.serviceAccount = serviceAccount;
    this.privateKey = privateKey;
    this.privateKeyFile = privateKeyFile;
    this.useComputeEngineCredential = useComputeEngineCredential;
    this.maxRetries = maxRetries;
    this.httpConnectTimeoutMillis = httpConnectTimeoutMillis;
    this.asyncStackTraceCaptureEnabled = asyncStackTraceCaptureEnabled;
  }

  @Override
  boolean useApiProxy() {
    return useApiProxy;
  }

  @Nullable
  @Override
  String hostOverride() {
    return hostOverride;
  }

  @Nullable
  @Override
  ImmutableSet<String> additionalAppIds() {
    return additionalAppIds;
  }

  @Override
  boolean installApiProxyEnvironment() {
    return installApiProxyEnvironment;
  }

  @Nullable
  @Override
  String appId() {
    return appId;
  }

  @Nullable
  @Override
  String projectId() {
    return projectId;
  }

  @Override
  boolean useProjectIdAsAppId() {
    return useProjectIdAsAppId;
  }

  @Nullable
  @Override
  String emulatorHost() {
    return emulatorHost;
  }

  @Nullable
  @Override
  String accessToken() {
    return accessToken;
  }

  @Nullable
  @Override
  String serviceAccount() {
    return serviceAccount;
  }

  @Nullable
  @Override
  PrivateKey privateKey() {
    return privateKey;
  }

  @Nullable
  @Override
  String privateKeyFile() {
    return privateKeyFile;
  }

  @Override
  boolean useComputeEngineCredential() {
    return useComputeEngineCredential;
  }

  @Override
  int maxRetries() {
    return maxRetries;
  }

  @Override
  int httpConnectTimeoutMillis() {
    return httpConnectTimeoutMillis;
  }

  @Override
  boolean asyncStackTraceCaptureEnabled() {
    return asyncStackTraceCaptureEnabled;
  }

  @Override
  public String toString() {
    return "DatastoreServiceGlobalConfig{"
        + "useApiProxy=" + useApiProxy + ", "
        + "hostOverride=" + hostOverride + ", "
        + "additionalAppIds=" + additionalAppIds + ", "
        + "installApiProxyEnvironment=" + installApiProxyEnvironment + ", "
        + "appId=" + appId + ", "
        + "projectId=" + projectId + ", "
        + "useProjectIdAsAppId=" + useProjectIdAsAppId + ", "
        + "emulatorHost=" + emulatorHost + ", "
        + "accessToken=" + accessToken + ", "
        + "serviceAccount=" + serviceAccount + ", "
        + "privateKey=" + privateKey + ", "
        + "privateKeyFile=" + privateKeyFile + ", "
        + "useComputeEngineCredential=" + useComputeEngineCredential + ", "
        + "maxRetries=" + maxRetries + ", "
        + "httpConnectTimeoutMillis=" + httpConnectTimeoutMillis + ", "
        + "asyncStackTraceCaptureEnabled=" + asyncStackTraceCaptureEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatastoreServiceGlobalConfig) {
      DatastoreServiceGlobalConfig that = (DatastoreServiceGlobalConfig) o;
      return this.useApiProxy == that.useApiProxy()
          && (this.hostOverride == null ? that.hostOverride() == null : this.hostOverride.equals(that.hostOverride()))
          && (this.additionalAppIds == null ? that.additionalAppIds() == null : this.additionalAppIds.equals(that.additionalAppIds()))
          && this.installApiProxyEnvironment == that.installApiProxyEnvironment()
          && (this.appId == null ? that.appId() == null : this.appId.equals(that.appId()))
          && (this.projectId == null ? that.projectId() == null : this.projectId.equals(that.projectId()))
          && this.useProjectIdAsAppId == that.useProjectIdAsAppId()
          && (this.emulatorHost == null ? that.emulatorHost() == null : this.emulatorHost.equals(that.emulatorHost()))
          && (this.accessToken == null ? that.accessToken() == null : this.accessToken.equals(that.accessToken()))
          && (this.serviceAccount == null ? that.serviceAccount() == null : this.serviceAccount.equals(that.serviceAccount()))
          && (this.privateKey == null ? that.privateKey() == null : this.privateKey.equals(that.privateKey()))
          && (this.privateKeyFile == null ? that.privateKeyFile() == null : this.privateKeyFile.equals(that.privateKeyFile()))
          && this.useComputeEngineCredential == that.useComputeEngineCredential()
          && this.maxRetries == that.maxRetries()
          && this.httpConnectTimeoutMillis == that.httpConnectTimeoutMillis()
          && this.asyncStackTraceCaptureEnabled == that.asyncStackTraceCaptureEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= useApiProxy ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (hostOverride == null) ? 0 : hostOverride.hashCode();
    h$ *= 1000003;
    h$ ^= (additionalAppIds == null) ? 0 : additionalAppIds.hashCode();
    h$ *= 1000003;
    h$ ^= installApiProxyEnvironment ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (appId == null) ? 0 : appId.hashCode();
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= useProjectIdAsAppId ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (emulatorHost == null) ? 0 : emulatorHost.hashCode();
    h$ *= 1000003;
    h$ ^= (accessToken == null) ? 0 : accessToken.hashCode();
    h$ *= 1000003;
    h$ ^= (serviceAccount == null) ? 0 : serviceAccount.hashCode();
    h$ *= 1000003;
    h$ ^= (privateKey == null) ? 0 : privateKey.hashCode();
    h$ *= 1000003;
    h$ ^= (privateKeyFile == null) ? 0 : privateKeyFile.hashCode();
    h$ *= 1000003;
    h$ ^= useComputeEngineCredential ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= maxRetries;
    h$ *= 1000003;
    h$ ^= httpConnectTimeoutMillis;
    h$ *= 1000003;
    h$ ^= asyncStackTraceCaptureEnabled ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends DatastoreServiceGlobalConfig.Builder {
    private Boolean useApiProxy;
    private String hostOverride;
    private ImmutableSet<String> additionalAppIds;
    private Boolean installApiProxyEnvironment;
    private String appId;
    private String projectId;
    private Boolean useProjectIdAsAppId;
    private String emulatorHost;
    private String accessToken;
    private String serviceAccount;
    private PrivateKey privateKey;
    private String privateKeyFile;
    private Boolean useComputeEngineCredential;
    private Integer maxRetries;
    private Integer httpConnectTimeoutMillis;
    private Boolean asyncStackTraceCaptureEnabled;
    Builder() {
    }
    @Override
    DatastoreServiceGlobalConfig.Builder useApiProxy(boolean useApiProxy) {
      this.useApiProxy = useApiProxy;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder hostOverride(String hostOverride) {
      this.hostOverride = hostOverride;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder additionalAppIds(Set<String> additionalAppIds) {
      this.additionalAppIds = (additionalAppIds == null ? null : ImmutableSet.copyOf(additionalAppIds));
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder installApiProxyEnvironment(boolean installApiProxyEnvironment) {
      this.installApiProxyEnvironment = installApiProxyEnvironment;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder appId(String appId) {
      this.appId = appId;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder projectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder useProjectIdAsAppId(boolean useProjectIdAsAppId) {
      this.useProjectIdAsAppId = useProjectIdAsAppId;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder emulatorHost(String emulatorHost) {
      this.emulatorHost = emulatorHost;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder accessToken(String accessToken) {
      this.accessToken = accessToken;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder serviceAccount(String serviceAccount) {
      this.serviceAccount = serviceAccount;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder privateKey(PrivateKey privateKey) {
      this.privateKey = privateKey;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder privateKeyFile(String privateKeyFile) {
      this.privateKeyFile = privateKeyFile;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder useComputeEngineCredential(boolean useComputeEngineCredential) {
      this.useComputeEngineCredential = useComputeEngineCredential;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder maxRetries(int maxRetries) {
      this.maxRetries = maxRetries;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder httpConnectTimeoutMillis(int httpConnectTimeoutMillis) {
      this.httpConnectTimeoutMillis = httpConnectTimeoutMillis;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig.Builder asyncStackTraceCaptureEnabled(boolean asyncStackTraceCaptureEnabled) {
      this.asyncStackTraceCaptureEnabled = asyncStackTraceCaptureEnabled;
      return this;
    }
    @Override
    DatastoreServiceGlobalConfig autoBuild() {
      if (this.useApiProxy == null
          || this.installApiProxyEnvironment == null
          || this.useProjectIdAsAppId == null
          || this.useComputeEngineCredential == null
          || this.maxRetries == null
          || this.httpConnectTimeoutMillis == null
          || this.asyncStackTraceCaptureEnabled == null) {
        StringBuilder missing = new StringBuilder();
        if (this.useApiProxy == null) {
          missing.append(" useApiProxy");
        }
        if (this.installApiProxyEnvironment == null) {
          missing.append(" installApiProxyEnvironment");
        }
        if (this.useProjectIdAsAppId == null) {
          missing.append(" useProjectIdAsAppId");
        }
        if (this.useComputeEngineCredential == null) {
          missing.append(" useComputeEngineCredential");
        }
        if (this.maxRetries == null) {
          missing.append(" maxRetries");
        }
        if (this.httpConnectTimeoutMillis == null) {
          missing.append(" httpConnectTimeoutMillis");
        }
        if (this.asyncStackTraceCaptureEnabled == null) {
          missing.append(" asyncStackTraceCaptureEnabled");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DatastoreServiceGlobalConfig(
          this.useApiProxy,
          this.hostOverride,
          this.additionalAppIds,
          this.installApiProxyEnvironment,
          this.appId,
          this.projectId,
          this.useProjectIdAsAppId,
          this.emulatorHost,
          this.accessToken,
          this.serviceAccount,
          this.privateKey,
          this.privateKeyFile,
          this.useComputeEngineCredential,
          this.maxRetries,
          this.httpConnectTimeoutMillis,
          this.asyncStackTraceCaptureEnabled);
    }
  }

}
