/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.ReserveIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.ReserveIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc;
import com.google.appengine.repackaged.com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, Code.UNAVAILABLE, "Invalid response", exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("allocateIds", request);){
            AllocateIdsResponse allocateIdsResponse = AllocateIdsResponse.parseFrom(is);
            return allocateIdsResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("allocateIds", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("beginTransaction", request);){
            BeginTransactionResponse beginTransactionResponse = BeginTransactionResponse.parseFrom(is);
            return beginTransactionResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("beginTransaction", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("commit", request);){
            CommitResponse commitResponse = CommitResponse.parseFrom(is);
            return commitResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("commit", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LookupResponse lookup(LookupRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("lookup", request);){
            LookupResponse lookupResponse = LookupResponse.parseFrom(is);
            return lookupResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("lookup", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("reserveIds", request);){
            ReserveIdsResponse reserveIdsResponse = ReserveIdsResponse.parseFrom(is);
            return reserveIdsResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("reserveIds", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RollbackResponse rollback(RollbackRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("rollback", request);){
            RollbackResponse rollbackResponse = RollbackResponse.parseFrom(is);
            return rollbackResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("rollback", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RunQueryResponse runQuery(RunQueryRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("runQuery", request);){
            RunQueryResponse runQueryResponse = RunQueryResponse.parseFrom(is);
            return runQueryResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("runQuery", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("runAggregationQuery", request);){
            RunAggregationQueryResponse runAggregationQueryResponse = RunAggregationQueryResponse.parseFrom(is);
            return runAggregationQueryResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("runAggregationQuery", exception);
        }
    }
}

